/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.api.spi.deploy.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.enterprise.deploy.shared.CommandType;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.status.ProgressObject;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServerConnection;
import javax.management.NotificationFilter;
import javax.management.ObjectName;
import weblogic.application.utils.ApplicationVersionUtils;
import weblogic.deploy.api.internal.SPIDeployerLogger;
import weblogic.deploy.api.internal.utils.ConfigHelper;
import weblogic.deploy.api.internal.utils.Debug;
import weblogic.deploy.api.internal.utils.InstallDir;
import weblogic.deploy.api.shared.WebLogicModuleType;
import weblogic.deploy.api.spi.DeploymentOptions;
import weblogic.deploy.api.spi.WebLogicDeploymentManager;
import weblogic.deploy.api.spi.WebLogicTargetModuleID;
import weblogic.deploy.api.spi.config.DescriptorParser;
import weblogic.deploy.api.spi.deploy.TargetModuleIDImpl;
import weblogic.deploy.api.spi.deploy.internal.FailedOperationException;
import weblogic.deploy.api.spi.exceptions.ServerConnectionException;
import weblogic.deploy.api.spi.status.ProgressObjectImpl;
import weblogic.deploy.internal.DeployerTextFormatter;
import weblogic.deploy.utils.TaskCompletionNotificationFilter;
import weblogic.deploy.utils.TaskCompletionNotificationListener;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.EditableDescriptorManager;
import weblogic.j2ee.descriptor.wl.DeploymentPlanBean;
import weblogic.j2ee.descriptor.wl.ModuleOverrideBean;
import weblogic.management.ManagementException;
import weblogic.management.configuration.AppDeploymentMBean;
import weblogic.management.configuration.TargetMBean;
import weblogic.management.deploy.DeploymentData;
import weblogic.management.runtime.DeploymentTaskRuntimeMBean;
import weblogic.utils.FileUtils;

public abstract class BasicOperation {
    protected static final boolean debug = Debug.isDebug("deploy");
    protected static final DeployerTextFormatter cat = new DeployerTextFormatter();
    private static final String PREFIX = "app";
    protected WebLogicDeploymentManager dm;
    protected Target[] targetList;
    protected File moduleArchive;
    protected File plan;
    protected DeploymentOptions options;
    protected ProgressObject po = null;
    protected CommandType cmd;
    protected DeploymentPlanBean planBean;
    protected InstallDir paths;
    protected DeploymentTaskRuntimeMBean task;
    protected String appName;
    protected DeploymentData info;
    protected TargetModuleID[] tmids;
    protected InputStream moduleStream;
    protected InputStream planStream;
    protected boolean initWithTmids = true;
    protected ModuleType distributeStreamModuleType = null;
    private TaskCompletionNotificationListener taskCompletionListener = null;
    protected boolean tmidsFromConfig = false;
    protected boolean isWLFullClient = false;

    protected BasicOperation() {
    }

    protected BasicOperation(WebLogicDeploymentManager webLogicDeploymentManager, DeploymentOptions deploymentOptions) {
        this.dm = webLogicDeploymentManager;
        this.options = deploymentOptions;
        if (this.options == null) {
            this.options = new DeploymentOptions();
        }
    }

    protected BasicOperation(WebLogicDeploymentManager webLogicDeploymentManager, File file, File file2, DeploymentOptions deploymentOptions) {
        this(webLogicDeploymentManager, deploymentOptions);
        if (file != null && file.getPath().length() == 0) {
            file = null;
        }
        if (file2 != null && file2.getPath().length() == 0) {
            file2 = null;
        }
        this.moduleArchive = file;
        this.plan = file2;
    }

    protected BasicOperation(WebLogicDeploymentManager webLogicDeploymentManager, InputStream inputStream, InputStream inputStream2, DeploymentOptions deploymentOptions) {
        this(webLogicDeploymentManager, deploymentOptions);
        this.moduleStream = inputStream;
        this.planStream = inputStream2;
    }

    protected TargetModuleID[] createTmidsFromTargets() {
        this.initWithTmids = false;
        HashSet<WebLogicTargetModuleID> hashSet = new HashSet<WebLogicTargetModuleID>();
        this.deriveAppName();
        for (int i = 0; i < this.targetList.length; ++i) {
            Target target = this.targetList[i];
            hashSet.add(this.dm.createTargetModuleID(this.appName, WebLogicModuleType.UNKNOWN, target));
        }
        return hashSet.toArray(new TargetModuleID[0]);
    }

    protected void deriveAppName() {
        if (this.initWithTmids && (this.options == null || !this.getNameFromAppFiles())) {
            try {
                this.appName = ConfigHelper.getAppName(this.tmids, this.options);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.appName == null) {
            this.appName = ConfigHelper.getAppName(this.options, this.moduleArchive, this.planBean);
        }
        if (debug) {
            Debug.say("appname established as: " + this.appName);
        }
        if (this.appName == null) {
            throw new IllegalArgumentException(SPIDeployerLogger.nullAppName((String)this.cmd.toString()));
        }
    }

    private boolean getNameFromAppFiles() {
        return this.options.isLibrary() && this.options.isNameFromLibrary() || this.options.isNameFromSource();
    }

    public synchronized ProgressObject run() throws IllegalStateException {
        if (this.po != null) {
            return this.po;
        }
        try {
            this.checkConnection();
            this.validateParams();
            try {
                Class<?> clazz = Class.forName("weblogic.j2ee.descriptor.wl.DeploymentPlanBeanImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.isWLFullClient = true;
            }
            if (!this.isWLFullClient && !this.options.isRemote()) {
                this.parsePlan();
            }
            this.initTmids();
            this.setupPaths();
            this.execute();
            this.po = this.createResults();
        }
        catch (FailedOperationException failedOperationException) {
            this.po = failedOperationException.getProgressObject();
        }
        return this.po;
    }

    protected void logRequest() {
        String string = this.tmids != null ? this.getTargetsFromTmids() : this.getTargetsFromTargets();
        if (string.length() == 0) {
            string = SPIDeployerLogger.getConfiguredTargetsLoggable().getMessageText();
        }
        String string2 = null;
        if (this.moduleStream != null) {
            SPIDeployerLogger.logInitStreamOperation((String)this.cmd.toString(), (String)this.appName, (String)string);
        } else {
            if (this.moduleArchive != null) {
                string2 = this.moduleArchive.getPath();
            }
            SPIDeployerLogger.logInitOperation((String)this.cmd.toString(), (String)this.appName, (String)string2, (String)string);
        }
    }

    private String getTargetsFromTargets() {
        String string = "";
        for (int i = 0; i < this.targetList.length; ++i) {
            string = string + this.targetList[i].getName() + " ";
        }
        return string;
    }

    private String getTargetsFromTmids() {
        String string = "";
        for (int i = 0; i < this.tmids.length; ++i) {
            string = string + this.tmids[i].getTarget().getName() + " ";
        }
        return string;
    }

    protected void checkConnection() {
        if (!this.dm.isConnected()) {
            throw new IllegalStateException(SPIDeployerLogger.notConnected());
        }
    }

    protected void initTmids() {
        if (this.tmids == null) {
            this.tmids = this.createTmidsFromTargets();
        } else {
            this.targetList = this.createTargetsFromTmids();
        }
        this.dumpTmids(this.tmids);
    }

    protected void validateParams() throws FailedOperationException {
        try {
            if (this.tmids == null && this.targetList == null) {
                throw new IllegalArgumentException(SPIDeployerLogger.nullTMID((String)this.cmd.toString()));
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new FailedOperationException(this.failOperation(illegalArgumentException));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void parsePlan() throws FailedOperationException {
        if (this.planBean != null) {
            return;
        }
        InputStream inputStream = null;
        try {
            try {
                if (this.planStream != null) {
                    inputStream = this.planStream;
                } else if (this.plan != null) {
                    inputStream = new FileInputStream(this.plan);
                }
                if (inputStream != null) {
                    this.planBean = DescriptorParser.parseDeploymentPlan(inputStream);
                }
            }
            catch (IOException iOException) {
                throw new FailedOperationException(this.failOperation(iOException));
            }
            Object var4_2 = null;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            try {
                if (inputStream == null) throw throwable;
                if (this.planStream != null) throw throwable;
                inputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        if (inputStream == null) return;
        if (this.planStream != null) return;
        inputStream.close();
        return;
    }

    protected void setupPaths() throws FailedOperationException {
        try {
            if (this.moduleArchive == null) {
                return;
            }
            if (!this.options.isRemote()) {
                this.moduleArchive = ConfigHelper.normalize(this.moduleArchive).getAbsoluteFile();
            }
            this.paths = new InstallDir(ConfigHelper.getAppName(this.options, this.moduleArchive, this.planBean), ConfigHelper.getAppRootFromPlan(this.planBean), false);
            this.paths.setArchive(this.moduleArchive);
            if (this.plan != null) {
                this.paths.setPlan(this.plan.getAbsoluteFile());
            }
            ConfigHelper.initPlanDirFromPlan(this.planBean, this.paths);
            if (this.planBean != null && this.planBean.getConfigRoot() != null) {
                this.paths.setConfigDir(new File(this.planBean.getConfigRoot()).getAbsoluteFile());
            }
        }
        catch (IOException iOException) {
            throw new FailedOperationException(this.failOperation(iOException));
        }
    }

    protected ProgressObject createResults() {
        try {
            ProgressObjectImpl progressObjectImpl = this.newProgressObject();
            return progressObjectImpl;
        }
        catch (ServerConnectionException serverConnectionException) {
            return this.failOperation(serverConnectionException);
        }
    }

    protected final void startTask() throws ManagementException {
        if (!this.task.isPendingActivation()) {
            this.task.start();
        }
    }

    protected abstract void initializeTask() throws Throwable;

    protected void buildDeploymentData() {
        this.info = this.createDeploymentData();
    }

    protected String getAppIdForUpload() {
        String string = this.options.getVersionIdentifier();
        if (string == null) {
            string = this.info != null && this.info.getDeploymentOptions() != null && this.info.getDeploymentOptions().isLibrary() ? ApplicationVersionUtils.getLibVersionId(this.paths.getArchive().getPath()) : ApplicationVersionUtils.getManifestVersion(this.paths.getArchive().getPath());
        }
        return ApplicationVersionUtils.getApplicationId(this.appName, string);
    }

    protected void uploadFiles() throws IOException {
        if (this.paths == null) {
            return;
        }
        String string = this.getAppIdForUpload();
        this.paths = this.dm.getServerConnection().upload(this.paths, string, null);
    }

    protected ProgressObject failOperation(Throwable throwable) {
        ProgressObjectImpl progressObjectImpl;
        if (throwable instanceof ServerConnectionException) {
            progressObjectImpl = new ProgressObjectImpl(this.cmd, ((ServerConnectionException)throwable).getRootCause(), this.dm);
            progressObjectImpl.setMessage(throwable.toString());
        } else {
            progressObjectImpl = new ProgressObjectImpl(this.cmd, throwable, this.dm);
        }
        return progressObjectImpl;
    }

    protected DeploymentData getDeploymentData() {
        if (this.options == null) {
            this.options = new DeploymentOptions();
        }
        DeploymentData deploymentData = new DeploymentData();
        for (int i = 0; i < this.targetList.length; ++i) {
            if (debug) {
                Debug.say("adding global target: " + this.targetList[i].getName());
            }
            deploymentData.addGlobalTarget(this.targetList[i].getName());
        }
        this.loadGeneralOptions(deploymentData, this.options.getName());
        return deploymentData;
    }

    protected void validateForNoTMIDs() {
        if (this.tmids == null || this.tmids.length == 0) {
            throw new IllegalArgumentException(SPIDeployerLogger.noTargetInfo((String)this.appName));
        }
    }

    ProgressObjectImpl newProgressObject() throws ServerConnectionException {
        if (this.defaultTmidsWithOnlySubModules()) {
            this.createTmidForAdminServer();
        }
        if (this.tmids.length == 0) {
            this.createTmidsFromApp();
        }
        ProgressObjectImpl progressObjectImpl = new ProgressObjectImpl(this.cmd, this.task.getId(), this.tmids, this.dm);
        progressObjectImpl.setTaskCompletionListener(this.taskCompletionListener);
        this.dm.getServerConnection().registerListener(progressObjectImpl);
        List list = this.task.getTaskMessages();
        StringBuffer stringBuffer = new StringBuffer();
        for (Object e : list) {
            stringBuffer.append(e).append("\n");
        }
        if (stringBuffer.length() > 0) {
            progressObjectImpl.setMessage(stringBuffer.toString());
        }
        return progressObjectImpl;
    }

    private void createTmidsFromApp() {
        AppDeploymentMBean appDeploymentMBean = ApplicationVersionUtils.getAppDeployment(this.dm.getHelper().getDomain(), this.appName, null);
        if (appDeploymentMBean != null) {
            List list = this.dm.getServerConnection().getModules(appDeploymentMBean);
            this.tmids = list.toArray(new TargetModuleID[0]);
            this.tmidsFromConfig = true;
        } else {
            this.createTmidForAdminServer();
        }
    }

    private void createTmidForAdminServer() throws IllegalArgumentException {
        String string;
        Target target;
        TargetModuleID[] targetModuleIDArray = new TargetModuleID[this.tmids.length + 1];
        if (0 != this.tmids.length) {
            System.arraycopy(this.tmids, 0, targetModuleIDArray, 1, this.tmids.length);
        }
        if ((target = this.dm.getTarget(string = this.dm.getHelper().getAdminServerName())) == null) {
            throw new IllegalArgumentException(cat.errorNoSuchTarget(string));
        }
        targetModuleIDArray[0] = this.dm.createTargetModuleID(this.appName, WebLogicModuleType.UNKNOWN, target);
        this.tmids = targetModuleIDArray;
    }

    protected void execute() throws FailedOperationException {
        try {
            this.deriveAppName();
            this.logRequest();
            if (this.defaultTmidsWithOnlySubModules()) {
                this.createTmidForAdminServer();
            }
            if (this.tmids.length == 0) {
                this.createTmidsFromApp();
            }
            this.validateForNoTMIDs();
            if (debug) {
                this.dumpTmids(this.tmids);
            }
            this.updateOptions();
            this.buildDeploymentData();
            this.uploadFiles();
            if (this.paths != null) {
                if (this.paths.getPlan() != null) {
                    this.info.setDeploymentPlan(this.paths.getPlan().getPath());
                }
                this.info.setConfigDirectory(this.paths.getConfigDir().getPath());
                this.info.setRootDirectory(this.paths.getInstallDir().getPath());
            }
            if (debug) {
                Debug.say("Initiating " + this.cmd.toString() + " operation for app, " + this.appName + ", on targets:");
                for (int i = 0; i < this.targetList.length; ++i) {
                    Debug.say("   " + this.targetList[i].getName());
                }
            }
            this.initializeTask();
            this.initializeNotifiers();
            this.startTask();
        }
        catch (ManagementException managementException) {
            throw new FailedOperationException(this.failOperation(ManagementException.unWrapExceptions((Throwable)managementException)));
        }
        catch (FailedOperationException failedOperationException) {
            throw failedOperationException;
        }
        catch (Throwable throwable) {
            throw new FailedOperationException(this.failOperation(throwable));
        }
    }

    protected void updateOptions() {
        if (this.options.usesNonExclusiveLock()) {
            this.options.setUseNonexclusiveLock(this.dm.getHelper().needsNonExclusiveLock());
        }
    }

    private TargetMBean[] getTargetMBeans() {
        this.targetList = this.createTargetsFromTmids();
        HashSet<TargetMBean> hashSet = new HashSet<TargetMBean>();
        TargetMBean[] targetMBeanArray = this.dm.getHelper().getDomain().getTargets();
        for (int i = 0; i < this.targetList.length; ++i) {
            Target target = this.targetList[i];
            TargetMBean targetMBean = this.findTarget(target, targetMBeanArray);
            if (targetMBean == null) {
                throw new IllegalArgumentException(SPIDeployerLogger.noSuchTarget((String)target.getName(), (String)target.getDescription()));
            }
            hashSet.add(targetMBean);
        }
        return hashSet.toArray(new TargetMBean[0]);
    }

    private TargetMBean findTarget(Target target, TargetMBean[] targetMBeanArray) {
        for (int i = 0; i < targetMBeanArray.length; ++i) {
            TargetMBean targetMBean = targetMBeanArray[i];
            if (!targetMBean.getName().equals(target.getName())) continue;
            return targetMBean;
        }
        return null;
    }

    private boolean isTargetedSubmodule(WebLogicTargetModuleID webLogicTargetModuleID) {
        if (webLogicTargetModuleID.getValue() == WebLogicModuleType.SUBMODULE.getValue()) {
            return webLogicTargetModuleID.isTargeted();
        }
        TargetModuleID[] targetModuleIDArray = webLogicTargetModuleID.getChildTargetModuleID();
        if (targetModuleIDArray != null) {
            for (int i = 0; i < targetModuleIDArray.length; ++i) {
                TargetModuleID targetModuleID = targetModuleIDArray[i];
                if (!this.isTargetedSubmodule((WebLogicTargetModuleID)targetModuleID)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean defaultTmidsWithOnlySubModules() {
        return false;
    }

    protected boolean tmidsHaveOnlySubModules() {
        boolean bl = false;
        for (int i = 0; i < this.tmids.length; ++i) {
            TargetModuleID[] targetModuleIDArray;
            if (((WebLogicTargetModuleID)this.tmids[i]).isTargeted()) {
                if (((WebLogicTargetModuleID)this.tmids[i]).getValue() == WebLogicModuleType.SUBMODULE.getValue()) {
                    bl = true;
                } else {
                    return false;
                }
            }
            if (null == (targetModuleIDArray = this.tmids[i].getChildTargetModuleID())) continue;
            for (int j = 0; j < targetModuleIDArray.length; ++j) {
                TargetModuleID[] targetModuleIDArray2;
                if (((WebLogicTargetModuleID)targetModuleIDArray[j]).isTargeted()) {
                    if (((WebLogicTargetModuleID)targetModuleIDArray[j]).getValue() == WebLogicModuleType.SUBMODULE.getValue()) {
                        bl = true;
                    } else {
                        return false;
                    }
                }
                if (null == (targetModuleIDArray2 = targetModuleIDArray[j].getChildTargetModuleID())) continue;
                for (int k = 0; k < targetModuleIDArray2.length; ++k) {
                    if (!((WebLogicTargetModuleID)targetModuleIDArray2[k]).isTargeted()) continue;
                    if (((WebLogicTargetModuleID)targetModuleIDArray[j]).getValue() == WebLogicModuleType.SUBMODULE.getValue()) {
                        bl = true;
                        continue;
                    }
                    return false;
                }
            }
        }
        return bl;
    }

    protected Target[] createTargetsFromTmids() {
        if (this.tmids == null) {
            return null;
        }
        HashSet<Target> hashSet = new HashSet<Target>();
        for (int i = 0; i < this.tmids.length; ++i) {
            hashSet.add(this.tmids[i].getTarget());
        }
        return hashSet.toArray(new Target[0]);
    }

    protected DeploymentData createDeploymentData() {
        TargetModuleIDImpl targetModuleIDImpl;
        String string = null;
        if (this.options == null) {
            this.options = new DeploymentOptions();
        }
        DeploymentData deploymentData = new DeploymentData();
        for (int i = 0; i < this.tmids.length; ++i) {
            targetModuleIDImpl = (TargetModuleIDImpl)this.tmids[i];
            if (!targetModuleIDImpl.isTargeted()) continue;
            string = targetModuleIDImpl.getModuleID();
            deploymentData.addGlobalTarget(targetModuleIDImpl.getTarget().getName());
        }
        for (int i = 0; i < this.tmids.length; ++i) {
            TargetModuleID[] targetModuleIDArray;
            targetModuleIDImpl = (TargetModuleIDImpl)this.tmids[i];
            if (targetModuleIDImpl.isTargeted() || (targetModuleIDArray = targetModuleIDImpl.getChildTargetModuleID()) == null) continue;
            for (int j = 0; j < targetModuleIDArray.length; ++j) {
                TargetModuleIDImpl targetModuleIDImpl2 = (TargetModuleIDImpl)targetModuleIDArray[j];
                if (targetModuleIDImpl2.isTargeted()) {
                    if (targetModuleIDImpl2.getValue() == WebLogicModuleType.SUBMODULE.getValue()) {
                        deploymentData.addSubModuleTarget(null, targetModuleIDImpl2.getModuleID(), new String[]{targetModuleIDImpl2.getTarget().getName()});
                        continue;
                    }
                    deploymentData.addModuleTarget(targetModuleIDImpl2.getModuleID(), targetModuleIDImpl2.getTarget().getName());
                    continue;
                }
                TargetModuleID[] targetModuleIDArray2 = targetModuleIDImpl2.getChildTargetModuleID();
                String string2 = targetModuleIDImpl2.getModuleID();
                if (targetModuleIDArray2 == null) continue;
                for (int k = 0; k < targetModuleIDArray2.length; ++k) {
                    targetModuleIDImpl2 = (TargetModuleIDImpl)targetModuleIDArray2[k];
                    if (!targetModuleIDImpl2.isTargeted()) continue;
                    deploymentData.addSubModuleTarget(string2, targetModuleIDImpl2.getModuleID(), new String[]{targetModuleIDImpl2.getTarget().getName()});
                }
            }
        }
        this.loadGeneralOptions(deploymentData, string);
        return deploymentData;
    }

    private void loadGeneralOptions(DeploymentData deploymentData, String string) {
        if (this.paths != null) {
            if (this.paths.getPlan() != null) {
                deploymentData.setDeploymentPlan(this.paths.getPlan().getPath());
            }
            deploymentData.setConfigDirectory(this.paths.getConfigDir().getPath());
            deploymentData.setRootDirectory(this.paths.getInstallDir().getPath());
        }
        this.setVersionInfo(string);
        deploymentData.setDeploymentOptions(this.options);
        if (debug) {
            Debug.say(deploymentData.toString());
        }
        deploymentData.setTargetsFromConfig(this.tmidsFromConfig);
        if (this.options.getTimeout() != 0L) {
            deploymentData.setTimeOut((int)this.options.getTimeout());
        }
        deploymentData.setRemote(this.options.isRemote());
        deploymentData.setThinClient(this.isWLFullClient);
    }

    private void setVersionInfo(String string) {
        if (this.options.getPlanVersion() != null) {
            return;
        }
        String string2 = null;
        String string3 = ApplicationVersionUtils.getVersionId(string);
        if (string3 != null) {
            string2 = ApplicationVersionUtils.getPlanVersion(string3);
        }
        this.setPlanVersion(string2);
    }

    private void setPlanVersion(String string) {
        if (string != null) {
            this.options.setPlanVersion(string);
        } else if (this.options.getPlanVersion() == null && this.planBean != null) {
            this.options.setPlanVersion(this.planBean.getVersion());
        }
        this.assertPlanVersionValid();
    }

    private void assertPlanVersionValid() {
        if (this.planBean != null) {
            String string = this.planBean.getVersion();
            String string2 = this.options.getPlanVersion();
            if (string == null || string2 == null) {
                return;
            }
            if (string != string2) {
                throw new IllegalArgumentException(SPIDeployerLogger.versionMismatchPlan((String)string, (String)string2));
            }
        }
    }

    protected List validateTmids() throws IllegalArgumentException, ServerConnectionException {
        String string = null;
        ArrayList<TargetModuleIDImpl> arrayList = new ArrayList<TargetModuleIDImpl>();
        for (int i = 0; i < this.tmids.length; ++i) {
            TargetModuleIDImpl targetModuleIDImpl = (TargetModuleIDImpl)this.tmids[i];
            if (targetModuleIDImpl.getParentTargetModuleID() != null) {
                throw new IllegalArgumentException(SPIDeployerLogger.notRootTMID((String)this.cmd.toString(), (String)targetModuleIDImpl.toString()));
            }
            if (string == null) {
                string = ConfigHelper.getAppName(targetModuleIDImpl);
                if (debug) {
                    Debug.say("Using app name " + string);
                }
                if (string == null) {
                    throw new IllegalArgumentException(SPIDeployerLogger.noAppForTMID((String)targetModuleIDImpl.toString()));
                }
            } else if (!string.equals(ConfigHelper.getAppName(targetModuleIDImpl))) {
                throw new IllegalArgumentException(SPIDeployerLogger.diffTMID((String)this.cmd.toString(), (String)targetModuleIDImpl.toString(), (String)string));
            }
            arrayList.add(targetModuleIDImpl);
        }
        return arrayList;
    }

    private void dumpTmids(TargetModuleID[] targetModuleIDArray) {
        if (debug && targetModuleIDArray != null) {
            Debug.say("Incoming tmids:");
            for (int i = 0; i < targetModuleIDArray.length; ++i) {
                Debug.say("  " + targetModuleIDArray[i].toString() + ", targeted=" + ((TargetModuleIDImpl)targetModuleIDArray[i]).isTargeted());
                this.dumpChildTmids(targetModuleIDArray[i].getChildTargetModuleID(), "  ");
            }
        }
    }

    private void dumpChildTmids(TargetModuleID[] targetModuleIDArray, String string) {
        if (targetModuleIDArray == null) {
            return;
        }
        for (int i = 0; i < targetModuleIDArray.length; ++i) {
            Debug.say("   " + string + targetModuleIDArray[i].toString() + ", targeted=" + ((TargetModuleIDImpl)targetModuleIDArray[i]).isTargeted());
            this.dumpChildTmids(targetModuleIDArray[i].getChildTargetModuleID(), "    ");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected InstallDir createRootFromStreams(InputStream inputStream, DeploymentPlanBean deploymentPlanBean, DeploymentOptions deploymentOptions) throws IOException {
        File file;
        ModuleType moduleType;
        File file2 = FileUtils.createTempDir((String)PREFIX);
        String string = ConfigHelper.getAppName(deploymentOptions, file2, deploymentPlanBean);
        InstallDir installDir = new InstallDir(string, file2);
        file2 = installDir.getAppDir();
        file2.mkdir();
        installDir.setAppDir(file2.getAbsoluteFile());
        if (debug) {
            Debug.say("App dir set to " + installDir.getAppDir().toString());
        }
        string = this.getArchiveName(deploymentPlanBean, string);
        file2 = new File(file2, string);
        this.copy(inputStream, file2);
        ModuleType moduleType2 = moduleType = this.distributeStreamModuleType == null ? WebLogicModuleType.getFileModuleType(file2) : this.distributeStreamModuleType;
        if (moduleType == null) throw new IOException(SPIDeployerLogger.getUnknownType((String)string));
        if (!string.endsWith(moduleType.getModuleExtension())) {
            string = string.concat(moduleType.getModuleExtension());
            if (debug) {
                Debug.say("renaming " + file2.getName() + " to " + string);
            }
            if (file2.renameTo(file = new File(installDir.getAppDir(), string))) {
                file2 = file;
            } else {
                if (!debug) throw new IOException(SPIDeployerLogger.getRenameError((String)string));
                Debug.say("rename failed for file, " + file2.getAbsolutePath() + "/" + string);
                throw new IOException(SPIDeployerLogger.getRenameError((String)string));
            }
        }
        installDir.setArchive(file2.getAbsoluteFile());
        if (debug) {
            Debug.say("Archive set to " + installDir.getArchive().toString());
        }
        file2 = installDir.getConfigDir();
        file2.mkdir();
        file = new File(file2, "plan.xml");
        if (debug) {
            Debug.say("using for plan  " + file.toString());
        }
        if (deploymentPlanBean != null) {
            new EditableDescriptorManager().writeDescriptorAsXML(((DescriptorBean)deploymentPlanBean).getDescriptor(), (OutputStream)new FileOutputStream(file));
            installDir.setPlan(file.getAbsoluteFile());
            File file3 = ConfigHelper.getConfigRootFile(deploymentPlanBean);
            if (file3 != null) {
                file3.mkdir();
                installDir.setConfigDir(file3.getAbsoluteFile());
            } else {
                installDir.setConfigDir(file2.getAbsoluteFile());
            }
        } else {
            if (debug) {
                Debug.say("no plan");
            }
            installDir.setConfigDir(file2.getAbsoluteFile());
            installDir.setPlan(file.getAbsoluteFile());
        }
        if (debug) {
            Debug.say("Plan dir to " + installDir.getPlan().toString());
        }
        if (!debug) return installDir;
        Debug.say("Config dir to " + installDir.getConfigDir().toString());
        return installDir;
    }

    private String getArchiveName(DeploymentPlanBean deploymentPlanBean, String string) {
        if (deploymentPlanBean != null) {
            ModuleOverrideBean[] moduleOverrideBeanArray = deploymentPlanBean.getModuleOverrides();
            for (int i = 0; i < moduleOverrideBeanArray.length; ++i) {
                ModuleOverrideBean moduleOverrideBean = moduleOverrideBeanArray[i];
                if (!deploymentPlanBean.rootModule(moduleOverrideBean.getModuleName())) continue;
                string = moduleOverrideBean.getModuleName();
                break;
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copy(InputStream inputStream, File file) throws IOException {
        if (debug) {
            Debug.say("copying stream to " + file.getName());
        }
        byte[] byArray = new byte[1024];
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            int n;
            while ((n = inputStream.read(byArray)) > 0) {
                fileOutputStream.write(byArray, 0, n);
            }
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            fileOutputStream.close();
            throw throwable;
        }
        fileOutputStream.close();
    }

    private void initializeNotifiers() {
        this.task.setNotificationLevel(1);
    }

    private void registerTaskCompletionListener() {
        block10: {
            if (this.task != null) {
                try {
                    TaskCompletionNotificationListener taskCompletionNotificationListener = new TaskCompletionNotificationListener(this.task);
                    MBeanServerConnection mBeanServerConnection = this.dm.getServerConnection().getMBeanServerConnection();
                    if (mBeanServerConnection != null) {
                        MBeanServerConnection mBeanServerConnection2 = this.dm.getServerConnection().getRuntimeServerConnection();
                        if (mBeanServerConnection2 == null) {
                            if (debug) {
                                Debug.say("Not adding TaskCompletionNotification since we do not have runtime server mbean connection");
                            }
                            return;
                        }
                        if (debug) {
                            Debug.say("Adding TaskCompletionNotification Listener : " + taskCompletionNotificationListener);
                        }
                        mBeanServerConnection2.addNotificationListener((ObjectName)this.task.getObjectName(), taskCompletionNotificationListener, (NotificationFilter)new TaskCompletionNotificationFilter(), null);
                        if (debug) {
                            Debug.say("Added TaskCompletionNotification Listener : " + taskCompletionNotificationListener);
                        }
                    }
                    this.taskCompletionListener = taskCompletionNotificationListener;
                }
                catch (InstanceNotFoundException instanceNotFoundException) {
                    if (debug) {
                        instanceNotFoundException.printStackTrace();
                    }
                }
                catch (IOException iOException) {
                    if (!debug) break block10;
                    iOException.printStackTrace();
                }
            }
        }
    }
}

