/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.api.spi.deploy.internal;

import java.io.File;
import java.io.IOException;
import javax.enterprise.deploy.shared.CommandType;
import javax.enterprise.deploy.spi.TargetModuleID;
import weblogic.application.utils.ApplicationVersionUtils;
import weblogic.deploy.api.internal.SPIDeployerLogger;
import weblogic.deploy.api.internal.utils.ConfigHelper;
import weblogic.deploy.api.spi.DeploymentOptions;
import weblogic.deploy.api.spi.WebLogicDeploymentManager;
import weblogic.deploy.api.spi.deploy.internal.BasicOperation;
import weblogic.deploy.api.spi.deploy.internal.FailedOperationException;

public class RedeployDeltaOperation
extends BasicOperation {
    protected String path;
    protected boolean inPlace;
    private boolean delete;
    private String[] delta;

    public RedeployDeltaOperation(WebLogicDeploymentManager webLogicDeploymentManager, TargetModuleID[] targetModuleIDArray, File file, String[] stringArray, boolean bl, DeploymentOptions deploymentOptions) {
        super(webLogicDeploymentManager, file, null, deploymentOptions);
        this.tmids = targetModuleIDArray;
        this.cmd = CommandType.REDEPLOY;
        this.delete = bl;
        this.delta = stringArray;
    }

    protected void uploadFiles() throws IOException {
        String string = null;
        if (this.moduleArchive != null) {
            string = this.moduleArchive.getCanonicalPath();
        }
        String string2 = ApplicationVersionUtils.getApplicationId(this.appName, this.options.getVersionIdentifier());
        this.dm.getServerConnection().uploadApp(string, string2, this.delta);
    }

    protected void buildDeploymentData() {
        super.buildDeploymentData();
        this.info.setFile(this.delta);
        this.info.setDelete(this.delete);
    }

    protected void initializeTask() throws Throwable {
        this.task = this.dm.getServerConnection().getHelper().getDeployer().redeploy(this.appName, this.info, this.dm.getTaskId(), false);
    }

    protected void validateParams() throws FailedOperationException {
        try {
            super.validateParams();
            if (!this.dm.isLocal()) {
                ConfigHelper.checkParam("moduleArchive", this.moduleArchive);
            }
            ConfigHelper.checkParam("delta", this.delta);
            if (this.delta.length == 0) {
                throw new IllegalArgumentException(SPIDeployerLogger.getNoDelta((String)this.cmd.toString()));
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new FailedOperationException(this.failOperation(illegalArgumentException));
        }
    }
}

