/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.api.spi.deploy.internal;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.enterprise.deploy.shared.CommandType;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.status.ProgressObject;
import weblogic.application.utils.ApplicationVersionUtils;
import weblogic.deploy.api.internal.utils.ConfigHelper;
import weblogic.deploy.api.internal.utils.Debug;
import weblogic.deploy.api.internal.utils.InstallDir;
import weblogic.deploy.api.spi.DeploymentOptions;
import weblogic.deploy.api.spi.WebLogicDeploymentManager;
import weblogic.deploy.api.spi.deploy.internal.BasicOperation;
import weblogic.deploy.api.spi.deploy.internal.FailedOperationException;
import weblogic.deploy.api.spi.exceptions.ServerConnectionException;
import weblogic.utils.FileUtils;

public class RedeployOperation
extends BasicOperation {
    protected String path;
    protected boolean inPlace;
    protected boolean streams = false;

    protected RedeployOperation(WebLogicDeploymentManager webLogicDeploymentManager, InputStream inputStream, InputStream inputStream2, DeploymentOptions deploymentOptions) {
        super(webLogicDeploymentManager, inputStream, inputStream2, deploymentOptions);
    }

    public RedeployOperation(WebLogicDeploymentManager webLogicDeploymentManager, TargetModuleID[] targetModuleIDArray, File file, File file2, DeploymentOptions deploymentOptions) {
        super(webLogicDeploymentManager, file, file2, deploymentOptions);
        this.tmids = targetModuleIDArray;
        this.cmd = CommandType.REDEPLOY;
    }

    public ProgressObject run() throws IllegalStateException {
        return super.run();
    }

    protected void initializeTask() throws Throwable {
        if (debug) {
            Debug.say("Starting task with path: " + this.path);
        }
        this.task = this.path == null ? this.dm.getServerConnection().getHelper().getDeployer().redeploy(this.appName, this.info, this.dm.getTaskId(), false) : this.dm.getServerConnection().getHelper().getDeployer().redeploy(this.path, this.appName, this.info, this.dm.getTaskId(), false);
    }

    protected void setupPaths() throws FailedOperationException {
        if (!this.streams) {
            try {
                this.paths = new InstallDir(ConfigHelper.getAppName(this.tmids, this.options), ConfigHelper.getAppRootFromPlan(this.planBean), false);
                if (this.moduleArchive != null) {
                    this.paths.setArchive(this.moduleArchive.getCanonicalFile());
                }
                if (this.plan != null) {
                    this.paths.setPlan(this.plan.getCanonicalFile());
                }
                ConfigHelper.initPlanDirFromPlan(this.planBean, this.paths);
            }
            catch (IOException iOException) {
                throw new FailedOperationException(this.failOperation(iOException));
            }
        }
        boolean bl = this.inPlace = this.moduleArchive == null;
        if (debug) {
            Debug.say("in place redeploy: " + this.inPlace + " from moduleArchive: " + this.moduleArchive);
        }
        if (this.inPlace) {
            this.path = null;
        } else {
            this.path = this.paths.getArchive().getPath();
            this.appName = ApplicationVersionUtils.getApplicationName(this.appName);
        }
        if (debug) {
            Debug.say("redeploy src path: " + this.path);
        }
    }

    protected boolean isInPlaceApp(String string, String string2, String string3) {
        String string4 = ApplicationVersionUtils.getVersionId(string2, string3);
        String string5 = ApplicationVersionUtils.getVersionId(string);
        return this.isInPlace(string4, string5);
    }

    protected boolean isInPlace(String string, String string2) {
        if (string != null) {
            return string.equals(string2);
        }
        if (string2 != null) {
            return string2.equals(string);
        }
        return true;
    }

    protected void uploadFiles() throws IOException {
        if (this.paths == null) {
            return;
        }
        if (this.moduleArchive != null) {
            String string = this.getAppIdForUpload();
            this.paths = this.dm.getServerConnection().upload(this.paths, string, null);
            this.path = this.paths.getArchive().getPath();
        } else if (this.plan != null) {
            String string = this.uploadConfig();
            if (debug) {
                Debug.say("Updating " + this.appName + " from " + string);
            }
        }
    }

    private String uploadConfig() throws ServerConnectionException {
        String string;
        String string2 = string = this.plan.getAbsoluteFile().getPath();
        if (!this.dm.isLocal()) {
            Object object;
            File file = new File(string);
            if (!this.paths.isInConfigDir(file)) {
                object = new File(this.paths.getConfigDir(), file.getName());
                if (debug) {
                    Debug.say("Copying " + file.getPath() + " to config area, " + ((File)object).getPath());
                }
                try {
                    FileUtils.copy((File)file, (File)object);
                }
                catch (IOException iOException) {
                    throw new ServerConnectionException(iOException.toString());
                }
                this.paths.setPlan((File)object);
            }
            string = this.paths.getConfigDir().getPath();
            object = ApplicationVersionUtils.getApplicationId(this.appName, this.options.getVersionIdentifier());
            string2 = this.dm.getServerConnection().uploadPlan(string, (String)object);
            this.paths.setConfigDir(new File(string2));
            this.paths.setPlan(new File(string2, this.plan.getName()));
        }
        return string2;
    }
}

