/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.api.spi.deploy.internal;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.enterprise.deploy.shared.ActionType;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.shared.StateType;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.OperationUnsupportedException;
import javax.enterprise.deploy.spi.exceptions.TargetException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import weblogic.deploy.api.internal.SPIDeployerLogger;
import weblogic.deploy.api.internal.utils.Debug;
import weblogic.deploy.api.internal.utils.DeployerHelperException;
import weblogic.deploy.api.internal.utils.InstallDir;
import weblogic.deploy.api.internal.utils.JMXDeployerHelper;
import weblogic.deploy.api.shared.WebLogicModuleType;
import weblogic.deploy.api.shared.WebLogicTargetType;
import weblogic.deploy.api.spi.WebLogicDeploymentManager;
import weblogic.deploy.api.spi.deploy.ServerConnection;
import weblogic.deploy.api.spi.deploy.TargetImpl;
import weblogic.deploy.api.spi.deploy.TargetModuleIDImpl;
import weblogic.deploy.api.spi.deploy.internal.DomainManager;
import weblogic.deploy.api.spi.deploy.mbeans.ModuleCache;
import weblogic.deploy.api.spi.deploy.mbeans.TargetCache;
import weblogic.deploy.api.spi.exceptions.ServerConnectionException;
import weblogic.deploy.api.spi.status.ProgressObjectImpl;
import weblogic.j2ee.descriptor.wl.DeploymentPlanBean;
import weblogic.jndi.Environment;
import weblogic.management.DeploymentNotification;
import weblogic.management.DomainDir;
import weblogic.management.RemoteNotificationListener;
import weblogic.management.configuration.AppDeploymentMBean;
import weblogic.management.configuration.BasicDeploymentMBean;
import weblogic.management.configuration.ClusterMBean;
import weblogic.management.configuration.ConfigurationMBean;
import weblogic.management.configuration.DeploymentMBean;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.configuration.SubDeploymentMBean;
import weblogic.management.configuration.TargetMBean;
import weblogic.management.jmx.MBeanServerInvocationHandler;
import weblogic.management.mbeanservers.domainruntime.DomainRuntimeServiceMBean;
import weblogic.management.mbeanservers.edit.ConfigurationManagerMBean;
import weblogic.management.mbeanservers.edit.EditServiceMBean;
import weblogic.management.provider.ManagementService;
import weblogic.management.remote.common.WLSJMXConnector;
import weblogic.management.runtime.AppRuntimeStateRuntimeMBean;
import weblogic.management.runtime.ApplicationRuntimeMBean;
import weblogic.management.runtime.ComponentRuntimeMBean;
import weblogic.management.runtime.DeployerRuntimeMBean;
import weblogic.management.runtime.DeploymentTaskRuntimeMBean;
import weblogic.management.runtime.ServerRuntimeMBean;
import weblogic.management.runtime.WebAppComponentRuntimeMBean;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.utils.FileUtils;
import weblogic.utils.StackTraceUtils;

public class ServerConnectionImpl
implements ServerConnection,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final boolean debug = Debug.isDebug("deploy");
    private static final boolean ddebug = Debug.isDebug("internal");
    private static final String IIOP = "iiop";
    private static final String POLLER_NAME = "J2EE-Deployment-task-poller";
    private static final int RUNTIME = 2;
    private static final int DOMAIN_RUNTIME = 3;
    private boolean isRemote = false;
    private transient String adminUrl;
    private transient URI adminURI = null;
    private transient String auth1 = null;
    private transient String auth2 = null;
    private transient MBeanServerConnection mbs = null;
    private transient MBeanServerConnection runtimeMBS = null;
    private transient JMXDeployerHelper helper = null;
    private transient Map listeners = Collections.synchronizedMap(new HashMap());
    private transient Thread poller = null;
    private boolean forceStop = false;
    private transient String domain = null;
    private transient WebLogicDeploymentManager dm;
    private transient DeployerRuntimeMBean deployer;
    private transient TargetCache targetCache;
    private transient ModuleCache moduleCache;
    private Context ctx;
    private transient JMXConnector jmx = null;
    private transient JMXConnector runtimeJmx = null;
    private transient JMXConnector editJmx = null;
    private File delApp = null;
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private ConfigurationManagerMBean configMgr;
    private transient DomainManager domainManager;
    private boolean closed = false;

    protected void finalize() throws Throwable {
        if (!this.closed) {
            this.close(true);
        }
    }

    public void init(URI uRI, String string, String string2, WebLogicDeploymentManager webLogicDeploymentManager) throws ServerConnectionException {
        this.dm = webLogicDeploymentManager;
        this.adminURI = uRI;
        this.auth1 = string;
        this.auth2 = string2;
        try {
            this.ctx = this.getEnvironment(uRI, string, string2);
        }
        catch (NamingException namingException) {
            throw new ServerConnectionException(namingException.getMessage(), namingException);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new ServerConnectionException(uRISyntaxException.getMessage(), uRISyntaxException);
        }
        this.mbs = this.getMBeanServerForType(3);
        this.runtimeMBS = this.getMBeanServerForType(2);
        try {
            this.helper = new JMXDeployerHelper(this.jmx);
            this.helper.setConfigMgr(this.configMgr);
        }
        catch (DeployerHelperException deployerHelperException) {
            throw new ServerConnectionException(deployerHelperException.getMessage(), deployerHelperException);
        }
        this.initialize();
        if (!webLogicDeploymentManager.isLocal()) {
            this.setRemote();
        }
        if (debug) {
            Debug.say("Initializing ServerConnection : " + this);
        }
    }

    private void initialize() throws ServerConnectionException {
        this.domainManager = new DomainManager(this);
        DomainMBean domainMBean = this.domainManager.getDomain();
        this.domain = domainMBean.getName();
        this.dm.setDomain(this.domain);
        if (debug) {
            Debug.say("Connected to WLS domain: " + this.domain);
        }
        try {
            this.deployer = this.helper.getDeployer();
        }
        catch (Throwable throwable) {
            throw new ServerConnectionException(SPIDeployerLogger.connectionError(), throwable);
        }
        if (this.deployer == null) {
            throw new ServerConnectionException(SPIDeployerLogger.connectionError());
        }
    }

    private void initCaches(DomainMBean domainMBean) {
        if (this.targetCache != null) {
            this.targetCache.reset();
        }
        this.targetCache = new TargetCache(domainMBean, this.dm);
        if (this.moduleCache != null) {
            this.moduleCache.reset();
        }
        this.moduleCache = new ModuleCache(domainMBean, this.dm);
    }

    private MBeanServerConnection getMBeanServerForType(int n) throws ServerConnectionException {
        if (this.adminURI == null) {
            throw new ServerConnectionException("Admin URI cannot be null");
        }
        return this.getMBeanServer(this.adminURI, this.auth1, this.auth2, n);
    }

    private MBeanServerConnection getMBeanServer(URI uRI, String string, String string2, int n) throws ServerConnectionException {
        String string3 = "";
        string3 = n == 3 ? "weblogic.management.mbeanservers.domainruntime" : "weblogic.management.mbeanservers.runtime";
        String string4 = "localhost";
        int n2 = 7001;
        String string5 = "t3";
        try {
            Object object;
            Object object2;
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            if (string != null) {
                hashtable.put("java.naming.security.principal", string);
                hashtable.put("java.naming.security.credentials", string2);
            }
            if (uRI == null || string == null) {
                object2 = ManagementService.getRuntimeAccess(kernelId);
                if (object2 != null && object2.isAdminServer()) {
                    return null;
                }
                object = ManagementService.getPropertyService(kernelId).getAdminBinaryURL();
                this.adminUrl = object;
                if (object != null) {
                    uRI = new URI((String)object);
                }
            }
            if (uRI != null) {
                this.adminUrl = uRI.toString();
                string4 = uRI.getHost();
                n2 = uRI.getPort();
                string5 = this.extractProtocol(uRI.getScheme());
            }
            hashtable.put("jmx.remote.protocol.provider.pkgs", "weblogic.management.remote");
            object2 = new JMXServiceURL(string5, string4, n2, "/jndi/" + string3);
            if (debug) {
                Debug.say("Connecting to MBeanServer at " + ((JMXServiceURL)object2).toString());
            }
            object = JMXConnectorFactory.connect((JMXServiceURL)object2, hashtable);
            if (n == 3) {
                this.jmx = object;
                this.getConfigurationManager(string5, string4, n2, hashtable);
            } else {
                this.runtimeJmx = object;
            }
            return object.getMBeanServerConnection();
        }
        catch (Exception exception) {
            if (debug) {
                exception.printStackTrace();
            }
            throw new ServerConnectionException(SPIDeployerLogger.failedMBeanConnection((String)(string5 + "://" + string4 + ":" + n2), (String)string, (String)exception.getMessage()), exception);
        }
    }

    private void getConfigurationManager(String string, String string2, int n, Hashtable hashtable) throws IOException, MalformedObjectNameException {
        Object object;
        if (this.configMgr != null) {
            return;
        }
        if (this.editJmx == null) {
            object = new JMXServiceURL(string, string2, n, "/jndi/weblogic.management.mbeanservers.edit");
            this.editJmx = JMXConnectorFactory.connect((JMXServiceURL)object, hashtable);
        }
        object = (EditServiceMBean)MBeanServerInvocationHandler.newProxyInstance((JMXConnector)this.editJmx, (ObjectName)new ObjectName(EditServiceMBean.OBJECT_NAME));
        this.configMgr = object.getConfigurationManager();
    }

    private String extractProtocol(String string) {
        if (string == null) {
            return "t3";
        }
        return string;
    }

    private Context getEnvironment(URI uRI, String string, String string2) throws NamingException, URISyntaxException {
        Context context;
        if (this.dm.isAuthenticated()) {
            return null;
        }
        if (debug) {
            Debug.say("setting environment");
        }
        if (string == null || uRI == null) {
            return null;
        }
        String string3 = this.getUriAsString(uRI);
        if (debug) {
            Debug.say("getting context using " + string3);
        }
        if (string3.startsWith(IIOP)) {
            if (System.getProperty("weblogic.system.iiop.enableClient") == null) {
                System.setProperty("weblogic.system.iiop.enableClient", "false");
            }
            context = this.getIIOPContext(string3, string, string2);
        } else {
            context = this.getContext(string3, string, string2);
        }
        return context;
    }

    private String getUriAsString(URI uRI) throws URISyntaxException {
        String string = this.extractProtocol(uRI.getScheme());
        String string2 = uRI.getHost();
        int n = uRI.getPort();
        return new URI(string, null, string2, n, null, null, null).toString();
    }

    private Context getIIOPContext(String string, String string2, String string3) throws NamingException {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("java.naming.factory.initial", "weblogic.jndi.WLInitialContextFactory");
        hashtable.put("java.naming.provider.url", string);
        hashtable.put("java.naming.security.principal", string2);
        hashtable.put("java.naming.security.credentials", string3);
        return new InitialContext(hashtable);
    }

    private Context getContext(String string, String string2, String string3) throws NamingException {
        Environment environment = new Environment();
        environment.setProviderUrl(string);
        environment.setSecurityPrincipal(string2);
        environment.setSecurityCredentials(string3);
        return environment.getInitialContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close(boolean bl) {
        if (debug) {
            Debug.say("Closing DM connection");
        }
        Map map = this.listeners;
        synchronized (map) {
            for (ProgressObjectImpl progressObjectImpl : this.listeners.keySet()) {
                if (bl) {
                    try {
                        progressObjectImpl.cancel();
                        progressObjectImpl.setAction(ActionType.CANCEL);
                    }
                    catch (OperationUnsupportedException operationUnsupportedException) {
                        // empty catch block
                    }
                }
                progressObjectImpl.setState(StateType.RELEASED);
                progressObjectImpl.reportEvent();
            }
            this.listeners.clear();
            this.forceStop = true;
            if (this.poller != null) {
                this.poller.interrupt();
            }
        }
        if (debug) {
            Debug.say("Unregistered all listeners");
        }
        this.waitForPollerToStop();
        if (this.moduleCache != null) {
            this.moduleCache.close();
        }
        if (this.targetCache != null) {
            this.targetCache.close();
        }
        if (this.domainManager != null) {
            this.domainManager.close();
        }
        this.closeJMX();
        try {
            if (this.ctx != null) {
                this.ctx.close();
            }
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        this.mbs = null;
        this.closed = true;
    }

    private void closeJMX() {
        block14: {
            block13: {
                block12: {
                    try {
                        if (this.jmx != null) {
                            this.jmx.close();
                            if (debug) {
                                Debug.say("Closed JMX connection");
                            }
                        }
                    }
                    catch (IOException iOException) {
                        if (!debug) break block12;
                        Debug.say("Failed to close JMX connection");
                        iOException.printStackTrace();
                    }
                }
                try {
                    if (this.runtimeJmx != null) {
                        this.runtimeJmx.close();
                        if (debug) {
                            Debug.say("Closed Runtime JMX connection");
                        }
                    }
                }
                catch (IOException iOException) {
                    if (!debug) break block13;
                    Debug.say("Failed to close Runtime JMX connection");
                    iOException.printStackTrace();
                }
            }
            try {
                if (this.editJmx != null) {
                    this.editJmx.close();
                    if (debug) {
                        Debug.say("Closed Edit JMX connection");
                    }
                }
            }
            catch (IOException iOException) {
                if (!debug) break block14;
                Debug.say("Failed to close Edit JMX connection");
                iOException.printStackTrace();
            }
        }
        this.jmx = null;
        this.runtimeJmx = null;
        this.editJmx = null;
    }

    private void waitForPollerToStop() {
        while (this.poller != null) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerListener(ProgressObjectImpl progressObjectImpl) throws ServerConnectionException {
        try {
            Object object;
            String string = progressObjectImpl.getTask();
            if (ddebug) {
                Debug.say("Register listener for task " + string);
            }
            if (string == null) {
                progressObjectImpl.setMessage(SPIDeployerLogger.lostTask());
                progressObjectImpl.reportEvent();
                return;
            }
            DeploymentTaskRuntimeMBean deploymentTaskRuntimeMBean = this.helper.getTaskMBean(string);
            if (deploymentTaskRuntimeMBean != null) {
                if (ddebug) {
                    Debug.say("Adding app listener for task " + string);
                }
                object = new AppListener(progressObjectImpl, deploymentTaskRuntimeMBean);
                Map map = this.listeners;
                synchronized (map) {
                    this.listeners.put(progressObjectImpl, object);
                }
            }
            if (ddebug) {
                Debug.say("Starting poller as nec for  task " + string);
            }
            object = this.listeners;
            synchronized (object) {
                if (this.poller == null) {
                    this.poller = new TaskPoller(POLLER_NAME);
                    this.poller.start();
                }
            }
        }
        catch (ServerConnectionException serverConnectionException) {
            throw serverConnectionException;
        }
        catch (Throwable throwable) {
            throw new ServerConnectionException(SPIDeployerLogger.noSuchApp((String)progressObjectImpl.getTask()), throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregisterListener(ProgressObjectImpl progressObjectImpl) {
        Map map = this.listeners;
        synchronized (map) {
            AppListener appListener = (AppListener)this.listeners.get(progressObjectImpl);
            if (appListener != null) {
                if (ddebug) {
                    Debug.say("removing listener: " + appListener);
                }
                this.listeners.remove(progressObjectImpl);
            }
        }
    }

    public JMXDeployerHelper getHelper() {
        return this.helper;
    }

    public MBeanServerConnection getMBeanServerConnection() {
        return this.mbs;
    }

    public MBeanServerConnection getRuntimeServerConnection() {
        return this.runtimeMBS;
    }

    public void setRemote() {
        if (debug) {
            Debug.say("Running in remote mode");
        }
        this.isRemote = true;
    }

    public boolean isUploadEnabled() {
        return this.isRemote;
    }

    public List getTargets() throws ServerConnectionException {
        List list = this.getServers();
        list.addAll(this.getClusters());
        list.addAll(this.getHosts());
        list.addAll(this.getJmsServers());
        list.addAll(this.getSafAgents());
        return list;
    }

    public List getServers() throws ServerConnectionException {
        return this.targetCache.getTargets(WebLogicTargetType.SERVER);
    }

    public List getClusters() throws ServerConnectionException {
        return this.targetCache.getTargets(WebLogicTargetType.CLUSTER);
    }

    public List getHosts() throws ServerConnectionException {
        return this.targetCache.getTargets(WebLogicTargetType.VIRTUALHOST);
    }

    public List getJmsServers() throws ServerConnectionException {
        return this.targetCache.getTargets(WebLogicTargetType.JMSSERVER);
    }

    public List getSafAgents() throws ServerConnectionException {
        return this.targetCache.getTargets(WebLogicTargetType.SAFAGENT);
    }

    public boolean isRunning(TargetModuleID targetModuleID) throws ServerConnectionException {
        try {
            if (!this.isTargetAlive(targetModuleID.getTarget())) {
                return false;
            }
            if (((TargetModuleIDImpl)targetModuleID).getValue() == WebLogicModuleType.SUBMODULE.getValue()) {
                return true;
            }
            AppRuntimeStateRuntimeMBean appRuntimeStateRuntimeMBean = this.helper.getAppRuntimeStateMBean();
            if (appRuntimeStateRuntimeMBean == null) {
                return false;
            }
            String string = targetModuleID.getParentTargetModuleID() == null ? appRuntimeStateRuntimeMBean.getCurrentState(targetModuleID.getModuleID(), targetModuleID.getTarget().getName()) : appRuntimeStateRuntimeMBean.getCurrentState(targetModuleID.getParentTargetModuleID().getModuleID(), targetModuleID.getModuleID(), targetModuleID.getTarget().getName());
            return "STATE_ACTIVE".equals(string);
        }
        catch (Exception exception) {
            throw new ServerConnectionException(exception.getMessage(), exception);
        }
    }

    private boolean isTargetAlive(Target target) {
        List list = this.getServersForTarget((TargetImpl)target);
        for (int i = 0; i < list.size(); ++i) {
            Target target2 = (Target)list.get(i);
            if (!this.helper.isServerAlive(target2.getName())) continue;
            return true;
        }
        return false;
    }

    public void validateTargets(Target[] targetArray) throws TargetException, ServerConnectionException {
        if (debug) {
            Debug.say("Validating targets");
        }
        if (targetArray == null || targetArray.length == 0) {
            throw new TargetException(SPIDeployerLogger.nullTargetArray());
        }
        List list = this.getTargets();
        for (int i = 0; i < targetArray.length; ++i) {
            if (targetArray[i] == null) {
                throw new TargetException(SPIDeployerLogger.nullTarget());
            }
            if (list.contains(targetArray[i])) continue;
            throw new TargetException(SPIDeployerLogger.noSuchTarget((String)targetArray[i].getName(), (String)targetArray[i].getDescription()));
        }
    }

    public List getModules(ConfigurationMBean configurationMBean) throws ServerConnectionException {
        boolean bl = configurationMBean instanceof AppDeploymentMBean;
        if (!(configurationMBean instanceof BasicDeploymentMBean) && !(configurationMBean instanceof SubDeploymentMBean)) {
            throw new IllegalArgumentException(SPIDeployerLogger.invalidMBean((String)configurationMBean.getObjectName().toString()));
        }
        List list = this.getModules();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            TargetModuleIDImpl targetModuleIDImpl = (TargetModuleIDImpl)iterator.next();
            if (!targetModuleIDImpl.getModuleID().equals(configurationMBean.getName())) {
                iterator.remove();
                continue;
            }
            if (bl && targetModuleIDImpl.getParentTargetModuleID() != null) {
                iterator.remove();
                continue;
            }
            if (bl || configurationMBean.getParent().getName().equals(targetModuleIDImpl.getParentTargetModuleID().getModuleID())) continue;
            iterator.remove();
        }
        return list;
    }

    public List getModulesForTarget(ModuleType moduleType, Target target) throws TargetException, ServerConnectionException {
        Target[] targetArray = new Target[]{target};
        this.validateTargets(targetArray);
        List list = this.getModules(Arrays.asList(targetArray).iterator());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            TargetModuleIDImpl targetModuleIDImpl = (TargetModuleIDImpl)iterator.next();
            if (debug) {
                Debug.say("checking tmid, " + targetModuleIDImpl.getModuleID() + ", " + Integer.toString(moduleType.getValue()));
            }
            if (targetModuleIDImpl.getValue() != moduleType.getValue()) {
                iterator.remove();
            }
            if (targetModuleIDImpl.getTarget().getName().equals(target.getName())) continue;
            iterator.remove();
        }
        return list;
    }

    public List getModulesForTargets(ModuleType moduleType, Target[] targetArray) throws TargetException, ServerConnectionException {
        this.validateTargets(targetArray);
        List list = this.getModules(Arrays.asList(targetArray).iterator());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            TargetModuleIDImpl targetModuleIDImpl = (TargetModuleIDImpl)iterator.next();
            this.populateWarUrlIfNecessary(targetModuleIDImpl);
            if (debug) {
                Debug.say("checking tmid, " + targetModuleIDImpl.getModuleID() + ", " + Integer.toString(moduleType.getValue()));
            }
            if (targetModuleIDImpl.getValue() != moduleType.getValue()) {
                iterator.remove();
            }
            boolean bl = false;
            for (int i = 0; i < targetArray.length; ++i) {
                if (!targetModuleIDImpl.getTarget().getName().equals(targetArray[i].getName())) continue;
                bl = true;
            }
            if (bl) continue;
            iterator.remove();
        }
        return list;
    }

    private void populateWarUrlIfNecessary(TargetModuleIDImpl targetModuleIDImpl) {
        block8: {
            if (targetModuleIDImpl == null) {
                return;
            }
            TargetModuleIDImpl targetModuleIDImpl2 = targetModuleIDImpl;
            String string = null;
            if (targetModuleIDImpl2.getValue() == ModuleType.WAR.getValue()) {
                try {
                    ServerRuntimeMBean serverRuntimeMBean;
                    String string2 = this.getServerName(targetModuleIDImpl2);
                    DomainRuntimeServiceMBean domainRuntimeServiceMBean = (DomainRuntimeServiceMBean)MBeanServerInvocationHandler.newProxyInstance((MBeanServerConnection)this.getMBeanServerConnection(), (ObjectName)new ObjectName(DomainRuntimeServiceMBean.OBJECT_NAME));
                    if (domainRuntimeServiceMBean != null && (serverRuntimeMBean = domainRuntimeServiceMBean.lookupServerRuntime(string2)) != null) {
                        ComponentRuntimeMBean[] componentRuntimeMBeanArray;
                        String string3 = serverRuntimeMBean.getURL("http");
                        ApplicationRuntimeMBean applicationRuntimeMBean = serverRuntimeMBean.lookupApplicationRuntime(targetModuleIDImpl2.getApplicationName());
                        if (applicationRuntimeMBean != null && (componentRuntimeMBeanArray = applicationRuntimeMBean.getComponentRuntimes()) != null) {
                            for (ComponentRuntimeMBean componentRuntimeMBean : componentRuntimeMBeanArray) {
                                WebAppComponentRuntimeMBean webAppComponentRuntimeMBean;
                                if (!(componentRuntimeMBean instanceof WebAppComponentRuntimeMBean) || !this.isMatchingTmidAndComponentMBean(targetModuleIDImpl2, webAppComponentRuntimeMBean = (WebAppComponentRuntimeMBean)componentRuntimeMBean)) continue;
                                string = webAppComponentRuntimeMBean.getContextRoot();
                                break;
                            }
                        }
                        if (string3 != null && string != null) {
                            targetModuleIDImpl2.setWebURL(string3 + string);
                        }
                    }
                }
                catch (Exception exception) {
                    if (!debug) break block8;
                    Debug.say("Unable to lookup the WAR's URL: " + exception.getMessage());
                }
            }
        }
    }

    private boolean isMatchingTmidAndComponentMBean(TargetModuleIDImpl targetModuleIDImpl, WebAppComponentRuntimeMBean webAppComponentRuntimeMBean) {
        if (targetModuleIDImpl.getParentTargetModuleID() != null) {
            String string = targetModuleIDImpl.getModuleID();
            String string2 = webAppComponentRuntimeMBean.getModuleId();
            if (string2.charAt(0) == '/') {
                string2 = string2.substring(1);
            }
            return string.equals(string2);
        }
        String string = targetModuleIDImpl.getApplicationName();
        String string3 = webAppComponentRuntimeMBean.getApplicationIdentifier();
        int n = string3.indexOf(35);
        if (n != -1) {
            string3 = string3.substring(0, n);
        }
        return string.equals(string3);
    }

    public void populateWarUrlInChildren(TargetModuleID targetModuleID) {
        if (!(targetModuleID instanceof TargetModuleIDImpl)) {
            return;
        }
        TargetModuleIDImpl targetModuleIDImpl = (TargetModuleIDImpl)targetModuleID;
        if (targetModuleIDImpl.getValue() == ModuleType.WAR.getValue()) {
            this.populateWarUrlIfNecessary(targetModuleIDImpl);
        } else {
            TargetModuleID[] targetModuleIDArray = targetModuleID.getChildTargetModuleID();
            if (targetModuleIDArray != null) {
                for (TargetModuleID targetModuleID2 : targetModuleIDArray) {
                    this.populateWarUrlInChildren(targetModuleID2);
                }
            }
        }
    }

    private String getServerName(TargetModuleIDImpl targetModuleIDImpl) {
        String string = null;
        TargetImpl targetImpl = (TargetImpl)targetModuleIDImpl.getTarget();
        if (targetImpl.isCluster()) {
            ClusterMBean[] clusterMBeanArray;
            DomainMBean domainMBean = this.domainManager.getDomain();
            for (ClusterMBean clusterMBean : clusterMBeanArray = domainMBean.getClusters()) {
                ServerMBean[] serverMBeanArray;
                if (!clusterMBean.getName().equals(targetImpl.getName()) || (serverMBeanArray = clusterMBean.getServers()) == null || serverMBeanArray.length <= 0) continue;
                string = serverMBeanArray[0].getName();
                break;
            }
        } else {
            string = targetImpl.getName();
        }
        return string;
    }

    public List getModules(Iterator iterator) throws ServerConnectionException {
        ArrayList arrayList = new ArrayList();
        while (iterator.hasNext()) {
            Target target = (Target)iterator.next();
            arrayList.addAll(this.moduleCache.getModules(target));
        }
        return arrayList;
    }

    public List getModules() throws ServerConnectionException {
        Iterator iterator = this.getTargets().iterator();
        return this.getModules(iterator);
    }

    public InstallDir upload(InstallDir installDir, String string, String[] stringArray) throws ServerConnectionException, IOException {
        InstallDir installDir2 = installDir;
        boolean bl = false;
        try {
            if (this.isRemote) {
                Object object;
                Object object2;
                if (!installDir.isProper()) {
                    bl = true;
                    object2 = new File(DomainDir.getTempDirForServer((String)this.helper.getAdminServerName()), installDir.getArchive().getName());
                    if (!((File)object2).exists()) {
                        object = System.getProperty("java.io.tmpdir");
                        if (object == null) {
                            object = "/tmp";
                        }
                        object2 = new File((String)object, installDir.getArchive().getName());
                    }
                    installDir2 = new InstallDir(installDir.getArchive().getName(), (File)object2);
                    installDir2.getAppDir().mkdir();
                    FileUtils.copy((File)installDir.getArchive().getCanonicalFile(), (File)installDir2.getArchive());
                    installDir2.getConfigDir().mkdir();
                    if (installDir.getConfigDir().exists()) {
                        FileUtils.copy((File)installDir.getConfigDir(), (File)installDir2.getConfigDir());
                    }
                    if (installDir.getPlan() != null) {
                        installDir2.setPlan(new File(installDir2.getConfigDir(), installDir.getPlan().getName()));
                        FileUtils.copy((File)installDir.getPlan().getCanonicalFile(), (File)installDir2.getPlan());
                    }
                }
                object2 = this.helper.uploadSource(this.adminUrl, this.auth1, this.auth2, installDir2.getInstallDir().getPath(), stringArray, string);
                object = new File((String)object2);
                installDir.resetInstallDir((File)object);
                installDir.setArchive(new File(installDir.getAppDir(), installDir2.getArchive().getName()));
                if (installDir2.getPlan() != null) {
                    installDir.setPlan(new File(installDir.getConfigDir(), installDir2.getPlan().getName()));
                }
                if (debug) {
                    Debug.say("Uploaded app to " + (String)object2);
                }
            }
        }
        catch (DeployerHelperException deployerHelperException) {
            throw new ServerConnectionException(SPIDeployerLogger.uploadFailure((String)this.adminUrl, (String)installDir.getArchive().getPath()), deployerHelperException);
        }
        finally {
            if (bl) {
                FileUtils.remove((File)installDir2.getInstallDir());
            }
        }
        return installDir;
    }

    public InstallDir upload2(InstallDir installDir, String string, String[] stringArray) throws ServerConnectionException, IOException {
        block21: {
            String string2 = installDir.getArchive() == null ? null : installDir.getArchive().getCanonicalPath();
            String string3 = null;
            if (installDir.getPlan() != null) {
                string3 = installDir.getPlan().getPath();
            }
            try {
                Serializable serializable;
                Object object;
                File file;
                if (!this.isRemote) break block21;
                File file2 = null;
                File file3 = null;
                if (string2 != null) {
                    file3 = new File(string2);
                    if (string3 != null) {
                        file2 = new File(string3);
                    }
                    if (!installDir.isInAppDir(file3)) {
                        file = installDir.getAppDir();
                        if (file.exists()) {
                            FileUtils.remove((File)file);
                        }
                        file.mkdirs();
                        object = new File(file, file3.getName());
                        if (debug) {
                            Debug.say("Copying " + file3.getPath() + " to app area, " + ((File)object).getPath());
                        }
                        serializable = new HashSet();
                        ((HashSet)serializable).add(file);
                        FileUtils.copy((File)file3, (File)object, (Set)((Object)serializable));
                        this.delApp = object;
                        installDir.setArchive(((File)object).getCanonicalFile());
                    } else {
                        installDir.setArchive(file3.getCanonicalFile());
                    }
                }
                file = installDir.getConfigDir().getCanonicalFile().getParentFile();
                if (!installDir.getInstallDir().equals(file)) {
                    file = new File(installDir.getInstallDir(), "plan");
                    file.mkdirs();
                    if (debug) {
                        Debug.say("Copying plan dir at " + installDir.getConfigDir() + " to " + file);
                    }
                    FileUtils.copy((File)installDir.getConfigDir(), (File)file);
                    installDir.setConfigDir(file);
                }
                if (file2 != null) {
                    if (!installDir.isInConfigDir(file2)) {
                        object = new File(installDir.getConfigDir(), file2.getName());
                        if (debug) {
                            Debug.say("Copying plan at " + file2.getPath() + " to config area, " + ((File)object).getPath());
                        }
                        FileUtils.copy((File)file2, (File)object);
                        installDir.setPlan(((File)object).getCanonicalFile());
                    } else {
                        installDir.setPlan(file2.getCanonicalFile());
                    }
                }
                object = this.helper.uploadSource(this.adminUrl, this.auth1, this.auth2, installDir.getInstallDir().getPath(), stringArray, string);
                serializable = new File((String)object);
                try {
                    serializable = new File(new URI((String)object));
                }
                catch (Exception exception) {
                    Debug.say("Caught: " + exception);
                }
                installDir.resetInstallDir((File)serializable);
                if (file3 != null) {
                    installDir.setArchive(new File(installDir.getAppDir(), file3.getName()));
                }
                if (file2 != null) {
                    installDir.setPlan(new File(installDir.getConfigDir(), file2.getName()));
                }
                if (debug) {
                    Debug.say("Uploaded app to " + (String)object);
                }
                if (this.delApp != null) {
                    FileUtils.remove((File)this.delApp);
                    this.delApp = null;
                }
            }
            catch (DeployerHelperException deployerHelperException) {
                throw new ServerConnectionException(SPIDeployerLogger.uploadFailure((String)this.adminUrl, (String)string2), deployerHelperException);
            }
        }
        return installDir;
    }

    public String uploadApp(String string, String string2, String[] stringArray) throws ServerConnectionException {
        String string3 = string;
        try {
            if (this.isRemote) {
                string3 = this.helper.uploadSource(this.adminUrl, this.auth1, this.auth2, string, stringArray, string2);
                if (debug) {
                    Debug.say("Uploaded file, " + string + " to " + this.adminUrl + ": " + string3);
                }
            }
            return string3;
        }
        catch (DeployerHelperException deployerHelperException) {
            throw new ServerConnectionException(SPIDeployerLogger.uploadFailure((String)this.adminUrl, (String)string), deployerHelperException);
        }
    }

    public String uploadConfig(String string, DeploymentPlanBean deploymentPlanBean, String string2) throws ServerConnectionException {
        String string3 = deploymentPlanBean.getConfigRoot();
        String string4 = null;
        if (string3 != null) {
            string4 = new File(string3).getParent();
        }
        try {
            String string5;
            InstallDir installDir = new InstallDir(string2, string4);
            String string6 = string5 = new File(string).getAbsoluteFile().getPath();
            if (this.isRemote) {
                File file = new File(string5);
                if (!installDir.isInConfigDir(file)) {
                    File file2 = new File(installDir.getConfigDir(), file.getName());
                    if (debug) {
                        Debug.say("Copying " + file.getPath() + " to config area, " + file2.getPath());
                    }
                    FileUtils.copy((File)file, (File)file2);
                    installDir.setPlan(file2);
                    string5 = installDir.getConfigDir().getPath();
                }
                string6 = this.helper.uploadPlan(this.adminUrl, this.auth1, this.auth2, string5, string2);
                if (debug) {
                    Debug.say("Uploaded file, " + string5 + " to " + this.adminUrl + ": " + string6);
                }
            }
            return string6;
        }
        catch (DeployerHelperException deployerHelperException) {
            throw new ServerConnectionException(SPIDeployerLogger.uploadFailure((String)this.adminUrl, (String)string3), deployerHelperException);
        }
        catch (IOException iOException) {
            throw new ServerConnectionException(SPIDeployerLogger.uploadFailure((String)this.adminUrl, (String)string3), iOException);
        }
    }

    public TargetModuleID[] getResultTmids(AppDeploymentMBean appDeploymentMBean, Target[] targetArray) throws TargetException, ServerConnectionException {
        if (appDeploymentMBean == null) {
            return new TargetModuleID[0];
        }
        if (ddebug) {
            Debug.say("Getting tmids for app: " + appDeploymentMBean.getName());
        }
        if (appDeploymentMBean == null) {
            return new TargetModuleID[0];
        }
        ArrayList<TargetModuleID> arrayList = new ArrayList<TargetModuleID>();
        for (int i = 0; i < targetArray.length; ++i) {
            TargetModuleID targetModuleID = this.moduleCache.getTMID(appDeploymentMBean, targetArray[i]);
            if (targetModuleID == null) continue;
            arrayList.add(targetModuleID);
        }
        return arrayList.toArray(new TargetModuleID[0]);
    }

    public ModuleCache getModuleCache() {
        return this.moduleCache;
    }

    public String uploadPlan(String string, String string2) throws ServerConnectionException {
        try {
            String string3 = this.helper.uploadPlan(this.adminUrl, this.auth1, this.auth2, string, string2);
            if (debug) {
                Debug.say("Uploaded file, " + string + " to " + this.adminUrl + ": " + string3);
            }
            return string3;
        }
        catch (DeployerHelperException deployerHelperException) {
            throw new ServerConnectionException(SPIDeployerLogger.uploadFailure((String)this.adminUrl, (String)string), deployerHelperException);
        }
    }

    public void test() throws Throwable {
        this.helper.getTaskByID("23");
    }

    public void resetDomain(DomainMBean domainMBean) {
        this.initCaches(domainMBean);
    }

    public List getServersForCluster(TargetImpl targetImpl) throws ServerConnectionException {
        ArrayList<TargetImpl> arrayList = new ArrayList<TargetImpl>();
        List list = this.targetCache.getMBeans();
        for (int i = 0; i < list.size(); ++i) {
            ClusterMBean clusterMBean;
            Object e = list.get(i);
            if (!(e instanceof ServerMBean) || (clusterMBean = ((ServerMBean)e).getCluster()) == null || !clusterMBean.getName().equals(targetImpl.getName())) continue;
            arrayList.add(this.targetCache.getTarget(((ServerMBean)e).getName()));
        }
        return arrayList;
    }

    public List getServersForJmsServer(TargetImpl targetImpl) throws ServerConnectionException {
        return this.getServersForDeployableTarget(targetImpl);
    }

    public List getServersForSafAgent(TargetImpl targetImpl) throws ServerConnectionException {
        return this.getServersForTarget(targetImpl);
    }

    public List getServersForHost(TargetImpl targetImpl) throws ServerConnectionException {
        return this.getServersForDeployableTarget(targetImpl);
    }

    private List getServersForDeployableTarget(TargetImpl targetImpl) throws ServerConnectionException {
        HashSet<TargetImpl> hashSet = new HashSet<TargetImpl>();
        ConfigurationMBean configurationMBean = this.targetCache.getMBean(targetImpl.getName());
        if (configurationMBean instanceof DeploymentMBean) {
            DeploymentMBean deploymentMBean = (DeploymentMBean)configurationMBean;
            TargetMBean[] targetMBeanArray = deploymentMBean.getTargets();
            for (int i = 0; i < targetMBeanArray.length; ++i) {
                TargetMBean targetMBean = targetMBeanArray[i];
                if (targetMBean instanceof ServerMBean) {
                    hashSet.add(this.targetCache.getTarget(targetMBean.getName()));
                    continue;
                }
                if (!(targetMBean instanceof ClusterMBean)) continue;
                hashSet.addAll(this.getServersForCluster(this.targetCache.getTarget(targetMBean.getName())));
            }
        }
        return new ArrayList(hashSet);
    }

    private List getServersForTarget(TargetImpl targetImpl) throws ServerConnectionException {
        ArrayList<TargetImpl> arrayList = new ArrayList<TargetImpl>();
        if (targetImpl.isServer()) {
            arrayList.add(targetImpl);
        } else if (targetImpl.isCluster()) {
            arrayList.addAll(this.getServersForCluster(targetImpl));
        } else if (targetImpl.isVirtualHost()) {
            arrayList.addAll(this.getServersForHost(targetImpl));
        } else if (targetImpl.isJMSServer()) {
            arrayList.addAll(this.getServersForJmsServer(targetImpl));
        }
        return arrayList;
    }

    public TargetImpl getTarget(String string) throws ServerConnectionException {
        return this.targetCache.getTarget(string);
    }

    public void setLocale(Locale locale) throws IOException {
        this.setLocale(locale, this.jmx);
        this.setLocale(locale, this.runtimeJmx);
        this.setLocale(locale, this.editJmx);
    }

    private void setLocale(Locale locale, JMXConnector jMXConnector) throws IOException {
        if (jMXConnector == null) {
            return;
        }
        if (jMXConnector instanceof WLSJMXConnector) {
            ((WLSJMXConnector)jMXConnector).getMBeanServerConnection(locale);
        }
    }

    public AppRuntimeStateRuntimeMBean getAppRuntimeStateRuntimeMBean() {
        try {
            return this.helper.getAppRuntimeStateMBean();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public DomainMBean getDomainMBean() {
        return this.domainManager.getDomain();
    }

    public class TaskPoller
    extends Thread {
        private Map msgMap;

        public TaskPoller(String string) {
            super(string);
            this.msgMap = new HashMap();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                if (ddebug) {
                    Debug.say("Poller starting up");
                }
                boolean bl = true;
                while (!(!bl || TaskPoller.interrupted() && ServerConnectionImpl.this.forceStop)) {
                    bl = this.poll();
                    try {
                        if (!bl) continue;
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        if (!ServerConnectionImpl.this.forceStop) continue;
                        break;
                    }
                }
                Map map = ServerConnectionImpl.this.listeners;
                synchronized (map) {
                    ServerConnectionImpl.this.poller = null;
                    if (ddebug) {
                        Debug.say("Poller shut down");
                    }
                }
            }
            catch (Throwable throwable) {
                SPIDeployerLogger.logPollerError((Throwable)throwable);
                ServerConnectionImpl.this.dm.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean poll() {
            HashSet<ProgressObjectImpl> hashSet = new HashSet<ProgressObjectImpl>();
            Map map = ServerConnectionImpl.this.listeners;
            synchronized (map) {
                for (ProgressObjectImpl progressObjectImpl : ServerConnectionImpl.this.listeners.keySet()) {
                    int n = this.getMessageIndex(progressObjectImpl);
                    try {
                        DeploymentTaskRuntimeMBean deploymentTaskRuntimeMBean = progressObjectImpl.getDtrm();
                        if (deploymentTaskRuntimeMBean != null) {
                            this.report(deploymentTaskRuntimeMBean, n, progressObjectImpl);
                            int n2 = deploymentTaskRuntimeMBean.getState();
                            if (n2 == 1 || n2 == 0) continue;
                            this.completeTask(n2, progressObjectImpl, deploymentTaskRuntimeMBean);
                            progressObjectImpl.reportEvent();
                            hashSet.add(progressObjectImpl);
                            continue;
                        }
                        if (progressObjectImpl.getDeploymentStatus().getState() == StateType.RUNNING) {
                            progressObjectImpl.setMessage(SPIDeployerLogger.lostTask());
                            progressObjectImpl.setState(StateType.RELEASED);
                            progressObjectImpl.reportEvent();
                        }
                        hashSet.add(progressObjectImpl);
                    }
                    catch (Throwable throwable) {
                        SPIDeployerLogger.logConnectionError((String)throwable.getMessage(), (Throwable)throwable);
                        progressObjectImpl.setState(StateType.RELEASED);
                        progressObjectImpl.setError(throwable);
                        progressObjectImpl.reportEvent();
                        hashSet.add(progressObjectImpl);
                    }
                }
                Iterator<Object> iterator = hashSet.iterator();
                while (iterator.hasNext()) {
                    ServerConnectionImpl.this.deregisterListener((ProgressObjectImpl)iterator.next());
                }
                return ServerConnectionImpl.this.listeners.size() > 0;
            }
        }

        private void completeTask(int n, ProgressObjectImpl progressObjectImpl, DeploymentTaskRuntimeMBean deploymentTaskRuntimeMBean) {
            switch (n) {
                case 4: {
                    if (ddebug) {
                        Debug.say("task state is deferred");
                    }
                    progressObjectImpl.setState(StateType.COMPLETED);
                    break;
                }
                case 2: {
                    if (ddebug) {
                        Debug.say("task state is complete");
                    }
                    progressObjectImpl.setState(StateType.COMPLETED);
                    break;
                }
                case 3: {
                    if (ddebug) {
                        Debug.say("task state is failed");
                    }
                    Exception exception = null;
                    try {
                        exception = deploymentTaskRuntimeMBean.getError();
                    }
                    catch (Throwable throwable) {
                        try {
                            List list = deploymentTaskRuntimeMBean.getTaskMessages();
                            if (list != null) {
                                for (int i = 0; i < list.size(); ++i) {
                                    String string = (String)list.get(i);
                                    progressObjectImpl.setMessage(string);
                                }
                            }
                        }
                        catch (Throwable throwable2) {
                            progressObjectImpl.setMessage(StackTraceUtils.throwable2StackTrace((Throwable)throwable2));
                        }
                    }
                    if (exception != null) {
                        progressObjectImpl.setError(exception);
                    } else if (progressObjectImpl.getDeploymentStatus().getMessage() == null) {
                        progressObjectImpl.setMessage(SPIDeployerLogger.unknownError((String)deploymentTaskRuntimeMBean.getDescription()));
                    }
                    progressObjectImpl.setState(StateType.FAILED);
                }
            }
        }

        private int getMessageIndex(ProgressObjectImpl progressObjectImpl) {
            Integer n = (Integer)this.msgMap.get(progressObjectImpl);
            if (n == null) {
                n = new Integer(0);
                this.msgMap.put(progressObjectImpl, n);
            }
            return n;
        }

        private void updateMessageIndex(ProgressObjectImpl progressObjectImpl, int n) {
            this.msgMap.put(progressObjectImpl, new Integer(n));
        }

        private void report(DeploymentTaskRuntimeMBean deploymentTaskRuntimeMBean, int n, ProgressObjectImpl progressObjectImpl) {
            List list = deploymentTaskRuntimeMBean.getTaskMessages();
            if (list != null && list.size() > n) {
                for (int i = n; i < list.size(); ++i) {
                    String string = (String)list.get(i);
                    progressObjectImpl.reportEvent(string);
                }
                this.updateMessageIndex(progressObjectImpl, list.size());
            }
        }
    }

    public class AppFilter
    implements NotificationFilter,
    Serializable {
        private static final long serialVersionUID = 1L;

        public boolean isNotificationEnabled(Notification notification) {
            return notification instanceof DeploymentNotification;
        }
    }

    public class AppListener
    implements RemoteNotificationListener,
    Serializable {
        transient String tid;
        transient DeploymentTaskRuntimeMBean task;
        transient ProgressObjectImpl po;
        private static final long serialVersionUID = 1L;

        AppListener(ProgressObjectImpl progressObjectImpl, DeploymentTaskRuntimeMBean deploymentTaskRuntimeMBean) {
            this.task = deploymentTaskRuntimeMBean;
            this.tid = deploymentTaskRuntimeMBean.getId();
            this.po = progressObjectImpl;
        }

        public void handleNotification(Notification notification, Object object) {
            if (this.tid.equals(object)) {
                String string;
                DeploymentNotification deploymentNotification = (DeploymentNotification)notification;
                if (debug) {
                    Debug.say("Received notification: " + deploymentNotification.getMessage());
                }
                String string2 = deploymentNotification.getAppName();
                String string3 = deploymentNotification.getServerName();
                String string4 = null;
                String string5 = null;
                if (deploymentNotification.isModuleNotification()) {
                    string5 = deploymentNotification.getModuleName();
                    string = deploymentNotification.getCurrentState();
                    String string6 = deploymentNotification.getTargetState();
                    String string7 = deploymentNotification.getTransition();
                    if (string7.equals("end")) {
                        string4 = SPIDeployerLogger.successfulTransition((String)string2, (String)string5, (String)string, (String)string6, (String)string3);
                    } else if (string7.equals("failed")) {
                        string4 = SPIDeployerLogger.failedTransition((String)string2, (String)string5, (String)string, (String)string6, (String)string3);
                        this.po.setError(this.task.getError());
                    }
                    if (string4 != null) {
                        this.po.setMessage(string4);
                    }
                } else {
                    string = deploymentNotification.getPhase();
                    string4 = SPIDeployerLogger.appNotification((String)string2, (String)string3, (String)string);
                    this.po.setMessage(string4);
                }
                if (string4 != null) {
                    this.updateProgress();
                    try {
                        this.po.reportEvent(string2, string5, string3, string4);
                    }
                    catch (ServerConnectionException serverConnectionException) {
                        this.po.reportEvent(string2, string5, string3, string4, serverConnectionException);
                    }
                }
            }
        }

        private void updateProgress() {
            int n = this.task.getState();
            int n2 = this.task.getCancelState();
            switch (n) {
                case 1: {
                    this.po.setState(StateType.RUNNING);
                    if (n2 == 2) {
                        this.po.setAction(ActionType.CANCEL);
                        break;
                    }
                    this.po.setAction(ActionType.EXECUTE);
                    break;
                }
                case 3: {
                    if (ddebug) {
                        Debug.say("failing task " + this.tid);
                    }
                    this.po.setState(StateType.FAILED);
                    this.po.setAction(ActionType.EXECUTE);
                    ServerConnectionImpl.this.deregisterListener(this.po);
                    break;
                }
                case 2: 
                case 4: {
                    if (ddebug) {
                        Debug.say("completing task " + this.tid);
                    }
                    this.po.setState(StateType.COMPLETED);
                    this.po.setAction(ActionType.EXECUTE);
                    ServerConnectionImpl.this.deregisterListener(this.po);
                }
            }
        }

        public String toString() {
            return "Listener on task " + this.tid;
        }
    }
}

