/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.api.spi.deploy.internal;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.spi.TargetModuleID;
import weblogic.application.utils.ApplicationVersionUtils;
import weblogic.deploy.api.internal.utils.ConfigHelper;
import weblogic.deploy.api.internal.utils.Debug;
import weblogic.deploy.api.internal.utils.InstallDir;
import weblogic.deploy.api.shared.WebLogicCommandType;
import weblogic.deploy.api.spi.DeploymentOptions;
import weblogic.deploy.api.spi.WebLogicDeploymentManager;
import weblogic.deploy.api.spi.deploy.internal.FailedOperationException;
import weblogic.deploy.api.spi.deploy.internal.RedeployOperation;
import weblogic.deploy.api.spi.exceptions.ServerConnectionException;
import weblogic.j2ee.descriptor.wl.ModuleDescriptorBean;
import weblogic.j2ee.descriptor.wl.ModuleOverrideBean;
import weblogic.utils.FileUtils;

public class UpdateOperation
extends RedeployOperation {
    protected String path;
    protected boolean inPlace;
    private String[] delta;

    public UpdateOperation(WebLogicDeploymentManager webLogicDeploymentManager, TargetModuleID[] targetModuleIDArray, File file, DeploymentOptions deploymentOptions) {
        super(webLogicDeploymentManager, targetModuleIDArray, null, file, deploymentOptions);
        this.tmids = targetModuleIDArray;
        this.cmd = WebLogicCommandType.UPDATE;
    }

    public UpdateOperation(WebLogicDeploymentManager webLogicDeploymentManager, TargetModuleID[] targetModuleIDArray, File file, String[] stringArray, DeploymentOptions deploymentOptions) {
        super(webLogicDeploymentManager, targetModuleIDArray, null, file, deploymentOptions);
        this.tmids = targetModuleIDArray;
        this.cmd = WebLogicCommandType.UPDATE;
        this.delta = stringArray;
    }

    protected void validateParams() throws FailedOperationException {
        super.validateParams();
        try {
            ConfigHelper.checkParam("plan", this.plan);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new FailedOperationException(this.failOperation(illegalArgumentException));
        }
    }

    protected void uploadFiles() throws IOException {
        String string = this.uploadConfig();
        if (debug) {
            Debug.say("Updating " + this.appName + " from " + string);
        }
    }

    protected void buildDeploymentData() {
        super.buildDeploymentData();
        this.info.setFile(this.delta);
        this.addDDPaths();
        this.info.setPlanUpdate(true);
    }

    protected void initializeTask() throws Throwable {
        this.task = this.dm.getServerConnection().getHelper().getDeployer().update(this.appName, this.info, this.dm.getTaskId(), false);
    }

    protected void setupPaths() throws FailedOperationException {
        try {
            this.paths = new InstallDir(ConfigHelper.getAppName(this.tmids, this.options), ConfigHelper.getAppRootFromPlan(this.planBean), false);
            this.paths.setPlan(this.plan.getCanonicalFile());
            ConfigHelper.initPlanDirFromPlan(this.planBean, this.paths);
        }
        catch (IOException iOException) {
            throw new FailedOperationException(this.failOperation(iOException));
        }
    }

    private String uploadConfig() throws ServerConnectionException {
        String string;
        String string2 = string = this.plan.getAbsoluteFile().getPath();
        if (!this.dm.isLocal()) {
            Object object;
            File file = new File(string);
            if (!this.paths.isInConfigDir(file)) {
                object = new File(this.paths.getConfigDir(), file.getName());
                if (debug) {
                    Debug.say("Copying " + file.getPath() + " to config area, " + ((File)object).getPath());
                }
                try {
                    FileUtils.copy((File)file, (File)object);
                }
                catch (IOException iOException) {
                    throw new ServerConnectionException(iOException.toString());
                }
                this.paths.setPlan((File)object);
            }
            string = this.paths.getConfigDir().getPath();
            object = ApplicationVersionUtils.getApplicationId(this.appName, this.options.getVersionIdentifier());
            string2 = this.dm.getServerConnection().uploadPlan(string, (String)object);
            this.paths.setConfigDir(new File(string2));
            this.paths.setPlan(new File(string2, this.plan.getName()));
        }
        return string2;
    }

    private void addDDPaths() {
        int n;
        if (this.planBean == null) {
            return;
        }
        ModuleOverrideBean[] moduleOverrideBeanArray = this.planBean.getModuleOverrides();
        if (moduleOverrideBeanArray == null) {
            return;
        }
        String string = null;
        for (n = 0; n < moduleOverrideBeanArray.length; ++n) {
            if (!this.planBean.rootModule(moduleOverrideBeanArray[n].getModuleName())) continue;
            string = moduleOverrideBeanArray[n].getModuleName();
            break;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.info.hasFiles()) {
            this.addFilesToList(this.info.getFiles(), arrayList);
        }
        for (int i = 0; i < moduleOverrideBeanArray.length; ++i) {
            boolean bl = ModuleType.EAR.toString().equals(moduleOverrideBeanArray[i].getModuleType());
            n = moduleOverrideBeanArray[i].getModuleName().equals(string) ? 1 : 0;
            ModuleDescriptorBean[] moduleDescriptorBeanArray = moduleOverrideBeanArray[i].getModuleDescriptors();
            if (moduleDescriptorBeanArray == null) continue;
            for (int j = 0; j < moduleDescriptorBeanArray.length; ++j) {
                String string2 = moduleDescriptorBeanArray[j].getUri();
                if (n == 0) {
                    string2 = moduleOverrideBeanArray[i].getModuleName() + "/" + string2;
                }
                if (!this.hasOverrides(moduleDescriptorBeanArray[j], string2) || arrayList.contains(string2)) continue;
                arrayList.add(string2);
            }
        }
        this.info.setFile(arrayList.toArray(new String[arrayList.size()]));
        if (debug) {
            Debug.say(this.info.toString());
        }
    }

    private boolean hasOverrides(ModuleDescriptorBean moduleDescriptorBean, String string) {
        if (moduleDescriptorBean.getVariableAssignments() != null && moduleDescriptorBean.getVariableAssignments().length > 0) {
            return true;
        }
        if (moduleDescriptorBean.isExternal()) {
            File file = new File(this.paths.getConfigDir(), string);
            if (debug) {
                Debug.say(file.getPath() + " has external dd: " + file.exists());
            }
            return file.exists();
        }
        return false;
    }

    private void addFilesToList(String[] stringArray, List list) {
        if (stringArray == null) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            list.add(stringArray[i]);
        }
    }
}

