/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.api.spi.deploy.mbeans;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.management.AttributeChangeNotification;
import javax.management.AttributeChangeNotificationFilter;
import javax.management.MBeanServerConnection;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import weblogic.deploy.api.internal.SPIDeployerLogger;
import weblogic.deploy.api.internal.utils.Debug;
import weblogic.deploy.api.spi.WebLogicDeploymentManager;
import weblogic.deploy.api.spi.exceptions.ServerConnectionException;
import weblogic.management.configuration.ConfigurationMBean;
import weblogic.management.configuration.DomainMBean;

public abstract class MBeanCache
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final boolean ddebug = Debug.isDebug("internal");
    private static final boolean debug = Debug.isDebug("deploy");
    private boolean cachingEnabled = true;
    private transient List mbeans = null;
    private boolean stale = true;
    protected transient WebLogicDeploymentManager dm;
    protected transient DomainMBean currDomain;
    protected Object listener;
    protected String[] listenType = null;

    MBeanCache(WebLogicDeploymentManager webLogicDeploymentManager) {
        this.dm = webLogicDeploymentManager;
    }

    public synchronized List getMBeans() throws ServerConnectionException {
        if (this.stale) {
            try {
                ConfigurationMBean[] configurationMBeanArray = this.getTypedMBeans();
                this.mbeans = new ArrayList();
                for (int i = 0; i < configurationMBeanArray.length; ++i) {
                    if (configurationMBeanArray[i] == null) continue;
                    this.mbeans.add(configurationMBeanArray[i]);
                }
                boolean bl = this.stale = !this.cachingEnabled;
                if (ddebug) {
                    Debug.say("Returning " + this.mbeans.size() + " mbeans: ");
                }
            }
            catch (Throwable throwable) {
                throw new ServerConnectionException(SPIDeployerLogger.connectionError(), throwable);
            }
        }
        return this.mbeans;
    }

    protected void addNotificationListener() {
        if (this.dm.getServerConnection().getMBeanServerConnection() == null) {
            DomainMBean domainMBean = this.currDomain;
            this.listener = new MyListener(false);
            domainMBean.addPropertyChangeListener((PropertyChangeListener)this.listener);
        } else {
            this.listener = new MyListener(true);
            try {
                MBeanServerConnection mBeanServerConnection = this.dm.getServerConnection().getRuntimeServerConnection();
                if (mBeanServerConnection == null) {
                    if (debug || ddebug) {
                        Debug.say("Disabling mbean caching since we do not runtime mbean server connection");
                    }
                    this.cachingEnabled = false;
                    return;
                }
                if (debug || ddebug) {
                    Debug.say("Adding notification listener for " + this);
                }
                mBeanServerConnection.addNotificationListener((ObjectName)this.currDomain.getObjectName(), (NotificationListener)this.listener, (NotificationFilter)new MyJMXFilter(), null);
                if (debug || ddebug) {
                    Debug.say("Added notification listener for " + this);
                }
            }
            catch (Exception exception) {
                if (debug || ddebug) {
                    Debug.say("Disabling mbean caching due to: " + exception.toString());
                }
                this.cachingEnabled = false;
            }
        }
    }

    protected void removeNotificationListener() {
        if (this.dm.getServerConnection().getMBeanServerConnection() == null) {
            DomainMBean domainMBean = this.currDomain;
            if (this.listener != null) {
                domainMBean.removePropertyChangeListener((PropertyChangeListener)this.listener);
            }
        } else {
            try {
                this.currDomain.removeNotificationListener((NotificationListener)this.listener);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public abstract ConfigurationMBean[] getTypedMBeans();

    public ConfigurationMBean getMBean(String string) throws ServerConnectionException {
        for (ConfigurationMBean configurationMBean : this.getMBeans()) {
            if (!configurationMBean.getName().equals(string)) continue;
            return configurationMBean;
        }
        return null;
    }

    public synchronized void reset() {
        if (ddebug) {
            Debug.say("Resetting cache: " + this.getClass().getName());
        }
        this.mbeans = null;
        this.stale = true;
    }

    public void close() {
        this.reset();
        this.removeNotificationListener();
    }

    public boolean isStale() {
        return this.stale;
    }

    public DeploymentManager getDM() {
        return this.dm;
    }

    public class MyJMXFilter
    extends AttributeChangeNotificationFilter
    implements Serializable {
        private static final long serialVersionUID = 7201439898187309867L;

        public MyJMXFilter() {
            if (MBeanCache.this.listenType != null) {
                this.disableAllAttributes();
                for (int i = 0; i < MBeanCache.this.listenType.length; ++i) {
                    this.enableAttribute(MBeanCache.this.listenType[i]);
                }
            }
        }
    }

    public class MyListener
    implements PropertyChangeListener,
    NotificationListener,
    Serializable {
        private static final long serialVersionUID = 1L;
        private Vector props = new Vector();
        private boolean jmx;

        public MyListener(boolean bl) {
            this.jmx = bl;
            if (MBeanCache.this.listenType == null) {
                return;
            }
            for (int i = 0; i < MBeanCache.this.listenType.length; ++i) {
                this.props.add(MBeanCache.this.listenType[i]);
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (ddebug) {
                Debug.say("Got change event for " + propertyChangeEvent.getPropertyName());
            }
            if (this.props.contains(propertyChangeEvent.getPropertyName())) {
                MBeanCache.this.reset();
            }
        }

        public void handleNotification(Notification notification, Object object) {
            if (!(notification instanceof AttributeChangeNotification)) {
                return;
            }
            if (ddebug) {
                Debug.say("Got change event for prop: " + ((AttributeChangeNotification)notification).getAttributeName());
            }
            if (this.props.contains(((AttributeChangeNotification)notification).getAttributeName())) {
                MBeanCache.this.reset();
            }
        }
    }
}

