/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.api.spi.deploy.mbeans;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import weblogic.deploy.api.internal.utils.Debug;
import weblogic.deploy.api.shared.WebLogicModuleType;
import weblogic.deploy.api.spi.WebLogicDeploymentManager;
import weblogic.deploy.api.spi.WebLogicTargetModuleID;
import weblogic.deploy.api.spi.deploy.TargetModuleIDImpl;
import weblogic.deploy.api.spi.deploy.mbeans.MBeanCache;
import weblogic.deploy.api.spi.exceptions.ServerConnectionException;
import weblogic.management.WebLogicMBean;
import weblogic.management.configuration.AppDeploymentMBean;
import weblogic.management.configuration.ConfigurationMBean;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.SubDeploymentMBean;
import weblogic.management.configuration.TargetInfoMBean;
import weblogic.management.configuration.TargetMBean;
import weblogic.management.runtime.AppRuntimeStateRuntimeMBean;
import weblogic.utils.application.WarDetector;

public class ModuleCache
extends MBeanCache {
    private static final long serialVersionUID = 1678014076382735164L;
    private static final boolean ddebug = Debug.isDebug("internal");
    transient List moduleTargetCache;
    transient List TMIDCache;
    transient Map tmidMap;
    transient Map beanTargetCache;
    private AppRuntimeStateRuntimeMBean artMBean = null;

    public ModuleCache(DomainMBean domainMBean, WebLogicDeploymentManager webLogicDeploymentManager) throws ServerConnectionException {
        super(webLogicDeploymentManager);
        this.currDomain = domainMBean;
        this.moduleTargetCache = null;
        this.TMIDCache = null;
        this.tmidMap = new HashMap();
        this.listenType = new String[]{"AppDeployments", "Libraries"};
        this.beanTargetCache = null;
        this.addNotificationListener();
    }

    public synchronized ConfigurationMBean[] getTypedMBeans() {
        ArrayList arrayList = new ArrayList();
        AppDeploymentMBean[] appDeploymentMBeanArray = this.currDomain.getAppDeployments();
        if (appDeploymentMBeanArray != null) {
            this.add(appDeploymentMBeanArray, arrayList);
        }
        if ((appDeploymentMBeanArray = this.currDomain.getLibraries()) != null) {
            this.add(appDeploymentMBeanArray, arrayList);
        }
        return arrayList.toArray(new ConfigurationMBean[0]);
    }

    private void add(AppDeploymentMBean[] appDeploymentMBeanArray, List list) {
        for (int i = 0; i < appDeploymentMBeanArray.length; ++i) {
            AppDeploymentMBean appDeploymentMBean = appDeploymentMBeanArray[i];
            list.add(appDeploymentMBean);
        }
    }

    public synchronized List getModules(Target target) throws ServerConnectionException {
        if (this.isStale()) {
            this.reset();
        }
        if (!this.moduleTargetCache.contains(target)) {
            if (ddebug) {
                Debug.say("Populating tmid cache for target " + target);
            }
            this.moduleTargetCache.add(target);
            for (Object object : this.getMBeans()) {
                TargetInfoMBean[] targetInfoMBeanArray;
                if (object == null) continue;
                if (ddebug) {
                    Debug.say("checking for tmid for " + object.getName());
                }
                boolean bl = this.targeted((TargetInfoMBean)object, target);
                TargetModuleID targetModuleID = null;
                if (bl && (targetModuleID = this.getTMID((TargetInfoMBean)object, target, null)) != null) {
                    if (this.TMIDCache.add(targetModuleID)) {
                        if (ddebug) {
                            Debug.say("Added " + targetModuleID.toString() + " to cache");
                        }
                    } else if (ddebug) {
                        Debug.say(targetModuleID.toString() + " already in cache");
                    }
                }
                if ((targetInfoMBeanArray = this.getChildModules((TargetInfoMBean)object)) == null) continue;
                for (int i = 0; i < targetInfoMBeanArray.length; ++i) {
                    TargetInfoMBean[] targetInfoMBeanArray2;
                    TargetInfoMBean targetInfoMBean = targetInfoMBeanArray[i];
                    if (targetInfoMBean == null) continue;
                    bl = this.targeted(targetInfoMBean, target);
                    WebLogicTargetModuleID webLogicTargetModuleID = null;
                    if (bl) {
                        if (targetModuleID == null) {
                            targetModuleID = this.addImpliedParent((TargetInfoMBean)object, target, null);
                        }
                        if ((webLogicTargetModuleID = this.getTMID(targetInfoMBean, target, (TargetInfoMBean)object)) != null) {
                            this.TMIDCache.add(webLogicTargetModuleID);
                        }
                    }
                    if ((targetInfoMBeanArray2 = this.getChildModules(targetInfoMBean)) == null) continue;
                    for (int j = 0; j < targetInfoMBeanArray2.length; ++j) {
                        WebLogicTargetModuleID webLogicTargetModuleID2;
                        TargetInfoMBean targetInfoMBean2 = targetInfoMBeanArray2[j];
                        if (targetInfoMBean2 == null || !(bl = this.targeted(targetInfoMBean2, target))) continue;
                        if (webLogicTargetModuleID == null) {
                            if (targetModuleID == null) {
                                targetModuleID = this.addImpliedParent((TargetInfoMBean)object, target, null);
                            }
                            webLogicTargetModuleID = this.addImpliedParent(targetInfoMBean, target, (TargetInfoMBean)object);
                        }
                        if ((webLogicTargetModuleID2 = this.getTMID(targetInfoMBean2, target, targetInfoMBean)) == null) continue;
                        this.TMIDCache.add(webLogicTargetModuleID2);
                    }
                }
            }
            this.addUnconfiguredModules(target);
        }
        if (ddebug) {
            this.dump();
        }
        ArrayList arrayList = new ArrayList();
        for (TargetModuleID targetModuleID : this.TMIDCache) {
            if (!targetModuleID.getTarget().getName().equals(target.getName())) continue;
            arrayList.add(targetModuleID);
        }
        return arrayList;
    }

    private AppRuntimeStateRuntimeMBean getAppRuntimeStateRuntimeMBean() {
        block3: {
            if (this.artMBean == null) {
                try {
                    this.artMBean = this.dm.getHelper().getAppRuntimeStateMBean();
                }
                catch (Exception exception) {
                    if (!ddebug) break block3;
                    Debug.say("Can't get app runtime state: " + exception.toString());
                }
            }
        }
        return this.artMBean;
    }

    private void addUnconfiguredModules(Target target) {
        if (this.getAppRuntimeStateRuntimeMBean() == null) {
            return;
        }
        ArrayList<TargetModuleID> arrayList = new ArrayList<TargetModuleID>();
        for (TargetModuleID targetModuleID : this.TMIDCache) {
            if (targetModuleID.getParentTargetModuleID() != null || !targetModuleID.getTarget().getName().equals(target.getName())) continue;
            arrayList.add(targetModuleID);
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            WebLogicTargetModuleID webLogicTargetModuleID = (WebLogicTargetModuleID)((Object)arrayList.get(i));
            if (webLogicTargetModuleID.getValue() == ModuleType.EAR.getValue()) {
                String[] stringArray = this.getAppRuntimeStateRuntimeMBean().getModuleIds(webLogicTargetModuleID.getModuleID());
                if (stringArray == null) continue;
                for (int j = 0; j < stringArray.length; ++j) {
                    String string = stringArray[j];
                    this.addMissingModule(string, webLogicTargetModuleID);
                }
            }
            this.addUnconfiguredSubmodules(webLogicTargetModuleID, webLogicTargetModuleID.getModuleID());
        }
    }

    private void addMissingModule(String string, WebLogicTargetModuleID webLogicTargetModuleID) {
        if (!this.isChild(string, webLogicTargetModuleID.getChildTargetModuleID())) {
            this.addImpliedChild(webLogicTargetModuleID, string, WebLogicModuleType.getTypeFromString(this.getAppRuntimeStateRuntimeMBean().getModuleType(webLogicTargetModuleID.getModuleID(), string)));
        }
    }

    private void addUnconfiguredSubmodules(WebLogicTargetModuleID webLogicTargetModuleID, String string) {
        if (webLogicTargetModuleID.getValue() == WebLogicModuleType.JMS.getValue()) {
            String[] stringArray = this.getAppRuntimeStateRuntimeMBean().getSubmoduleIds(string, webLogicTargetModuleID.getModuleID());
            if (stringArray == null) {
                return;
            }
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                this.addMissingModule(string2, webLogicTargetModuleID);
            }
        } else {
            TargetModuleID[] targetModuleIDArray = webLogicTargetModuleID.getChildTargetModuleID();
            if (targetModuleIDArray == null) {
                return;
            }
            for (int i = 0; i < targetModuleIDArray.length; ++i) {
                WebLogicTargetModuleID webLogicTargetModuleID2 = (WebLogicTargetModuleID)targetModuleIDArray[i];
                this.addUnconfiguredSubmodules(webLogicTargetModuleID2, string);
            }
        }
    }

    private void addImpliedChild(TargetModuleID targetModuleID, String string, ModuleType moduleType) {
        TargetModuleIDImpl targetModuleIDImpl = new TargetModuleIDImpl(string, targetModuleID.getTarget(), targetModuleID, moduleType, this.getDM());
        targetModuleIDImpl.setTargeted(false);
        if (moduleType == ModuleType.WAR) {
            targetModuleIDImpl.setWebURL(string);
        }
        this.TMIDCache.add(targetModuleIDImpl);
    }

    private boolean isChild(String string, TargetModuleID[] targetModuleIDArray) {
        if (targetModuleIDArray == null) {
            return false;
        }
        for (int i = 0; i < targetModuleIDArray.length; ++i) {
            TargetModuleID targetModuleID = targetModuleIDArray[i];
            if (!string.equals(targetModuleID.getModuleID())) continue;
            return true;
        }
        return false;
    }

    private WebLogicTargetModuleID addImpliedParent(TargetInfoMBean targetInfoMBean, Target target, TargetInfoMBean targetInfoMBean2) {
        WebLogicTargetModuleID webLogicTargetModuleID = this.getTMID(targetInfoMBean, target, targetInfoMBean2);
        if (webLogicTargetModuleID != null) {
            webLogicTargetModuleID.setTargeted(false);
            this.TMIDCache.add(webLogicTargetModuleID);
        }
        return webLogicTargetModuleID;
    }

    public TargetInfoMBean[] getChildModules(TargetInfoMBean targetInfoMBean) {
        TargetInfoMBean[] targetInfoMBeanArray = null;
        if (targetInfoMBean instanceof AppDeploymentMBean) {
            targetInfoMBeanArray = ((AppDeploymentMBean)targetInfoMBean).getSubDeployments();
        } else if (targetInfoMBean instanceof SubDeploymentMBean) {
            targetInfoMBeanArray = ((SubDeploymentMBean)targetInfoMBean).getSubDeployments();
        }
        if (targetInfoMBeanArray == null) {
            targetInfoMBeanArray = new TargetInfoMBean[]{};
        }
        return targetInfoMBeanArray;
    }

    public TargetInfoMBean getTargetInfoMBean(TargetModuleIDImpl targetModuleIDImpl) {
        this.getModules(targetModuleIDImpl.getTarget());
        return (TargetInfoMBean)this.tmidMap.get(targetModuleIDImpl);
    }

    public boolean targeted(TargetInfoMBean targetInfoMBean, Target target) {
        String[] stringArray;
        boolean bl = false;
        if (!this.beanTargetCache.containsKey(targetInfoMBean)) {
            stringArray = new String[]{};
            TargetMBean[] targetMBeanArray = targetInfoMBean.getTargets();
            if (targetMBeanArray != null) {
                stringArray = new String[targetMBeanArray.length];
                for (int i = 0; i < targetMBeanArray.length; ++i) {
                    stringArray[i] = targetMBeanArray[i] == null ? null : targetMBeanArray[i].getObjectName().getName();
                }
            }
            this.beanTargetCache.put(targetInfoMBean, stringArray);
        }
        if ((stringArray = (String[])this.beanTargetCache.get(targetInfoMBean)) != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i] == null || !stringArray[i].equals(target.getName())) continue;
                bl = true;
                break;
            }
        }
        if (ddebug && !bl) {
            Debug.say(targetInfoMBean.getName() + " is not targeted to " + target.getName());
        }
        return bl;
    }

    public TargetModuleID getTMID(AppDeploymentMBean appDeploymentMBean, Target target) {
        if (this.targeted(appDeploymentMBean, target)) {
            for (TargetModuleID targetModuleID : this.getModules(target)) {
                if (!targetModuleID.getModuleID().equals(appDeploymentMBean.getName())) continue;
                return targetModuleID;
            }
            return this.getTMID(appDeploymentMBean, target, null);
        }
        return null;
    }

    public TargetModuleID getResultTmids(String string, Target target) {
        for (TargetModuleID targetModuleID : this.getModules(target)) {
            if (!targetModuleID.getModuleID().equals(string)) continue;
            return targetModuleID;
        }
        return null;
    }

    private WebLogicTargetModuleID getTMID(TargetInfoMBean targetInfoMBean, Target target, TargetInfoMBean targetInfoMBean2) {
        ModuleType moduleType;
        if (ddebug) {
            Debug.say("Getting TMID for " + targetInfoMBean.getName() + ", target=(" + target.toString() + ") " + target.getName());
        }
        if ((moduleType = this.getModuleType(targetInfoMBean)) == null) {
            return null;
        }
        return this.getNewTMID(targetInfoMBean, moduleType, target, targetInfoMBean2);
    }

    private WebLogicTargetModuleID getNewTMID(TargetInfoMBean targetInfoMBean, ModuleType moduleType, Target target, TargetInfoMBean targetInfoMBean2) {
        if (ddebug) {
            Debug.say("Creating TMID for " + targetInfoMBean.getName() + ": type=" + moduleType.toString() + ": value=" + moduleType.getValue() + ", target=(" + target.toString() + ") " + target.getName());
        }
        TargetModuleID targetModuleID = this.getParentTmid(target, targetInfoMBean2);
        TargetModuleIDImpl targetModuleIDImpl = new TargetModuleIDImpl(targetInfoMBean.getObjectName().getName(), target, targetModuleID, moduleType, this.getDM());
        this.tmidMap.put(targetModuleIDImpl, targetInfoMBean);
        return targetModuleIDImpl;
    }

    private TargetModuleID getParentTmid(Target target, TargetInfoMBean targetInfoMBean) {
        if (targetInfoMBean == null) {
            return null;
        }
        for (TargetModuleIDImpl targetModuleIDImpl : this.TMIDCache) {
            if (!targetModuleIDImpl.getTarget().getName().equals(target.getName()) || !targetInfoMBean.getName().equals(targetModuleIDImpl.getModuleID()) || !this.compareParents(targetModuleIDImpl, targetInfoMBean)) continue;
            return targetModuleIDImpl;
        }
        return this.getTMID(targetInfoMBean, target, targetInfoMBean.getParent() instanceof TargetInfoMBean ? (TargetInfoMBean)targetInfoMBean.getParent() : null);
    }

    private boolean compareParents(TargetModuleID targetModuleID, WebLogicMBean webLogicMBean) {
        String string;
        TargetModuleID targetModuleID2 = targetModuleID.getParentTargetModuleID();
        WebLogicMBean webLogicMBean2 = webLogicMBean.getParent();
        String string2 = targetModuleID2 == null ? "" : targetModuleID2.getModuleID();
        String string3 = string = webLogicMBean2 instanceof TargetInfoMBean ? webLogicMBean2.getName() : "";
        if (string2.equals(string)) {
            if (targetModuleID2 != null) {
                return this.compareParents(targetModuleID2, webLogicMBean2);
            }
            return true;
        }
        return false;
    }

    private ModuleType getModuleType(TargetInfoMBean targetInfoMBean) {
        String string;
        if (targetInfoMBean == null) {
            return null;
        }
        String string2 = targetInfoMBean.getModuleType();
        if (ddebug) {
            Debug.say("Checking type for " + targetInfoMBean.getName() + ", with type attr = " + string2);
        }
        if (string2 != null) {
            return this.getTypeFromString(string2);
        }
        if (targetInfoMBean instanceof AppDeploymentMBean && (string = ((AppDeploymentMBean)targetInfoMBean).getSourcePath()) != null) {
            if (string.endsWith(".ear")) {
                return ModuleType.EAR;
            }
            if (WarDetector.instance.suffixed(string)) {
                return ModuleType.WAR;
            }
            if (string.endsWith(".jar")) {
                return ModuleType.EJB;
            }
            if (string.endsWith(".rar")) {
                return ModuleType.RAR;
            }
            if (string.endsWith("-jms.xml")) {
                return WebLogicModuleType.JMS;
            }
            if (string.endsWith("-jdbc.xml")) {
                return WebLogicModuleType.JDBC;
            }
            if (string.endsWith("-interception.xml")) {
                return WebLogicModuleType.INTERCEPT;
            }
        }
        if (targetInfoMBean instanceof SubDeploymentMBean && targetInfoMBean.getParent() instanceof SubDeploymentMBean) {
            return WebLogicModuleType.SUBMODULE;
        }
        if (targetInfoMBean instanceof SubDeploymentMBean && ((AppDeploymentMBean)targetInfoMBean.getParent()).getSourcePath().endsWith("-jms.xml")) {
            return WebLogicModuleType.SUBMODULE;
        }
        return this.getModuleTypeFromState(targetInfoMBean);
    }

    private ModuleType getModuleTypeFromState(TargetInfoMBean targetInfoMBean) {
        try {
            AppRuntimeStateRuntimeMBean appRuntimeStateRuntimeMBean = this.dm.getHelper().getAppRuntimeStateMBean();
            if (targetInfoMBean instanceof AppDeploymentMBean) {
                SubDeploymentMBean[] subDeploymentMBeanArray = ((AppDeploymentMBean)targetInfoMBean).getSubDeployments();
                if (subDeploymentMBeanArray != null && subDeploymentMBeanArray.length > 0) {
                    return ModuleType.EAR;
                }
                String string = targetInfoMBean.getName();
                return this.getTypeFromString(appRuntimeStateRuntimeMBean.getModuleType(string, string));
            }
            String string = targetInfoMBean.getParent().getName();
            return this.getTypeFromString(appRuntimeStateRuntimeMBean.getModuleType(string, targetInfoMBean.getName()));
        }
        catch (Exception exception) {
            return WebLogicModuleType.UNKNOWN;
        }
    }

    private ModuleType getTypeFromString(String string) {
        if (ModuleType.EAR.toString().equals(string)) {
            return ModuleType.EAR;
        }
        if (ModuleType.WAR.toString().equals(string)) {
            return ModuleType.WAR;
        }
        if (ModuleType.EJB.toString().equals(string)) {
            return ModuleType.EJB;
        }
        if (ModuleType.RAR.toString().equals(string)) {
            return ModuleType.RAR;
        }
        if (ModuleType.CAR.toString().equals(string)) {
            return ModuleType.CAR;
        }
        if (WebLogicModuleType.JMS.toString().equals(string)) {
            return WebLogicModuleType.JMS;
        }
        if (WebLogicModuleType.JDBC.toString().equals(string)) {
            return WebLogicModuleType.JDBC;
        }
        if (WebLogicModuleType.INTERCEPT.toString().equals(string)) {
            return WebLogicModuleType.INTERCEPT;
        }
        if (WebLogicModuleType.SUBMODULE.toString().equals(string)) {
            return WebLogicModuleType.SUBMODULE;
        }
        return WebLogicModuleType.UNKNOWN;
    }

    public synchronized void reset() {
        super.reset();
        this.moduleTargetCache = new ArrayList();
        this.TMIDCache = new ArrayList();
        this.tmidMap = new HashMap();
        this.beanTargetCache = new HashMap();
    }

    private void dump() {
        Debug.say("Current cache of TMIDs:");
        Iterator iterator = this.TMIDCache.iterator();
        while (iterator.hasNext()) {
            Debug.say("  " + ((TargetModuleID)iterator.next()).toString());
        }
    }
}

