/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.api.spi.deploy.mbeans;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import weblogic.deploy.api.internal.utils.Debug;
import weblogic.deploy.api.shared.WebLogicTargetType;
import weblogic.deploy.api.spi.WebLogicDeploymentManager;
import weblogic.deploy.api.spi.deploy.TargetImpl;
import weblogic.deploy.api.spi.deploy.mbeans.MBeanCache;
import weblogic.deploy.api.spi.exceptions.ServerConnectionException;
import weblogic.management.configuration.ClusterMBean;
import weblogic.management.configuration.ConfigurationMBean;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.JMSServerMBean;
import weblogic.management.configuration.SAFAgentMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.configuration.TargetMBean;
import weblogic.management.configuration.VirtualHostMBean;

public class TargetCache
extends MBeanCache {
    private static final boolean ddebug = Debug.isDebug("internal");
    private transient boolean loadedAllTargets = false;
    private transient List targets = null;

    public TargetCache(DomainMBean domainMBean, WebLogicDeploymentManager webLogicDeploymentManager) {
        super(webLogicDeploymentManager);
        this.currDomain = domainMBean;
        this.listenType = new String[]{"Servers", "Clusters", "VirtualHosts"};
        this.addNotificationListener();
    }

    public synchronized ConfigurationMBean[] getTypedMBeans() {
        ConfigurationMBean[] configurationMBeanArray = this.currDomain.getTargets();
        if (configurationMBeanArray == null) {
            configurationMBeanArray = new ConfigurationMBean[]{};
        }
        return configurationMBeanArray;
    }

    public synchronized List getTargets() throws ServerConnectionException {
        return this.getTargets(true);
    }

    public synchronized TargetImpl getTarget(String string) throws ServerConnectionException {
        Object object2;
        for (Object object2 : this.getTargets(false)) {
            if (!((TargetImpl)object2).getName().equals(string)) continue;
            return object2;
        }
        object2 = this.currDomain.lookupTarget(string);
        if (object2 == null) {
            return null;
        }
        TargetImpl targetImpl = new TargetImpl(string, this.getTypeForTarget((TargetMBean)object2), this.getDM());
        this.targets.add(targetImpl);
        return targetImpl;
    }

    public List getTargets(WebLogicTargetType webLogicTargetType) throws ServerConnectionException {
        Iterator iterator = this.getTargets().iterator();
        ArrayList<WebLogicTargetType> arrayList = new ArrayList<WebLogicTargetType>();
        while (iterator.hasNext()) {
            WebLogicTargetType webLogicTargetType2 = (WebLogicTargetType)iterator.next();
            if (webLogicTargetType2.getValue() != webLogicTargetType.getValue()) continue;
            arrayList.add(webLogicTargetType2);
        }
        return arrayList;
    }

    public synchronized void reset() {
        super.reset();
        this.loadedAllTargets = false;
        this.targets = null;
    }

    private WebLogicTargetType getTypeForTarget(TargetMBean targetMBean) {
        if (targetMBean instanceof ServerMBean) {
            return WebLogicTargetType.SERVER;
        }
        if (targetMBean instanceof ClusterMBean) {
            return WebLogicTargetType.CLUSTER;
        }
        if (targetMBean instanceof VirtualHostMBean) {
            return WebLogicTargetType.VIRTUALHOST;
        }
        if (targetMBean instanceof JMSServerMBean) {
            return WebLogicTargetType.JMSSERVER;
        }
        if (targetMBean instanceof SAFAgentMBean) {
            return WebLogicTargetType.SAFAGENT;
        }
        return null;
    }

    private synchronized List getTargets(boolean bl) throws ServerConnectionException {
        if (this.isStale()) {
            this.reset();
        }
        if (!this.loadedAllTargets && bl) {
            Iterator iterator = this.getMBeans().iterator();
            this.targets = new ArrayList();
            while (iterator.hasNext()) {
                TargetMBean targetMBean = (TargetMBean)iterator.next();
                WebLogicTargetType webLogicTargetType = this.getTypeForTarget(targetMBean);
                if (webLogicTargetType == null) continue;
                this.targets.add(new TargetImpl(targetMBean.getObjectName().getName(), webLogicTargetType, this.getDM()));
            }
            this.loadedAllTargets = true;
        }
        if (this.targets == null) {
            this.targets = new ArrayList();
        }
        return this.targets;
    }

    public void dumpTargets() {
        for (TargetImpl targetImpl : this.getTargets()) {
            Debug.say(targetImpl.toString());
        }
    }
}

