/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.api.spi.factories.internal;

import java.net.URI;
import java.net.URISyntaxException;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.exceptions.DeploymentManagerCreationException;
import weblogic.deploy.api.internal.SPIDeployerLogger;
import weblogic.deploy.api.internal.utils.ConfigHelper;
import weblogic.deploy.api.internal.utils.Debug;
import weblogic.deploy.api.spi.deploy.WebLogicDeploymentManagerImpl;
import weblogic.deploy.api.spi.factories.WebLogicDeploymentFactory;
import weblogic.utils.net.InetAddressHelper;

public class DeploymentFactoryImpl
implements WebLogicDeploymentFactory {
    private static final String JMX_DOMAIN_ACCESS_CLASS = "weblogic.deploy.api.spi.deploy.internal.ServerConnectionImpl";
    private static final String SERVER_CONNECTION_CLASS = "weblogic.deploy.api.spi.deploy.internal.ServerConnectionImpl";
    private static final String DEPLOYMENT_MANAGER_VERSION = "1.0";
    private String host;
    private int port;
    private static final boolean debug = Debug.isDebug("factory");
    private static final String[] uris = new String[]{"deployer:WebLogic", "remote:deployer:WebLogic", "authenticated:deployer:WebLogic"};
    private String deployerUri;
    private URI connectUri;

    public DeploymentManager getDisconnectedDeploymentManager(String string) throws DeploymentManagerCreationException {
        try {
            ConfigHelper.checkParam("uri", string);
            if (debug) {
                Debug.say("Getting disconnected DM with uri: " + string);
            }
            this.validateUri(string);
            WebLogicDeploymentManagerImpl webLogicDeploymentManagerImpl = new WebLogicDeploymentManagerImpl(this.deployerUri);
            return webLogicDeploymentManagerImpl;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new DeploymentManagerCreationException(illegalArgumentException.getMessage());
        }
    }

    public DeploymentManager getDeploymentManager(String string, String string2, String string3) throws DeploymentManagerCreationException {
        try {
            ConfigHelper.checkParam("uri", string);
            if (debug) {
                Debug.say("Getting connected DM with uri: " + string + ", user: " + string2);
            }
            this.validateUri(string);
            if (!(this.host != null && this.port != -1 || string.toString().startsWith("authenticated:deployer:WebLogic"))) {
                throw new DeploymentManagerCreationException(SPIDeployerLogger.getInvalidServerAuth((String)string));
            }
            return new WebLogicDeploymentManagerImpl("weblogic.deploy.api.spi.deploy.internal.ServerConnectionImpl", this.deployerUri, this.connectUri, string2, string3);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
            DeploymentManagerCreationException deploymentManagerCreationException = new DeploymentManagerCreationException(illegalArgumentException.getMessage());
            deploymentManagerCreationException.initCause((Throwable)illegalArgumentException);
            throw deploymentManagerCreationException;
        }
        catch (DeploymentManagerCreationException deploymentManagerCreationException) {
            deploymentManagerCreationException.printStackTrace();
            throw deploymentManagerCreationException;
        }
    }

    public String getDisplayName() {
        return SPIDeployerLogger.getDisplayName();
    }

    public String getProductVersion() {
        return DEPLOYMENT_MANAGER_VERSION;
    }

    public boolean handlesURI(String string) {
        try {
            this.validateUri(string);
            return true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    public String[] getUris() {
        return uris;
    }

    public String createUri(String string, String string2, String string3) {
        return this.createUri("t3", string, string2, string3);
    }

    public String createUri(String string, String string2, String string3, String string4) {
        String string5 = null;
        try {
            string5 = string == null ? "t3://" : string + "://";
            String string6 = string5 = string2 == null ? "deployer:WebLogic:" + string5 : string2 + ":" + string5;
            if (debug) {
                Debug.say("createUri host:  " + string3);
            }
            String string7 = null;
            string7 = string3 == null ? "localhost" : InetAddressHelper.convertHostIfIPV6((String)string3);
            if (debug) {
                Debug.say("createUri result host:  " + string7);
            }
            string5 = string5 + string7;
            string5 = string4 == null ? string5 + ":" + "7001" : string5 + ":" + string4;
            this.validateUri(string5);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (debug) {
                Debug.say(illegalArgumentException.getMessage());
            }
            return null;
        }
        if (debug) {
            Debug.say("createUri result: " + string5);
        }
        return string5;
    }

    private void validateUri(String string) throws IllegalArgumentException {
        if (string.equals("deployer:WebLogic")) {
            this.deployerUri = "deployer:WebLogic";
            return;
        }
        if (string.equals("remote:deployer:WebLogic")) {
            this.deployerUri = "remote:deployer:WebLogic";
            return;
        }
        if (string.equals("authenticated:deployer:WebLogic")) {
            this.deployerUri = "authenticated:deployer:WebLogic";
            return;
        }
        if (string.startsWith("deployer:WebLogic")) {
            this.deployerUri = "deployer:WebLogic";
        } else if (string.startsWith("remote:deployer:WebLogic")) {
            this.deployerUri = "remote:deployer:WebLogic";
        } else if (string.startsWith("authenticated:deployer:WebLogic")) {
            this.deployerUri = "authenticated:deployer:WebLogic";
        } else {
            throw new IllegalArgumentException(SPIDeployerLogger.getInvalidURI((String)string));
        }
        string = string.substring(this.deployerUri.length());
        if (string.charAt(0) == ':') {
            try {
                this.connectUri = string.indexOf("://") != -1 ? new URI(string.substring(1)) : new URI("t3://" + string.substring(1));
                this.host = this.connectUri.getHost();
                this.port = this.connectUri.getPort();
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new IllegalArgumentException(SPIDeployerLogger.getInvalidServerAuth((String)string));
            }
        } else {
            throw new IllegalArgumentException(SPIDeployerLogger.getInvalidServerAuth((String)string));
        }
    }
}

