/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.api.spi.status;

import java.util.HashSet;
import java.util.Iterator;
import javax.enterprise.deploy.shared.ActionType;
import javax.enterprise.deploy.shared.CommandType;
import javax.enterprise.deploy.shared.StateType;
import weblogic.deploy.api.spi.status.WebLogicDeploymentStatus;
import weblogic.management.ManagementException;
import weblogic.utils.ErrorCollectionException;

public class DeploymentStatusImpl
implements WebLogicDeploymentStatus {
    private StateType state = StateType.RUNNING;
    private CommandType command = null;
    private ActionType action = null;
    private boolean completed = false;
    private boolean failed = false;
    private String message = null;
    private Throwable error = null;

    DeploymentStatusImpl() {
    }

    DeploymentStatusImpl(StateType stateType, CommandType commandType, ActionType actionType, String string) {
        this.setState(stateType);
        this.setCommand(commandType);
        this.setAction(actionType);
        this.setMessage(string);
    }

    DeploymentStatusImpl(StateType stateType, CommandType commandType, ActionType actionType, String string, Throwable throwable) {
        this(stateType, commandType, actionType, string);
        this.setError(throwable);
    }

    public StateType getState() {
        return this.state;
    }

    public CommandType getCommand() {
        return this.command;
    }

    public ActionType getAction() {
        return this.action;
    }

    public String getMessage() {
        return this.message;
    }

    public boolean isCompleted() {
        if (!this.completed) {
            this.completed = this.state == StateType.COMPLETED;
        }
        return this.completed;
    }

    public boolean isFailed() {
        if (!this.failed) {
            this.failed = this.state == StateType.FAILED;
        }
        return this.failed;
    }

    public boolean isRunning() {
        return !this.isCompleted() && !this.isFailed() && this.state != StateType.RELEASED;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(59);
        stringBuffer.append("State Type : " + this.state);
        stringBuffer.append("; Command Type : " + this.command);
        stringBuffer.append("; Action Type  : " + this.action);
        stringBuffer.append("; Completed  : " + this.completed);
        stringBuffer.append("; Failed : " + this.failed);
        stringBuffer.append("; Message : " + this.message);
        stringBuffer.append("; Exception : " + this.error);
        return stringBuffer.toString();
    }

    public void setState(StateType stateType) {
        this.state = stateType;
    }

    public void setCommand(CommandType commandType) {
        this.command = commandType;
    }

    public void setAction(ActionType actionType) {
        this.action = actionType;
    }

    public void setMessage(String string) {
        this.message = string;
    }

    public void setCompleted(boolean bl) {
        this.completed = bl;
    }

    public void setFailed(boolean bl) {
        this.failed = bl;
    }

    public void setError(Throwable throwable) {
        this.error = throwable;
    }

    public Iterator getRootException() {
        HashSet<Throwable> hashSet = new HashSet<Throwable>();
        if (this.error != null) {
            Throwable throwable = ManagementException.unWrapExceptions((Throwable)this.error);
            if (throwable instanceof ErrorCollectionException) {
                return ((ErrorCollectionException)throwable).getErrors();
            }
            hashSet.add(throwable);
            return hashSet.iterator();
        }
        return hashSet.iterator();
    }
}

