/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.api.spi.status;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.enterprise.deploy.shared.ActionType;
import javax.enterprise.deploy.shared.CommandType;
import javax.enterprise.deploy.shared.StateType;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.OperationUnsupportedException;
import javax.enterprise.deploy.spi.status.ClientConfiguration;
import javax.enterprise.deploy.spi.status.DeploymentStatus;
import javax.enterprise.deploy.spi.status.ProgressEvent;
import javax.enterprise.deploy.spi.status.ProgressListener;
import javax.enterprise.deploy.spi.status.ProgressObject;
import weblogic.deploy.api.internal.SPIDeployerLogger;
import weblogic.deploy.api.internal.utils.Debug;
import weblogic.deploy.api.spi.WebLogicDeploymentManager;
import weblogic.deploy.api.spi.deploy.TargetImpl;
import weblogic.deploy.api.spi.deploy.TargetModuleIDImpl;
import weblogic.deploy.api.spi.exceptions.ServerConnectionException;
import weblogic.deploy.api.spi.status.DeploymentStatusImpl;
import weblogic.deploy.utils.TaskCompletionNotificationListener;
import weblogic.management.ManagementException;
import weblogic.management.deploy.TargetStatus;
import weblogic.management.runtime.DeploymentTaskRuntimeMBean;

public class ProgressObjectImpl
implements ProgressObject,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final boolean debug = Debug.isDebug("status");
    private transient StateType state = StateType.RUNNING;
    private transient CommandType cmd;
    private transient ActionType action = ActionType.EXECUTE;
    private String msg = null;
    private transient WebLogicDeploymentManager dm;
    private String task;
    private transient List tmids = Collections.synchronizedList(new ArrayList());
    private transient Set listeners = Collections.synchronizedSet(new HashSet());
    private transient Throwable error = null;
    private transient List pending = Collections.synchronizedList(new ArrayList());
    private transient DeploymentTaskRuntimeMBean dtrm = null;
    private transient boolean haveDtrm = false;
    private transient TaskCompletionNotificationListener taskCompletionListener = null;

    public ProgressObjectImpl(CommandType commandType, String string, TargetModuleID[] targetModuleIDArray, WebLogicDeploymentManager webLogicDeploymentManager) {
        this.cmd = commandType;
        this.task = string;
        this.dm = webLogicDeploymentManager;
        this.copyInto(targetModuleIDArray, this.pending);
        if (debug) {
            this.dumpPO();
        }
    }

    private void copyInto(TargetModuleID[] targetModuleIDArray, List list) {
        if (targetModuleIDArray == null) {
            return;
        }
        for (int i = 0; i < targetModuleIDArray.length; ++i) {
            list.add(targetModuleIDArray[i]);
        }
    }

    public ProgressObjectImpl(CommandType commandType, String string, WebLogicDeploymentManager webLogicDeploymentManager) {
        this(commandType, null, new TargetModuleID[0], webLogicDeploymentManager);
        this.msg = string;
        this.state = StateType.FAILED;
    }

    public ProgressObjectImpl(CommandType commandType, Throwable throwable, WebLogicDeploymentManager webLogicDeploymentManager) {
        this(commandType, null, new TargetModuleID[0], webLogicDeploymentManager);
        Throwable throwable2 = ManagementException.unWrapExceptions((Throwable)throwable);
        this.msg = throwable2.toString();
        this.state = StateType.FAILED;
        this.error = throwable2;
    }

    public ProgressObjectImpl(CommandType commandType, WebLogicDeploymentManager webLogicDeploymentManager) {
        this(commandType, null, new TargetModuleID[0], webLogicDeploymentManager);
        this.msg = SPIDeployerLogger.noop((String)commandType.toString());
        this.state = StateType.COMPLETED;
    }

    public DeploymentStatus getDeploymentStatus() {
        this.getResultTargetModuleIDs();
        return new DeploymentStatusImpl(this.state, this.cmd, this.action, this.msg, this.error);
    }

    public TargetModuleID[] getResultTargetModuleIDs() {
        this.updateState();
        if (this.state != StateType.RELEASED && this.pending.size() > 0) {
            this.updateTmids();
        }
        TargetModuleID[] targetModuleIDArray = this.tmids.toArray(new TargetModuleID[0]);
        if (this.dm != null && this.dm.getServerConnection() != null) {
            for (TargetModuleID targetModuleID : targetModuleIDArray) {
                this.dm.getServerConnection().populateWarUrlInChildren(targetModuleID);
            }
        }
        return targetModuleIDArray;
    }

    private void updateTmids() {
        try {
            this.getDtrm();
            if (this.dtrm != null) {
                TargetStatus[] targetStatusArray = this.dtrm.getTargets();
                if (targetStatusArray == null) {
                    return;
                }
                for (int i = 0; i < targetStatusArray.length; ++i) {
                    List list;
                    TargetStatus targetStatus = targetStatusArray[i];
                    if (targetStatus.getState() == 1 || targetStatus.getState() == 0 || (list = this.getPendingTmidsForTarget(targetStatus.getTarget())).isEmpty()) continue;
                    for (int j = 0; j < list.size(); ++j) {
                        TargetModuleID targetModuleID = (TargetModuleID)list.get(j);
                        if (targetStatus.getState() == 3 || targetStatus.getState() == 4) {
                            TargetModuleID targetModuleID2;
                            if (debug) {
                                Debug.say("adding successful tmid: " + targetModuleID.toString());
                            }
                            if ((targetModuleID2 = this.dm.getServerConnection().getModuleCache().getResultTmids(targetModuleID.getModuleID(), targetModuleID.getTarget())) == null) {
                                targetModuleID2 = targetModuleID;
                            }
                            this.tmids.add(targetModuleID2);
                        }
                        this.pending.remove(targetModuleID);
                    }
                }
            } else if (this.state == StateType.RUNNING) {
                this.setState(StateType.RELEASED);
            }
        }
        catch (Throwable throwable) {
            SPIDeployerLogger.logConnectionError((String)throwable.getMessage(), (Throwable)throwable);
            if (this.state == StateType.RUNNING) {
                this.setState(StateType.RELEASED);
            }
            this.dtrm = null;
        }
    }

    private List getPendingTmidsForTarget(String string) {
        ArrayList<TargetModuleID> arrayList = new ArrayList<TargetModuleID>();
        for (int i = 0; i < this.pending.size(); ++i) {
            TargetModuleID targetModuleID = (TargetModuleID)this.pending.get(i);
            if (!targetModuleID.getTarget().getName().equals(string)) continue;
            arrayList.add(targetModuleID);
        }
        return arrayList;
    }

    private void updateState() {
        if (this.state == StateType.RELEASED) {
            return;
        }
        if (!this.dm.isConnected() && this.state == StateType.RUNNING) {
            this.setState(StateType.RELEASED);
        }
    }

    public ClientConfiguration getClientConfiguration(TargetModuleID targetModuleID) {
        return null;
    }

    public boolean isCancelSupported() {
        return true;
    }

    public void cancel() throws OperationUnsupportedException {
        block4: {
            DeploymentTaskRuntimeMBean deploymentTaskRuntimeMBean = this.getDtrm();
            if (deploymentTaskRuntimeMBean != null) {
                try {
                    if (debug) {
                        Debug.say("Cancelling task " + this.getTask());
                    }
                    deploymentTaskRuntimeMBean.cancel();
                }
                catch (Exception exception) {
                    if (!debug) break block4;
                    Debug.say("Cancel of task " + this.getTask() + " failed: " + exception.toString());
                }
            }
        }
    }

    public boolean isStopSupported() {
        return false;
    }

    public void stop() throws OperationUnsupportedException {
        throw new OperationUnsupportedException(SPIDeployerLogger.unsupported((String)"stop"));
    }

    public void addProgressListener(ProgressListener progressListener) {
        if (!this.listeners.add(progressListener) && debug) {
            Debug.say("Listener already registered: " + progressListener.toString());
        }
        if (this.state != StateType.RUNNING) {
            this.reportEvent();
        }
    }

    public void removeProgressListener(ProgressListener progressListener) {
        if (!this.listeners.remove(progressListener) && debug) {
            Debug.say("Listener not registered: " + progressListener.toString());
        }
    }

    public final void setTaskCompletionListener(TaskCompletionNotificationListener taskCompletionNotificationListener) {
        this.taskCompletionListener = taskCompletionNotificationListener;
    }

    public final TaskCompletionNotificationListener getTaskCompletionListener() {
        return this.taskCompletionListener;
    }

    public String getTask() {
        return this.task;
    }

    public void reportEvent(String string, String string2, String string3, String string4) throws ServerConnectionException {
        this.getResultTargetModuleIDs();
        this.msg = string4;
        if (this.listeners.size() == 0) {
            return;
        }
        for (TargetModuleIDImpl targetModuleIDImpl : this.getTmidsForServer(string3)) {
            if (!targetModuleIDImpl.getModuleID().equals(string2) && !targetModuleIDImpl.getModuleID().equals(string)) continue;
            this.broadcastReport(string4, targetModuleIDImpl);
        }
    }

    public void reportEvent(String string, String string2, String string3, String string4, Exception exception) {
        this.msg = string4;
        if (this.listeners.size() == 0) {
            return;
        }
        this.broadcastReport(SPIDeployerLogger.reportErrorEvent((String)string, (String)string2, (String)string3, (String)string4, (String)exception.toString()), null);
    }

    public void reportEvent(String string) {
        this.msg = string;
        if (this.listeners.size() == 0) {
            return;
        }
        this.broadcastReport(string, null);
    }

    public void reportEvent() {
        this.getResultTargetModuleIDs();
        if (this.listeners.size() == 0) {
            return;
        }
        if (this.tmids != null && this.tmids.size() > 0) {
            for (int i = 0; i < this.tmids.size(); ++i) {
                TargetModuleID targetModuleID = (TargetModuleID)this.tmids.get(i);
                if (debug) {
                    Debug.say("reporting final event for " + targetModuleID.getModuleID());
                }
                this.broadcastReport(this.msg, targetModuleID);
            }
        } else {
            this.broadcastReport(this.msg, null);
        }
    }

    public void setState(StateType stateType) {
        if (debug) {
            Debug.say("Updating state to " + stateType.toString());
        }
        this.state = stateType;
    }

    public void setAction(ActionType actionType) {
        if (debug) {
            Debug.say("Updating action to " + actionType.toString());
        }
        this.action = actionType;
    }

    public void setMessage(String string) {
        if (debug) {
            Debug.say("Updating message to " + string);
        }
        this.msg = string;
    }

    public void setError(Throwable throwable) {
        if (throwable == null) {
            return;
        }
        throwable = ManagementException.unWrapExceptions((Throwable)throwable);
        this.setMessage(throwable.toString());
        this.error = throwable;
    }

    private void broadcastReport(String string, TargetModuleID targetModuleID) {
        ProgressListener[] progressListenerArray;
        DeploymentStatusImpl deploymentStatusImpl = (DeploymentStatusImpl)this.getDeploymentStatus();
        deploymentStatusImpl.setMessage(string);
        ProgressEvent progressEvent = new ProgressEvent((Object)this, targetModuleID, (DeploymentStatus)deploymentStatusImpl);
        for (ProgressListener progressListener : progressListenerArray = this.listeners.toArray(new ProgressListener[0])) {
            progressListener.handleProgressEvent(progressEvent);
        }
    }

    private Set getTmidsForServer(String string) throws ServerConnectionException {
        Set set = this.getTargetsForServer(string);
        HashSet<TargetModuleID> hashSet = new HashSet<TargetModuleID>();
        if (this.tmids != null) {
            for (int i = 0; i < this.tmids.size(); ++i) {
                TargetModuleID targetModuleID = (TargetModuleID)this.tmids.get(i);
                if (!set.contains(targetModuleID.getTarget())) continue;
                hashSet.add(targetModuleID);
            }
        }
        return hashSet;
    }

    private Set getTargetsForServer(String string) throws ServerConnectionException {
        HashSet<Target> hashSet = new HashSet<Target>();
        if (this.tmids != null) {
            block0: for (int i = 0; i < this.tmids.size(); ++i) {
                TargetModuleIDImpl targetModuleIDImpl = (TargetModuleIDImpl)this.tmids.get(i);
                for (TargetImpl targetImpl : targetModuleIDImpl.getServersForTarget()) {
                    if (!targetImpl.getName().equals(string)) continue;
                    hashSet.add(targetModuleIDImpl.getTarget());
                    continue block0;
                }
            }
        }
        return hashSet;
    }

    private void dumpPO() {
        int n;
        Debug.say("Constructed ProgressObject: ");
        if (this.cmd != null) {
            Debug.say("Command: " + this.cmd.toString());
        }
        if (this.task != null) {
            Debug.say("Task: " + this.task.toString());
        }
        Debug.say("TMIDs:");
        if (this.tmids != null) {
            for (n = 0; n < this.tmids.size(); ++n) {
                Debug.say(this.tmids.get(n).toString());
            }
        }
        Debug.say("Pending TMIDs:");
        if (this.pending != null) {
            for (n = 0; n < this.pending.size(); ++n) {
                Debug.say(this.pending.get(n).toString());
            }
        }
    }

    public DeploymentTaskRuntimeMBean getDtrm() {
        if (!this.haveDtrm) {
            this.dtrm = this.dm.getHelper().getTaskByID(this.getTask());
            this.haveDtrm = true;
        }
        return this.dtrm;
    }
}

