/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.api.tools;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import javax.enterprise.deploy.model.DDBeanRoot;
import javax.enterprise.deploy.model.DeployableObject;
import javax.enterprise.deploy.model.exceptions.DDBeanCreateException;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import weblogic.deploy.api.model.WebLogicDDBeanRoot;
import weblogic.deploy.api.model.WebLogicDeployableObject;
import weblogic.deploy.api.model.WebLogicJ2eeApplicationObject;
import weblogic.deploy.api.model.internal.DDBeanRootImpl;
import weblogic.deploy.api.model.sca.internal.WebLogicScaApplicationObject;
import weblogic.deploy.api.shared.WebLogicModuleType;
import weblogic.deploy.api.spi.WebLogicDConfigBeanRoot;
import weblogic.deploy.api.spi.WebLogicDeploymentConfiguration;
import weblogic.deploy.api.spi.config.BasicDConfigBeanRoot;
import weblogic.deploy.api.tools.ModuleInfo;
import weblogic.descriptor.DescriptorBean;
import weblogic.j2ee.descriptor.ApplicationBean;
import weblogic.j2ee.descriptor.EjbJarBean;
import weblogic.j2ee.descriptor.EnterpriseBeansBean;
import weblogic.j2ee.descriptor.ModuleBean;
import weblogic.j2ee.descriptor.SessionBeanBean;
import weblogic.j2ee.descriptor.WebBean;
import weblogic.j2ee.descriptor.WebserviceDescriptionBean;
import weblogic.j2ee.descriptor.WebservicesBean;
import weblogic.j2ee.descriptor.wl.JMSBean;
import weblogic.j2ee.descriptor.wl.WeblogicApplicationBean;
import weblogic.j2ee.descriptor.wl.WeblogicModuleBean;
import weblogic.j2ee.descriptor.wl.WeblogicWebAppBean;
import weblogic.jms.module.DefaultingHelper;
import weblogic.utils.application.WarDetector;

public class DeployableObjectInfo
extends ModuleInfo {
    private static final String[] WSEE_URIS = new String[]{"WEB-INF/webservices.xml", "META-INF/webservices.xml", "WEB-INF/web-services.xml", "META-INF/web-services.xml"};
    private WebLogicDeployableObject dobj = null;
    private WebLogicDeploymentConfiguration dc = null;

    protected DeployableObjectInfo(WebLogicDeployableObject webLogicDeployableObject, WebLogicDeploymentConfiguration webLogicDeploymentConfiguration, String string) throws IOException, ConfigurationException {
        this.name = string;
        if (string == null) {
            this.name = webLogicDeployableObject.getArchive().getName();
        }
        this.type = webLogicDeployableObject.getType();
        this.archived = this.checkIfArchived(webLogicDeployableObject);
        this.dobj = webLogicDeployableObject;
        this.dc = webLogicDeploymentConfiguration;
        this.addSubModules();
        this.addWlsModules();
        this.addWebServices();
    }

    public String[] getBeans() {
        if (this.beans != null) {
            return this.beans;
        }
        if (this.dobj.getType().getValue() != ModuleType.EJB.getValue()) {
            return null;
        }
        try {
            SessionBeanBean sessionBeanBean;
            int n;
            DescriptorBean descriptorBean = ((WebLogicDDBeanRoot)this.dobj.getDDBeanRoot()).getDescriptorBean();
            if (descriptorBean == null) {
                return null;
            }
            EnterpriseBeansBean enterpriseBeansBean = ((EjbJarBean)descriptorBean).getEnterpriseBeans();
            SessionBeanBean[] sessionBeanBeanArray = enterpriseBeansBean.getSessions();
            ArrayList<String> arrayList = new ArrayList<String>();
            for (n = 0; n < sessionBeanBeanArray.length; ++n) {
                sessionBeanBean = sessionBeanBeanArray[n];
                arrayList.add(sessionBeanBean.getEjbName());
            }
            sessionBeanBeanArray = enterpriseBeansBean.getEntities();
            for (n = 0; n < sessionBeanBeanArray.length; ++n) {
                sessionBeanBean = sessionBeanBeanArray[n];
                arrayList.add(sessionBeanBean.getEjbName());
            }
            sessionBeanBeanArray = enterpriseBeansBean.getMessageDrivens();
            for (n = 0; n < sessionBeanBeanArray.length; ++n) {
                sessionBeanBean = sessionBeanBeanArray[n];
                arrayList.add(sessionBeanBean.getEjbName());
            }
            this.beans = arrayList.toArray(new String[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.beans;
    }

    public String[] getSubDeployments() {
        if (this.subDeployments != null) {
            return this.subDeployments;
        }
        if (WebLogicModuleType.JMS.equals(this.type)) {
            try {
                BasicDConfigBeanRoot basicDConfigBeanRoot = (BasicDConfigBeanRoot)this.dc.getDConfigBeanRoot(this.dobj.getDDBeanRoot());
                JMSBean jMSBean = (JMSBean)basicDConfigBeanRoot.getDescriptorBean();
                this.subDeployments = DefaultingHelper.getSubDeploymentNames(jMSBean);
            }
            catch (ConfigurationException configurationException) {
                throw new Error("Impossible Exception " + (Object)((Object)configurationException));
            }
        }
        return this.subDeployments;
    }

    public String[] getContextRoots() {
        if (this.roots != null) {
            return this.roots;
        }
        if (this.dobj.getType().getValue() != ModuleType.WAR.getValue()) {
            return null;
        }
        if (this.getParent() == null) {
            this.roots = this.getStandAloneContextRoots();
        } else {
            String string = this.dobj.getContextRoot();
            this.roots = new String[]{string};
        }
        return this.roots;
    }

    private void addSubModules() throws IOException, ConfigurationException {
        if (this.getType() == ModuleType.EAR) {
            this.addEarSubModules();
        } else if (this.getType() == WebLogicModuleType.SCA_COMPOSITE) {
            this.addScaSubModules();
        }
    }

    private void addEarSubModules() throws IOException, ConfigurationException {
        WebLogicJ2eeApplicationObject webLogicJ2eeApplicationObject = (WebLogicJ2eeApplicationObject)this.dobj;
        String[] stringArray = webLogicJ2eeApplicationObject.getModuleUris();
        if (stringArray == null) {
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (arrayList.contains(string)) continue;
            DeployableObject[] deployableObjectArray = webLogicJ2eeApplicationObject.getDeployableObjects(string);
            for (int j = 0; j < deployableObjectArray.length; ++j) {
                this.addModuleInfo(ModuleInfo.createModuleInfo((WebLogicDeployableObject)deployableObjectArray[j], null, string));
            }
            arrayList.add(stringArray[i]);
        }
    }

    private void addScaSubModules() throws IOException, ConfigurationException {
        WebLogicScaApplicationObject webLogicScaApplicationObject = (WebLogicScaApplicationObject)this.dobj;
        String[] stringArray = webLogicScaApplicationObject.getModuleUris();
        if (stringArray == null) {
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (arrayList.contains(string)) continue;
            DeployableObject[] deployableObjectArray = webLogicScaApplicationObject.getDeployableObjects(string);
            for (int j = 0; j < deployableObjectArray.length; ++j) {
                this.addModuleInfo(ModuleInfo.createModuleInfo((WebLogicDeployableObject)deployableObjectArray[j], null, string));
            }
            arrayList.add(stringArray[i]);
        }
    }

    private String[] getContextRootsFromEar() {
        ArrayList<String> arrayList = new ArrayList<String>();
        WebLogicDeployableObject webLogicDeployableObject = ((DeployableObjectInfo)this.getParent()).getDeployableObject();
        try {
            ApplicationBean applicationBean = (ApplicationBean)webLogicDeployableObject.getDescriptorBean();
            ModuleBean[] moduleBeanArray = applicationBean.getModules();
            for (int i = 0; i < moduleBeanArray.length; ++i) {
                ModuleBean moduleBean = moduleBeanArray[i];
                WebBean webBean = moduleBean.getWeb();
                if (webBean == null || !webBean.getWebUri().equals(this.getName())) continue;
                arrayList.add(moduleBean.getWeb().getContextRoot());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return arrayList.toArray(new String[0]);
    }

    private String[] getStandAloneContextRoots() {
        String[] stringArray;
        if (this.dc == null) {
            return new String[]{this.sansExtension(this.getName())};
        }
        String string = null;
        try {
            WebLogicDConfigBeanRoot webLogicDConfigBeanRoot = (WebLogicDConfigBeanRoot)this.dc.getDConfigBeanRoot(this.dobj.getDDBeanRoot());
            if (webLogicDConfigBeanRoot != null) {
                WeblogicWebAppBean weblogicWebAppBean = (WeblogicWebAppBean)webLogicDConfigBeanRoot.getDescriptorBean();
                string = weblogicWebAppBean.getContextRoots().length > 0 ? weblogicWebAppBean.getContextRoots()[0] : null;
            }
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
        if (string == null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = this.sansExtension(this.getName());
        } else {
            String[] stringArray3 = new String[1];
            stringArray = stringArray3;
            stringArray3[0] = string;
        }
        return stringArray;
    }

    private String sansExtension(String string) {
        return WarDetector.instance.stem(string);
    }

    private void addWebServices() {
        try {
            for (int i = 0; i < WSEE_URIS.length; ++i) {
                String string = WSEE_URIS[i];
                if (!this.dobj.hasDDBean(string)) continue;
                this.extractWebServices(string);
                return;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected WebLogicDeployableObject getDeployableObject() {
        return this.dobj;
    }

    private void extractWebServices(String string) throws IOException {
        DDBeanRootImpl dDBeanRootImpl;
        try {
            dDBeanRootImpl = (DDBeanRootImpl)this.dobj.getDDBeanRoot(string);
        }
        catch (DDBeanCreateException dDBeanCreateException) {
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        WebservicesBean webservicesBean = (WebservicesBean)dDBeanRootImpl.getDescriptorBean();
        if (webservicesBean != null) {
            WebserviceDescriptionBean[] webserviceDescriptionBeanArray = webservicesBean.getWebserviceDescriptions();
            for (int i = 0; i < webserviceDescriptionBeanArray.length; ++i) {
                WebserviceDescriptionBean webserviceDescriptionBean = webserviceDescriptionBeanArray[i];
                arrayList.add(webserviceDescriptionBean.getWebserviceDescriptionName());
            }
        }
        this.webservices = arrayList.toArray(new String[0]);
    }

    private void addWlsModules() throws ConfigurationException {
        if (this.dobj.getType() != ModuleType.EAR) {
            return;
        }
        if (this.dc != null) {
            WebLogicDConfigBeanRoot webLogicDConfigBeanRoot = (WebLogicDConfigBeanRoot)this.dc.getDConfigBeanRoot(this.dobj.getDDBeanRoot());
            this.addModules((WeblogicApplicationBean)webLogicDConfigBeanRoot.getDescriptorBean());
        }
    }

    private void addModules(WeblogicApplicationBean weblogicApplicationBean) {
        WeblogicModuleBean[] weblogicModuleBeanArray = weblogicApplicationBean.getModules();
        for (int i = 0; i < weblogicModuleBeanArray.length; ++i) {
            WeblogicModuleBean weblogicModuleBean = weblogicModuleBeanArray[i];
            this.addModuleInfo(weblogicModuleBean, this.getDescriptorBean(weblogicModuleBean));
        }
    }

    private DescriptorBean getDescriptorBean(WeblogicModuleBean weblogicModuleBean) {
        DescriptorBean descriptorBean = null;
        try {
            DDBeanRoot dDBeanRoot = this.getDDBeanRoot(weblogicModuleBean);
            if (dDBeanRoot != null && this.dc != null && this.dobj != null) {
                BasicDConfigBeanRoot basicDConfigBeanRoot = (BasicDConfigBeanRoot)this.dc.getDConfigBeanRoot(this.dobj.getDDBeanRoot());
                BasicDConfigBeanRoot basicDConfigBeanRoot2 = (BasicDConfigBeanRoot)basicDConfigBeanRoot.getDConfigBean(dDBeanRoot);
                descriptorBean = basicDConfigBeanRoot2.getDescriptorBean();
            }
        }
        catch (ConfigurationException configurationException) {
            return descriptorBean;
        }
        return descriptorBean;
    }

    private DDBeanRoot getDDBeanRoot(WeblogicModuleBean weblogicModuleBean) {
        try {
            return this.dobj.getDDBeanRoot(weblogicModuleBean.getPath());
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
        catch (DDBeanCreateException dDBeanCreateException) {
            return null;
        }
    }
}

