/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.api.tools;

import java.io.File;
import java.io.IOException;
import java.security.AccessController;
import javax.enterprise.deploy.shared.StateType;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import javax.enterprise.deploy.spi.exceptions.DeploymentManagerCreationException;
import javax.enterprise.deploy.spi.exceptions.InvalidModuleException;
import javax.enterprise.deploy.spi.status.DeploymentStatus;
import javax.enterprise.deploy.spi.status.ProgressObject;
import weblogic.deploy.api.internal.SPIDeployerLogger;
import weblogic.deploy.api.internal.utils.Debug;
import weblogic.deploy.api.spi.WebLogicDeploymentManager;
import weblogic.deploy.api.tools.SessionHelper;
import weblogic.j2ee.descriptor.wl.DeploymentPlanBean;
import weblogic.management.DomainDir;
import weblogic.management.configuration.AppDeploymentMBean;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.provider.ManagementService;
import weblogic.management.provider.RuntimeAccess;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.utils.FileUtils;

public class ManagedSessionHelper {
    private boolean debug = Debug.isDebug("deploy");
    private static final AuthenticatedSubject kernelid = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static final String BAD_PLAN = "_wls_bad_plan.xml";
    private static final String BACKUP_PLAN = "_wls_plan_bk.xml";
    private AppDeploymentMBean mbean;
    private RuntimeAccess rt;
    protected WebLogicDeploymentManager myDM;
    private String server;
    private String host;
    private String port;
    private boolean isadmin;
    private boolean noplan = true;
    private File planBackup = null;
    private IOException backupPlanException = null;
    private boolean enableLightWeightView = false;
    protected SessionHelper helper;

    protected AppDeploymentMBean getAppDeploymentMBean() {
        return this.mbean;
    }

    protected String getPort() {
        return this.port;
    }

    protected String getHost() {
        return this.host;
    }

    protected void initSessionHelper(WebLogicDeploymentManager webLogicDeploymentManager) {
        this.helper = SessionHelper.getInstance(this.myDM);
    }

    protected boolean isAdmin() {
        return this.isadmin;
    }

    public SessionHelper getHelper() {
        return this.helper;
    }

    public ManagedSessionHelper(AppDeploymentMBean appDeploymentMBean) throws ConfigurationException, IOException, DeploymentManagerCreationException, InvalidModuleException {
        this(appDeploymentMBean, null, null);
    }

    public ManagedSessionHelper(AppDeploymentMBean appDeploymentMBean, boolean bl) throws ConfigurationException, IOException, DeploymentManagerCreationException, InvalidModuleException {
        this.enableLightWeightView = bl;
        this.rt = ManagementService.getRuntimeAccess(kernelid);
        if (this.rt == null) {
            throw new IllegalStateException("Must be running on server");
        }
        String string = this.rt.getAdminServerName();
        ServerMBean serverMBean = ((DomainMBean)appDeploymentMBean.getParent()).lookupServer(string);
        this.port = new Integer(serverMBean.getListenPort()).toString();
        this.host = serverMBean.getListenAddress();
        this.server = this.rt.getServerName();
        this.isadmin = string.equals(this.server);
        this.mbean = appDeploymentMBean;
        this.createSession(appDeploymentMBean, null, null);
    }

    public ManagedSessionHelper(AppDeploymentMBean appDeploymentMBean, String string, String string2) throws ConfigurationException, IOException, DeploymentManagerCreationException, InvalidModuleException {
        this.rt = ManagementService.getRuntimeAccess(kernelid);
        if (this.rt == null) {
            throw new IllegalStateException("Must be running on server");
        }
        String string3 = this.rt.getAdminServerName();
        ServerMBean serverMBean = ((DomainMBean)appDeploymentMBean.getParent()).lookupServer(string3);
        this.port = new Integer(serverMBean.getListenPort()).toString();
        this.host = serverMBean.getListenAddress();
        this.server = this.rt.getServerName();
        this.isadmin = string3.equals(this.server);
        this.mbean = appDeploymentMBean;
        this.createSession(appDeploymentMBean, string, string2);
    }

    private void createSession(AppDeploymentMBean appDeploymentMBean, String string, String string2) throws DeploymentManagerCreationException, ConfigurationException, IOException, InvalidModuleException {
        this.initDM(string, string2);
        this.initSessionHelper(this.myDM);
        this.helper = this.getHelper();
        String string3 = appDeploymentMBean.getLocalInstallDir();
        if (string3 != null) {
            this.helper.setApplicationRoot(new File(string3));
        }
        if ((string3 = appDeploymentMBean.getLocalSourcePath()) != null) {
            this.helper.setApplication(new File(string3));
        }
        if ((string3 = appDeploymentMBean.getLocalPlanPath()) != null) {
            this.helper.setPlan(new File(string3));
            this.noplan = false;
        }
        if ((string3 = appDeploymentMBean.getLocalPlanDir()) != null) {
            this.helper.setPlandir(new File(string3));
        } else {
            this.helper.setPlandir(this.getOrCreatePlanDir());
        }
        DeploymentPlanBean deploymentPlanBean = appDeploymentMBean.getDeploymentPlanDescriptor();
        this.helper.setPlanBean(deploymentPlanBean);
        if (deploymentPlanBean != null) {
            deploymentPlanBean.setConfigRoot(this.helper.getPlandir().getPath());
        }
        this.helper.enableLibraryMerge();
        if (this.enableLightWeightView) {
            this.helper.setLightWeightAppName(appDeploymentMBean.getApplicationName());
        }
        this.helper.initializeConfiguration(appDeploymentMBean);
    }

    protected void initDM(String string, String string2) throws DeploymentManagerCreationException {
        if (string == null || this.isadmin) {
            this.myDM = SessionHelper.getDeploymentManager(this.host, this.port);
            if (!this.isadmin) {
                this.myDM.enableFileUploads();
            }
        } else {
            this.myDM = SessionHelper.getRemoteDeploymentManager(this.host, this.port, string, string2);
        }
    }

    public ProgressObject saveAndUpdate() throws ConfigurationException, IOException {
        File file = this.getNewPlanFile();
        TargetModuleID[] targetModuleIDArray = this.myDM.getModules(this.mbean);
        if (this.debug) {
            Debug.say("Updating " + this.mbean.getName() + " with new plan: " + file.getPath());
        }
        String[] stringArray = this.helper.getChangedDescriptors();
        ProgressObject progressObject = this.myDM.update(targetModuleIDArray, file, stringArray, null);
        this.waitForTask(progressObject);
        DeploymentStatus deploymentStatus = progressObject.getDeploymentStatus();
        if (deploymentStatus.getState() != StateType.COMPLETED) {
            this.restoreOrigPlan(file);
            SPIDeployerLogger.logRestorePlan((String)deploymentStatus.getMessage());
        }
        if (!this.debug && this.planBackup != null) {
            this.planBackup.delete();
        }
        return progressObject;
    }

    private void waitForTask(ProgressObject progressObject) {
        while (progressObject.getDeploymentStatus().isRunning()) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void saveBadPlan(File file) {
        try {
            FileUtils.copy((File)file, (File)new File(file.getParentFile(), BAD_PLAN));
        }
        catch (IOException iOException) {
            Debug.say("Unable to copy the bad plan to a backup location : " + iOException);
        }
    }

    private void restoreOrigPlan(File file) throws IOException {
        if (this.planBackup == null) {
            return;
        }
        if (this.debug) {
            this.saveBadPlan(file);
        }
        try {
            FileUtils.copy((File)this.planBackup, (File)file);
            this.mbean.setDeploymentPlanDescriptor(null);
            DeploymentPlanBean deploymentPlanBean = this.mbean.getDeploymentPlanDescriptor();
            this.helper.setPlanBean(deploymentPlanBean);
            file = null;
            this.planBackup = null;
        }
        catch (IOException iOException) {
            throw new IOException(SPIDeployerLogger.restorePlanFailure((String)iOException.getMessage(), (String)this.planBackup.getPath()));
        }
    }

    protected File getNewPlanFile() throws IOException, ConfigurationException {
        File file = this.getOrCreatePlanDir();
        File file2 = new File(file, this.helper.getNewPlanName());
        if (this.helper.getPlan() != null && file2.getPath().equals(this.helper.getPlan().getPath())) {
            this.planBackup = new File(file, BACKUP_PLAN);
            try {
                FileUtils.copy((File)this.helper.getPlan(), (File)this.planBackup);
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException(SPIDeployerLogger.backupPlanError((String)iOException.getMessage(), (String)this.planBackup.getPath()));
            }
        }
        file2 = this.helper.savePlan(file, this.helper.getNewPlanName());
        return file2;
    }

    private File getOrCreatePlanDir() throws IOException {
        File file;
        if (this.helper.getPlandir() != null) {
            return this.helper.getPlandir();
        }
        if (this.isadmin) {
            if (this.noplan) {
                file = new File(DomainDir.getDeploymentsDir());
                if (this.debug) {
                    Debug.say("deployments dir: " + file);
                }
                file = new File(file, this.mbean.getName());
                file = new File(file, "plan");
                file.mkdirs();
            } else {
                file = this.helper.getPlan().getParentFile();
            }
            if (this.debug) {
                Debug.say("Using plan dir: " + file);
            }
        } else {
            file = new File(DomainDir.getTempDirForServer((String)this.server));
        }
        return file;
    }

    public void close() {
        this.helper.close();
        this.myDM.release();
    }
}

