/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.api.tools;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import weblogic.deploy.api.internal.utils.ConfigHelper;
import weblogic.deploy.api.model.WebLogicDeployableObject;
import weblogic.deploy.api.shared.WebLogicModuleType;
import weblogic.deploy.api.spi.WebLogicDeploymentConfiguration;
import weblogic.deploy.api.tools.DeployableObjectInfo;
import weblogic.deploy.api.tools.ModuleBeanInfo;
import weblogic.descriptor.DescriptorBean;
import weblogic.j2ee.descriptor.wl.WeblogicModuleBean;

public class ModuleInfo {
    protected String name = null;
    protected Set subModules = new HashSet();
    protected ModuleType type = WebLogicModuleType.UNKNOWN;
    protected boolean archived = false;
    protected ModuleInfo parent = null;
    protected String[] roots = null;
    protected String[] webservices;
    protected String[] beans;
    protected String[] subDeployments;

    protected ModuleInfo() {
    }

    protected static ModuleInfo createModuleInfo(WebLogicDeployableObject webLogicDeployableObject) throws IOException, ConfigurationException {
        return ModuleInfo.createModuleInfo(webLogicDeployableObject, null, null);
    }

    protected static ModuleInfo createModuleInfo(WebLogicDeployableObject webLogicDeployableObject, WebLogicDeploymentConfiguration webLogicDeploymentConfiguration, String string) throws IOException, ConfigurationException {
        ConfigHelper.checkParam("WebLogicDeployableObject", webLogicDeployableObject);
        return new DeployableObjectInfo(webLogicDeployableObject, webLogicDeploymentConfiguration, string);
    }

    private ModuleInfo createModuleInfo(WeblogicModuleBean weblogicModuleBean, DescriptorBean descriptorBean) {
        if ("JMS".equals(weblogicModuleBean.getType())) {
            return new ModuleBeanInfo(weblogicModuleBean, WebLogicModuleType.JMS, descriptorBean);
        }
        if ("JDBC".equals(weblogicModuleBean.getType())) {
            return new ModuleBeanInfo(weblogicModuleBean, WebLogicModuleType.JDBC, descriptorBean);
        }
        if ("Interception".equals(weblogicModuleBean.getType())) {
            return new ModuleBeanInfo(weblogicModuleBean, WebLogicModuleType.INTERCEPT, descriptorBean);
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public ModuleInfo[] getSubModules() {
        return this.subModules.toArray(new ModuleInfo[0]);
    }

    public ModuleType getType() {
        return this.type;
    }

    public boolean isArchived() {
        return this.archived;
    }

    public boolean isWebService() {
        return this.webservices != null && this.webservices.length > 0;
    }

    public String[] getWebServices() {
        return this.webservices;
    }

    public String[] getContextRoots() {
        return this.roots;
    }

    public String[] getBeans() {
        return this.beans;
    }

    public String[] getSubDeployments() {
        return this.subDeployments;
    }

    protected boolean addModuleInfo(ModuleInfo moduleInfo) {
        boolean bl = this.subModules.add(moduleInfo);
        if (bl) {
            moduleInfo.setParent(this);
        }
        return bl;
    }

    protected boolean addModuleInfo(WeblogicModuleBean weblogicModuleBean, DescriptorBean descriptorBean) {
        ModuleInfo moduleInfo = this.createModuleInfo(weblogicModuleBean, descriptorBean);
        if (moduleInfo != null) {
            return this.addModuleInfo(moduleInfo);
        }
        return false;
    }

    protected ModuleInfo getParent() {
        return this.parent;
    }

    private void setParent(ModuleInfo moduleInfo) {
        this.parent = moduleInfo;
    }

    protected boolean checkIfArchived(WebLogicDeployableObject webLogicDeployableObject) {
        File file = webLogicDeployableObject.getArchive();
        if (file.isDirectory()) {
            return false;
        }
        return !file.getName().endsWith(".xml");
    }
}

