/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.api.tools;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import weblogic.application.library.LibraryData;
import weblogic.application.library.LoggableLibraryProcessingException;
import weblogic.application.utils.LibraryLoggingUtils;
import weblogic.deploy.api.internal.PlanGenTextFormatter;
import weblogic.deploy.api.internal.utils.Debug;
import weblogic.deploy.api.spi.WebLogicDeploymentConfiguration;
import weblogic.deploy.api.spi.WebLogicDeploymentManager;
import weblogic.deploy.api.tools.SessionHelper;
import weblogic.utils.Getopt2;
import weblogic.utils.StringUtils;

public class PlanGenerator {
    private static final String HELP = "help";
    private static final String DEBUG = "debug";
    private static final String PLAN = "plan";
    private static final String USEPLAN = "useplan";
    private static final String INSTALLROOT = "root";
    private static final String VARIABLES = "variables";
    private static final String DEPENDENCIES = "dependencies";
    private static final String DECLARATIONS = "declarations";
    private static final String CONFIGURABLES = "configurables";
    private static final String DYNAMIC = "dynamics";
    private static final String ALL = "all";
    private static final String NONE = "none";
    private static final String LIBRARY = "library";
    private static final String LIBRARYDIR = "librarydir";
    private static PlanGenTextFormatter cat = PlanGenTextFormatter.getInstance();
    private static boolean debug = false;
    private SessionHelper helper;
    private WebLogicDeploymentManager dm;
    private File app;
    private File plan = null;
    private WebLogicDeploymentConfiguration dc;
    private int exportArg = 0;
    private boolean globalVars = false;
    private static int EXPORT_NONE = -1;
    private Getopt2 opts;
    private static final String DEFAULT_PLAN = "plan.xml";
    private static final String NOEXIT = "noexit";
    private Set libraries = null;

    private PlanGenerator(Getopt2 getopt2) {
        this.opts = getopt2;
    }

    private void run() throws Exception {
        this.dm = SessionHelper.getDisconnectedDeploymentManager();
        this.helper = SessionHelper.getInstance(this.dm);
        this.setVariables();
        this.setExport();
        this.setRoot();
        this.setApp();
        this.setUsePlan();
        this.setPlan();
        this.setLibraries();
        this.setLibrarDirs();
        this.registerLibraries();
        this.showInputs();
        this.helper.initializeConfiguration();
        this.dc = this.helper.getConfiguration();
        this.dc.getPlan().setGlobalVariables(this.globalVars);
        if (this.exportArg != EXPORT_NONE) {
            System.out.println(cat.exporting());
            this.dc.export(this.exportArg);
        }
    }

    private void registerLibraries() {
        if (this.libraries == null) {
            return;
        }
        for (LibraryData libraryData : this.libraries) {
            this.helper.registerLibrary(libraryData.getLocation(), libraryData.getName(), libraryData.getSpecificationVersion() == null ? null : libraryData.getSpecificationVersion().toString(), libraryData.getImplementationVersion());
        }
    }

    private void setLibrarDirs() {
        if (!this.opts.hasOption(LIBRARYDIR)) {
            return;
        }
        File file = new File(this.opts.getOption(LIBRARYDIR));
        try {
            LibraryLoggingUtils.checkLibdirIsValid(file);
        }
        catch (LoggableLibraryProcessingException loggableLibraryProcessingException) {
            throw new IllegalArgumentException(loggableLibraryProcessingException);
        }
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            this.addLibrary(LibraryData.newEmptyInstance(fileArray[i]));
        }
    }

    private void setLibraries() {
        if (!this.opts.hasOption(LIBRARY)) {
            return;
        }
        String[] stringArray = StringUtils.splitCompletely((String)this.opts.getOption(LIBRARY), (String)",");
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            String string2 = stringArray[i];
            int n = stringArray[i].indexOf("@");
            if (n > -1) {
                string = stringArray[i].substring(0, n);
                string2 = stringArray[i].substring(n);
            }
            File file = new File(string);
            try {
                this.addLibrary(this.parseLibraryArg(file, string2));
                continue;
            }
            catch (LoggableLibraryProcessingException loggableLibraryProcessingException) {
                throw new IllegalArgumentException(loggableLibraryProcessingException);
            }
        }
    }

    private void addLibrary(LibraryData libraryData) {
        if (this.libraries == null) {
            this.libraries = new HashSet();
        }
        this.libraries.add(libraryData);
    }

    private LibraryData parseLibraryArg(File file, String string) throws LoggableLibraryProcessingException {
        LibraryLoggingUtils.checkLibraryExists(file);
        if (string.indexOf("@") == -1) {
            return LibraryData.newEmptyInstance(file);
        }
        String[] stringArray = StringUtils.splitCompletely((String)string, (String)"@");
        String string2 = null;
        String string3 = null;
        String string4 = null;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].indexOf("=") == -1) continue;
            String[] stringArray2 = StringUtils.splitCompletely((String)stringArray[i], (String)"=");
            if (stringArray2[0].equalsIgnoreCase("name")) {
                string2 = stringArray2[1];
            }
            if (stringArray2[0].equalsIgnoreCase("libspecver")) {
                string3 = stringArray2[1];
            }
            if (!stringArray2[0].equalsIgnoreCase("libimplver")) continue;
            string4 = stringArray2[1];
        }
        return LibraryLoggingUtils.initLibraryData(string2, string3, string4, file);
    }

    private void setPlan() {
        this.plan = this.opts.hasOption(PLAN) ? new File(this.opts.getOption(PLAN)) : this.helper.getPlan();
        if (this.plan == null) {
            this.setImplicitPlan();
        }
        if (this.plan == null) {
            this.plan = new File(DEFAULT_PLAN);
        }
        if (this.plan.exists() && !this.opts.hasOption(USEPLAN)) {
            this.helper.setPlan(this.plan);
        }
    }

    private void setImplicitPlan() {
        if (this.helper.getApplicationRoot() != null) {
            File file = new File(this.helper.getApplicationRoot(), PLAN);
            if (!file.exists()) {
                file.mkdirs();
            }
            if (file.isDirectory()) {
                this.plan = new File(file, DEFAULT_PLAN);
            }
        }
    }

    private void setUsePlan() {
        if (this.opts.hasOption(USEPLAN)) {
            if (debug) {
                Debug.say(" UsePlan set. So, setting plan on helper to : " + this.opts.getOption(USEPLAN));
            }
            this.helper.setPlan(new File(this.opts.getOption(USEPLAN)));
            if (debug) {
                Debug.say(" Plan on helper set to : " + this.helper.getPlan());
            }
        }
    }

    private void setApp() {
        if (this.opts.args().length > 0) {
            this.helper.setApplication(new File(this.opts.args()[0]));
        }
        this.app = this.helper.getApplication();
        if (this.app == null) {
            throw new IllegalArgumentException(cat.noApp());
        }
    }

    private void setRoot() {
        if (this.opts.hasOption(INSTALLROOT)) {
            this.helper.setApplicationRoot(new File(this.opts.getOption(INSTALLROOT)));
        }
    }

    private void showInputs() {
        if (this.helper.getPlan() != null) {
            System.out.println(cat.genningWithPlan(this.app.getPath(), this.helper.getPlan().getPath()));
        } else {
            System.out.println(cat.genning(this.app.getPath()));
        }
        System.out.println(cat.exportOptions(this.exportAsString(this.exportArg)));
        if (this.libraries != null) {
            System.out.println(cat.merging());
            for (LibraryData libraryData : this.libraries) {
                System.out.println(cat.libLocation(libraryData.getLocation().getPath()));
                System.out.println(cat.libName(libraryData.getName()));
                System.out.println(cat.libSpec(libraryData.getSpecificationVersion() == null ? null : libraryData.getSpecificationVersion().toString()));
                System.out.println(cat.libImpl(libraryData.getImplementationVersion()));
                System.out.println();
            }
        }
    }

    private String exportAsString(int n) {
        switch (n) {
            case 0: {
                return DEPENDENCIES;
            }
            case 1: {
                return DECLARATIONS;
            }
            case 2: {
                return CONFIGURABLES;
            }
            case 3: {
                return ALL;
            }
            case 4: {
                return DYNAMIC;
            }
        }
        return NONE;
    }

    private void setExport() {
        if (this.opts.hasOption(DEPENDENCIES)) {
            this.exportArg = 0;
        } else if (this.opts.hasOption(DECLARATIONS)) {
            this.exportArg = 1;
        } else if (this.opts.hasOption(CONFIGURABLES)) {
            this.exportArg = 2;
        } else if (this.opts.hasOption(ALL)) {
            this.exportArg = 3;
        } else if (this.opts.hasOption(NONE)) {
            this.exportArg = EXPORT_NONE;
        } else if (this.opts.hasOption(DYNAMIC)) {
            this.exportArg = 4;
        }
    }

    private void setVariables() {
        if (this.opts.hasOption(VARIABLES)) {
            String string = this.opts.getOption(VARIABLES);
            if ("global".equals(string)) {
                this.globalVars = true;
            } else if ("unique".equals(string)) {
                this.globalVars = false;
            } else {
                throw new IllegalArgumentException(cat.badVariables(string));
            }
        }
    }

    private void save() throws IOException, ConfigurationException {
        System.out.println(cat.saving(this.plan.getCanonicalPath()));
        this.helper.setPlan(this.plan);
        this.helper.savePlan();
    }

    private void close() {
        if (this.helper != null) {
            this.helper.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void main(String[] stringArray) throws Exception {
        boolean bl;
        Getopt2 getopt2;
        block14: {
            PlanGenerator planGenerator;
            block12: {
                block13: {
                    getopt2 = new Getopt2();
                    planGenerator = null;
                    bl = false;
                    String[] stringArray2 = stringArray;
                    getopt2.addFlag(DEBUG, cat.debug());
                    getopt2.addFlag(NOEXIT, cat.noexit());
                    getopt2.addOption(PLAN, "myplan.xml", cat.plan());
                    getopt2.addOption(USEPLAN, "myplan.xml", cat.useplan());
                    getopt2.addOption(INSTALLROOT, "/weblogic/install/myapp", "application install root");
                    getopt2.addFlag(DEPENDENCIES, cat.dependencies());
                    getopt2.addFlag(DECLARATIONS, cat.declarations());
                    getopt2.addFlag(CONFIGURABLES, cat.configurables());
                    getopt2.addFlag(DYNAMIC, cat.dynamics());
                    getopt2.addFlag(ALL, cat.all());
                    getopt2.addFlag(NONE, cat.none());
                    getopt2.addOption(VARIABLES, "global", cat.variables());
                    getopt2.addOption(LIBRARY, "/mylibs/lib.ear@name=mylib,/mylibs/lib2.ear@name=otherlib@libspecver=1@libimplver=2", cat.libraries());
                    getopt2.addOption(LIBRARYDIR, "/mylibs", cat.libraryDir());
                    getopt2.setUsageArgs(cat.application());
                    getopt2.grok(stringArray2);
                    if (!getopt2.hasOption(HELP) && stringArray.length != 0) break block12;
                    PlanGenerator.usage(getopt2);
                    if (planGenerator == null) break block13;
                    planGenerator.close();
                }
                if (!bl || getopt2.hasOption(NOEXIT)) return;
                System.exit(1);
                return;
            }
            try {
                if (getopt2.hasOption(DEBUG)) {
                    PlanGenerator.setDebug();
                }
                planGenerator = new PlanGenerator(getopt2);
                planGenerator.run();
                planGenerator.save();
                if (planGenerator == null) break block14;
                planGenerator.close();
            }
            catch (Throwable throwable) {
                block15: {
                    try {
                        if (getopt2.hasOption(NOEXIT)) {
                            if (!(throwable instanceof Exception)) throw new Exception(throwable);
                            throw (Exception)throwable;
                        }
                        if (debug) {
                            throwable.printStackTrace();
                        } else {
                            String string = throwable.getMessage();
                            if (string != null) {
                                System.out.println(throwable.getMessage());
                            } else {
                                throwable.printStackTrace();
                            }
                        }
                        bl = true;
                        if (planGenerator == null) break block15;
                        planGenerator.close();
                    }
                    catch (Throwable throwable2) {
                        if (planGenerator != null) {
                            super.close();
                        }
                        if (!bl || getopt2.hasOption(NOEXIT)) throw throwable2;
                        System.exit(1);
                        throw throwable2;
                    }
                }
                if (!bl || getopt2.hasOption(NOEXIT)) return;
                System.exit(1);
                return;
            }
        }
        if (!bl || getopt2.hasOption(NOEXIT)) return;
        System.exit(1);
        return;
    }

    private static void usage(Getopt2 getopt2) {
        getopt2.usageError("weblogic.PlanGenerator");
        System.out.println(cat.usage());
    }

    private static void setDebug() {
        debug = true;
        System.setProperty("weblogic.deployer.debug", ALL);
    }
}

