/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.api.tools;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.enterprise.deploy.model.DDBeanRoot;
import javax.enterprise.deploy.model.DeployableObject;
import javax.enterprise.deploy.model.exceptions.DDBeanCreateException;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.shared.factories.DeploymentFactoryManager;
import javax.enterprise.deploy.spi.DConfigBeanRoot;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import javax.enterprise.deploy.spi.exceptions.DeploymentManagerCreationException;
import javax.enterprise.deploy.spi.exceptions.InvalidModuleException;
import javax.enterprise.deploy.spi.factories.DeploymentFactory;
import weblogic.deploy.api.internal.Closable;
import weblogic.deploy.api.internal.SPIDeployerLogger;
import weblogic.deploy.api.internal.utils.ConfigHelper;
import weblogic.deploy.api.internal.utils.Debug;
import weblogic.deploy.api.internal.utils.InstallDir;
import weblogic.deploy.api.internal.utils.LibrarySpec;
import weblogic.deploy.api.model.WebLogicDeployableObject;
import weblogic.deploy.api.model.WebLogicJ2eeApplicationObject;
import weblogic.deploy.api.model.internal.WebLogicDeployableObjectFactoryImpl;
import weblogic.deploy.api.model.sca.ScaApplicationObject;
import weblogic.deploy.api.shared.WebLogicModuleType;
import weblogic.deploy.api.spi.WebLogicDConfigBeanRoot;
import weblogic.deploy.api.spi.WebLogicDeploymentConfiguration;
import weblogic.deploy.api.spi.WebLogicDeploymentManager;
import weblogic.deploy.api.spi.WebLogicTargetModuleID;
import weblogic.deploy.api.spi.config.DescriptorSupportManager;
import weblogic.deploy.api.spi.factories.WebLogicDeploymentFactory;
import weblogic.deploy.api.spi.factories.internal.DeploymentFactoryImpl;
import weblogic.deploy.api.tools.ModuleInfo;
import weblogic.j2ee.descriptor.wl.DeploymentPlanBean;
import weblogic.j2ee.descriptor.wl.JMSBean;
import weblogic.j2ee.descriptor.wl.ModuleDescriptorBean;
import weblogic.j2ee.descriptor.wl.ModuleOverrideBean;
import weblogic.j2ee.descriptor.wl.WeblogicApplicationBean;
import weblogic.j2ee.descriptor.wl.WeblogicModuleBean;
import weblogic.jms.module.DefaultingHelper;
import weblogic.management.DomainDir;
import weblogic.management.configuration.AppDeploymentMBean;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.SubDeploymentMBean;
import weblogic.management.configuration.TargetMBean;
import weblogic.management.utils.AppDeploymentHelper;
import weblogic.utils.FileUtils;

public class SessionHelper {
    private static final Class DEF_FACTORY_CLASS = DeploymentFactoryImpl.class;
    private boolean debug = Debug.isDebug("config");
    protected WebLogicDeploymentManager dm;
    protected WebLogicDeployableObject dObject = null;
    protected WebLogicDeploymentConfiguration dConfig = null;
    private ModuleType moduleType = null;
    private boolean explicitApplication = false;
    private boolean explicitPlan = false;
    private boolean explicitRoot = false;
    private File application = null;
    private String lightWeightAppName = null;
    private File plan = null;
    private File root = null;
    private File plandir = null;
    private boolean fullInit = true;
    private static final String APP_DIR = "app";
    private static final String PLAN_DIR = "plan";
    private boolean updatePlanVersion = false;
    private DeploymentPlanBean planBean = null;
    private List libs = null;

    private boolean isExplicitApplication() {
        return this.explicitApplication;
    }

    private void setExplicitApplication(boolean bl) {
        this.explicitApplication = bl;
    }

    private boolean isExplicitPlan() {
        return this.explicitPlan;
    }

    private void setExplicitPlan(boolean bl) {
        this.explicitPlan = bl;
    }

    private boolean isExplicitRoot() {
        return this.explicitRoot;
    }

    private void setExplicitRoot(boolean bl) {
        this.explicitRoot = bl;
    }

    public void close() {
        this.close(this.dConfig);
        this.close(this.dObject);
        this.dConfig = null;
        this.dObject = null;
    }

    private void close(Closable closable) {
        try {
            if (closable != null) {
                closable.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public File getApplication() {
        return this.application;
    }

    public void setApplication(File file) {
        this.setApplication(file, true);
        this.setImplicitRoot(this.getApplication(), APP_DIR);
        this.setImplicitPlan();
    }

    protected void setLightWeightAppName(String string) {
        this.lightWeightAppName = string;
    }

    private void setImplicitRoot(File file, String string) {
        if (this.isExplicitRoot()) {
            return;
        }
        if (file == null) {
            return;
        }
        if (string.equals(file.getAbsoluteFile().getParentFile().getName())) {
            this.setApplicationRoot(file.getAbsoluteFile().getParentFile().getParentFile(), false);
        }
    }

    private void setImplicitPlan() {
        String[] stringArray;
        String string;
        if (this.isExplicitPlan()) {
            return;
        }
        File file = this.getApplicationRoot();
        if (file == null) {
            return;
        }
        File file2 = new File(file, PLAN_DIR);
        if (file2.exists() && file2.isDirectory() && (string = this.getOnlyXMLFile(stringArray = file2.list())) != null) {
            this.setPlan(new File(file2, string), false);
        }
    }

    private String getOnlyXMLFile(String[] stringArray) {
        String string = null;
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (!string2.endsWith(".xml")) continue;
            if (string == null) {
                string = string2;
                continue;
            }
            return null;
        }
        return string;
    }

    private void setImplicitApplication() {
        String[] stringArray;
        if (this.isExplicitApplication()) {
            return;
        }
        File file = this.getApplicationRoot();
        if (file == null) {
            return;
        }
        File file2 = new File(file, APP_DIR);
        if (file2.exists() && file2.isDirectory() && (stringArray = file2.list()).length == 1) {
            this.setApplication(new File(file2, stringArray[0]), false);
        }
    }

    private void setApplication(File file, boolean bl) {
        this.application = file;
        this.setExplicitApplication(bl);
    }

    public File getPlan() {
        return this.plan;
    }

    public void setPlan(File file) {
        this.setPlan(file, true);
        this.setImplicitRoot(file, PLAN_DIR);
    }

    private void setPlan(File file, boolean bl) {
        if (file != null && file.exists() && file.isDirectory()) {
            throw new IllegalArgumentException(SPIDeployerLogger.planIsDir((String)file.getPath()));
        }
        this.plan = file;
        this.setExplicitPlan(bl);
    }

    public File getPlandir() {
        return this.plandir;
    }

    public void setPlandir(File file) {
        this.plandir = file;
    }

    public void setPlanBean(DeploymentPlanBean deploymentPlanBean) {
        this.planBean = deploymentPlanBean;
    }

    public File getApplicationRoot() {
        return this.root;
    }

    public void setApplicationRoot(File file) {
        this.setApplicationRoot(file, true);
        this.setImplicitApplication();
        this.setImplicitPlan();
    }

    private void setApplicationRoot(File file, boolean bl) {
        if (file != null && file.exists() && !file.isDirectory()) {
            throw new IllegalArgumentException(SPIDeployerLogger.rootIsFile((String)file.getPath()));
        }
        this.root = file;
        this.setExplicitRoot(bl);
    }

    protected String[] getChangedDescriptors() {
        int n;
        if (this.planBean == null) {
            return new String[0];
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        ModuleOverrideBean[] moduleOverrideBeanArray = this.planBean.getModuleOverrides();
        if (moduleOverrideBeanArray == null) {
            return new String[0];
        }
        String string = null;
        for (n = 0; n < moduleOverrideBeanArray.length; ++n) {
            if (!this.planBean.rootModule(moduleOverrideBeanArray[n].getModuleName())) continue;
            string = moduleOverrideBeanArray[n].getModuleName();
            break;
        }
        for (int i = 0; i < moduleOverrideBeanArray.length; ++i) {
            boolean bl = ModuleType.EAR.toString().equals(moduleOverrideBeanArray[i].getModuleType());
            n = moduleOverrideBeanArray[i].getModuleName().equals(string) ? 1 : 0;
            ModuleDescriptorBean[] moduleDescriptorBeanArray = moduleOverrideBeanArray[i].getModuleDescriptors();
            if (moduleDescriptorBeanArray == null) continue;
            for (int j = 0; j < moduleDescriptorBeanArray.length; ++j) {
                String string2 = moduleDescriptorBeanArray[j].getUri();
                if (n == 0) {
                    string2 = moduleOverrideBeanArray[i].getModuleName() + "/" + string2;
                }
                if (!moduleDescriptorBeanArray[j].isChanged()) continue;
                arrayList.add(string2);
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public void setDebug() {
        this.debug = true;
    }

    public boolean isFullInit() {
        return this.fullInit;
    }

    public void setFullInit(boolean bl) {
        this.fullInit = bl;
    }

    public boolean isUpdatePlanVersion() {
        return this.updatePlanVersion;
    }

    public void setUpdatePlanVersion(boolean bl) {
        this.updatePlanVersion = bl;
        if (bl && this.getConfiguration() != null) {
            this.bumpVersion();
        }
    }

    protected SessionHelper(WebLogicDeploymentManager webLogicDeploymentManager) {
        this.dm = webLogicDeploymentManager;
    }

    public static SessionHelper getInstance(WebLogicDeploymentManager webLogicDeploymentManager) {
        return new SessionHelper(webLogicDeploymentManager);
    }

    public static WebLogicDeploymentManager getDisconnectedDeploymentManager() throws DeploymentManagerCreationException {
        WebLogicDeploymentFactory webLogicDeploymentFactory = (WebLogicDeploymentFactory)SessionHelper.registerDefaultFactory();
        return (WebLogicDeploymentManager)webLogicDeploymentFactory.getDisconnectedDeploymentManager("deployer:WebLogic");
    }

    public static WebLogicDeploymentManager getDeploymentManager(String string, String string2, String string3, String string4, String string5) throws DeploymentManagerCreationException {
        WebLogicDeploymentFactory webLogicDeploymentFactory = (WebLogicDeploymentFactory)SessionHelper.registerDefaultFactory();
        return (WebLogicDeploymentManager)webLogicDeploymentFactory.getDeploymentManager(webLogicDeploymentFactory.createUri(string, "deployer:WebLogic", string2, string3), string4, string5);
    }

    public static WebLogicDeploymentManager getDeploymentManager(String string, String string2, String string3, String string4) throws DeploymentManagerCreationException {
        return SessionHelper.getDeploymentManager("t3", string, string2, string3, string4);
    }

    public static WebLogicDeploymentManager getRemoteDeploymentManager(String string, String string2, String string3, String string4) throws DeploymentManagerCreationException {
        return SessionHelper.getRemoteDeploymentManager("t3", string, string2, string3, string4);
    }

    public static WebLogicDeploymentManager getRemoteDeploymentManager(String string, String string2, String string3, String string4, String string5) throws DeploymentManagerCreationException {
        WebLogicDeploymentFactory webLogicDeploymentFactory = (WebLogicDeploymentFactory)SessionHelper.registerDefaultFactory();
        return (WebLogicDeploymentManager)webLogicDeploymentFactory.getDeploymentManager(webLogicDeploymentFactory.createUri(string, "remote:deployer:WebLogic", string2, string3), string4, string5);
    }

    public static WebLogicDeploymentManager getDeploymentManager(String string, String string2) throws DeploymentManagerCreationException {
        WebLogicDeploymentFactory webLogicDeploymentFactory = (WebLogicDeploymentFactory)SessionHelper.registerDefaultFactory();
        return (WebLogicDeploymentManager)webLogicDeploymentFactory.getDeploymentManager(webLogicDeploymentFactory.createUri("authenticated:deployer:WebLogic", string, string2), null, null);
    }

    public WebLogicDeployableObject getDeployableObject() {
        return this.dObject;
    }

    public WebLogicDeploymentConfiguration getConfiguration() {
        return this.dConfig;
    }

    public void initializeConfiguration() throws ConfigurationException, IOException, InvalidModuleException {
        this.initializeConfiguration(null);
    }

    public void initializeConfiguration(AppDeploymentMBean appDeploymentMBean) throws ConfigurationException, IOException, InvalidModuleException {
        if (this.dObject != null) {
            throw new AssertionError((Object)SPIDeployerLogger.getReinitializeError());
        }
        this.normalizeProperties(appDeploymentMBean);
        this.initialize();
    }

    private void normalizeProperties() throws IOException {
        this.normalizeProperties(null);
    }

    private void normalizeProperties(AppDeploymentMBean appDeploymentMBean) throws IOException {
        if (this.getApplication() == null) {
            throw new IllegalArgumentException(SPIDeployerLogger.noAppProvided());
        }
        String string = this.getApplication().getName();
        if (appDeploymentMBean != null) {
            string = appDeploymentMBean.getName();
        }
        InstallDir installDir = new InstallDir(string, this.getApplicationRoot());
        installDir.setArchive(this.getApplication());
        installDir.setPlan(this.getPlan());
        if (this.getPlandir() != null) {
            installDir.setConfigDir(this.getPlandir());
        }
        this.setApplication(installDir.getArchive(), true);
        this.setPlan(installDir.getPlan(), true);
        this.setApplicationRoot(installDir.getInstallDir(), true);
    }

    public void initializeConfiguration(File file, File file2, ModuleType moduleType) throws ConfigurationException, IOException, InvalidModuleException {
        this.initializeConfiguration(file, file2, (File)null);
    }

    public void initializeConfiguration(File file, File file2) throws ConfigurationException, IOException, InvalidModuleException {
        this.initializeConfiguration(file, file2, (File)null);
    }

    public void initializeConfiguration(File file, File file2, File file3) throws ConfigurationException, IOException, InvalidModuleException {
        if (this.debug) {
            Debug.say("In deprecated method");
        }
        this.setApplication(file, true);
        this.setPlan(file2, true);
        this.setApplicationRoot(file3, true);
        this.initializeConfiguration();
    }

    public void initializeConfiguration(File file, File file2, File file3, ModuleType moduleType) throws ConfigurationException, IOException, InvalidModuleException {
        this.initializeConfiguration(file, file2, file3);
    }

    public void inspect() throws IOException, InvalidModuleException, ConfigurationException {
        if (this.dObject != null) {
            throw new AssertionError((Object)SPIDeployerLogger.getReinitializeError());
        }
        this.normalizeProperties();
        WebLogicDeployableObjectFactoryImpl webLogicDeployableObjectFactoryImpl = new WebLogicDeployableObjectFactoryImpl();
        if (this.lightWeightAppName != null) {
            webLogicDeployableObjectFactoryImpl.setLightWeightAppName(this.lightWeightAppName);
        }
        this.dObject = webLogicDeployableObjectFactoryImpl.createLazyDeployableObject(this.getApplication(), this.getApplicationRoot(), this.getPlan(), this.getPlandir(), this.getLibraries());
        this.moduleType = this.dObject.getType();
        if (this.debug) {
            Debug.say("derived module type: " + this.moduleType.toString());
        }
        this.dConfig = (WebLogicDeploymentConfiguration)this.dm.createConfiguration(this.dObject);
        if (this.dObject instanceof WebLogicJ2eeApplicationObject) {
            this.dConfig.getDConfigBeanRoot(this.dObject.getDDBeanRoot());
        }
        this.restorefromPlan();
    }

    public LibrarySpec registerLibrary(File file, String string, String string2, String string3) throws IllegalArgumentException {
        if (this.libs == null) {
            this.enableLibraryMerge();
        }
        LibrarySpec librarySpec = new LibrarySpec(string, string2, string3, file);
        this.libs.add(librarySpec);
        return librarySpec;
    }

    public ModuleInfo getModuleInfo() throws IOException, ConfigurationException {
        return ModuleInfo.createModuleInfo(this.getDeployableObject(), this.getConfiguration(), null);
    }

    protected void initialize() throws ConfigurationException, IOException, InvalidModuleException {
        if (this.debug) {
            Debug.say("Initializing configuration using");
            Debug.say("   app: " + this.getApplication().getPath());
            if (this.getPlan() != null) {
                Debug.say("   plan: " + this.getPlan().getPath());
            }
            if (this.getApplicationRoot() != null) {
                Debug.say("   root: " + this.getApplicationRoot().getPath());
            }
        }
        WebLogicDeployableObjectFactoryImpl webLogicDeployableObjectFactoryImpl = new WebLogicDeployableObjectFactoryImpl();
        if (this.lightWeightAppName != null) {
            webLogicDeployableObjectFactoryImpl.setLightWeightAppName(this.lightWeightAppName);
        }
        this.dObject = webLogicDeployableObjectFactoryImpl.createDeployableObject(this.getApplication(), this.getApplicationRoot(), this.getPlan(), this.getPlandir(), this.getLibraries());
        this.moduleType = this.dObject.getType();
        if (this.debug) {
            Debug.say("derived module type: " + this.moduleType.toString());
        }
        this.dConfig = (WebLogicDeploymentConfiguration)this.dm.createConfiguration(this.dObject);
        this.initializeWithConfig();
        if (this.updatePlanVersion) {
            this.bumpVersion();
        }
    }

    public LibrarySpec[] getLibraries() {
        return this.libs == null ? null : this.libs.toArray(new LibrarySpec[0]);
    }

    public void enableLibraryMerge() {
        if (this.libs == null) {
            this.libs = new ArrayList();
        }
    }

    private void initializeScaWithConfig() throws ConfigurationException {
        ScaApplicationObject scaApplicationObject = (ScaApplicationObject)((Object)this.dObject);
        DeployableObject[] deployableObjectArray = scaApplicationObject.getDeployableObjects();
        if (deployableObjectArray == null) {
            return;
        }
        for (int i = 0; i < deployableObjectArray.length; ++i) {
            ModuleType moduleType = deployableObjectArray[i].getType();
            if (moduleType != ModuleType.WAR && moduleType != ModuleType.EJB) continue;
            DDBeanRoot dDBeanRoot = deployableObjectArray[i].getDDBeanRoot();
            DConfigBeanRoot dConfigBeanRoot = this.dConfig.getDConfigBeanRoot(dDBeanRoot);
            if (!this.fullInit) continue;
            ConfigHelper.beanWalker(dDBeanRoot, dConfigBeanRoot);
        }
    }

    protected void initializeWithConfig() throws ConfigurationException {
        DeployableObject[] deployableObjectArray;
        if (this.debug) {
            Debug.say("initializing dconfig");
        }
        if (this.moduleType == WebLogicModuleType.SCA_COMPOSITE) {
            this.initializeScaWithConfig();
            return;
        }
        DDBeanRoot dDBeanRoot = this.dObject.getDDBeanRoot();
        this.restorefromPlan();
        DConfigBeanRoot dConfigBeanRoot = this.dConfig.getDConfigBeanRoot(dDBeanRoot);
        if (this.fullInit) {
            ConfigHelper.beanWalker(dDBeanRoot, dConfigBeanRoot);
        }
        if (dConfigBeanRoot != null && this.moduleType == ModuleType.EAR && (deployableObjectArray = ((WebLogicJ2eeApplicationObject)this.dObject).getDeployableObjects()) != null) {
            for (int i = 0; i < deployableObjectArray.length; ++i) {
                DeployableObject deployableObject = deployableObjectArray[i];
                String string = ((WebLogicDeployableObject)deployableObject).getUri();
                if (this.debug) {
                    Debug.say("Collecting beans for embedded module at, " + string);
                }
                try {
                    if (DescriptorSupportManager.getForModuleType(deployableObject.getDDBeanRoot().getType()).length <= 0) continue;
                    DConfigBeanRoot dConfigBeanRoot2 = this.dConfig.getDConfigBeanRoot(deployableObject.getDDBeanRoot());
                    if (!this.fullInit) continue;
                    ConfigHelper.beanWalker(deployableObject.getDDBeanRoot(), dConfigBeanRoot2);
                    continue;
                }
                catch (ConfigurationException configurationException) {
                    SPIDeployerLogger.logNoDCB((String)string, (String)configurationException.toString());
                    throw configurationException;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restorefromPlan() throws ConfigurationException {
        if (this.planBean != null) {
            this.dConfig.restore(this.planBean);
        } else if (this.getPlan() != null) {
            try {
                FileInputStream fileInputStream = new FileInputStream(this.getPlan());
                try {
                    this.dConfig.restore(fileInputStream);
                    Object var3_3 = null;
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    ((InputStream)fileInputStream).close();
                    throw throwable;
                }
                ((InputStream)fileInputStream).close();
                {
                }
            }
            catch (IOException iOException) {
                SPIDeployerLogger.logNoPlan((String)this.getPlan().getPath());
                this.setPlan(null);
            }
        }
    }

    public void savePlan() throws IllegalStateException, ConfigurationException, FileNotFoundException {
        if (this.getConfiguration() == null) {
            throw new IllegalStateException(SPIDeployerLogger.mustInit());
        }
        if (this.debug) {
            Debug.say("Saving plan to " + this.getPlan());
        }
        this.getPlan().getAbsoluteFile().getParentFile().mkdirs();
        this.savePlan(new FileOutputStream(this.getPlan()));
    }

    public void saveApplicationRoot() throws IOException, ConfigurationException, IllegalStateException {
        if (this.getConfiguration() == null) {
            throw new IllegalStateException(SPIDeployerLogger.mustInit());
        }
        File file = this.getApplication().getCanonicalFile();
        InstallDir installDir = new InstallDir(this.getApplicationRoot());
        installDir.getAppDir().mkdirs();
        installDir.setArchive(new File(installDir.getAppDir(), this.getApplication().getName()));
        installDir.getConfigDir().mkdirs();
        String string = this.getPlan() == null ? "plan.xml" : this.getPlan().getName();
        installDir.setPlan(new File(installDir.getConfigDir(), string));
        this.setApplication(installDir.getArchive(), true);
        this.setPlan(installDir.getPlan(), true);
        this.getConfiguration().getPlan().setConfigRoot(installDir.getConfigDir().getCanonicalPath());
        if (!file.equals(this.getApplication().getCanonicalFile())) {
            if (this.debug) {
                Debug.say("Copying app to " + this.getApplication());
            }
            FileUtils.copy((File)file, (File)this.getApplication());
        }
        this.savePlan();
    }

    private static DeploymentFactory getRegisteredDefaultFactory() {
        DeploymentFactory[] deploymentFactoryArray = DeploymentFactoryManager.getInstance().getDeploymentFactories();
        if (deploymentFactoryArray != null) {
            for (int i = 0; i < deploymentFactoryArray.length; ++i) {
                if (!DEF_FACTORY_CLASS.isInstance(deploymentFactoryArray[i])) continue;
                return deploymentFactoryArray[i];
            }
        }
        return null;
    }

    private static DeploymentFactory registerDefaultFactory() throws IllegalArgumentException {
        DeploymentFactory deploymentFactory = SessionHelper.getRegisteredDefaultFactory();
        if (deploymentFactory != null) {
            return deploymentFactory;
        }
        try {
            if (DeploymentFactory.class.isAssignableFrom(DEF_FACTORY_CLASS)) {
                DeploymentFactory deploymentFactory2 = (DeploymentFactory)DEF_FACTORY_CLASS.newInstance();
                DeploymentFactoryManager.getInstance().registerDeploymentFactory(deploymentFactory2);
                return deploymentFactory2;
            }
            throw new IllegalArgumentException(SPIDeployerLogger.invalidFactory((String)DEF_FACTORY_CLASS.getName()));
        }
        catch (InstantiationException instantiationException) {
            throw new IllegalArgumentException(SPIDeployerLogger.invalidFactory((String)DEF_FACTORY_CLASS.getName()));
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalArgumentException(SPIDeployerLogger.invalidFactory((String)DEF_FACTORY_CLASS.getName()));
        }
    }

    public File[] getPlanDirectories(String string) throws IOException {
        File file;
        ConfigHelper.checkParam("appName", string);
        if (this.getConfiguration() == null) {
            throw new IllegalStateException(SPIDeployerLogger.mustInit());
        }
        HashSet hashSet = new HashSet();
        if (this.getPlan() != null) {
            this.addFile(hashSet, this.getPlan().getParentFile().getCanonicalFile(), false);
        }
        if (this.getConfiguration().getPlan().getConfigRoot() != null) {
            this.addFile(hashSet, new File(this.getConfiguration().getPlan().getConfigRoot()).getCanonicalFile(), false);
        }
        if ((file = new File(DomainDir.getDeploymentsDir(), string)).exists()) {
            this.addFile(hashSet, new InstallDir(string, file).getConfigDir().getCanonicalFile(), false);
        }
        return hashSet.toArray(new File[0]);
    }

    public File savePlan(File file, String string) throws IOException, ConfigurationException {
        ConfigHelper.checkParam("dir", file);
        ConfigHelper.checkParam("planName", string);
        if (this.getConfiguration() == null) {
            throw new IllegalStateException(SPIDeployerLogger.mustInit());
        }
        File file2 = file;
        if (!file2.exists()) {
            file2.mkdirs();
        }
        if (!(file2 = file2.getCanonicalFile()).isDirectory()) {
            throw new IllegalArgumentException(SPIDeployerLogger.notDir((String)file2.getPath()));
        }
        return this.saveBackToSource(file, string);
    }

    private File saveBackToSource(File file, String string) throws FileNotFoundException, ConfigurationException {
        File file2 = new File(file, string);
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        this.savePlan(fileOutputStream);
        return file2;
    }

    private void savePlan(OutputStream outputStream) throws ConfigurationException {
        this.getConfiguration().save(outputStream);
    }

    protected void bumpVersion() {
        DeploymentPlanBean deploymentPlanBean = this.getConfiguration().getPlan();
        if (deploymentPlanBean.getVersion() == null) {
            deploymentPlanBean.setVersion("1.0");
        } else {
            try {
                Float f = new Float(deploymentPlanBean.getVersion());
                Float f2 = new Float(1.0);
                deploymentPlanBean.setVersion(new Float(f.floatValue() + f2.floatValue()).toString());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public String getNewPlanName() {
        String string;
        String string2 = "plan.xml";
        if (this.getPlan() != null) {
            string2 = this.getPlan().getName();
        }
        if (this.getConfiguration() != null && (string = this.getConfiguration().getPlan().getVersion()) != null) {
            int n = string2.indexOf(".xml");
            string2 = n == -1 ? string2 + "_" + string : string2.substring(0, n) + "_" + string + ".xml";
        }
        return string2;
    }

    public File[] findPlans() {
        File file;
        HashSet hashSet = new HashSet();
        if (this.getPlan() != null) {
            this.addFile(hashSet, this.getPlan(), true);
        }
        if (this.getConfiguration() != null) {
            file = new File(this.getConfiguration().getPlan().getConfigRoot());
            this.addPlansFromDirectory(file, hashSet);
        }
        if (this.getApplicationRoot() != null) {
            file = new File(this.getApplicationRoot().getPath() + File.separator + PLAN_DIR);
            this.addPlansFromDirectory(file, hashSet);
        }
        return hashSet.toArray(new File[0]);
    }

    private void addPlansFromDirectory(File file, Set set) {
        if (file.exists() && file.isDirectory()) {
            File[] fileArray = file.listFiles(new FileFilter(){

                public boolean accept(File file) {
                    return file.isFile() && file.getName().endsWith(".xml");
                }
            });
            for (int i = 0; i < fileArray.length; ++i) {
                this.addFile(set, fileArray[i], true);
            }
        }
    }

    private void addFile(Set set, File file, boolean bl) {
        try {
            if (!bl || file.exists()) {
                set.add(file.getCanonicalFile());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public TargetModuleID[] getDefaultJMSTargetModuleIDs(DomainMBean domainMBean, TargetMBean[] targetMBeanArray, String string, String string2) throws ConfigurationException {
        if (this.getConfiguration() == null) {
            throw new IllegalStateException(SPIDeployerLogger.mustInit());
        }
        ArrayList<WebLogicTargetModuleID> arrayList = new ArrayList<WebLogicTargetModuleID>();
        if (string2 == null) {
            return null;
        }
        if (targetMBeanArray == null || targetMBeanArray.length <= 0) {
            return null;
        }
        AppDeploymentMBean appDeploymentMBean = AppDeploymentHelper.lookupAppOrLib(string, domainMBean);
        if (appDeploymentMBean != null && this.checkAppTargetting(appDeploymentMBean, string2)) {
            return null;
        }
        JMSBean jMSBean = null;
        try {
            jMSBean = this.getJMSDescriptor(string2);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        if (jMSBean == null) {
            return null;
        }
        HashMap hashMap = DefaultingHelper.getJMSDefaultTargets(jMSBean, domainMBean, targetMBeanArray);
        for (String string3 : hashMap.keySet()) {
            TargetMBean[] targetMBeanArray2 = (TargetMBean[])hashMap.get(string3);
            for (int i = 0; i < targetMBeanArray2.length; ++i) {
                TargetMBean targetMBean = targetMBeanArray2[i];
                if (targetMBean == null) continue;
                TargetModuleID targetModuleID = this.createParentTmids(string, string2, targetMBean);
                if (targetModuleID.getChildTargetModuleID() != null) {
                    targetModuleID = targetModuleID.getChildTargetModuleID()[0];
                }
                WebLogicTargetModuleID webLogicTargetModuleID = this.dm.createTargetModuleID(targetModuleID, string3, WebLogicModuleType.SUBMODULE);
                arrayList.add(webLogicTargetModuleID);
            }
        }
        return arrayList.toArray(new TargetModuleID[0]);
    }

    private boolean checkAppTargetting(AppDeploymentMBean appDeploymentMBean, String string) {
        if (this.getDeployableObject().getType().getValue() == ModuleType.EAR.getValue()) {
            SubDeploymentMBean[] subDeploymentMBeanArray = appDeploymentMBean.getSubDeployments();
            for (int i = 0; i < subDeploymentMBeanArray.length; ++i) {
                SubDeploymentMBean subDeploymentMBean = subDeploymentMBeanArray[i];
                if (!subDeploymentMBean.getName().equals(string)) continue;
                return this.checkIfTargeted(subDeploymentMBean);
            }
        } else {
            SubDeploymentMBean[] subDeploymentMBeanArray = appDeploymentMBean.getSubDeployments();
            if (subDeploymentMBeanArray != null && subDeploymentMBeanArray.length != 0) {
                return true;
            }
        }
        return false;
    }

    private boolean checkIfTargeted(SubDeploymentMBean subDeploymentMBean) {
        SubDeploymentMBean[] subDeploymentMBeanArray = subDeploymentMBean.getSubDeployments();
        return subDeploymentMBeanArray != null && subDeploymentMBeanArray.length != 0;
    }

    private TargetModuleID createParentTmids(String string, String string2, TargetMBean targetMBean) {
        WebLogicTargetModuleID webLogicTargetModuleID;
        if (this.getDeployableObject().getType().getValue() == ModuleType.EAR.getValue()) {
            webLogicTargetModuleID = this.dm.createTargetModuleID(string, ModuleType.EAR, this.getTarget(targetMBean));
            webLogicTargetModuleID = this.dm.createTargetModuleID(webLogicTargetModuleID, string2, WebLogicModuleType.JMS);
        } else {
            webLogicTargetModuleID = this.dm.createTargetModuleID(string2, WebLogicModuleType.JMS, this.getTarget(targetMBean));
        }
        return webLogicTargetModuleID;
    }

    public Target getTarget(TargetMBean targetMBean) {
        return this.dm.getTarget(targetMBean.getName());
    }

    public JMSBean getJMSDescriptor(String string) throws ConfigurationException, FileNotFoundException {
        if (this.getConfiguration() == null) {
            throw new IllegalStateException(SPIDeployerLogger.mustInit());
        }
        if (this.getDeployableObject().getType().getValue() == WebLogicModuleType.JMS.getValue() && this.getApplication().getName().equals(string)) {
            WebLogicDConfigBeanRoot webLogicDConfigBeanRoot = (WebLogicDConfigBeanRoot)this.getConfiguration().getDConfigBeanRoot(this.getDeployableObject().getDDBeanRoot());
            return (JMSBean)webLogicDConfigBeanRoot.getDescriptorBean();
        }
        if (this.getDeployableObject() instanceof WebLogicJ2eeApplicationObject) {
            WebLogicDConfigBeanRoot webLogicDConfigBeanRoot = null;
            try {
                webLogicDConfigBeanRoot = (WebLogicDConfigBeanRoot)this.getConfiguration().getDConfigBeanRoot(this.getDeployableObject().getDDBeanRoot());
                WeblogicApplicationBean weblogicApplicationBean = (WeblogicApplicationBean)webLogicDConfigBeanRoot.getDescriptorBean();
                if (weblogicApplicationBean.getModules() == null) {
                    return null;
                }
                Iterator<Object> iterator = Arrays.asList((Object[])weblogicApplicationBean.getModules()).iterator();
                String string2 = null;
                while (iterator.hasNext()) {
                    WeblogicModuleBean weblogicModuleBean = (WeblogicModuleBean)iterator.next();
                    if (!weblogicModuleBean.getName().equals(string)) continue;
                    string2 = weblogicModuleBean.getPath();
                    break;
                }
                if (string2 != null) {
                    webLogicDConfigBeanRoot = (WebLogicDConfigBeanRoot)webLogicDConfigBeanRoot.getDConfigBean(this.getDeployableObject().getDDBeanRoot(string2));
                    return (JMSBean)webLogicDConfigBeanRoot.getDescriptorBean();
                }
            }
            catch (DDBeanCreateException dDBeanCreateException) {
                throw new ConfigurationException(dDBeanCreateException.toString());
            }
        }
        return null;
    }

    public String[] getDescriptorUris(ModuleType moduleType) {
        if (this.getConfiguration() == null) {
            throw new IllegalStateException(SPIDeployerLogger.mustInit());
        }
        if (this.getDeployableObject().getType().getValue() == moduleType.getValue()) {
            return new String[]{this.getApplication().getName()};
        }
        if (this.getDeployableObject().getType().getValue() == ModuleType.EAR.getValue()) {
            ArrayList<String> arrayList = new ArrayList<String>();
            WebLogicJ2eeApplicationObject webLogicJ2eeApplicationObject = (WebLogicJ2eeApplicationObject)this.getDeployableObject();
            DDBeanRoot[] dDBeanRootArray = webLogicJ2eeApplicationObject.getDDBeanRoots();
            for (int i = 0; i < dDBeanRootArray.length; ++i) {
                DDBeanRoot dDBeanRoot = dDBeanRootArray[i];
                if (dDBeanRoot.getType().getValue() != moduleType.getValue()) continue;
                arrayList.add(dDBeanRoot.getFilename());
            }
            return arrayList.toArray(new String[0]);
        }
        return new String[0];
    }
}

