/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.api.tools.deployer;

import weblogic.deploy.api.tools.deployer.DeployerException;
import weblogic.deploy.api.tools.deployer.Options;
import weblogic.deploy.api.tools.deployer.TaskOperation;
import weblogic.deploy.utils.MBeanHomeTool;
import weblogic.management.runtime.DeploymentTaskRuntimeMBean;

public class CancelOperation
extends TaskOperation {
    private DeploymentTaskRuntimeMBean task;

    public CancelOperation(MBeanHomeTool mBeanHomeTool, Options options) {
        super(mBeanHomeTool, options);
    }

    public void setAllowedOptions() {
        this.allowedOptions.add("id");
    }

    public void validate() throws IllegalArgumentException, DeployerException {
        super.validate();
        if (this.options.id == null) {
            throw new IllegalArgumentException(cat.errorMissingId());
        }
    }

    public void execute() throws Exception {
        this.task = this.helper.getTaskByID(this.options.id);
        if (this.task == null) {
            throw new DeployerException(cat.errorTaskNotFound(this.options.id));
        }
        this.task.cancel();
    }

    public int report() {
        int n = 0;
        String string = this.task.getId();
        while (this.task.isRunning()) {
        }
        int n2 = this.task.getCancelState();
        if (n2 == 0 || n2 == 2 || n2 == 4) {
            System.out.println(cat.cancelFailed(string));
            n = 1;
        } else {
            System.out.println(cat.cancelSucceeded(string));
        }
        return n;
    }

    public String getOperation() {
        return "cancel";
    }
}

