/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.api.tools.deployer;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import weblogic.deploy.api.tools.deployer.ActivateOperation;
import weblogic.deploy.api.tools.deployer.CancelOperation;
import weblogic.deploy.api.tools.deployer.DeactivateOperation;
import weblogic.deploy.api.tools.deployer.DeployOperation;
import weblogic.deploy.api.tools.deployer.DeployerException;
import weblogic.deploy.api.tools.deployer.DistributeOperation;
import weblogic.deploy.api.tools.deployer.ListTaskOperation;
import weblogic.deploy.api.tools.deployer.ListappsOperation;
import weblogic.deploy.api.tools.deployer.Operation;
import weblogic.deploy.api.tools.deployer.Options;
import weblogic.deploy.api.tools.deployer.PurgeTasksOperation;
import weblogic.deploy.api.tools.deployer.RedeployOperation;
import weblogic.deploy.api.tools.deployer.RemoveOperation;
import weblogic.deploy.api.tools.deployer.StartOperation;
import weblogic.deploy.api.tools.deployer.StopOperation;
import weblogic.deploy.api.tools.deployer.UndeployOperation;
import weblogic.deploy.api.tools.deployer.UnprepareOperation;
import weblogic.deploy.api.tools.deployer.UpdateOperation;
import weblogic.deploy.internal.DeployerTextFormatter;
import weblogic.deploy.utils.MBeanHomeTool;
import weblogic.jndi.Environment;
import weblogic.rmi.extensions.RemoteRuntimeException;

public class Deployer
extends MBeanHomeTool {
    private static DeployerTextFormatter cat = new DeployerTextFormatter();
    private Options options;
    private String[] myargs;
    private static final String JNDI_NAME = "weblogic.remote.Deployer";

    public Deployer(String[] stringArray) {
        super(stringArray);
        this.myargs = stringArray;
        cat = new DeployerTextFormatter();
    }

    public void prepare() {
        super.prepare();
        this.options = new Options(this.opts);
        this.setRequireExtraArgs(false);
    }

    public void runBody() throws Exception {
        int n = -1;
        this.options.extractOptions();
        System.out.println(cat.infoOptions(this.removePassword(this.myargs)));
        this.checkForMultipleOps();
        if (this.options.examples) {
            this.showDetailedMessage();
            return;
        }
        this.setShowStackTrace(this.options.debug);
        Operation operation = null;
        try {
            operation = this.newOperation();
            operation.validate();
            n = this.perform(operation, n);
        }
        catch (Throwable throwable) {
            if (throwable instanceof RemoteRuntimeException) {
                throw new DeployerException(cat.errorLostConnection());
            }
            if (throwable instanceof RuntimeException && !(throwable instanceof IllegalArgumentException) || !(throwable instanceof Exception)) {
                Exception exception = this.handleUnexpectedException(throwable);
                n = 1;
                throw exception;
            }
            n = this.handleExpectedException((Exception)throwable);
            throw (Exception)throwable;
        }
        finally {
            if (operation != null) {
                operation.cleanUp();
            }
            this.reset();
            if (!this.options.noexit && n != -1) {
                System.exit(n);
            }
        }
    }

    private Exception handleUnexpectedException(Throwable throwable) throws Exception {
        throwable.printStackTrace();
        Exception exception = throwable instanceof Exception ? (Exception)throwable : new DeployerException(throwable.getMessage());
        if (!this.options.noexit) {
            System.out.println(exception.getMessage());
        }
        return exception;
    }

    private int handleExpectedException(Exception exception) {
        if (this.options.debug) {
            exception.printStackTrace();
        } else if (!this.options.noexit) {
            if (exception.getMessage() != null) {
                System.out.println(exception.getMessage());
            } else {
                System.out.println(exception.toString());
            }
        }
        return 1;
    }

    private int perform(Operation operation, int n) throws Exception {
        operation.connect();
        operation.prepare();
        operation.execute();
        n = operation.report();
        return n;
    }

    private String getUriAsString(URI uRI) throws URISyntaxException {
        String string = uRI.getScheme();
        String string2 = uRI.getHost();
        int n = uRI.getPort();
        return new URI(string, null, string2, n, null, null, null).toString();
    }

    private Context getIIOPContext(String string, String string2, String string3) throws NamingException {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("java.naming.factory.initial", "weblogic.jndi.WLInitialContextFactory");
        hashtable.put("java.naming.provider.url", string);
        hashtable.put("java.naming.security.principal", string2);
        hashtable.put("java.naming.security.credentials", string3);
        return new InitialContext(hashtable);
    }

    private Context getContext(String string, String string2, String string3) throws NamingException {
        Environment environment = new Environment();
        environment.setProviderUrl(string);
        environment.setSecurityPrincipal(string2);
        environment.setSecurityCredentials(string3);
        return environment.getInitialContext();
    }

    private String removePassword(String[] stringArray) {
        if (stringArray == null) {
            return "";
        }
        boolean bl = false;
        String string = "";
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (string2.equals("-password")) {
                bl = true;
                continue;
            }
            if (!bl) {
                string = string + " " + string2;
                continue;
            }
            bl = false;
        }
        return string;
    }

    private void checkForMultipleOps() throws IllegalArgumentException {
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.options.distributeOp) {
            ++n;
            stringBuffer.append("distribute ");
        }
        if (this.options.startOp) {
            ++n;
            stringBuffer.append("start ");
        }
        if (this.options.stopOp) {
            ++n;
            stringBuffer.append("stop ");
        }
        if (this.options.redeployOp) {
            ++n;
            stringBuffer.append("redeploy ");
        }
        if (this.options.undeployOp) {
            ++n;
            stringBuffer.append("undeploy ");
        }
        if (this.options.deployOp) {
            ++n;
            stringBuffer.append("deploy ");
        }
        if (this.options.updateOp) {
            ++n;
            stringBuffer.append("update ");
        }
        if (this.options.cancelOp) {
            ++n;
            stringBuffer.append("cancel ");
        }
        if (this.options.listOp) {
            ++n;
            stringBuffer.append("list ");
        }
        if (this.options.purgetasksOp) {
            ++n;
            stringBuffer.append("purgetasks ");
        }
        if (this.options.listtaskOp) {
            ++n;
            stringBuffer.append("listtask ");
        }
        if (this.options.listappOp) {
            ++n;
            stringBuffer.append("listapps ");
        }
        if (this.options.activateOp) {
            ++n;
            stringBuffer.append("activate ");
        }
        if (this.options.deactivateOp) {
            ++n;
            stringBuffer.append("deactivate ");
        }
        if (this.options.unprepareOp) {
            ++n;
            stringBuffer.append("unprepare ");
        }
        if (this.options.removeOp) {
            ++n;
            stringBuffer.append("remove ");
        }
        if (n > 1) {
            throw new IllegalArgumentException(cat.errorMultipleActions(stringBuffer.toString()));
        }
    }

    private void showDetailedMessage() {
        if (this.options.distributeOp) {
            System.out.println(cat.usageAdDistribute());
        } else if (this.options.startOp) {
            System.out.println(cat.usageAdStart());
        } else if (this.options.stopOp) {
            System.out.println(cat.usageAdStop());
        } else if (this.options.deployOp) {
            System.out.println(cat.usageAdDeploy());
        } else if (this.options.redeployOp) {
            System.out.println(cat.usageAdRedeploy());
        } else if (this.options.undeployOp) {
            System.out.println(cat.usageAdUndeploy());
        } else if (this.options.updateOp) {
            System.out.println(cat.usageAdUpdate());
        } else if (this.options.cancelOp) {
            System.out.println(cat.usageAdCancel());
        } else if (this.options.listOp) {
            System.out.println(cat.usageAdList());
        } else if (this.options.purgetasksOp) {
            System.out.println(cat.usageAdPurgeTasks());
        } else if (this.options.listtaskOp) {
            System.out.println(cat.usageAdListtask());
        } else if (this.options.listappOp) {
            System.out.println(cat.usageAdListapps());
        } else if (this.options.activateOp) {
            System.out.println(cat.usageAdDeploy());
        } else if (this.options.deactivateOp) {
            System.out.println(cat.usageAdStop());
        } else if (this.options.unprepareOp) {
            System.out.println(cat.usageAdStop());
        } else if (this.options.removeOp) {
            System.out.println(cat.usageAdUndeploy());
        } else {
            System.out.println(cat.showExamples());
        }
    }

    private Operation newOperation() throws IllegalArgumentException {
        if (this.options.distributeOp) {
            return new DistributeOperation(this, this.options);
        }
        if (this.options.startOp) {
            return new StartOperation(this, this.options);
        }
        if (this.options.stopOp) {
            return new StopOperation(this, this.options);
        }
        if (this.options.redeployOp) {
            return new RedeployOperation(this, this.options);
        }
        if (this.options.undeployOp) {
            return new UndeployOperation(this, this.options);
        }
        if (this.options.deployOp) {
            return new DeployOperation(this, this.options);
        }
        if (this.options.updateOp) {
            return new UpdateOperation(this, this.options);
        }
        if (this.options.cancelOp) {
            return new CancelOperation(this, this.options);
        }
        if (this.options.purgetasksOp) {
            return new PurgeTasksOperation(this, this.options);
        }
        if (this.options.listOp) {
            return new ListTaskOperation(this, this.options);
        }
        if (this.options.listtaskOp) {
            return new ListTaskOperation(this, this.options);
        }
        if (this.options.listappOp) {
            return new ListappsOperation(this, this.options);
        }
        if (this.options.activateOp) {
            return new ActivateOperation(this, this.options);
        }
        if (this.options.deactivateOp) {
            return new DeactivateOperation(this, this.options);
        }
        if (this.options.unprepareOp) {
            return new UnprepareOperation(this, this.options);
        }
        if (this.options.removeOp) {
            return new RemoveOperation(this, this.options);
        }
        throw new IllegalArgumentException(cat.errorMissingAction());
    }

    private void debug(String string) {
        if (this.options.debug) {
            System.out.println(string);
        }
    }

    private void inform(String string) {
        if (this.options.verbose) {
            System.out.println(string);
        }
    }
}

