/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.api.tools.deployer;

import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.enterprise.deploy.shared.StateType;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.DeploymentManagerCreationException;
import javax.enterprise.deploy.spi.status.DeploymentStatus;
import javax.enterprise.deploy.spi.status.ProgressObject;
import weblogic.deploy.api.internal.utils.ConfigHelper;
import weblogic.deploy.api.spi.DeploymentOptions;
import weblogic.deploy.api.spi.WebLogicDeploymentManager;
import weblogic.deploy.api.spi.status.ProgressObjectImpl;
import weblogic.deploy.api.spi.status.WebLogicDeploymentStatus;
import weblogic.deploy.api.tools.SessionHelper;
import weblogic.deploy.api.tools.deployer.DeployerException;
import weblogic.deploy.api.tools.deployer.ModuleTargetInfo;
import weblogic.deploy.api.tools.deployer.Operation;
import weblogic.deploy.api.tools.deployer.Options;
import weblogic.deploy.api.tools.deployer.SubModuleTargetInfo;
import weblogic.deploy.utils.MBeanHomeTool;
import weblogic.deploy.utils.MBeanHomeToolException;
import weblogic.deploy.utils.TaskCompletionNotificationListener;
import weblogic.management.ManagementException;
import weblogic.management.deploy.DeploymentData;
import weblogic.management.runtime.DeploymentTaskRuntimeMBean;
import weblogic.rmi.extensions.RemoteRuntimeException;

public abstract class Jsr88Operation
extends Operation
implements Serializable {
    private static final long serialVersionUID = 1L;
    private transient String id;
    protected transient WebLogicDeploymentManager dm;
    protected transient ProgressObject po;
    protected transient Target[] targets;
    protected transient File src = null;
    protected transient File plan = null;
    protected transient DeploymentOptions dOpts;
    protected transient ModuleTargetInfo[] targetInfos;
    protected transient List tmids;

    protected Jsr88Operation(MBeanHomeTool mBeanHomeTool, Options options) {
        super(mBeanHomeTool, options);
    }

    protected Jsr88Operation(Options options) {
        super(options);
    }

    protected Jsr88Operation() {
    }

    protected void init() {
        super.init();
        this.tmids = new ArrayList();
        this.dOpts = new DeploymentOptions();
        this.targets = new Target[0];
    }

    public void setAllowedOptions() throws IllegalArgumentException {
        this.allowedOptions.add("name");
        this.allowedOptions.add("id");
        this.allowedOptions.add("targets");
        this.allowedOptions.add("submoduletargets");
        this.allowedOptions.add("appversion");
        this.allowedOptions.add("planversion");
        this.allowedOptions.add("libspecver");
        this.allowedOptions.add("libimplver");
        this.allowedOptions.add("library");
    }

    public void validate() throws IllegalArgumentException, DeployerException {
        super.validate();
        this.validateSource();
        this.validateName();
        this.validateDelta();
        this.validateGraceful();
        this.validateRetireTimeout();
        this.validateAllVersions();
        this.validateAltDDs();
        this.validateDeleteFiles();
        this.validateVersions();
        this.validateLibVersions();
        this.validatePlan();
        this.validateTargets();
    }

    private void validateTargets() throws IllegalArgumentException {
    }

    protected void validatePlan() throws IllegalArgumentException {
        File file;
        if (this.isPlanRequired() && this.options.plan == null) {
            throw new IllegalArgumentException(cat.errorNoPlan(this.getOperation()));
        }
        if (!this.options.remote && this.options.plan != null && !(file = new File(this.options.plan)).exists()) {
            throw new IllegalArgumentException(cat.errorNoSuchFile(this.options.plan));
        }
    }

    protected void validateLibVersions() throws IllegalArgumentException {
        this.validateLibVersion(this.options.libSpecVersion);
    }

    private void validateLibVersion(String string) throws IllegalArgumentException {
        if (string != null && !string.matches("[0-9]+(\\.[0-9]+)*")) {
            throw new IllegalArgumentException(cat.invalidLibVersion(string));
        }
    }

    protected void validateVersions() throws IllegalArgumentException {
        this.validateFileVersion(this.options.appVersion);
        this.validateFileVersion(this.options.planVersion);
        this.validateVersionNoVersion();
    }

    protected void validateVersionNoVersion() throws IllegalArgumentException {
        if (this.options.noVersion && (this.options.appVersion != null || this.options.planVersion != null)) {
            throw new IllegalArgumentException(cat.invalidVersionNoVersion());
        }
    }

    private void validateFileVersion(String string) throws IllegalArgumentException {
        if (string != null && (string.length() >= 215 || !string.matches("[a-zA-Z0-9\\._-]*") || string.equals(".") || string.equals(".."))) {
            throw new IllegalArgumentException(cat.invalidFileVersion(this.options.name, string));
        }
    }

    protected void validateName() throws IllegalArgumentException {
    }

    protected void validateSource() throws IllegalArgumentException {
        if (this.isSourceRequired()) {
            File file;
            if (this.options.source == null) {
                throw new IllegalArgumentException(cat.errorNoSourceSpecified());
            }
            if (!this.options.remote && !(file = new File(this.options.source)).exists()) {
                throw new IllegalArgumentException(cat.errorNoSuchFile(this.options.source));
            }
        }
    }

    protected boolean isSourceRequired() {
        return this.options.upload;
    }

    protected boolean isPlanRequired() {
        return false;
    }

    protected void validateDelta() throws IllegalArgumentException {
        if (this.options.delta != null) {
            if (this.options.delta.length > 1) {
                throw new IllegalArgumentException(cat.errorMultipleSourceSpecified());
            }
            if (this.options.sourceFromOpts && this.options.delta.length > 0) {
                throw new IllegalArgumentException(cat.errorFilesIllegalWithSource());
            }
        }
    }

    protected void validateDeleteFiles() throws IllegalArgumentException {
        if (this.options.deleteFiles) {
            if (this.options.delta == null) {
                throw new IllegalArgumentException(cat.errorMissingDelta());
            }
            if (this.options.upload) {
                throw new IllegalArgumentException(cat.errorUploadDelete(this.getOperation()));
            }
        }
    }

    protected void validateAltDDs() {
        this.options.altAppDD = this.validateAltDD(this.options.altAppDD);
        this.options.altWlsAppDD = this.validateAltDD(this.options.altWlsAppDD);
    }

    private String validateAltDD(String string) {
        if (string != null && !this.options.remote) {
            File file = new File(string);
            if (!file.exists() || file.isDirectory()) {
                throw new IllegalArgumentException(cat.noSourceAltAppDD(string));
            }
            if (string.length() > 1 && string.charAt(1) != ':') {
                string = file.getAbsolutePath();
            }
        }
        return string;
    }

    protected void validateRetireTimeout() {
        if (this.options.retireTimeout != -1 && this.options.libModule) {
            throw new IllegalArgumentException(cat.errorRetireTimeoutIllegal("retiretimeout"));
        }
    }

    protected void validateGraceful() throws IllegalArgumentException {
        if (!this.options.graceful && this.options.ignoreSessions) {
            throw new IllegalArgumentException(cat.errorIgnoreSessionsIllegal("graceful", "ignoresessions"));
        }
        if (!this.options.redeployOp && !this.options.graceful && this.options.rmiGracePeriod != -1) {
            throw new IllegalArgumentException(cat.errorRMIGracePeriodIllegal("graceful", "rmigraceperiod"));
        }
        if (this.options.graceful && this.options.retireTimeout != -1) {
            throw new IllegalArgumentException(cat.errorRetireTimeoutGracefulIllegal("retiretimeout", "graceful"));
        }
    }

    protected void validateAllVersions() throws IllegalArgumentException {
        if (!this.options.allVersions) {
            return;
        }
        if (!this.options.undeployOp) {
            throw new IllegalArgumentException(cat.errorAllVersionsIllegal1("undeploy", "allversions"));
        }
        if (this.options.graceful) {
            throw new IllegalArgumentException(cat.errorAllVersionsIllegal2("graceful", "allversions"));
        }
        if (this.options.appVersion != null) {
            throw new IllegalArgumentException(cat.errorAllVersionsIllegal2("appversion", "allversions"));
        }
    }

    public void prepare() throws DeployerException {
        try {
            this.helper = this.dm.getHelper();
            this.src = this.prepareFile(this.options.source);
            this.plan = this.prepareFile(this.options.plan);
            this.prepareTargets();
            this.prepareTmids();
            this.prepareDeploymentOptions();
            if (this.options.id != null) {
                this.dm.setTaskId(this.options.id);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DeployerException deployerException = new DeployerException(illegalArgumentException.toString());
            deployerException.initCause(illegalArgumentException);
            throw deployerException;
        }
    }

    public void connect() throws DeployerException {
        URI uRI = this.getUri();
        try {
            this.tool.processUsernameAndPassword();
            this.dm = this.options.upload ? SessionHelper.getRemoteDeploymentManager(uRI.getScheme(), uRI.getHost(), new Integer(uRI.getPort()).toString(), this.tool.getUser(), this.tool.getPassword()) : SessionHelper.getDeploymentManager(uRI.getScheme(), uRI.getHost(), new Integer(uRI.getPort()).toString(), this.tool.getUser(), this.tool.getPassword());
        }
        catch (MBeanHomeToolException mBeanHomeToolException) {
            DeployerException deployerException = new DeployerException(mBeanHomeToolException.toString());
            deployerException.initCause(mBeanHomeToolException);
            throw deployerException;
        }
        catch (DeploymentManagerCreationException deploymentManagerCreationException) {
            DeployerException deployerException = new DeployerException(cat.errorUnableToAccessDeployer(uRI.toString(), ManagementException.unWrapExceptions((Throwable)deploymentManagerCreationException).getMessage()));
            if (this.options.debug || this.options.verbose) {
                deployerException.initCause(deploymentManagerCreationException);
            }
            throw deployerException;
        }
    }

    protected void prepareTmids() {
        String string = null;
        if (this.targetInfos.length > 0) {
            string = this.deriveName();
        }
        for (int i = 0; i < this.targetInfos.length; ++i) {
            ModuleTargetInfo moduleTargetInfo = this.targetInfos[i];
            this.tmids.add(moduleTargetInfo.createTmid(string, this.findTarget(moduleTargetInfo, this.targets), this.dm));
        }
    }

    private String deriveName() {
        String string = this.options.name;
        if ((string == null || string.length() == 0) && this.options.source != null) {
            string = this.getNameFromSource(this.options.source);
            this.dOpts.setNameFromSource(true);
        }
        return string;
    }

    private String getNameFromSource(String string) {
        if (string == null) {
            return null;
        }
        File file = new File(ConfigHelper.normalize(string));
        if (string.equals(".")) {
            file = new File(file.getAbsolutePath()).getParentFile();
        }
        return file.getName();
    }

    private void prepareDeploymentOptions() throws IllegalArgumentException {
        if (this.options.stageMode != null) {
            this.dOpts.setStageMode(this.options.stageMode);
        }
        this.dOpts.setTestMode(this.options.adminMode);
        this.dOpts.setGracefulProductionToAdmin(this.options.graceful);
        this.dOpts.setGracefulIgnoreSessions(this.options.ignoreSessions);
        this.dOpts.setRMIGracePeriodSecs(this.options.rmiGracePeriod);
        this.dOpts.setUndeployAllVersions(this.options.allVersions);
        this.dOpts.setSecurityValidationEnabled(this.options.securityValidation);
        if (this.options.securityModel != null) {
            this.dOpts.setSecurityModel(this.options.securityModel);
        }
        this.dOpts.setLibrary(this.options.libModule);
        if (this.options.appVersion != null) {
            this.dOpts.setArchiveVersion(this.options.appVersion);
        }
        if (this.options.planVersion != null) {
            this.dOpts.setPlanVersion(this.options.planVersion);
        }
        this.dOpts.setNoVersion(this.options.noVersion);
        this.dOpts.setRetireTime(this.options.retireTimeout);
        if (this.options.libSpecVersion != null) {
            this.dOpts.setLibSpecVersion(this.options.libSpecVersion);
        }
        if (this.options.libImplVersion != null) {
            this.dOpts.setLibImplVersion(this.options.libImplVersion);
        }
        if (this.options.name != null) {
            this.dOpts.setName(this.options.name);
        }
        this.dOpts.setAltDD(this.options.altAppDD);
        this.dOpts.setAltWlsDD(this.options.altWlsAppDD);
        this.dOpts.setForceUndeployTimeout(this.options.timeout);
        this.dOpts.setDefaultSubmoduleTargets(this.options.isDefaultSubmoduleTargets);
        this.dOpts.setUseNonexclusiveLock(this.options.useNonExclusiveLock);
        this.dOpts.setTimeout(this.options.timeout * 1000L);
        this.dOpts.setDeploymentOrder(this.options.deploymentOrder);
        this.dOpts.setRemote(this.options.remote);
    }

    private File prepareFile(String string) {
        if (string == null) {
            return null;
        }
        File file = new File(ConfigHelper.normalize(string));
        if (!this.options.remote && string != null) {
            if (string.equals(".")) {
                file = new File(file.getAbsolutePath()).getParentFile();
            }
            if (string.length() > 1 && string.charAt(1) != ':') {
                file = file.getAbsoluteFile();
            }
        }
        return file;
    }

    private void prepareTargets() throws DeployerException {
        if (this.options.moduleTargets == null) {
            this.options.moduleTargets = new String[0];
        }
        ArrayList<Target> arrayList = new ArrayList<Target>();
        this.targetInfos = this.getTargetInfos(this.options.moduleTargets, this.options.submoduleTargets);
        for (int i = 0; i < this.targetInfos.length; ++i) {
            ModuleTargetInfo moduleTargetInfo = this.targetInfos[i];
            Target target = this.findTarget(moduleTargetInfo);
            if (target == null) {
                throw new DeployerException(cat.errorNoSuchTarget(moduleTargetInfo.getTarget()));
            }
            arrayList.add(target);
        }
        this.targets = arrayList.toArray(new Target[0]);
    }

    private Target findTarget(ModuleTargetInfo moduleTargetInfo, Target[] targetArray) {
        for (int i = 0; i < targetArray.length; ++i) {
            Target target = targetArray[i];
            if (!target.getName().equals(moduleTargetInfo.getTarget())) continue;
            return target;
        }
        return null;
    }

    private Target findTarget(ModuleTargetInfo moduleTargetInfo) {
        return this.getDm().getTarget(moduleTargetInfo.getTarget());
    }

    private ModuleTargetInfo[] getTargetInfos(String[] stringArray, String[] stringArray2) {
        int n;
        HashSet<ModuleTargetInfo> hashSet = new HashSet<ModuleTargetInfo>();
        for (n = 0; n < stringArray.length; ++n) {
            hashSet.add(new ModuleTargetInfo(stringArray[n]));
        }
        for (n = 0; n < stringArray2.length; ++n) {
            hashSet.add(new SubModuleTargetInfo(stringArray2[n]));
        }
        return hashSet.toArray(new ModuleTargetInfo[0]);
    }

    protected URI getUri() throws DeployerException {
        String string = this.tool.getOpts().getOption("adminurl", "t3://localhost:7001");
        int n = string.indexOf("://");
        if (n == -1) {
            string = "t3://" + string;
        }
        try {
            return new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new DeployerException(uRISyntaxException.toString());
        }
    }

    public void cleanUp() {
        if (this.dm != null) {
            this.dm.release();
        }
        super.cleanUp();
    }

    public int report() throws DeployerException {
        TaskCompletionNotificationListener taskCompletionNotificationListener;
        if (!this.dm.isConnected()) {
            this.println(cat.errorLostConnection());
            DeploymentStatus deploymentStatus = this.po.getDeploymentStatus();
            if (deploymentStatus.getMessage() != null) {
                this.println(deploymentStatus.getMessage());
            }
            this.println(cat.lastKnownStatus(deploymentStatus.getCommand().toString(), deploymentStatus.getState().toString()));
        }
        this.println(cat.messageStartedTask(this.task.getId(), this.task.getDescription()));
        if (this.options.nowait) {
            return 0;
        }
        if (this.dOpts.usesNonExclusiveLock() && this.po.getDeploymentStatus().isRunning()) {
            this.println(cat.pendingOperation());
            return 0;
        }
        this.id = this.options.id;
        if (this.id == null) {
            this.id = this.task.getId();
        }
        long l = 0L;
        if (this.options.timeout != 0L) {
            l = System.currentTimeMillis() + 1000L * this.options.timeout;
        }
        if ((taskCompletionNotificationListener = ((ProgressObjectImpl)this.po).getTaskCompletionListener()) != null) {
            taskCompletionNotificationListener.waitForTaskCompletion(1000L * this.options.timeout);
            if (this.task.isRunning()) {
                this.inform(cat.timeOut(this.task.getId()));
            }
            if (this.options.formatted) {
                this.showTaskInformationHeader();
            }
            this.failures = this.showTaskInformation(this.task);
            this.reportState(this.task);
            if (this.options.noexit && this.failures != 0) {
                throw new DeployerException(this.outstr == null ? cat.deploymentFailed() : this.outstr.toString());
            }
            return this.failures;
        }
        try {
            this.waitForTaskCompletion(this.task, l);
            if (this.task.isRunning()) {
                this.inform(cat.timeOut(this.task.getId()));
            }
            if (this.options.formatted) {
                this.showTaskInformationHeader();
            }
            this.failures = this.showTaskInformation(this.task);
            this.reportState(this.task);
            if (this.options.noexit && this.failures != 0) {
                throw new DeployerException(this.outstr == null ? cat.deploymentFailed() : this.outstr.toString());
            }
            return this.failures;
        }
        catch (RemoteRuntimeException remoteRuntimeException) {
            throw new DeployerException(cat.errorLostConnection());
        }
    }

    protected void postExecute() throws Exception {
        if (((ProgressObjectImpl)this.po).getTask() == null) {
            WebLogicDeploymentStatus webLogicDeploymentStatus = (WebLogicDeploymentStatus)this.po.getDeploymentStatus();
            Iterator iterator = webLogicDeploymentStatus.getRootException();
            Throwable throwable = (Throwable)iterator.next();
            if (throwable == null) {
                throw new DeployerException(cat.errorFailedOp());
            }
            if (throwable instanceof Exception) {
                throw (Exception)throwable;
            }
            DeployerException deployerException = new DeployerException(throwable.getMessage());
            deployerException.initCause(throwable);
            throw deployerException;
        }
        this.task = this.helper.getTaskMBean(((ProgressObjectImpl)this.po).getTask());
        if (this.task == null) {
            throw new DeployerException(cat.noTask(((ProgressObjectImpl)this.po).getTask().toString()));
        }
    }

    protected TargetModuleID[] getTmids() {
        return this.tmids.toArray(new TargetModuleID[0]);
    }

    public WebLogicDeploymentManager getDm() {
        return this.dm;
    }

    public void setDm(WebLogicDeploymentManager webLogicDeploymentManager) {
        this.dm = webLogicDeploymentManager;
    }

    private void reportState(DeploymentTaskRuntimeMBean deploymentTaskRuntimeMBean) {
        int n = deploymentTaskRuntimeMBean.getState();
        switch (n) {
            case 2: 
            case 4: {
                ((ProgressObjectImpl)this.po).setState(StateType.COMPLETED);
                break;
            }
            case 3: {
                ((ProgressObjectImpl)this.po).setState(StateType.FAILED);
                break;
            }
        }
    }

    private void waitForTaskCompletion(DeploymentTaskRuntimeMBean deploymentTaskRuntimeMBean, long l) throws DeployerException {
        try {
            while (true) {
                if (!deploymentTaskRuntimeMBean.isRunning() || l > 0L && l <= System.currentTimeMillis()) {
                    return;
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        catch (RemoteRuntimeException remoteRuntimeException) {
            throw new DeployerException(cat.errorLostConnection());
        }
    }

    public int showTaskInformation(DeploymentTaskRuntimeMBean deploymentTaskRuntimeMBean) {
        int n = super.showTaskInformation(deploymentTaskRuntimeMBean);
        if (!this.options.verbose) {
            return n;
        }
        String string = this.getOperation();
        if (!"deploy".equals(string) && !"distribute".equals(string)) {
            return n;
        }
        DeploymentData deploymentData = deploymentTaskRuntimeMBean.getDeploymentData();
        this.println(cat.showTargetAssignmentsHeader());
        this.printTargetAssignment(deploymentTaskRuntimeMBean.getApplicationName(), deploymentData.getGlobalTargets(), 0);
        Map map = deploymentData.getAllSubModuleTargets();
        for (Object object : map.keySet()) {
            this.printTargetAssignment((String)object, deploymentData.getModuleTargets((String)object), 1);
            Object object2 = (Map)map.get(object);
            if (object2 == null) continue;
            for (String string2 : object2.keySet()) {
                this.printTargetAssignment(string2, (String[])object2.get(string2), 2);
            }
        }
        Map map2 = deploymentData.getAllModuleTargets();
        for (Object object2 : map2.keySet()) {
            if (map.containsKey(object2)) continue;
            this.printTargetAssignment((String)object2, deploymentData.getModuleTargets((String)object2), 1);
        }
        return n;
    }

    private void printTargetAssignment(String string, String[] stringArray, int n) {
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        for (n2 = 0; n2 < n; ++n2) {
            stringBuffer.append("   ");
        }
        stringBuffer.append("+ ");
        stringBuffer.append(string);
        stringBuffer.append("  ");
        if (stringArray == null || stringArray.length == 0) {
            stringBuffer.append(cat.noneSpecified());
        } else {
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                if (n2 != 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(stringArray[n2]);
            }
        }
        this.println(stringBuffer.toString());
    }
}

