/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.api.tools.deployer;

import java.util.Arrays;
import java.util.Comparator;
import weblogic.deploy.api.tools.deployer.DeployerException;
import weblogic.deploy.api.tools.deployer.Options;
import weblogic.deploy.api.tools.deployer.TaskOperation;
import weblogic.deploy.utils.MBeanHomeTool;
import weblogic.management.runtime.DeploymentTaskRuntimeMBean;

public class ListTaskOperation
extends TaskOperation {
    private DeploymentTaskRuntimeMBean[] tasks = null;

    public ListTaskOperation(MBeanHomeTool mBeanHomeTool, Options options) {
        super(mBeanHomeTool, options);
    }

    public void setAllowedOptions() {
        this.allowedOptions.add("id");
    }

    public void execute() throws Exception {
        if (this.options.id != null) {
            this.task = this.helper.getTaskByID(this.options.id);
            if (this.task == null) {
                throw new DeployerException(cat.errorTaskNotFound(this.options.id));
            }
        } else {
            this.tasks = this.helper.getAllTasks();
            Arrays.sort(this.tasks, new Comparator(){

                public int compare(Object object, Object object2) {
                    DeploymentTaskRuntimeMBean deploymentTaskRuntimeMBean = (DeploymentTaskRuntimeMBean)object;
                    DeploymentTaskRuntimeMBean deploymentTaskRuntimeMBean2 = (DeploymentTaskRuntimeMBean)object2;
                    return deploymentTaskRuntimeMBean.getId().compareTo(deploymentTaskRuntimeMBean2.getId());
                }
            });
        }
    }

    public int report() {
        if (this.tasks != null) {
            for (int i = 0; i < this.tasks.length; ++i) {
                this.showTaskInformation(this.tasks[i]);
            }
        } else if (this.task != null) {
            if (this.options.formatted) {
                this.showTaskInformationHeader();
            }
            this.showTaskInformation(this.task);
        }
        return 0;
    }

    public String getOperation() {
        if (this.options.listOp) {
            return "list";
        }
        return "listtask";
    }
}

