/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.api.tools.deployer;

import java.util.HashSet;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import weblogic.application.utils.ApplicationVersionUtils;
import weblogic.deploy.api.shared.WebLogicModuleType;
import weblogic.deploy.api.tools.deployer.DeployerException;
import weblogic.deploy.api.tools.deployer.Jsr88Operation;
import weblogic.deploy.api.tools.deployer.Options;
import weblogic.deploy.utils.MBeanHomeTool;
import weblogic.management.runtime.AppRuntimeStateRuntimeMBean;

public class ListappsOperation
extends Jsr88Operation {
    private HashSet apps;
    private AppRuntimeStateRuntimeMBean appRT;

    public ListappsOperation(MBeanHomeTool mBeanHomeTool, Options options) {
        super(mBeanHomeTool, options);
    }

    public void setAllowedOptions() {
    }

    public void validate() throws DeployerException {
        super.validate();
    }

    protected void prepareTmids() {
    }

    public void execute() throws Exception {
        this.apps = new HashSet();
        TargetModuleID[] targetModuleIDArray = null;
        Target[] targetArray = this.dm.getTargets();
        for (int i = 0; i < WebLogicModuleType.getModuleTypes(); ++i) {
            ModuleType moduleType = WebLogicModuleType.getModuleType(i);
            if (moduleType == null || (targetModuleIDArray = this.dm.getAvailableModules(moduleType, targetArray)) == null) continue;
            for (int j = 0; j < targetModuleIDArray.length; ++j) {
                if (targetModuleIDArray[j].getParentTargetModuleID() != null) continue;
                this.apps.add(targetModuleIDArray[j].getModuleID());
            }
        }
    }

    public int report() {
        if (this.apps.isEmpty()) {
            System.out.println(cat.noAppToList());
        } else {
            for (String string : this.apps) {
                String string2 = " " + ApplicationVersionUtils.getDisplayName(string) + this.getActiveState(string);
                System.out.println(string2);
            }
            System.out.println(cat.appsFound() + " " + this.apps.size());
        }
        return 0;
    }

    public String getOperation() {
        return "listapps";
    }

    private String getActiveState(String string) {
        if (ApplicationVersionUtils.getVersionId(string) == null) {
            return "";
        }
        AppRuntimeStateRuntimeMBean appRuntimeStateRuntimeMBean = this.getAppRuntimeStateMBean();
        if (appRuntimeStateRuntimeMBean == null) {
            return "";
        }
        Target[] targetArray = this.dm.getTargets();
        if (targetArray == null || targetArray.length == 0 || targetArray[0] == null) {
            return "";
        }
        for (int i = 0; i < targetArray.length; ++i) {
            String string2 = appRuntimeStateRuntimeMBean.getCurrentState(string, targetArray[i].getName());
            if (!string2.equals("STATE_ACTIVE")) continue;
            return " <ACTIVE VERSION>";
        }
        return "";
    }

    private AppRuntimeStateRuntimeMBean getAppRuntimeStateMBean() {
        if (this.appRT == null) {
            try {
                this.appRT = this.dm.getHelper().getAppRuntimeStateMBean();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.appRT;
    }
}

