/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.api.tools.deployer;

import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import weblogic.deploy.api.shared.WebLogicModuleType;
import weblogic.deploy.api.spi.WebLogicDeploymentManager;
import weblogic.deploy.api.spi.WebLogicTargetModuleID;
import weblogic.deploy.internal.DeployerTextFormatter;

public class ModuleTargetInfo {
    private String target = null;
    private String module = null;
    protected static DeployerTextFormatter cat = new DeployerTextFormatter();

    protected ModuleTargetInfo() {
    }

    public ModuleTargetInfo(String string) {
        this.init(string);
    }

    protected void init(String string) {
        int n = string.indexOf("@");
        if (n != -1) {
            if (string.length() == n + 1) {
                throw new IllegalArgumentException(cat.invalidTargetSyntax(string));
            }
            this.setModule(string.substring(0, n));
            this.setTarget(string.substring(n + 1));
        } else {
            this.setTarget(string);
        }
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String string) {
        this.target = string;
    }

    public String getModule() {
        return this.module;
    }

    public void setModule(String string) {
        this.module = string;
    }

    public TargetModuleID createTmid(String string, Target target, WebLogicDeploymentManager webLogicDeploymentManager) {
        WebLogicModuleType webLogicModuleType = WebLogicModuleType.UNKNOWN;
        if (this.getModule() != null) {
            webLogicModuleType = ModuleType.EAR;
        }
        WebLogicTargetModuleID webLogicTargetModuleID = webLogicDeploymentManager.createTargetModuleID(string, webLogicModuleType, target);
        if (this.getModule() != null) {
            webLogicTargetModuleID = webLogicDeploymentManager.createTargetModuleID(webLogicTargetModuleID, this.getModule(), WebLogicModuleType.UNKNOWN);
        }
        return webLogicTargetModuleID;
    }
}

