/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.api.tools.deployer;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import weblogic.deploy.api.tools.deployer.DeployerException;
import weblogic.deploy.internal.DeployerTextFormatter;
import weblogic.deploy.utils.DeployerHelper;
import weblogic.deploy.utils.MBeanHomeTool;
import weblogic.management.ApplicationException;
import weblogic.management.MBeanHome;
import weblogic.management.ManagementException;
import weblogic.management.deploy.DeploymentData;
import weblogic.management.deploy.TargetStatus;
import weblogic.management.runtime.DeployerRuntimeMBean;
import weblogic.management.runtime.DeploymentTaskRuntimeMBean;
import weblogic.rmi.extensions.RemoteRuntimeException;
import weblogic.utils.StackTraceUtils;

public class OldDeployer
extends MBeanHomeTool {
    public static final long MAX_NOTIFICATION_WAIT = 1000L;
    private static final String OPTION_OUTPUT = "output";
    private static final String OPTION_VERBOSE = "verbose";
    private static final String OPTION_DEBUG = "debug";
    private static final String OPTION_EXAMPLES = "examples";
    private static final String OPTION_NOWAIT = "nowait";
    private static final String OPTION_NOSTAGE = "nostage";
    private static final String OPTION_STAGE = "stage";
    private static final String OPTION_EXTERNAL_STAGE = "external_stage";
    private static final String OPTION_SOURCE = "source";
    private static final String OPTION_UPLOAD = "upload";
    private static final String OPTION_DELETE_FILES = "delete_files";
    private static final String OPTION_REMOTE = "remote";
    private static final String OPTION_NAME = "name";
    private static final String OPTION_APP_VERSION = "appversion";
    private static final String OPTION_PLAN_VERSION = "planversion";
    private static final String OPTION_RETIRE_TIMEOUT = "retiretimeout";
    private static final String OPTION_ADMIN_MODE = "adminmode";
    private static final String OPTION_GRACEFUL = "graceful";
    private static final String OPTION_IGNORE_SESSIONS = "ignoresessions";
    private static final String OPTION_TARGETS = "targets";
    private static final String OPTION_SUBMODULE_TARGETS = "submoduletargets";
    private static final String OPTION_SECURITY_MODEL = "securityModel";
    private static final String OPTION_SECURITY_VALIDATE = "enableSecurityValidation";
    private static final String OPTION_LIB_MODULE = "library";
    private static final String OPTION_LIB_SPEC_VERSION = "libspecver";
    private static final String OPTION_LIB_IMPL_VERSION = "libimplver";
    private static final String OPTION_ID = "id";
    private static final String OPTION_TIMEOUT = "timeout";
    private static final String OPTION_ALT_APP_DD = "altappdd";
    private static final String OPTION_ALT_WEB_DD = "altwlsappdd";
    private static final String OPTION_ACTIVATE = "activate";
    private static final String OPTION_DEACTIVATE = "deactivate";
    private static final String OPTION_REMOVE = "remove";
    private static final String OPTION_CANCEL = "cancel";
    private static final String OPTION_LIST = "list";
    private static final String OPTION_UNPREPARE = "unprepare";
    private static final String OPTION_DEPLOY = "deploy";
    private static final String OPTION_UNDEPLOY = "undeploy";
    private static final String OPTION_DISTRIBUTE = "distribute";
    private static final String OPTION_START = "start";
    private static final String OPTION_STOP = "stop";
    private static final String OPTION_REDEPLOY = "redeploy";
    private static final String OPTION_LIST_APP = "listapps";
    private static final String OPTION_LIST_TASK = "listtask";
    private static final int ACTION_UNSPECIFIED = -1;
    private static final int ACTION_ACTIVATE = 0;
    private static final int ACTION_DEACTIVATE = 1;
    private static final int ACTION_REMOVE = 2;
    private static final int ACTION_CANCEL = 3;
    private static final int ACTION_LIST = 4;
    private static final int ACTION_UNPREPARE = 5;
    private static final int ACTION_DISTRIBUTE = 6;
    private static final int ACTION_START = 7;
    private static final int ACTION_STOP = 8;
    private static final int ACTION_REDEPLOY = 9;
    private static final int ACTION_UNDEPLOY = 10;
    private static final int ACTION_DEPLOY = 11;
    private static final int ACTION_LIST_APPS = 12;
    private static final int ACTION_LIST_TASK = 13;
    private static final int ACTION_MAX = 13;
    private static boolean debug = false;
    private static boolean verbose = false;
    private static final boolean DEFAULT_FMT = false;
    private boolean formatted = false;
    private boolean raw = true;
    private static DeployerTextFormatter messageFormatter;
    private static String[] options;
    private boolean isNameFromSource = false;
    private boolean isSourceFromOpts = false;
    StringBuffer outstr;

    public OldDeployer(String[] stringArray) {
        super(stringArray);
        messageFormatter = new DeployerTextFormatter();
    }

    public OldDeployer(MBeanHome mBeanHome, String[] stringArray) {
        super(mBeanHome, stringArray);
        messageFormatter = new DeployerTextFormatter();
    }

    public static void main(String[] stringArray) {
        try {
            OldDeployer.runMain(stringArray);
        }
        catch (Exception exception) {
            OldDeployer.println(messageFormatter.errorInitDeployer(exception.toString()));
        }
    }

    private static void runMain(String[] stringArray) throws Exception {
        OldDeployer oldDeployer = new OldDeployer(stringArray);
        oldDeployer.run();
    }

    public static void mainWithExceptions(String[] stringArray) throws Exception {
        OldDeployer.runMain(stringArray);
    }

    public void prepare() {
        super.prepare();
        this.opts.addFlag("advanced", "Advanced options are:");
        this.opts.markPrivate("advanced");
        this.opts.addFlag("version", "version 1.1");
        this.opts.markPrivate("version");
        this.opts.addFlag("help", "Displays help for weblogic.Deployer");
        this.opts.markPrivate("help");
        this.opts.setUsageArgs(messageFormatter.usageArgs());
        this.opts.addAdvancedFlag(OPTION_VERBOSE, messageFormatter.usageVerbose());
        this.opts.addAdvancedOption(OPTION_OUTPUT, "raw", messageFormatter.usageOutput());
        this.opts.addAdvancedFlag(OPTION_DEBUG, messageFormatter.usageDebug());
        this.opts.addFlag(OPTION_EXAMPLES, messageFormatter.usageExamples());
        this.opts.addAdvancedFlag(OPTION_UPLOAD, messageFormatter.usageUpload());
        this.opts.addAdvancedFlag(OPTION_DELETE_FILES, messageFormatter.usageDeleteFiles());
        this.opts.addAdvancedFlag(OPTION_REMOTE, messageFormatter.usageRemote());
        this.opts.addAdvancedFlag(OPTION_NOSTAGE, messageFormatter.usageNoStage());
        this.opts.addAdvancedFlag(OPTION_EXTERNAL_STAGE, messageFormatter.usageExternalStage());
        this.opts.addAdvancedFlag(OPTION_STAGE, messageFormatter.usageStage());
        this.opts.addAdvancedFlag(OPTION_NOWAIT, messageFormatter.usageNoWait());
        this.opts.addAdvancedOption(OPTION_TIMEOUT, messageFormatter.exampleTimeout(), messageFormatter.usageTimeout());
        this.opts.addAdvancedOption(OPTION_SOURCE, messageFormatter.exampleSource(), messageFormatter.usageSource());
        this.opts.addAdvancedOption(OPTION_ALT_APP_DD, messageFormatter.exampleAltAppDD(), messageFormatter.usageAltAppDD());
        this.opts.addAdvancedOption(OPTION_ALT_WEB_DD, messageFormatter.exampleAltWebDD(), messageFormatter.usageAltWebDD());
        this.opts.addOption(OPTION_NAME, messageFormatter.exampleName(), messageFormatter.usageName());
        this.opts.addAdvancedOption(OPTION_APP_VERSION, messageFormatter.exampleAppVersion(), messageFormatter.usageAppVersion());
        this.opts.addAdvancedOption(OPTION_RETIRE_TIMEOUT, messageFormatter.exampleRetireTimeout(), messageFormatter.usageRetireTimeout());
        this.opts.addOption(OPTION_TARGETS, messageFormatter.exampleTargets(), messageFormatter.usageAdTargets());
        this.opts.addAdvancedOption(OPTION_ID, messageFormatter.exampleId(), messageFormatter.usageId());
        this.opts.addAdvancedFlag(OPTION_ACTIVATE, messageFormatter.usageActivate());
        this.opts.markPrivate(OPTION_ACTIVATE);
        this.opts.addAdvancedFlag(OPTION_DEACTIVATE, messageFormatter.usageDeactivate());
        this.opts.markPrivate(OPTION_DEACTIVATE);
        this.opts.addAdvancedFlag(OPTION_UNPREPARE, messageFormatter.usageUnprepare());
        this.opts.markPrivate(OPTION_UNPREPARE);
        this.opts.addAdvancedFlag(OPTION_REMOVE, messageFormatter.usageRemove());
        this.opts.markPrivate(OPTION_REMOVE);
        this.opts.addAdvancedFlag(OPTION_CANCEL, messageFormatter.usageCancel());
        this.opts.addAdvancedFlag(OPTION_LIST, messageFormatter.usageList());
        this.opts.addAdvancedFlag(OPTION_LIST_TASK, messageFormatter.usageList());
        this.opts.addAdvancedFlag(OPTION_LIST_APP, messageFormatter.usageListApps());
        this.opts.addAdvancedFlag(OPTION_ADMIN_MODE, messageFormatter.usageAdminMode());
        this.opts.addAdvancedFlag(OPTION_GRACEFUL, messageFormatter.usageGraceful());
        this.opts.addAdvancedFlag(OPTION_IGNORE_SESSIONS, messageFormatter.usageIgnoreSessions(OPTION_GRACEFUL));
        this.opts.addFlag(OPTION_DEPLOY, messageFormatter.usageDeploy());
        this.opts.addAdvancedFlag(OPTION_DISTRIBUTE, messageFormatter.usageDistribute());
        this.opts.addAdvancedFlag(OPTION_START, messageFormatter.usageStart());
        this.opts.addAdvancedFlag(OPTION_STOP, messageFormatter.usageStop());
        this.opts.addFlag(OPTION_REDEPLOY, messageFormatter.usageRedeploy());
        this.opts.addFlag(OPTION_UNDEPLOY, messageFormatter.usageUndeploy());
        this.opts.addAdvancedOption(OPTION_SUBMODULE_TARGETS, messageFormatter.paramSubModuleTargets(), messageFormatter.usageSubModuleTargets());
        this.opts.addAdvancedOption(OPTION_SECURITY_MODEL, "DDOnly|CustomRoles|CustomRolesAndPolicies|Advanced", messageFormatter.usageSecurityModel());
        this.opts.addAdvancedFlag(OPTION_SECURITY_VALIDATE, messageFormatter.usageSecurityEnabled());
        this.opts.addAdvancedFlag(OPTION_LIB_MODULE, messageFormatter.usageLibrary());
        this.opts.addAdvancedOption(OPTION_LIB_SPEC_VERSION, messageFormatter.exampleLibSpecVersion(), messageFormatter.usageLibSpecVersion());
        this.opts.addAdvancedOption(OPTION_LIB_IMPL_VERSION, messageFormatter.exampleLibImplVersion(), messageFormatter.usageLibImplVersion());
        this.setRequireExtraArgs(false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void runBody() throws Exception {
        boolean bl = this.opts.getBooleanOption(OPTION_EXAMPLES, false);
        if (bl) {
            this.showDetailedMessage();
            return;
        }
        this.checkOptions();
        String string = this.opts.getOption(OPTION_SOURCE);
        verbose = this.opts.getBooleanOption(OPTION_VERBOSE, false);
        String string2 = this.opts.getOption(OPTION_OUTPUT);
        if (string2 != null) {
            if (string2.equals("raw")) {
                this.formatted = false;
                this.raw = true;
            } else if (string2.equals("formatted")) {
                this.formatted = true;
                this.raw = false;
            }
        }
        debug = this.opts.getBooleanOption(OPTION_DEBUG, false);
        boolean bl2 = this.opts.getBooleanOption(OPTION_NOWAIT, false);
        boolean bl3 = this.opts.getBooleanOption(OPTION_UPLOAD, false);
        long l = this.opts.getIntegerOption(OPTION_TIMEOUT, 0);
        boolean bl4 = this.opts.getBooleanOption(OPTION_NOSTAGE, false);
        boolean bl5 = this.opts.getBooleanOption(OPTION_EXTERNAL_STAGE, false);
        boolean bl6 = this.opts.getBooleanOption(OPTION_STAGE, false);
        boolean bl7 = this.opts.getBooleanOption(OPTION_REMOTE, false);
        this.setShowStackTrace(debug);
        MBeanHome mBeanHome = null;
        mBeanHome = this.getMBeanHome();
        try {
            DeployerHelper deployerHelper = new DeployerHelper(mBeanHome);
            deployerHelper.setFormatted(this.formatted);
            DeployerRuntimeMBean deployerRuntimeMBean = deployerHelper.getDeployer();
            if (deployerRuntimeMBean == null) {
                throw new DeployerException(messageFormatter.errorUnableToAccessDeployer(this.opts.getOption("adminurl", "t3://localhost:7001"), null));
            }
            String string3 = this.opts.getOption(OPTION_ID);
            DeploymentTaskRuntimeMBean deploymentTaskRuntimeMBean = null;
            String string4 = null;
            int n = this.getActionFromOpts(false);
            String[] stringArray = this.opts.args();
            switch (n) {
                case 0: 
                case 9: 
                case 11: {
                    String string5;
                    Object object;
                    String string6;
                    string4 = this.getNameRequired();
                    string = this.getSourceFromOpts();
                    if (bl3) {
                        if (string == null) throw new IllegalArgumentException(messageFormatter.errorMissingSourceForUpload());
                        string6 = this.opts.getOption("adminurl", "t3://localhost:7001");
                        object = this.getUser();
                        string5 = this.getPassword();
                        String[] stringArray2 = this.isSourceFromOpts ? null : this.getFilesFromOpts();
                        string = deployerHelper.uploadSource(string6, (String)object, string5, string, stringArray2, string4);
                    } else {
                        string = this.getAbsoluteSourcePath(bl7, string);
                    }
                    string6 = null;
                    if (bl6) {
                        string6 = OPTION_STAGE;
                    } else if (bl4) {
                        string6 = OPTION_NOSTAGE;
                    } else if (bl5) {
                        string6 = OPTION_EXTERNAL_STAGE;
                    }
                    object = this.getDeploymentDataFromOpts();
                    deploymentTaskRuntimeMBean = n == 9 ? (string == null ? deployerRuntimeMBean.redeploy(string4, (DeploymentData)object, string3, false) : deployerRuntimeMBean.redeploy(string, string4, (DeploymentData)object, string3, false)) : deployerRuntimeMBean.deploy(string, string4, string6, (DeploymentData)object, string3, false);
                    if (verbose) {
                        deploymentTaskRuntimeMBean.setNotificationLevel(2);
                        deployerHelper.initiateListening(deploymentTaskRuntimeMBean);
                    }
                    deployerHelper.registerTaskCompletionNotificationListener(deploymentTaskRuntimeMBean);
                    deploymentTaskRuntimeMBean.start();
                    break;
                }
                case 1: {
                    this.rejectFileList(stringArray);
                    string4 = this.getNameRequired();
                    deploymentTaskRuntimeMBean = deployerRuntimeMBean.deactivate(string4, this.getDeploymentDataFromOpts(), string3, false);
                    if (verbose) {
                        deploymentTaskRuntimeMBean.setNotificationLevel(2);
                        deployerHelper.initiateListening(deploymentTaskRuntimeMBean);
                    }
                    deployerHelper.registerTaskCompletionNotificationListener(deploymentTaskRuntimeMBean);
                    deploymentTaskRuntimeMBean.start();
                    break;
                }
                case 2: 
                case 10: {
                    this.rejectFileList(stringArray);
                    string4 = this.getNameRequired();
                    deploymentTaskRuntimeMBean = deployerRuntimeMBean.remove(string4, this.getDeploymentDataFromOpts(), string3, false);
                    if (verbose) {
                        deploymentTaskRuntimeMBean.setNotificationLevel(2);
                        deployerHelper.initiateListening(deploymentTaskRuntimeMBean);
                    }
                    deployerHelper.registerTaskCompletionNotificationListener(deploymentTaskRuntimeMBean);
                    deploymentTaskRuntimeMBean.start();
                    break;
                }
                case 5: {
                    string4 = this.getNameRequired();
                    deploymentTaskRuntimeMBean = deployerRuntimeMBean.unprepare(string4, this.getDeploymentDataFromOpts(), string3, false);
                    if (verbose) {
                        deploymentTaskRuntimeMBean.setNotificationLevel(2);
                        deployerHelper.initiateListening(deploymentTaskRuntimeMBean);
                    }
                    deployerHelper.registerTaskCompletionNotificationListener(deploymentTaskRuntimeMBean);
                    deploymentTaskRuntimeMBean.start();
                    break;
                }
                case 6: {
                    String string5;
                    string4 = this.getNameRequired();
                    string = this.getSourceFromOpts();
                    if (bl3) {
                        if (string == null) throw new IllegalArgumentException(messageFormatter.errorMissingSourceForUpload());
                        string5 = this.opts.getOption("adminurl", "t3://localhost:7001");
                        String string7 = this.getUser();
                        String string8 = this.getPassword();
                        string = deployerHelper.uploadSource(string5, string7, string8, string, this.getFilesFromOpts(), string4);
                    }
                    string = this.getAbsoluteSourcePath(bl7, this.getSourceFromOpts());
                    deploymentTaskRuntimeMBean = deployerRuntimeMBean.distribute(string, string4, this.getDeploymentDataFromOpts(), string3, false);
                    if (verbose) {
                        deploymentTaskRuntimeMBean.setNotificationLevel(2);
                        deployerHelper.initiateListening(deploymentTaskRuntimeMBean);
                    }
                    deployerHelper.registerTaskCompletionNotificationListener(deploymentTaskRuntimeMBean);
                    deploymentTaskRuntimeMBean.start();
                    break;
                }
                case 7: {
                    this.rejectFileListWithSourceArgument(stringArray);
                    string4 = this.getNameRequired();
                    deploymentTaskRuntimeMBean = deployerRuntimeMBean.start(string4, this.getDeploymentDataFromOpts(), string3, false);
                    if (verbose) {
                        deploymentTaskRuntimeMBean.setNotificationLevel(2);
                        deployerHelper.initiateListening(deploymentTaskRuntimeMBean);
                    }
                    deployerHelper.registerTaskCompletionNotificationListener(deploymentTaskRuntimeMBean);
                    deploymentTaskRuntimeMBean.start();
                    break;
                }
                case 8: {
                    this.rejectFileList(stringArray);
                    string4 = this.getNameRequired();
                    deploymentTaskRuntimeMBean = deployerRuntimeMBean.stop(string4, this.getDeploymentDataFromOpts(), string3, false);
                    if (verbose) {
                        deploymentTaskRuntimeMBean.setNotificationLevel(2);
                        deployerHelper.initiateListening(deploymentTaskRuntimeMBean);
                    }
                    deployerHelper.registerTaskCompletionNotificationListener(deploymentTaskRuntimeMBean);
                    deploymentTaskRuntimeMBean.start();
                    break;
                }
                case 3: {
                    if (string3 == null) {
                        throw new IllegalArgumentException(messageFormatter.errorMissingId());
                    }
                    deploymentTaskRuntimeMBean = deployerHelper.getTaskByID(string3);
                    if (deploymentTaskRuntimeMBean == null) {
                        throw new DeployerException(messageFormatter.errorTaskNotFound(string3));
                    }
                    deploymentTaskRuntimeMBean.cancel();
                    this.processCancel(deploymentTaskRuntimeMBean);
                    break;
                }
                case 12: {
                    this.listApps(deployerHelper);
                    break;
                }
                case 4: 
                case 13: {
                    if (string3 != null) {
                        deploymentTaskRuntimeMBean = deployerHelper.getTaskByID(string3);
                        if (deploymentTaskRuntimeMBean == null) throw new DeployerException(messageFormatter.errorTaskNotFound(string3));
                        if (this.formatted) {
                            this.showTaskInformationHeader();
                        }
                        this.showTaskInformation(deploymentTaskRuntimeMBean);
                        return;
                    } else {
                        DeploymentTaskRuntimeMBean[] deploymentTaskRuntimeMBeanArray = deployerHelper.getAllTasks();
                        for (int i = 0; i < deploymentTaskRuntimeMBeanArray.length; ++i) {
                            this.showTaskInformation(deploymentTaskRuntimeMBeanArray[i]);
                        }
                    }
                    return;
                }
            }
            OldDeployer.println(messageFormatter.messageStartedTask(deploymentTaskRuntimeMBean.getId(), deploymentTaskRuntimeMBean.getDescription()));
            if (bl2) {
                return;
            }
            if (string3 == null) {
                string3 = deploymentTaskRuntimeMBean.getId();
            }
            long l2 = 0L;
            if (l != 0L) {
                l2 = System.currentTimeMillis() + 1000L * l;
            }
            deployerHelper.waitForTaskCompletion(deploymentTaskRuntimeMBean, l2);
            if (deploymentTaskRuntimeMBean.isRunning()) {
                OldDeployer.inform(messageFormatter.timeOut(deploymentTaskRuntimeMBean.getId()));
            }
            if (this.formatted) {
                this.showTaskInformationHeader();
            }
            int n2 = this.showTaskInformation(deploymentTaskRuntimeMBean);
            if (!this.opts.hasOption("noexit")) {
                System.exit(n2);
                return;
            }
            if (n2 == 0) return;
            throw new DeployerException(this.outstr == null ? "Deployment failed" : this.outstr.toString());
        }
        catch (Exception exception) {
            if (!(exception instanceof RemoteRuntimeException)) throw exception;
            throw new DeployerException(messageFormatter.errorLostConnection());
        }
        finally {
            this.reset();
        }
    }

    private void rejectFileList(String[] stringArray) {
        if (stringArray != null && stringArray.length > 0) {
            throw new IllegalArgumentException(messageFormatter.errorFilesIllegalInDeactivate());
        }
    }

    private String getAbsoluteSourcePath(boolean bl, String string) {
        if (!bl && string != null) {
            File file;
            if (string.equals(".")) {
                file = new File(new File(string).getAbsolutePath());
                string = file.getParent();
            }
            if (string.length() > 1 && string.charAt(1) != ':') {
                file = new File(string);
                string = file.getAbsolutePath();
            }
        }
        return string;
    }

    void checkOptions() throws DeployerException {
        String string;
        int n = this.getActionFromOpts(false);
        String string2 = this.getSourceFromOpts();
        if (n == 4) {
            System.out.println(messageFormatter.warningListDeprecated());
        }
        if ((string = this.opts.getOption(OPTION_NAME)) != null && (4 == n || 3 == n)) {
            throw new IllegalArgumentException(messageFormatter.errorNameNotAllowed(this.translateAction(n)));
        }
        String[] stringArray = this.getFilesFromOpts();
        if (string == null && string2 == null && 0 == n && stringArray == null) {
            throw new IllegalArgumentException(messageFormatter.errorMissingName());
        }
        if (string == null && (1 == n || 2 == n || 5 == n)) {
            throw new IllegalArgumentException(messageFormatter.errorMissingName());
        }
        if (n != 11 && n != 6) {
            if (this.opts.hasOption(OPTION_SECURITY_MODEL)) {
                throw new IllegalArgumentException(messageFormatter.errorOptionOnlyWithDeploy(OPTION_SECURITY_MODEL));
            }
            if (this.opts.hasOption(OPTION_SECURITY_VALIDATE)) {
                throw new IllegalArgumentException(messageFormatter.errorOptionOnlyWithDeploy(OPTION_SECURITY_VALIDATE));
            }
            if (this.opts.hasOption(OPTION_LIB_MODULE)) {
                throw new IllegalArgumentException(messageFormatter.errorOptionOnlyWithDeploy(OPTION_LIB_MODULE));
            }
        }
    }

    private void showTaskInformationHeader() {
        OldDeployer.println("");
        OldDeployer.println(messageFormatter.showListHeader());
    }

    private static int getActionFromTask(int n) {
        switch (n) {
            case 1: {
                return 11;
            }
            case 3: {
                return 10;
            }
            case 6: {
                return 6;
            }
            case 9: {
                return 9;
            }
            case 4: {
                return 2;
            }
            case 7: {
                return 7;
            }
            case 8: {
                return 8;
            }
            case 5: {
                return 5;
            }
        }
        return -1;
    }

    private int showRawTaskInfo(DeploymentTaskRuntimeMBean deploymentTaskRuntimeMBean) {
        int n = 0;
        this.outstr = new StringBuffer();
        String string = this.getTaskStatus(deploymentTaskRuntimeMBean);
        this.outstr.append(messageFormatter.allTaskStatus(deploymentTaskRuntimeMBean.getId(), string, deploymentTaskRuntimeMBean.getDescription()));
        this.outstr.append("\n");
        TargetStatus[] targetStatusArray = deploymentTaskRuntimeMBean.getTargets();
        for (int i = 0; i < targetStatusArray.length; ++i) {
            TargetStatus targetStatus = targetStatusArray[i];
            if (targetStatus.getState() == 2) {
                ++n;
            }
            String string2 = this.getTargetType(targetStatus.getTargetType());
            String string3 = this.getTargetState(targetStatus.getState());
            this.outstr.append(messageFormatter.showTargetState(string2, targetStatus.getTarget(), string3, this.translateAction(deploymentTaskRuntimeMBean.getTask())));
            this.outstr.append("\n");
            Exception[] exceptionArray = targetStatus.getMessages();
            for (int j = 0; j < exceptionArray.length; ++j) {
                this.outstr.append(this.translateDeploymentMessage(exceptionArray[j]));
            }
        }
        this.outstr.append("\n");
        return n;
    }

    private String getTargetState(int n) {
        switch (n) {
            case 4: {
                return messageFormatter.stateDeferred();
            }
            case 1: {
                return messageFormatter.stateRunning();
            }
            case 3: {
                return messageFormatter.stateCompleted();
            }
            case 2: {
                return messageFormatter.stateFailed();
            }
            case 0: {
                return messageFormatter.stateInit();
            }
        }
        return messageFormatter.unknown();
    }

    private String getTargetType(int n) {
        switch (n) {
            case 1: {
                return messageFormatter.messageServer();
            }
            case 2: {
                return messageFormatter.messageCluster();
            }
        }
        return messageFormatter.unknown();
    }

    private String getTaskStatus(DeploymentTaskRuntimeMBean deploymentTaskRuntimeMBean) {
        int n = deploymentTaskRuntimeMBean.getState();
        switch (n) {
            case 4: {
                return messageFormatter.stateDeferred();
            }
            case 1: {
                return messageFormatter.stateRunning();
            }
            case 2: {
                return messageFormatter.stateCompleted();
            }
            case 3: {
                return messageFormatter.stateFailed();
            }
            case 0: {
                return messageFormatter.stateInit();
            }
        }
        return messageFormatter.unknown();
    }

    private int showTaskInformation(DeploymentTaskRuntimeMBean deploymentTaskRuntimeMBean) {
        if (this.raw) {
            int n = this.showRawTaskInfo(deploymentTaskRuntimeMBean);
            OldDeployer.print(this.outstr.toString());
            return n;
        }
        int n = 0;
        String string = deploymentTaskRuntimeMBean.getId();
        int n2 = this.getActionFromOpts(false);
        if (n2 == 4 || n2 == 3) {
            n2 = OldDeployer.getActionFromTask(deploymentTaskRuntimeMBean.getTask());
        }
        String string2 = this.translateTask(n2);
        String string3 = deploymentTaskRuntimeMBean.getSource();
        String string4 = deploymentTaskRuntimeMBean.getApplicationName();
        TargetStatus[] targetStatusArray = deploymentTaskRuntimeMBean.getTargets();
        if (targetStatusArray.length == 0) {
            int n3 = deploymentTaskRuntimeMBean.getState();
            if (n3 == 2 || n3 == 4) {
                messageFormatter.messageNoRealTargets();
                return 0;
            }
            if (n3 == 3) {
                Exception exception = deploymentTaskRuntimeMBean.getError();
                String string5 = messageFormatter.noMessage();
                if (exception != null) {
                    string5 = exception.getMessage();
                }
                messageFormatter.errorNoRealTargets(string5);
                return 1;
            }
            messageFormatter.messageNoTargetsRunning();
            return 0;
        }
        for (int i = 0; i < targetStatusArray.length; ++i) {
            TargetStatus targetStatus = targetStatusArray[i];
            String string6 = targetStatus.getTarget();
            int n4 = targetStatus.getType();
            int n5 = targetStatus.getState();
            String string7 = this.translateTargetType(n4);
            String string8 = this.translateStatus(n5);
            OldDeployer.print(string + "\t" + string2 + "\t" + string8 + "\t" + string6 + "\t" + string7 + "\t" + string4 + "\t" + string3 + "\t");
            if (n5 == 2) {
                ++n;
            }
            Exception[] exceptionArray = targetStatus.getMessages();
            for (int j = 0; j < exceptionArray.length && exceptionArray[j] != null; ++j) {
                OldDeployer.print(this.translateDeploymentMessage(exceptionArray[j]));
            }
            OldDeployer.println("");
        }
        return n;
    }

    private String translateTask(int n) {
        switch (n) {
            case 0: {
                return messageFormatter.messageActivate();
            }
            case 11: {
                return messageFormatter.messageDeploy();
            }
            case 1: {
                return messageFormatter.messageDeactivate();
            }
            case 2: {
                return messageFormatter.messageRemove();
            }
            case 5: {
                return messageFormatter.messageUnprepare();
            }
            case 6: {
                return messageFormatter.messageDistribute();
            }
            case 7: {
                return messageFormatter.messageStart();
            }
            case 8: {
                return messageFormatter.messageStop();
            }
            case 9: {
                return messageFormatter.messageRedeploy();
            }
            case 10: {
                return messageFormatter.messageUndeploy();
            }
            case 4: {
                return messageFormatter.messageList();
            }
            case 12: {
                return messageFormatter.messageListApps();
            }
            case 3: {
                return messageFormatter.messageCancel();
            }
        }
        return null;
    }

    private String translateAction(int n) {
        return options[n];
    }

    private String translateTargetType(int n) {
        if (n == 1) {
            return messageFormatter.messageServer();
        }
        if (n == 2) {
            return messageFormatter.messageCluster();
        }
        return messageFormatter.messageUnknown();
    }

    private String translateStatus(int n) {
        switch (n) {
            case 4: {
                return messageFormatter.messageStateDeferred();
            }
            case 2: {
                return messageFormatter.messageStateFailed();
            }
            case 1: {
                return messageFormatter.messageStateInProgress();
            }
            case 0: {
                return messageFormatter.messageStateInit();
            }
            case 3: {
                return messageFormatter.messageStateSuccess();
            }
        }
        return null;
    }

    private String translateDeploymentMessage(Exception exception) {
        StringBuffer stringBuffer;
        if (this.formatted) {
            if (exception instanceof ApplicationException) {
                ApplicationException applicationException = (ApplicationException)((Object)exception);
                stringBuffer = new StringBuffer("\nException:");
                stringBuffer.append(((Object)((Object)applicationException)).getClass().getName() + ": ");
                stringBuffer.append(applicationException.getApplicationMessage());
                stringBuffer.append("\n");
                Hashtable hashtable = applicationException.getModuleErrors();
                if (hashtable != null && hashtable.size() != 0) {
                    for (String string : hashtable.keySet()) {
                        Exception exception2;
                        String string2 = (String)hashtable.get(string);
                        stringBuffer.append("\tModule: ");
                        stringBuffer.append(string);
                        stringBuffer.append("\tError: ");
                        stringBuffer.append(string2);
                        stringBuffer.append("\n");
                        if (!debug || (exception2 = applicationException.getTargetException(string)) == null) continue;
                        stringBuffer.append(StackTraceUtils.throwable2StackTrace((Throwable)exception2));
                        stringBuffer.append("\n");
                    }
                }
                if (applicationException.getNestedException() != null) {
                    stringBuffer.append("Nested Exception:\n");
                    stringBuffer.append(StackTraceUtils.throwable2StackTrace((Throwable)applicationException.getNestedException()));
                    stringBuffer.append("\n");
                }
            } else if (exception instanceof ManagementException) {
                ManagementException cfr_ignored_0 = (ManagementException)((Object)exception);
                Throwable throwable = ManagementException.unWrapExceptions((Throwable)exception);
                if (throwable != exception) {
                    if (throwable instanceof Exception) {
                        return this.translateDeploymentMessage((Exception)throwable);
                    }
                    stringBuffer = new StringBuffer("\n" + throwable.toString());
                } else {
                    stringBuffer = new StringBuffer("\n" + exception.toString());
                }
            } else {
                stringBuffer = new StringBuffer("\n" + exception.toString());
            }
        } else {
            stringBuffer = new StringBuffer();
            Throwable throwable = ManagementException.unWrapExceptions((Throwable)exception);
            if (throwable instanceof ApplicationException) {
                ApplicationException applicationException = (ApplicationException)((Object)throwable);
                OldDeployer.debug("dumping ApplicationException message");
                stringBuffer.append(applicationException.getApplicationMessage());
                stringBuffer.append("\n");
                Hashtable hashtable = applicationException.getModuleErrors();
                if (hashtable != null && hashtable.size() != 0) {
                    for (String string : hashtable.keySet()) {
                        Exception exception3;
                        String string3 = (String)hashtable.get(string);
                        OldDeployer.debug("dumping ModuleException message");
                        stringBuffer.append(messageFormatter.moduleException(string, string3));
                        stringBuffer.append("\n");
                        if (!debug || (exception3 = applicationException.getTargetException(string)) == null) continue;
                        OldDeployer.debug("dumping ModuleException stack");
                        stringBuffer.append(StackTraceUtils.throwable2StackTrace((Throwable)exception3));
                        stringBuffer.append("\n");
                    }
                }
            } else if (debug) {
                OldDeployer.debug("dumping Exception stack");
                stringBuffer.append(StackTraceUtils.throwable2StackTrace((Throwable)throwable));
                stringBuffer.append("\n");
            } else {
                OldDeployer.debug("dumping Exception message");
                stringBuffer.append(throwable.toString());
                stringBuffer.append("\n");
            }
        }
        return stringBuffer.toString();
    }

    private void showDetailedMessage() {
        int n = this.getActionFromOpts(true);
        switch (n) {
            case 6: {
                OldDeployer.println(messageFormatter.usageAdDistribute());
                break;
            }
            case 7: {
                OldDeployer.println(messageFormatter.usageAdStart());
                break;
            }
            case 8: {
                OldDeployer.println(messageFormatter.usageAdStop());
                break;
            }
            case 0: 
            case 11: {
                OldDeployer.println(messageFormatter.usageAdDeploy());
                break;
            }
            case 9: {
                OldDeployer.println(messageFormatter.usageAdRedeploy());
                break;
            }
            case 10: {
                OldDeployer.println(messageFormatter.usageAdUndeploy());
                break;
            }
            default: {
                OldDeployer.println(messageFormatter.showExamples());
            }
        }
    }

    private String getNameRequired() throws DeployerException {
        String string = this.opts.getOption(OPTION_NAME);
        if (!(this.opts.hasOption(OPTION_LIB_MODULE) || string != null && string.length() != 0)) {
            String string2 = this.opts.getOption(OPTION_SOURCE);
            String[] stringArray = this.getFilesFromOpts();
            if (string2 == null && stringArray == null) {
                throw new DeployerException(messageFormatter.errorMissingName());
            }
            if (string2 == null && stringArray.length > 0) {
                string2 = stringArray[0];
            }
            File file = new File(string2);
            try {
                string = file.getCanonicalFile().getName();
            }
            catch (IOException iOException) {
                throw new DeployerException(messageFormatter.messageIOException(string));
            }
            int n = string.indexOf(46);
            if (n != -1) {
                string = string.substring(0, n);
            }
            this.isNameFromSource = true;
        }
        return string;
    }

    String[] getFilesFromOpts() {
        String[] stringArray = this.opts.args();
        if (stringArray != null && stringArray.length == 0) {
            return null;
        }
        return stringArray;
    }

    private int getActionFromOpts(boolean bl) throws IllegalArgumentException {
        String string = null;
        int n = -1;
        for (int i = 0; i <= 13; ++i) {
            if (!this.opts.containsOption(options[i])) continue;
            if (n == -1) {
                n = i;
                continue;
            }
            if (string == null) {
                string = new String(options[n]);
            }
            string = string + "," + options[i];
        }
        if (n == -1) {
            if (bl) {
                return n;
            }
            throw new IllegalArgumentException(messageFormatter.errorMissingAction());
        }
        if (string != null) {
            throw new IllegalArgumentException(messageFormatter.errorMultipleActions(string));
        }
        return n;
    }

    private DeploymentData getDeploymentDataFromOpts() throws IllegalArgumentException, DeployerException {
        int n = this.getActionFromOpts(false);
        DeploymentData deploymentData = new DeploymentData();
        deploymentData.setActionFromDeployer(true);
        if (n == 0 || n == 9) {
            deploymentData.setFile(this.getFilesFromOpts());
        }
        deploymentData.setIsNameFromSource(this.isNameFromSource);
        this.setVersionParams(n, deploymentData);
        this.setAdminMode(n, deploymentData);
        this.setAltAppDD(deploymentData);
        this.setAltWeblogicDD(deploymentData);
        int n2 = this.opts.getIntegerOption(OPTION_TIMEOUT, 0);
        if (n2 != 0) {
            deploymentData.setTimeOut(n2 * 1000);
        }
        boolean bl = this.opts.getBooleanOption(OPTION_DELETE_FILES, false);
        deploymentData.setDelete(bl);
        OldDeployer.debug("DeploymentData : " + deploymentData.toString());
        String string = this.opts.getOption(OPTION_TARGETS);
        if (string != null) {
            this.setTargets(deploymentData, string);
        }
        this.setSubModuleTargets(deploymentData, n, string == null);
        deploymentData.setLibrary(this.opts.hasOption(OPTION_LIB_MODULE));
        this.setSecurityParams(deploymentData);
        return deploymentData;
    }

    private void setSecurityParams(DeploymentData deploymentData) {
        String string;
        if (this.opts.hasOption(OPTION_SECURITY_VALIDATE)) {
            deploymentData.setSecurityValidationEnabled(true);
        }
        if ((string = this.opts.getOption(OPTION_SECURITY_MODEL)) != null) {
            deploymentData.setSecurityModel(string);
        }
    }

    private void setTargets(DeploymentData deploymentData, String string) {
        String[] stringArray;
        HashMap<Object, String[]> hashMap = new HashMap<Object, String[]>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            Object object = stringTokenizer.nextToken();
            if (object == null || ((String)object).length() == 0) continue;
            String string2 = null;
            int n = ((String)object).indexOf(64);
            if (n != -1) {
                string2 = ((String)object).substring(0, n);
                object = ((String)object).substring(n + 1);
            }
            if ((stringArray = (String[])hashMap.get(object)) == null) {
                stringArray = new ArrayList();
                hashMap.put(object, stringArray);
            }
            if (string2 == null) continue;
            stringArray.add(string2);
        }
        for (String string2 : hashMap.keySet()) {
            ArrayList arrayList = (ArrayList)hashMap.get(string2);
            if (!arrayList.isEmpty()) {
                stringArray = new String[arrayList.size()];
                stringArray = arrayList.toArray(stringArray);
                deploymentData.addTarget(string2, stringArray);
                continue;
            }
            deploymentData.addTarget(string2, null);
        }
    }

    private void setVersionParams(int n, DeploymentData deploymentData) {
        deploymentData.getDeploymentOptions().setArchiveVersion(this.opts.getOption(OPTION_APP_VERSION));
        deploymentData.getDeploymentOptions().setPlanVersion(this.opts.getOption(OPTION_PLAN_VERSION));
        int n2 = this.opts.getIntegerOption(OPTION_RETIRE_TIMEOUT, -1);
        if (n2 != -1) {
            if (n != 6 && n != 11 && (n != 0 && n != 9 || this.hasFiles(deploymentData)) || this.opts.getOption(OPTION_LIB_MODULE) != null) {
                throw new IllegalArgumentException(messageFormatter.errorRetireTimeoutIllegal(OPTION_RETIRE_TIMEOUT));
            }
            deploymentData.getDeploymentOptions().setRetireTime(n2);
        }
        deploymentData.getDeploymentOptions().setLibSpecVersion(this.opts.getOption(OPTION_LIB_SPEC_VERSION));
        deploymentData.getDeploymentOptions().setLibImplVersion(this.opts.getOption(OPTION_LIB_IMPL_VERSION));
    }

    private void setAdminMode(int n, DeploymentData deploymentData) {
        boolean bl = this.opts.getBooleanOption(OPTION_ADMIN_MODE, false);
        if (bl) {
            if (n != 6 && n != 11 && n != 10 && (n != 0 && n != 9 && n != 7 && n != 8 || this.hasFiles(deploymentData))) {
                throw new IllegalArgumentException(messageFormatter.errorAdminModeIllegal(OPTION_ADMIN_MODE));
            }
            deploymentData.getDeploymentOptions().setTestMode(bl);
        }
        boolean bl2 = this.opts.getBooleanOption(OPTION_GRACEFUL, false);
        boolean bl3 = this.opts.getBooleanOption(OPTION_IGNORE_SESSIONS, false);
        if (!bl2) {
            if (bl3) {
                throw new IllegalArgumentException(messageFormatter.errorIgnoreSessionsIllegal(OPTION_GRACEFUL, OPTION_IGNORE_SESSIONS));
            }
            return;
        }
        if (n != 8 && n != 10) {
            throw new IllegalArgumentException(messageFormatter.errorGracefulIllegal(OPTION_GRACEFUL));
        }
        deploymentData.getDeploymentOptions().setGracefulProductionToAdmin(bl2);
        deploymentData.getDeploymentOptions().setGracefulIgnoreSessions(bl3);
    }

    private void setAltWeblogicDD(DeploymentData deploymentData) {
        String string = this.opts.getOption(OPTION_ALT_WEB_DD);
        if (string != null) {
            File file;
            if (string.length() > 1 && string.charAt(1) != ':') {
                file = new File(string);
                string = file.getAbsolutePath();
            }
            if (!(file = new File(string)).exists() || file.isDirectory()) {
                throw new IllegalArgumentException(messageFormatter.noSourceAltWebDD(string));
            }
            deploymentData.setAltWLSDescriptorPath(string);
        }
    }

    private void setAltAppDD(DeploymentData deploymentData) {
        String string = this.opts.getOption(OPTION_ALT_APP_DD);
        if (string != null) {
            File file;
            if (string.length() > 1 && string.charAt(1) != ':') {
                file = new File(string);
                string = file.getAbsolutePath();
            }
            if (!(file = new File(string)).exists() || file.isDirectory()) {
                throw new IllegalArgumentException(messageFormatter.noSourceAltAppDD(string));
            }
            deploymentData.setAltDescriptorPath(string);
        }
    }

    private void setSubModuleTargets(DeploymentData deploymentData, int n, boolean bl) throws DeployerException {
        String string = this.opts.getOption(OPTION_SUBMODULE_TARGETS);
        if (string == null) {
            return;
        }
        if (!bl && n == 9) {
            throw new DeployerException("-targets & -submoduletargets are mutually exclusive for -redeploy operation.");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2 == null || string2.length() == 0) continue;
            String string3 = null;
            String string4 = null;
            int n2 = string2.indexOf(64);
            if (n2 == -1) {
                throw new DeployerException("SubModuleTargets must have atleast one '@' symbol");
            }
            string3 = string2.substring(0, n2);
            int n3 = string2.indexOf(64, n2 + 1);
            if (n3 == -1) {
                string2 = string2.substring(n2 + 1);
            } else {
                string4 = string2.substring(n2 + 1, n3);
                string2 = string2.substring(n3 + 1);
            }
            deploymentData.addSubModuleTarget(string4, string3, new String[]{string2});
        }
    }

    private String getSourceFromOpts() {
        String string = this.opts.getOption(OPTION_SOURCE);
        int n = this.getActionFromOpts(false);
        if (string == null) {
            if (11 == n || 6 == n) {
                String[] stringArray = this.opts.args();
                if (stringArray != null && stringArray.length > 1) {
                    throw new IllegalArgumentException(messageFormatter.errorMultipleSourceSpecified());
                }
                if (stringArray != null && stringArray.length == 1) {
                    string = stringArray[0];
                    this.isSourceFromOpts = true;
                }
            }
        } else {
            switch (n) {
                case 6: 
                case 11: {
                    String[] stringArray = this.opts.args();
                    if (stringArray == null || stringArray.length <= 0) break;
                    throw new IllegalArgumentException(messageFormatter.errorFilesIllegal());
                }
                case 9: {
                    String[] stringArray = this.opts.args();
                    if (stringArray == null || stringArray.length <= 0) break;
                    throw new IllegalArgumentException(messageFormatter.errorFilesIllegalWithSource());
                }
                case 0: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException(messageFormatter.errorSourceIllegal());
                }
            }
        }
        return string;
    }

    private void listApps(DeployerHelper deployerHelper) {
        this.printApps(deployerHelper.getAppDeployments());
        System.exit(0);
    }

    private void printApps(List list) {
        int n = list.size();
        if (n == 0) {
            System.out.println(messageFormatter.noAppToList());
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n").append(messageFormatter.appsFound()).append(" ");
        stringBuffer.append(n);
        stringBuffer.append("\n");
        String[] stringArray = new String[n];
        stringArray = list.toArray(stringArray);
        for (int i = 0; i < stringArray.length; ++i) {
            if (i != 0) {
                stringBuffer.append("\n");
            }
            stringBuffer.append("\t").append(stringArray[i]);
        }
        stringBuffer.append("\n");
        System.out.println(stringBuffer.toString());
    }

    private void processCancel(DeploymentTaskRuntimeMBean deploymentTaskRuntimeMBean) {
        String string = deploymentTaskRuntimeMBean.getId();
        while (true) {
            if (deploymentTaskRuntimeMBean.isRunning()) {
                continue;
            }
            int n = deploymentTaskRuntimeMBean.getCancelState();
            if (n == 0 || n == 2 || n == 4) {
                System.out.println(messageFormatter.cancelFailed(string));
            } else {
                System.out.println(messageFormatter.cancelSucceeded(string));
            }
            System.exit(0);
        }
    }

    private void rejectFileListWithSourceArgument(String[] stringArray) throws IllegalArgumentException {
        if (this.opts.getOption(OPTION_SOURCE) == null) {
            return;
        }
        if (stringArray != null && stringArray.length > 0) {
            throw new IllegalArgumentException(messageFormatter.errorFilesIllegal());
        }
    }

    private boolean hasFiles(DeploymentData deploymentData) {
        return deploymentData.getFiles() != null && deploymentData.getFiles().length > 0;
    }

    private static void print(String string) {
        System.out.print(string);
    }

    private static void println(String string) {
        System.out.println(string);
    }

    private static void debug(String string) {
        if (debug) {
            System.out.println(string);
        }
    }

    private static void inform(String string) {
        if (verbose) {
            System.out.println(string);
        }
    }

    static {
        options = new String[]{OPTION_ACTIVATE, OPTION_DEACTIVATE, OPTION_REMOVE, OPTION_CANCEL, OPTION_LIST, OPTION_UNPREPARE, OPTION_DISTRIBUTE, OPTION_START, OPTION_STOP, OPTION_REDEPLOY, OPTION_UNDEPLOY, OPTION_DEPLOY, OPTION_LIST_APP, OPTION_LIST_TASK};
    }
}

