/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.api.tools.deployer;

import java.io.PrintStream;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import weblogic.deploy.api.internal.utils.JMXDeployerHelper;
import weblogic.deploy.api.tools.deployer.DeployerException;
import weblogic.deploy.api.tools.deployer.Options;
import weblogic.deploy.internal.DeployerTextFormatter;
import weblogic.deploy.utils.MBeanHomeTool;
import weblogic.management.ApplicationException;
import weblogic.management.DeploymentNotification;
import weblogic.management.ManagementException;
import weblogic.management.deploy.TargetStatus;
import weblogic.management.runtime.DeploymentTaskRuntimeMBean;
import weblogic.utils.Getopt2;
import weblogic.utils.StackTraceUtils;

public abstract class Operation {
    public transient MBeanHomeTool tool;
    public transient Options options;
    public static transient DeployerTextFormatter cat;
    public transient DeploymentTaskRuntimeMBean task = null;
    public transient String id;
    public transient int failures;
    public transient StringBuffer outstr;
    public transient JMXDeployerHelper helper;
    public transient HashSet allowedOptions;
    public transient PrintStream out = System.out;

    protected Operation(MBeanHomeTool mBeanHomeTool, Options options) {
        this(options);
        this.tool = mBeanHomeTool;
        this.setAllowedOptions();
    }

    protected Operation(Options options) {
        this();
        this.options = options;
    }

    protected Operation() {
        this.init();
    }

    protected void init() {
        cat = new DeployerTextFormatter();
        this.allowedOptions = new HashSet();
    }

    public void setOptions(Options options) {
        this.options = options;
    }

    public abstract void setAllowedOptions() throws IllegalArgumentException;

    public void validate() throws IllegalArgumentException, DeployerException {
        HashSet hashSet = (HashSet)Options.allOptions.clone();
        hashSet.removeAll(this.allowedOptions);
        Iterator iterator = hashSet.iterator();
        Getopt2 getopt2 = this.options.getOpts();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (!getopt2.hasOption(string)) continue;
            throw new IllegalArgumentException(cat.errorOptionNotAllowed(string, this.getOperation()));
        }
    }

    public abstract void connect() throws DeployerException;

    public abstract void prepare() throws DeployerException;

    public abstract void execute() throws Exception;

    public abstract int report() throws DeployerException;

    public void debug(String string) {
        if (this.options.debug) {
            this.println(string);
        }
    }

    public void inform(String string) {
        if (this.options.verbose) {
            this.println(string);
        }
    }

    private int showRawTaskInfo(DeploymentTaskRuntimeMBean deploymentTaskRuntimeMBean) {
        int n = 0;
        this.outstr = new StringBuffer();
        String string = this.getTaskStatus(deploymentTaskRuntimeMBean);
        this.outstr.append(cat.allTaskStatus(deploymentTaskRuntimeMBean.getId(), string, deploymentTaskRuntimeMBean.getDescription()));
        this.outstr.append("\n");
        TargetStatus[] targetStatusArray = deploymentTaskRuntimeMBean.getTargets();
        if (targetStatusArray == null) {
            return n;
        }
        for (int i = 0; i < targetStatusArray.length; ++i) {
            TargetStatus targetStatus = targetStatusArray[i];
            if (targetStatus.getState() == 2) {
                ++n;
            }
            String string2 = this.getTargetType(targetStatus.getTargetType());
            String string3 = this.getTargetState(targetStatus.getState());
            this.outstr.append(cat.showTargetState(string2, targetStatus.getTarget(), string3, this.getOperation()));
            this.outstr.append("\n");
            Exception[] exceptionArray = targetStatus.getMessages();
            for (int j = 0; j < exceptionArray.length; ++j) {
                this.outstr.append(this.translateDeploymentMessage(exceptionArray[j]));
            }
        }
        this.outstr.append("\n");
        return n;
    }

    public int showTaskInformation(DeploymentTaskRuntimeMBean deploymentTaskRuntimeMBean) {
        if (!this.options.formatted) {
            int n = this.showRawTaskInfo(deploymentTaskRuntimeMBean);
            this.print(this.outstr.toString());
            return n;
        }
        int n = 0;
        String string = deploymentTaskRuntimeMBean.getId();
        String string2 = this.getOperation();
        String string3 = deploymentTaskRuntimeMBean.getSource();
        String string4 = deploymentTaskRuntimeMBean.getApplicationName();
        TargetStatus[] targetStatusArray = deploymentTaskRuntimeMBean.getTargets();
        int n2 = deploymentTaskRuntimeMBean.getState();
        if (targetStatusArray.length == 0) {
            if (n2 == 2 || n2 == 4) {
                cat.messageNoRealTargets();
                return 0;
            }
            if (n2 == 3) {
                Exception exception = deploymentTaskRuntimeMBean.getError();
                String string5 = cat.noMessage();
                if (exception != null) {
                    string5 = exception.getMessage();
                }
                cat.errorNoRealTargets(string5);
                return 1;
            }
            cat.messageNoTargetsRunning();
            return 0;
        }
        for (int i = 0; i < targetStatusArray.length; ++i) {
            TargetStatus targetStatus = targetStatusArray[i];
            String string6 = targetStatus.getTarget();
            int n3 = targetStatus.getType();
            int n4 = targetStatus.getState();
            String string7 = this.translateTargetType(n3);
            String string8 = this.translateStatus(n4);
            this.print(string + "\t" + string2 + "\t" + string8 + "\t" + string6 + "\t" + string7 + "\t" + string4 + "\t" + string3 + "\t");
            if (n4 == 2) {
                ++n;
            }
            Exception[] exceptionArray = targetStatus.getMessages();
            for (int j = 0; j < exceptionArray.length && exceptionArray[j] != null; ++j) {
                this.print(this.translateDeploymentMessage(exceptionArray[j]));
            }
            this.println("");
        }
        return n;
    }

    public abstract String getOperation();

    public void showTaskInformationHeader() {
        this.println("");
        this.println(cat.showListHeader());
    }

    private String getTaskStatus(DeploymentTaskRuntimeMBean deploymentTaskRuntimeMBean) {
        int n = deploymentTaskRuntimeMBean.getState();
        switch (n) {
            case 4: {
                return cat.stateDeferred();
            }
            case 1: {
                return cat.stateRunning();
            }
            case 2: {
                return cat.stateCompleted();
            }
            case 3: {
                return cat.stateFailed();
            }
            case 0: {
                return cat.stateInit();
            }
        }
        return cat.unknown();
    }

    private String translateDeploymentMessage(Exception exception) {
        StringBuffer stringBuffer;
        if (this.options.formatted) {
            if (exception instanceof ApplicationException) {
                ApplicationException applicationException = (ApplicationException)((Object)exception);
                stringBuffer = new StringBuffer("\nException:");
                stringBuffer.append(((Object)((Object)applicationException)).getClass().getName() + ": ");
                stringBuffer.append(applicationException.getApplicationMessage());
                stringBuffer.append("\n");
                Hashtable hashtable = applicationException.getModuleErrors();
                if (hashtable != null && hashtable.size() != 0) {
                    for (String string : hashtable.keySet()) {
                        Exception exception2;
                        String string2 = (String)hashtable.get(string);
                        stringBuffer.append("\tModule: ");
                        stringBuffer.append(string);
                        stringBuffer.append("\tError: ");
                        stringBuffer.append(string2);
                        stringBuffer.append("\n");
                        if (!this.options.debug || (exception2 = applicationException.getTargetException(string)) == null) continue;
                        stringBuffer.append(StackTraceUtils.throwable2StackTrace((Throwable)exception2));
                        stringBuffer.append("\n");
                    }
                }
                if (applicationException.getNestedException() != null) {
                    stringBuffer.append("Nested Exception:\n");
                    stringBuffer.append(StackTraceUtils.throwable2StackTrace((Throwable)applicationException.getNestedException()));
                    stringBuffer.append("\n");
                }
            } else if (exception instanceof ManagementException) {
                Throwable throwable = ManagementException.unWrapExceptions((Throwable)exception);
                if (throwable != exception) {
                    if (throwable instanceof Exception) {
                        return this.translateDeploymentMessage((Exception)throwable);
                    }
                    stringBuffer = new StringBuffer("\n" + throwable.toString());
                } else {
                    stringBuffer = new StringBuffer("\n" + exception.toString());
                }
            } else {
                stringBuffer = new StringBuffer("\n" + exception.toString());
            }
        } else {
            stringBuffer = new StringBuffer();
            Throwable throwable = ManagementException.unWrapExceptions((Throwable)exception);
            if (throwable instanceof ApplicationException) {
                ApplicationException applicationException = (ApplicationException)((Object)throwable);
                this.debug("dumping ApplicationException message");
                stringBuffer.append(applicationException.getApplicationMessage());
                stringBuffer.append("\n");
                Hashtable hashtable = applicationException.getModuleErrors();
                if (hashtable != null && hashtable.size() != 0) {
                    for (String string : hashtable.keySet()) {
                        Exception exception3;
                        String string3 = (String)hashtable.get(string);
                        this.debug("dumping ModuleException message");
                        stringBuffer.append(cat.moduleException(string, string3));
                        stringBuffer.append("\n");
                        if (!this.options.debug || (exception3 = applicationException.getTargetException(string)) == null) continue;
                        this.debug("dumping ModuleException stack");
                        stringBuffer.append(StackTraceUtils.throwable2StackTrace((Throwable)exception3));
                        stringBuffer.append("\n");
                    }
                }
            } else if (this.options.debug) {
                this.debug("dumping Exception stack");
                stringBuffer.append(StackTraceUtils.throwable2StackTrace((Throwable)throwable));
                stringBuffer.append("\n");
            } else {
                stringBuffer.append(throwable.toString() + "\n");
                if (throwable.getMessage() == null) {
                    stringBuffer.append(StackTraceUtils.throwable2StackTrace((Throwable)throwable));
                }
                stringBuffer.append("\n");
            }
        }
        return stringBuffer.toString();
    }

    private String translateStatus(int n) {
        switch (n) {
            case 4: {
                return cat.messageStateDeferred();
            }
            case 2: {
                return cat.messageStateFailed();
            }
            case 1: {
                return cat.messageStateInProgress();
            }
            case 0: {
                return cat.messageStateInit();
            }
            case 3: {
                return cat.messageStateSuccess();
            }
        }
        return null;
    }

    private String translateTargetType(int n) {
        if (n == 1) {
            return cat.messageServer();
        }
        if (n == 2) {
            return cat.messageCluster();
        }
        return cat.messageUnknown();
    }

    private String getTargetState(int n) {
        switch (n) {
            case 1: {
                return cat.stateRunning();
            }
            case 3: {
                return cat.stateCompleted();
            }
            case 2: {
                return cat.stateFailed();
            }
            case 0: {
                return cat.stateInit();
            }
            case 4: {
                return cat.stateDeferred();
            }
        }
        return cat.unknown();
    }

    private String getTargetType(int n) {
        switch (n) {
            case 1: {
                return cat.messageServer();
            }
            case 2: {
                return cat.messageCluster();
            }
            case 3: {
                return cat.messageJMSServer();
            }
            case 5: {
                return cat.messageSAFAgent();
            }
            case 4: {
                return cat.messageHost();
            }
        }
        return cat.unknown();
    }

    public void showDeploymentNotificationInformation(String string, DeploymentNotification deploymentNotification) {
        if (this.options.formatted) {
            String string2 = this.translateNotificationType(deploymentNotification.getPhase());
            if (deploymentNotification.isAppNotification()) {
                this.println(cat.showDeploymentNotification(string, string2, deploymentNotification.getAppName(), deploymentNotification.getServerName()));
            }
        } else {
            String string3 = deploymentNotification.getAppName();
            String string4 = deploymentNotification.getServerName();
            String string5 = null;
            String string6 = null;
            if (deploymentNotification.isModuleNotification()) {
                string6 = deploymentNotification.getModuleName();
                String string7 = deploymentNotification.getCurrentState();
                String string8 = deploymentNotification.getTargetState();
                String string9 = deploymentNotification.getTransition();
                if (string9.equals("end")) {
                    string5 = cat.successfulTransition(string6, string7, string8, string4);
                } else if (string9.equals("failed")) {
                    string5 = cat.failedTransition(string6, string7, string8, string4);
                }
                if (string5 != null) {
                    this.println(string5);
                }
            } else {
                String string10 = deploymentNotification.getPhase();
                this.println(cat.appNotification(string3, string4, string10));
            }
        }
    }

    private String translateNotificationType(String string) {
        if ("activated".equals(string)) {
            return cat.messageNotificationActivated();
        }
        if ("activating".equals(string)) {
            return cat.messageNotificationActivating();
        }
        if ("deactivated".equals(string)) {
            return cat.messageNotificationDeactivated();
        }
        if ("deactivating".equals(string)) {
            return cat.messageNotificationDeactivating();
        }
        if ("prepared".equals(string)) {
            return cat.messageNotificationPrepared();
        }
        if ("preparing".equals(string)) {
            return cat.messageNotificationPreparing();
        }
        if ("unprepared".equals(string)) {
            return cat.messageNotificationUnprepared();
        }
        if ("unpreparing".equals(string)) {
            return cat.messageNotificationUnpreparing();
        }
        if ("distributing".equals(string)) {
            return cat.messageNotificationDistributing();
        }
        if ("distributed".equals(string)) {
            return cat.messageNotificationDistributed();
        }
        if ("failed".equals(string)) {
            return cat.messageNotificationFailed();
        }
        return string;
    }

    public void cleanUp() {
    }

    public void setOut(PrintStream printStream) {
        this.out = printStream;
    }

    public PrintStream getOut() {
        return this.out;
    }

    public void println(String string) {
        this.out.println(string);
    }

    public void print(String string) {
        this.out.print(string);
    }
}

