/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.api.tools.deployer;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.StringTokenizer;
import weblogic.deploy.internal.DeployerTextFormatter;
import weblogic.utils.Getopt2;

public class Options
implements Serializable {
    private static final long serialVersionUID = 1L;
    private transient Getopt2 opts;
    private static transient DeployerTextFormatter cat;
    public static final String OPTION_CANCEL = "cancel";
    public static final String OPTION_LIST = "list";
    public static final String OPTION_DEPLOY = "deploy";
    public static final String OPTION_UNDEPLOY = "undeploy";
    public static final String OPTION_DISTRIBUTE = "distribute";
    public static final String OPTION_START = "start";
    public static final String OPTION_STOP = "stop";
    public static final String OPTION_REDEPLOY = "redeploy";
    public static final String OPTION_LIST_APP = "listapps";
    public static final String OPTION_LIST_TASK = "listtask";
    public static final String OPTION_PURGE_TASKS = "purgetasks";
    public static final String OPTION_UPDATE = "update";
    public static final String OPTION_ACTIVATE = "activate";
    public static final String OPTION_DEACTIVATE = "deactivate";
    public static final String OPTION_UNPREPARE = "unprepare";
    public static final String OPTION_REMOVE = "remove";
    public static final String OPTION_VERBOSE = "verbose";
    public static final String OPTION_DEBUG = "debug";
    public static final String OPTION_EXAMPLES = "examples";
    public static final String OPTION_NOWAIT = "nowait";
    public static final String OPTION_NOSTAGE = "nostage";
    public static final String OPTION_STAGE = "stage";
    public static final String OPTION_EXTERNAL_STAGE = "external_stage";
    public static final String OPTION_UPLOAD = "upload";
    public static final String OPTION_DELETE_FILES = "delete_files";
    public static final String OPTION_REMOTE = "remote";
    public static final String OPTION_ADMIN_MODE = "adminmode";
    public static final String OPTION_GRACEFUL = "graceful";
    public static final String OPTION_IGNORE_SESSIONS = "ignoresessions";
    public static final String OPTION_RMI_GRACE_PERIOD = "rmigraceperiod";
    public static final String OPTION_ALL_VERSIONS = "allversions";
    public static final String OPTION_SECURITY_VALIDATE = "enableSecurityValidation";
    public static final String OPTION_LIB_MODULE = "library";
    public static final String OPTION_NOEXIT = "noexit";
    public static final String OPTION_NO_VERSION = "noversion";
    public static final String OPTION_DEFAULT_SUBMODULE_TARGETS = "defaultsubmoduletargets";
    public static final String OPTION_NO_DEFAULT_SUBMODULE_TARGETS = "nodefaultsubmoduletargets";
    public static final String OPTION_USE_NONEXCLUSIVE_LOCK = "usenonexclusivelock";
    public static final String OPTION_SOURCE = "source";
    public static final String OPTION_NAME = "name";
    public static final String OPTION_APP_VERSION = "appversion";
    public static final String OPTION_PLAN_VERSION = "planversion";
    public static final String OPTION_RETIRE_TIMEOUT = "retiretimeout";
    public static final String OPTION_TARGETS = "targets";
    public static final String OPTION_SUBMODULE_TARGETS = "submoduletargets";
    public static final String OPTION_SECURITY_MODEL = "securityModel";
    public static final String OPTION_LIB_SPEC_VERSION = "libspecver";
    public static final String OPTION_LIB_IMPL_VERSION = "libimplver";
    public static final String OPTION_ID = "id";
    public static final String OPTION_TIMEOUT = "timeout";
    public static final String OPTION_PLAN = "plan";
    public static final String OPTION_DEPLOYMENT_ORDER = "deploymentorder";
    public static final String OPTION_ALT_APP_DD = "altappdd";
    public static final String OPTION_ALT_WLS_DD = "altwlsappdd";
    public static final String OPTION_OUTPUT = "output";
    public static final String RAW_OUTPUT = "raw";
    public static final String FORMATTED_OUTPUT = "formatted";
    public static final String OPTION_SRCROOT = "sourcerootforupload";
    static final transient HashSet allOptions;
    boolean verbose;
    boolean debug;
    boolean examples;
    boolean nowait;
    String stageMode = null;
    boolean upload;
    boolean deleteFiles;
    boolean remote;
    boolean adminMode;
    boolean graceful;
    boolean ignoreSessions;
    int rmiGracePeriod;
    boolean allVersions;
    boolean securityValidation;
    boolean libModule;
    String source;
    String name;
    String appVersion;
    String planVersion;
    boolean noVersion;
    int retireTimeout = -1;
    String securityModel;
    String libSpecVersion;
    String libImplVersion;
    String id;
    long timeout = 0L;
    int deploymentOrder = 100;
    String altAppDD;
    String altWlsAppDD;
    boolean sourceFromOpts = false;
    boolean removeOp;
    boolean cancelOp;
    boolean listOp;
    boolean deployOp;
    boolean undeployOp;
    boolean distributeOp;
    boolean startOp;
    boolean stopOp;
    boolean redeployOp;
    boolean listappOp;
    boolean listtaskOp;
    boolean purgetasksOp;
    boolean updateOp;
    boolean activateOp;
    boolean deactivateOp;
    boolean unprepareOp;
    String[] moduleTargets;
    String[] submoduleTargets;
    String[] delta;
    boolean sourceFromArgs = false;
    boolean formatted;
    boolean noexit;
    String plan;
    boolean isDefaultSubmoduleTargets;
    boolean useNonExclusiveLock = false;
    static final long MAX_NOTIFICATION_WAIT = 1000L;

    Options(Getopt2 getopt2) throws IllegalArgumentException {
        this.opts = getopt2;
        this.prepare();
    }

    Options() {
    }

    Getopt2 getOpts() {
        return this.opts;
    }

    private void prepare() {
        this.opts.setUsageArgs(cat.usageArgs());
        this.opts.setUsageFooter(cat.usageTrailer());
        this.opts.addFlag(OPTION_DISTRIBUTE, cat.usageDistribute());
        this.opts.addFlag(OPTION_START, cat.usageStart());
        this.opts.addFlag(OPTION_STOP, cat.usageStop());
        this.opts.addFlag(OPTION_REDEPLOY, cat.usageRedeploy());
        this.opts.addFlag(OPTION_UNDEPLOY, cat.usageUndeploy());
        this.opts.addFlag(OPTION_DEPLOY, cat.usageDeploy());
        this.opts.addFlag(OPTION_UPDATE, cat.usageUpdate());
        this.opts.addAdvancedFlag(OPTION_CANCEL, cat.usageCancel());
        this.opts.addAdvancedFlag(OPTION_LIST, cat.usageList());
        this.opts.addAdvancedFlag(OPTION_LIST_TASK, cat.usageList());
        this.opts.addAdvancedFlag(OPTION_LIST_APP, cat.usageListApps());
        this.opts.addAdvancedFlag(OPTION_PURGE_TASKS, cat.usageAdPurgeTasks());
        this.opts.addFlag(OPTION_EXAMPLES, cat.usageExamples());
        this.opts.addOption(OPTION_NAME, cat.exampleName(), cat.usageName());
        this.opts.addOption(OPTION_TARGETS, cat.exampleTargets(), cat.usageAdTargets());
        this.opts.addOption(OPTION_PLAN, cat.examplePlan(), cat.usagePlan());
        this.opts.addFlag(OPTION_LIB_MODULE, cat.usageLibrary());
        this.opts.addAdvancedFlag(OPTION_VERBOSE, cat.usageVerbose());
        this.opts.addAdvancedOption(OPTION_OUTPUT, RAW_OUTPUT, cat.usageOutput());
        this.opts.addAdvancedFlag(OPTION_DEBUG, cat.usageDebug());
        this.opts.addAdvancedFlag(OPTION_UPLOAD, cat.usageUpload());
        this.opts.addAdvancedFlag(OPTION_DELETE_FILES, cat.usageDeleteFiles());
        this.opts.addAdvancedFlag(OPTION_REMOTE, cat.usageRemote());
        this.opts.addAdvancedFlag(OPTION_NOSTAGE, cat.usageNoStage());
        this.opts.addAdvancedFlag(OPTION_EXTERNAL_STAGE, cat.usageExternalStage());
        this.opts.addAdvancedFlag(OPTION_STAGE, cat.usageStage());
        this.opts.addAdvancedFlag(OPTION_NOWAIT, cat.usageNoWait());
        this.opts.addAdvancedOption(OPTION_TIMEOUT, cat.exampleTimeout(), cat.usageTimeout());
        this.opts.addAdvancedOption(OPTION_DEPLOYMENT_ORDER, cat.exampleDeploymentOrder(), cat.usageDeploymentOrder());
        this.opts.addAdvancedOption(OPTION_SOURCE, cat.exampleSource(), cat.usageSource());
        this.opts.addAdvancedOption(OPTION_ALT_APP_DD, cat.exampleAltAppDD(), cat.usageAltAppDD());
        this.opts.addAdvancedOption(OPTION_ALT_WLS_DD, cat.exampleAltWebDD(), cat.usageAltWebDD());
        this.opts.addAdvancedOption(OPTION_APP_VERSION, cat.exampleAppVersion(), cat.usageAppVersion());
        this.opts.addAdvancedOption(OPTION_PLAN_VERSION, cat.examplePlanVersion(), cat.usagePlanVersion());
        this.opts.addAdvancedFlag(OPTION_NO_VERSION, cat.usageNoVersion());
        this.opts.addAdvancedOption(OPTION_RETIRE_TIMEOUT, cat.exampleRetireTimeout(), cat.usageRetireTimeout());
        this.opts.addAdvancedOption(OPTION_ID, cat.exampleId(), cat.usageId());
        this.opts.addAdvancedFlag(OPTION_ADMIN_MODE, cat.usageAdminMode());
        this.opts.addAdvancedFlag(OPTION_GRACEFUL, cat.usageGraceful());
        this.opts.addAdvancedFlag(OPTION_IGNORE_SESSIONS, cat.usageIgnoreSessions(OPTION_GRACEFUL));
        this.opts.addAdvancedOption(OPTION_RMI_GRACE_PERIOD, cat.exampleRmiGracePeriod(), cat.usageRmiGracePeriod(OPTION_GRACEFUL));
        this.opts.addAdvancedFlag(OPTION_ALL_VERSIONS, cat.usageAllVersions(OPTION_ALL_VERSIONS));
        this.opts.addAdvancedOption(OPTION_SUBMODULE_TARGETS, cat.paramSubModuleTargets(), cat.usageSubModuleTargets());
        this.opts.addAdvancedOption(OPTION_SECURITY_MODEL, "DDOnly|CustomRoles|CustomRolesAndPolicies|Advanced", cat.usageSecurityModel());
        this.opts.addAdvancedFlag(OPTION_SECURITY_VALIDATE, cat.usageSecurityEnabled());
        this.opts.addAdvancedOption(OPTION_LIB_SPEC_VERSION, cat.exampleLibSpecVersion(), cat.usageLibSpecVersion());
        this.opts.addAdvancedOption(OPTION_LIB_IMPL_VERSION, cat.exampleLibImplVersion(), cat.usageLibImplVersion());
        this.opts.addAdvancedFlag(OPTION_USE_NONEXCLUSIVE_LOCK, cat.usageUseNonexclusiveLock());
        this.opts.addAdvancedFlag(OPTION_DEFAULT_SUBMODULE_TARGETS, cat.usageDefaultTargets());
        this.opts.markPrivate(OPTION_DEFAULT_SUBMODULE_TARGETS);
        this.opts.addAdvancedFlag(OPTION_NO_DEFAULT_SUBMODULE_TARGETS, cat.usageNoDefaultTargets());
        this.opts.markPrivate(OPTION_NO_DEFAULT_SUBMODULE_TARGETS);
        this.opts.addAdvancedFlag(OPTION_ACTIVATE, cat.usageActivate());
        this.opts.markPrivate(OPTION_ACTIVATE);
        this.opts.addAdvancedFlag(OPTION_DEACTIVATE, cat.usageDeactivate());
        this.opts.markPrivate(OPTION_DEACTIVATE);
        this.opts.addAdvancedFlag(OPTION_UNPREPARE, cat.usageUnprepare());
        this.opts.markPrivate(OPTION_UNPREPARE);
        this.opts.addAdvancedFlag(OPTION_REMOVE, cat.usageRemove());
        this.opts.markPrivate(OPTION_REMOVE);
        this.opts.addAdvancedOption(OPTION_SRCROOT, cat.exampleSourceRootForUpload(), cat.usageSourceRootForUpload());
        this.opts.markPrivate(OPTION_SRCROOT);
    }

    void extractOptions() throws IllegalArgumentException {
        String string;
        this.verbose = this.opts.getBooleanOption(OPTION_VERBOSE, false);
        this.debug = this.opts.getBooleanOption(OPTION_DEBUG, false);
        if (this.debug && (string = System.getProperty("weblogic.deployer.debug")) == null) {
            System.setProperty("weblogic.deployer.debug", OPTION_DEPLOY);
        }
        this.examples = this.opts.getBooleanOption(OPTION_EXAMPLES, false);
        this.nowait = this.opts.getBooleanOption(OPTION_NOWAIT, false);
        if (this.opts.getBooleanOption(OPTION_STAGE, false)) {
            this.stageMode = OPTION_STAGE;
        } else if (this.opts.getBooleanOption(OPTION_NOSTAGE, false)) {
            this.stageMode = OPTION_NOSTAGE;
        } else if (this.opts.getBooleanOption(OPTION_EXTERNAL_STAGE, false)) {
            this.stageMode = OPTION_EXTERNAL_STAGE;
        }
        this.upload = this.opts.getBooleanOption(OPTION_UPLOAD, false);
        this.deleteFiles = this.opts.getBooleanOption(OPTION_DELETE_FILES, false);
        this.remote = this.opts.getBooleanOption(OPTION_REMOTE, false);
        this.adminMode = this.opts.getBooleanOption(OPTION_ADMIN_MODE, false);
        this.graceful = this.opts.getBooleanOption(OPTION_GRACEFUL, false);
        this.ignoreSessions = this.opts.getBooleanOption(OPTION_IGNORE_SESSIONS, false);
        this.allVersions = this.opts.getBooleanOption(OPTION_ALL_VERSIONS, false);
        this.securityValidation = this.opts.getBooleanOption(OPTION_SECURITY_VALIDATE, false);
        this.libModule = this.opts.getBooleanOption(OPTION_LIB_MODULE, false);
        this.noexit = this.opts.getBooleanOption(OPTION_NOEXIT, false);
        this.isDefaultSubmoduleTargets = !this.opts.hasOption(OPTION_NO_DEFAULT_SUBMODULE_TARGETS);
        this.useNonExclusiveLock = this.opts.hasOption(OPTION_USE_NONEXCLUSIVE_LOCK);
        this.formatted = this.getOutputFormat();
        this.source = this.opts.getOption(OPTION_SOURCE);
        if (this.source != null) {
            this.sourceFromOpts = true;
        }
        this.name = this.opts.getOption(OPTION_NAME);
        this.appVersion = this.opts.getOption(OPTION_APP_VERSION);
        this.planVersion = this.opts.getOption(OPTION_PLAN_VERSION);
        this.noVersion = this.opts.getBooleanOption(OPTION_NO_VERSION, false);
        this.retireTimeout = this.opts.getIntegerOption(OPTION_RETIRE_TIMEOUT, this.retireTimeout);
        this.rmiGracePeriod = this.opts.getIntegerOption(OPTION_RMI_GRACE_PERIOD, -1);
        this.securityModel = this.opts.getOption(OPTION_SECURITY_MODEL);
        this.libSpecVersion = this.opts.getOption(OPTION_LIB_SPEC_VERSION);
        this.libImplVersion = this.opts.getOption(OPTION_LIB_IMPL_VERSION);
        this.id = this.opts.getOption(OPTION_ID);
        this.timeout = this.opts.getIntegerOption(OPTION_TIMEOUT, 0);
        this.deploymentOrder = this.opts.getIntegerOption(OPTION_DEPLOYMENT_ORDER, 100);
        this.altAppDD = this.opts.getOption(OPTION_ALT_APP_DD);
        this.altWlsAppDD = this.opts.getOption(OPTION_ALT_WLS_DD);
        this.plan = this.opts.getOption(OPTION_PLAN);
        string = this.opts.getOption(OPTION_SRCROOT);
        if (string != null) {
            if (this.source != null || this.upload) {
                throw new IllegalArgumentException(cat.errorSourceAndSourceRootNotAllowed());
            }
            this.source = string;
            this.sourceFromOpts = true;
            this.upload = true;
        }
        this.cancelOp = this.opts.hasOption(OPTION_CANCEL);
        this.deployOp = this.opts.hasOption(OPTION_DEPLOY);
        this.undeployOp = this.opts.hasOption(OPTION_UNDEPLOY);
        this.distributeOp = this.opts.hasOption(OPTION_DISTRIBUTE);
        this.startOp = this.opts.hasOption(OPTION_START);
        this.stopOp = this.opts.hasOption(OPTION_STOP);
        this.redeployOp = this.opts.hasOption(OPTION_REDEPLOY);
        this.listappOp = this.opts.hasOption(OPTION_LIST_APP);
        this.listtaskOp = this.opts.hasOption(OPTION_LIST_TASK);
        this.purgetasksOp = this.opts.hasOption(OPTION_PURGE_TASKS);
        this.updateOp = this.opts.hasOption(OPTION_UPDATE);
        this.deployOp = this.opts.hasOption(OPTION_DEPLOY);
        this.stopOp = this.opts.hasOption(OPTION_STOP);
        this.activateOp = this.checkDeprecated(OPTION_ACTIVATE, OPTION_DEPLOY);
        this.deactivateOp = this.checkDeprecated(OPTION_DEACTIVATE, OPTION_STOP);
        this.unprepareOp = this.checkDeprecated(OPTION_UNPREPARE, OPTION_STOP);
        this.removeOp = this.checkDeprecated(OPTION_REMOVE, OPTION_UNDEPLOY);
        this.listOp = this.opts.hasOption(OPTION_LIST);
        if (this.listOp) {
            System.out.println(cat.warningListDeprecated());
        }
        this.checkDeprecated(OPTION_SRCROOT, OPTION_UPLOAD);
        this.moduleTargets = this.getTargets(OPTION_TARGETS);
        this.submoduleTargets = this.getTargets(OPTION_SUBMODULE_TARGETS);
        this.delta = this.opts.args();
        if (this.delta != null && this.delta.length == 0) {
            this.delta = null;
        }
        if (this.delta != null && this.delta.length > 0 && this.source == null && this.delta.length == 1) {
            if (this.opts.hasOption(OPTION_SRCROOT)) {
                throw new IllegalArgumentException(cat.errorSourceAndSourceRootNotAllowed());
            }
            this.source = this.delta[0];
            this.sourceFromArgs = true;
        }
        this.setImpliedLibrary();
    }

    private void setImpliedLibrary() {
        if (this.libImplVersion != null || this.libSpecVersion != null) {
            this.libModule = true;
        }
    }

    private boolean getOutputFormat() throws IllegalArgumentException {
        String string = this.opts.getOption(OPTION_OUTPUT, RAW_OUTPUT);
        if (RAW_OUTPUT.equals(string)) {
            return false;
        }
        if (FORMATTED_OUTPUT.equals(string)) {
            return true;
        }
        System.out.println(cat.badFormat(string));
        return false;
    }

    private boolean checkDeprecated(String string, String string2) {
        boolean bl = this.opts.hasOption(string);
        if (bl) {
            System.out.println(cat.deprecated(string, string2));
        }
        return bl;
    }

    private String[] getTargets(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = this.opts.getOption(string);
        if (string2 != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                if (string3 == null || string3.length() == 0) continue;
                arrayList.add(string3);
            }
        }
        return arrayList.toArray(new String[0]);
    }

    public boolean isRemote() {
        return this.remote;
    }

    public void setRemote(boolean bl) {
        this.remote = bl;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    public boolean isUpload() {
        return this.upload;
    }

    static {
        allOptions = new HashSet();
        allOptions.add(OPTION_PLAN);
        allOptions.add(OPTION_ALT_WLS_DD);
        allOptions.add(OPTION_ALT_APP_DD);
        allOptions.add(OPTION_ID);
        allOptions.add(OPTION_LIB_IMPL_VERSION);
        allOptions.add(OPTION_LIB_SPEC_VERSION);
        allOptions.add(OPTION_SECURITY_MODEL);
        allOptions.add(OPTION_SUBMODULE_TARGETS);
        allOptions.add(OPTION_TARGETS);
        allOptions.add(OPTION_RETIRE_TIMEOUT);
        allOptions.add(OPTION_PLAN_VERSION);
        allOptions.add(OPTION_APP_VERSION);
        allOptions.add(OPTION_NO_VERSION);
        allOptions.add(OPTION_NAME);
        allOptions.add(OPTION_SOURCE);
        allOptions.add(OPTION_LIB_MODULE);
        allOptions.add(OPTION_SECURITY_VALIDATE);
        allOptions.add(OPTION_IGNORE_SESSIONS);
        allOptions.add(OPTION_RMI_GRACE_PERIOD);
        allOptions.add(OPTION_GRACEFUL);
        allOptions.add(OPTION_ALL_VERSIONS);
        allOptions.add(OPTION_ADMIN_MODE);
        allOptions.add(OPTION_DELETE_FILES);
        allOptions.add(OPTION_STAGE);
        allOptions.add(OPTION_NOSTAGE);
        allOptions.add(OPTION_DEFAULT_SUBMODULE_TARGETS);
        allOptions.add(OPTION_NO_DEFAULT_SUBMODULE_TARGETS);
        allOptions.add(OPTION_USE_NONEXCLUSIVE_LOCK);
        cat = new DeployerTextFormatter();
    }
}

