/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.api.tools.deployer;

import java.util.Arrays;
import java.util.Comparator;
import weblogic.deploy.api.tools.deployer.Options;
import weblogic.deploy.api.tools.deployer.TaskOperation;
import weblogic.deploy.utils.MBeanHomeTool;

public class PurgeTasksOperation
extends TaskOperation {
    private String[] retiredTaskIds = null;

    public PurgeTasksOperation(MBeanHomeTool mBeanHomeTool, Options options) {
        super(mBeanHomeTool, options);
    }

    public void setAllowedOptions() {
    }

    public void execute() throws Exception {
        try {
            this.retiredTaskIds = this.helper.getDeployer().purgeRetiredTasks();
        }
        catch (Throwable throwable) {
            String string = cat.errorGettingDeployerRuntime();
            throw new RuntimeException(string, throwable);
        }
    }

    public int report() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.retiredTaskIds == null || this.retiredTaskIds.length == 0) {
            System.out.println(cat.showNoRetiredTasks());
        } else {
            Arrays.sort(this.retiredTaskIds, new Comparator(){

                public int compare(Object object, Object object2) {
                    String string = (String)object;
                    String string2 = (String)object2;
                    return string.compareTo(string2);
                }
            });
            for (int i = 0; i < this.retiredTaskIds.length; ++i) {
                if (i > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(this.retiredTaskIds[i]);
            }
            System.out.println(cat.showRetiredTasks(stringBuffer.toString()));
        }
        return 0;
    }

    public String getOperation() {
        return "purgetasks";
    }
}

