/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.api.tools.deployer;

import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import weblogic.deploy.api.shared.WebLogicModuleType;
import weblogic.deploy.api.spi.WebLogicDeploymentManager;
import weblogic.deploy.api.tools.deployer.ModuleTargetInfo;
import weblogic.deploy.internal.DeployerTextFormatter;

public class SubModuleTargetInfo
extends ModuleTargetInfo {
    private String submodule = null;
    protected static DeployerTextFormatter cat = new DeployerTextFormatter();

    public SubModuleTargetInfo(String string) {
        int n = string.indexOf("@");
        if (n == -1) {
            throw new IllegalArgumentException(cat.invalidTargetSyntax(string));
        }
        this.setSubmodule(string.substring(0, n));
        this.init(string.substring(n + 1));
    }

    public String getSubmodule() {
        return this.submodule;
    }

    public void setSubmodule(String string) {
        this.submodule = string;
    }

    public TargetModuleID createTmid(String string, Target target, WebLogicDeploymentManager webLogicDeploymentManager) {
        TargetModuleID targetModuleID = null;
        TargetModuleID targetModuleID2 = super.createTmid(string, target, webLogicDeploymentManager);
        TargetModuleID[] targetModuleIDArray = targetModuleID2.getChildTargetModuleID();
        if (targetModuleIDArray != null) {
            for (int i = 0; i < targetModuleIDArray.length; ++i) {
                TargetModuleID targetModuleID3 = targetModuleIDArray[i];
                if (!targetModuleID3.getModuleID().equals(this.getModule())) continue;
                targetModuleID = targetModuleID3;
            }
            if (targetModuleID == null) {
                throw new AssertionError((Object)"Failed to build tmids");
            }
        } else {
            targetModuleID = targetModuleID2;
        }
        if (this.getSubmodule() != null) {
            targetModuleID2 = webLogicDeploymentManager.createTargetModuleID(targetModuleID, this.getSubmodule(), WebLogicModuleType.SUBMODULE);
        }
        return targetModuleID2;
    }
}

