/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.api.tools.deployer;

import javax.management.MBeanServerConnection;
import weblogic.deploy.api.internal.utils.DeployerHelperException;
import weblogic.deploy.api.internal.utils.JMXDeployerHelper;
import weblogic.deploy.api.tools.deployer.DeployerException;
import weblogic.deploy.api.tools.deployer.Operation;
import weblogic.deploy.api.tools.deployer.Options;
import weblogic.deploy.utils.MBeanHomeTool;
import weblogic.deploy.utils.MBeanHomeToolException;
import weblogic.management.runtime.DeploymentTaskRuntimeMBean;

abstract class TaskOperation
extends Operation {
    protected DeploymentTaskRuntimeMBean task = null;
    protected int failures;
    protected MBeanServerConnection mbs;
    protected JMXDeployerHelper helper;

    TaskOperation(MBeanHomeTool mBeanHomeTool, Options options) {
        super(mBeanHomeTool, options);
    }

    public void validate() throws IllegalArgumentException, DeployerException {
        super.validate();
    }

    public void prepare() throws DeployerException {
        try {
            this.helper = new JMXDeployerHelper(this.mbs);
        }
        catch (DeployerHelperException deployerHelperException) {
            throw new DeployerException(deployerHelperException.toString());
        }
    }

    public void connect() throws DeployerException {
        try {
            this.mbs = this.tool.getMBeanServer();
        }
        catch (MBeanHomeToolException mBeanHomeToolException) {
            DeployerException deployerException = new DeployerException(cat.errorUnableToAccessDeployer(this.tool.getOpts().getOption("adminurl", "t3://localhost:7001"), mBeanHomeToolException.getMessage()));
            if (this.options.debug || this.options.verbose) {
                deployerException.initCause(mBeanHomeToolException);
            }
            throw deployerException;
        }
    }

    public abstract void execute() throws Exception;

    public abstract int report() throws DeployerException;
}

