/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.api.tools.deployer.remote;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import javax.ejb.CreateException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.enterprise.deploy.spi.exceptions.DeploymentManagerCreationException;
import weblogic.deploy.api.tools.SessionHelper;
import weblogic.deploy.api.tools.deployer.DeployerException;
import weblogic.deploy.api.tools.deployer.Jsr88Operation;
import weblogic.deploy.api.tools.deployer.Options;
import weblogic.deploy.api.tools.deployer.remote.DeployerResponse;
import weblogic.deploy.internal.DeployerTextFormatter;
import weblogic.rmi.extensions.RemoteRuntimeException;
import weblogic.utils.StackTraceUtils;

public class DeployerBean
implements SessionBean {
    public static final String REMOTE_DEPLOYER_NAME = "bea_wls_remote_deployer";
    private static DeployerTextFormatter cat = new DeployerTextFormatter();
    private int failures = -1;
    private String output = "";
    private Jsr88Operation op;
    private ByteArrayOutputStream os;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DeployerResponse deploy(Jsr88Operation jsr88Operation, Options options) throws Exception {
        this.op = jsr88Operation;
        this.op.setOptions(options);
        this.op.options.setRemote(false);
        this.os = new ByteArrayOutputStream();
        this.op.setOut(new PrintStream(this.os));
        try {
            try {
                this.connect();
                this.op.prepare();
                this.op.execute();
                this.failures = this.op.report();
                this.output = this.os.toString();
                DeployerResponse deployerResponse = new DeployerResponse(this.failures, this.output);
                Object var7_6 = null;
                if (this.op == null) return deployerResponse;
                this.op.cleanUp();
                return deployerResponse;
            }
            catch (RemoteRuntimeException remoteRuntimeException) {
                DeployerResponse deployerResponse = new DeployerResponse(1, cat.errorLostConnection());
                Object var7_7 = null;
                if (this.op == null) return deployerResponse;
                this.op.cleanUp();
                return deployerResponse;
            }
            catch (Throwable throwable) {
                String string = throwable.getMessage();
                if (string == null) {
                    string = StackTraceUtils.throwable2StackTrace((Throwable)throwable);
                }
                DeployerResponse deployerResponse = new DeployerResponse(1, string);
                Object var7_8 = null;
                if (this.op == null) return deployerResponse;
                this.op.cleanUp();
                return deployerResponse;
            }
        }
        catch (Throwable throwable2) {
            Object var7_9 = null;
            if (this.op == null) throw throwable2;
            this.op.cleanUp();
            throw throwable2;
        }
    }

    private void connect() throws DeployerException {
        try {
            this.op.setDm(SessionHelper.getDeploymentManager(null, null));
            if (this.op.options.isUpload()) {
                this.op.getDm().enableFileUploads();
            }
        }
        catch (DeploymentManagerCreationException deploymentManagerCreationException) {
            DeployerException deployerException = new DeployerException(deploymentManagerCreationException.toString());
            deployerException.initCause(deploymentManagerCreationException);
            throw deployerException;
        }
    }

    public int getFailures() {
        return this.failures;
    }

    public String getOutPut() {
        return this.op.getOut().toString();
    }

    public void ejbActivate() {
    }

    public void ejbRemove() {
    }

    public void ejbPassivate() {
    }

    public void setSessionContext(SessionContext sessionContext) {
    }

    public void ejbCreate() throws CreateException {
    }
}

