/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.api.tools.samples;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.enterprise.deploy.shared.ModuleType;
import weblogic.deploy.api.shared.WebLogicModuleType;
import weblogic.deploy.api.spi.DeploymentOptions;
import weblogic.deploy.api.tools.samples.J2EEDeployerToolTextFormatter;
import weblogic.utils.Getopt2;

class Config {
    static final String HOST = "host";
    static final String PORT = "port";
    static final String USER = "user";
    static final String PASSWORD = "password";
    static final String VERBOSE = "verbose";
    static final String DEBUG = "debug";
    static final String QUIET = "quiet";
    static final String USEPLAN = "useplan";
    static final String SAVEPLAN = "saveplan";
    static final String TARGETS = "targets";
    static final String PLUGIN = "plugin";
    static final String CONFIG = "config";
    static final String TYPE = "type";
    static final String REMOTE = "remote";
    static final String NAME = "name";
    static final String STAGE = "stage";
    static final String MODULES = "modules";
    static final String START = "start";
    static final String DEPLOY = "deploy";
    static final String STOP = "stop";
    static final String DISTRIBUTE = "distribute";
    static final String UNDEPLOY = "undeploy";
    static final String REDEPLOY = "redeploy";
    static final String UPDATE = "update";
    static final String LISTALL = "listall";
    static final String LISTSTARTED = "liststarted";
    static final String LISTSTOPPED = "liststopped";
    static final String LISTTARGETS = "listtargets";
    static final String LISTTYPES = "listtypes";
    static final String LISTCOMMANDS = "listcommands";
    static final String FACTORY = "J2EE-DeploymentFactory-Implementation-Class";
    static final String DEFAULT_CONFIG = ".config";
    static final String DEFAULT_FACTORY = "weblogic.deploy.api.spi.factories.internal.DeploymentFactoryImpl";
    String adminURL;
    String host = "localhost";
    String port = "8888";
    String user = "system";
    String password = "gumby1234";
    boolean verbose = false;
    boolean debug = false;
    boolean quiet = false;
    String usePlan = null;
    String savePlan = null;
    Set targets = new HashSet();
    String[] targetArray;
    String targs;
    String mods;
    String plugin = null;
    String config = ".config";
    String name = null;
    String[] arglist;
    Getopt2 opts;
    J2EEDeployerToolTextFormatter cat;
    String command = null;
    String fileOrApp = null;
    Set modules = new HashSet();
    String factoryClassName;
    ModuleType moduleType = null;
    boolean remote = false;
    String appName = null;
    String stage = DeploymentOptions.STAGE_DEFAULT;
    Set delta = new HashSet();

    Config(String[] stringArray, String string) throws IllegalArgumentException {
        StringTokenizer stringTokenizer;
        this.name = string;
        this.arglist = stringArray;
        this.opts = new Getopt2();
        this.cat = J2EEDeployerToolTextFormatter.getInstance();
        this.opts.addOption(HOST, this.host, this.cat.hostOption());
        this.opts.addOption(PORT, this.port, this.cat.portOption());
        this.opts.addOption(USER, "admin", this.cat.userOption());
        this.opts.addOption(PASSWORD, "?????", this.cat.passwordOption());
        this.opts.addFlag(VERBOSE, this.cat.verboseOption());
        this.opts.addFlag(DEBUG, this.cat.debugOption());
        this.opts.addFlag(QUIET, this.cat.quietOption());
        this.opts.addOption(USEPLAN, "/plans/myapp.plan", this.cat.useplanOption());
        this.opts.addOption(SAVEPLAN, "/plans/myapp.plan", this.cat.saveplanOption());
        this.opts.addOption(TARGETS, "server1,server2", this.cat.targetsOption());
        this.opts.addOption(PLUGIN, "wldeploy.jar", this.cat.pluginOption());
        this.opts.addOption(CONFIG, "./.config", this.cat.configOption());
        this.opts.addOption(TYPE, "EAR", this.cat.typeOption());
        this.opts.addOption(NAME, "myapp", this.cat.nameOption());
        this.opts.addOption(MODULES, "mod1,mod2", this.cat.modulesOption());
        this.opts.addOption(STAGE, STAGE, this.cat.stageOption());
        this.opts.addFlag(REMOTE, this.cat.remoteOption());
        this.opts.addFlag(START, this.cat.startCommand());
        this.opts.addFlag(DEPLOY, this.cat.deployCommand());
        this.opts.addFlag(STOP, this.cat.stopCommand());
        this.opts.addFlag(DISTRIBUTE, this.cat.distributeCommand());
        this.opts.addFlag(UNDEPLOY, this.cat.undeployCommand());
        this.opts.addFlag(REDEPLOY, this.cat.redeployCommand());
        this.opts.addFlag(UPDATE, this.cat.updateCommand());
        this.opts.addFlag(LISTALL, this.cat.listallCommand());
        this.opts.addFlag(LISTSTARTED, this.cat.liststartedCommand());
        this.opts.addFlag(LISTSTOPPED, this.cat.liststoppedCommand());
        this.opts.addFlag(LISTTARGETS, this.cat.listtargetsCommand());
        this.opts.addFlag(LISTTYPES, this.cat.listtypesCommand());
        this.opts.addFlag(LISTCOMMANDS, this.cat.listcommandsCommand());
        this.opts.setUsageArgs(this.cat.fileOrAppNameOption());
        this.opts.grok(this.arglist);
        if (stringArray.length == 0) {
            this.usage();
            System.exit(0);
        }
        if (this.opts.hasOption(CONFIG)) {
            this.config = this.opts.getOption(CONFIG);
        }
        this.initFromConfig();
        if (this.opts.hasOption(VERBOSE)) {
            this.setVerbose(true);
        }
        if (this.opts.hasOption(QUIET)) {
            this.setQuiet(true);
        }
        if (this.opts.hasOption(DEBUG)) {
            this.setDebug(true);
        }
        if (this.opts.hasOption(REMOTE)) {
            this.remote = true;
        }
        if (this.opts.hasOption(HOST)) {
            this.host = this.opts.getOption(HOST);
        }
        if (this.opts.hasOption(PORT)) {
            this.port = this.opts.getOption(PORT);
        }
        if (this.opts.hasOption(USER)) {
            this.user = this.opts.getOption(USER);
        }
        if (this.opts.hasOption(PASSWORD)) {
            this.password = this.opts.getOption(PASSWORD);
        }
        if (this.opts.hasOption(USEPLAN)) {
            this.usePlan = this.opts.getOption(USEPLAN);
        }
        if (this.opts.hasOption(SAVEPLAN)) {
            this.savePlan = this.opts.getOption(SAVEPLAN);
        }
        if (this.opts.hasOption(TARGETS)) {
            this.targets = new HashSet();
            this.targs = this.trim(this.opts.getOption(TARGETS));
            stringTokenizer = new StringTokenizer(this.targs, ",");
            while (stringTokenizer.hasMoreTokens()) {
                this.targets.add(stringTokenizer.nextToken());
            }
        }
        if (this.opts.hasOption(PLUGIN)) {
            this.plugin = this.opts.getOption(PLUGIN);
        }
        if (this.opts.hasOption(TYPE)) {
            this.setModuleType(this.opts.getOption(TYPE));
        }
        if (this.opts.hasOption(NAME)) {
            this.setAppName(this.opts.getOption(NAME));
        }
        if (this.opts.hasOption(MODULES)) {
            this.mods = this.trim(this.opts.getOption(MODULES));
            stringTokenizer = new StringTokenizer(this.mods, ",");
            while (stringTokenizer.hasMoreTokens()) {
                this.modules.add(stringTokenizer.nextToken());
            }
        }
        if (this.opts.hasOption(START)) {
            this.command = START;
        }
        if (this.opts.hasOption(DEPLOY)) {
            this.command = DEPLOY;
        }
        if (this.opts.hasOption(STOP)) {
            this.command = STOP;
        }
        if (this.opts.hasOption(DISTRIBUTE)) {
            this.command = DISTRIBUTE;
        }
        if (this.opts.hasOption(UNDEPLOY)) {
            this.command = UNDEPLOY;
        }
        if (this.opts.hasOption(REDEPLOY)) {
            this.command = REDEPLOY;
        }
        if (this.opts.hasOption(UPDATE)) {
            this.command = UPDATE;
        }
        if (this.opts.hasOption(LISTALL)) {
            this.command = LISTALL;
        }
        if (this.opts.hasOption(LISTSTARTED)) {
            this.command = LISTSTARTED;
        }
        if (this.opts.hasOption(LISTSTOPPED)) {
            this.command = LISTSTOPPED;
        }
        if (this.opts.hasOption(LISTTARGETS)) {
            this.command = LISTTARGETS;
        }
        if (this.opts.hasOption(LISTTYPES)) {
            this.command = LISTTYPES;
        }
        if (this.opts.hasOption(LISTCOMMANDS)) {
            this.command = LISTCOMMANDS;
        }
        if (this.opts.hasOption(STAGE)) {
            this.setStage();
        }
        if (this.opts.args().length > 0) {
            this.fileOrApp = this.opts.args()[0];
            for (int i = 1; i < this.opts.args().length; ++i) {
                this.delta.add(this.opts.args()[i]);
            }
        }
        this.dumpArgs();
        this.factoryClassName = this.getFactoryName();
        this.validateArgs();
        this.targetArray = this.targets.toArray(new String[0]);
    }

    private void setStage() {
        String string = this.opts.getOption(STAGE);
        if (STAGE.equals(string)) {
            this.stage = STAGE;
        } else if ("nostage".equals(string)) {
            this.stage = "nostage";
        } else if ("external".equals(string)) {
            this.stage = "external_stage";
        }
    }

    private void setAppName(String string) {
        this.appName = string;
    }

    private void setModuleType(String string) throws IllegalArgumentException {
        if (string.equalsIgnoreCase("EAR")) {
            this.moduleType = ModuleType.EAR;
        } else if (string.equalsIgnoreCase("EJB")) {
            this.moduleType = ModuleType.EJB;
        } else if (string.equalsIgnoreCase("CAR")) {
            this.moduleType = ModuleType.CAR;
        } else if (string.equalsIgnoreCase("RAR")) {
            this.moduleType = ModuleType.RAR;
        } else if (string.equalsIgnoreCase("WAR")) {
            this.moduleType = ModuleType.WAR;
        } else if (string.equalsIgnoreCase("JMS")) {
            this.moduleType = WebLogicModuleType.JMS;
        } else if (string.equalsIgnoreCase("JDBC")) {
            this.moduleType = WebLogicModuleType.JDBC;
        } else if (string.equalsIgnoreCase("intercept")) {
            this.moduleType = WebLogicModuleType.INTERCEPT;
        } else if (string.equalsIgnoreCase(CONFIG)) {
            this.moduleType = WebLogicModuleType.CONFIG;
        } else if (string.equalsIgnoreCase("submodule")) {
            this.moduleType = WebLogicModuleType.SUBMODULE;
        } else if (string.equalsIgnoreCase("wldf")) {
            this.moduleType = WebLogicModuleType.WLDF;
        } else {
            throw new IllegalArgumentException(this.cat.badType(string));
        }
    }

    void setVerbose(boolean bl) {
        this.verbose = bl;
        if (this.verbose) {
            this.quiet = false;
        }
    }

    void setQuiet(boolean bl) {
        this.quiet = bl;
        if (this.quiet) {
            this.verbose = false;
        }
    }

    void setDebug(boolean bl) {
        this.debug = bl;
        if (this.debug) {
            this.setVerbose(true);
        }
        String string = this.debug ? "all:internal" : "";
        System.setProperty("weblogic.deployer.debug", string);
    }

    private void usage() {
        this.opts.usageError(this.name);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getFactoryName() throws IllegalArgumentException {
        String string = null;
        if (this.plugin != null) {
            try {
                JarFile jarFile = new JarFile(this.plugin);
                Manifest manifest = jarFile.getManifest();
                if (manifest == null) return string;
                Attributes attributes = manifest.getMainAttributes();
                string = attributes.getValue(FACTORY);
                if (this.debug) {
                    this.print("Getting factory from plugin");
                }
                this.inform(this.cat.factoryClassName(string));
                return string;
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException(this.cat.badArchive(this.plugin, iOException.toString()));
            }
        } else {
            string = DEFAULT_FACTORY;
            if (this.debug) {
                this.print("Getting factory from defaults");
            }
            this.inform(this.cat.factoryClassName(string));
        }
        return string;
    }

    private void initFromConfig() throws IllegalArgumentException {
        File file = new File(DEFAULT_CONFIG);
        File file2 = new File(this.config);
        boolean bl = file.equals(file2);
        try {
            FileInputStream fileInputStream = new FileInputStream(new File(this.config));
            Properties properties = new Properties();
            properties.load(fileInputStream);
            String string = properties.getProperty(PORT);
            if (string != null) {
                this.port = string;
            }
            if ((string = properties.getProperty(HOST)) != null) {
                this.host = string;
            }
            if ((string = properties.getProperty(USER)) != null) {
                this.user = string;
            }
            if ((string = properties.getProperty(PASSWORD)) != null) {
                this.password = string;
            }
            if ((string = properties.getProperty(VERBOSE)) != null) {
                this.setVerbose(Boolean.valueOf(string));
            }
            if ((string = properties.getProperty(REMOTE)) != null) {
                this.remote = Boolean.valueOf(string);
            }
            if ((string = properties.getProperty(DEBUG)) != null) {
                this.setDebug(Boolean.valueOf(string));
            }
            if ((string = properties.getProperty(QUIET)) != null) {
                this.setQuiet(Boolean.valueOf(string));
            }
            if ((string = properties.getProperty(USEPLAN)) != null) {
                this.usePlan = string;
            }
            if ((string = properties.getProperty(SAVEPLAN)) != null) {
                this.savePlan = string;
            }
            if ((string = properties.getProperty(TARGETS)) != null) {
                this.targets = new HashSet();
                this.targs = this.trim(string);
                StringTokenizer stringTokenizer = new StringTokenizer(this.targs, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    this.targets.add(stringTokenizer.nextToken());
                }
            }
            if ((string = properties.getProperty(PLUGIN)) != null) {
                this.plugin = string;
            }
            if ((string = properties.getProperty(TYPE)) != null) {
                this.setModuleType(string);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (!bl) {
                throw new IllegalArgumentException(this.cat.noConfig(this.config));
            }
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException(this.cat.badConfig(this.config, iOException.toString()));
        }
    }

    private String trim(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (string != null) {
            char[] cArray = string.toCharArray();
            for (int i = 0; i < cArray.length; ++i) {
                char c = cArray[i];
                if (Character.isWhitespace(c)) continue;
                stringBuffer.append(c);
            }
        }
        return stringBuffer.toString();
    }

    private void validateArgs() throws IllegalArgumentException {
        File file;
        String string = null;
        if (this.host == null || this.host.length() == 0) {
            string = this.cat.badHost();
            this.error(string);
        }
        if (this.port == null || this.port.length() == 0) {
            string = this.cat.badPort();
            this.error(string);
        }
        if (this.user == null || this.user.length() == 0) {
            string = this.cat.badUser();
            this.error(string);
        }
        if (!(this.usePlan == null || this.usePlan.length() <= 0 || (file = new File(this.usePlan)).exists() && !file.isDirectory() && file.canRead())) {
            string = this.cat.badUsePlan(this.usePlan);
            this.error(string);
        }
        if (this.savePlan != null && this.savePlan.length() > 0 && (!(file = new File(this.savePlan)).getParentFile().exists() || file.isDirectory() || file.exists() && !file.canWrite())) {
            string = this.cat.badSavePlan(this.savePlan);
            this.error(string);
        }
        if (this.command == null) {
            string = this.cat.noCommand();
            this.error(string);
        } else {
            if (!this.command.startsWith("list") && this.targets.isEmpty()) {
                string = this.cat.noTargets(this.command);
                this.error(string);
            }
            if ((this.fileOrApp == null || this.fileOrApp.length() == 0) && (START.equalsIgnoreCase(this.command) || STOP.equalsIgnoreCase(this.command) || DEPLOY.equalsIgnoreCase(this.command) || DISTRIBUTE.equalsIgnoreCase(this.command) || REDEPLOY.equalsIgnoreCase(this.command) || UPDATE.equalsIgnoreCase(this.command) || UNDEPLOY.equalsIgnoreCase(this.command))) {
                string = this.cat.missingFileOrApp(this.command);
                this.error(string);
            }
            if ((this.usePlan == null || this.usePlan.length() == 0) && UPDATE.equalsIgnoreCase(this.command)) {
                string = this.cat.missingPlan();
                this.error(string);
            }
            if (this.factoryClassName == null || this.factoryClassName.length() == 0) {
                string = this.cat.noFactory();
                this.error(string);
            }
            if (!(this.moduleType != null || !this.command.startsWith("LIST") || this.command.equals(LISTTARGETS) && this.command.equals(LISTTYPES) && this.command.equals(LISTCOMMANDS))) {
                string = this.cat.noType();
                this.error(string);
            }
            if (this.moduleType == null && !this.command.startsWith("LIST")) {
                string = this.cat.noType();
                this.error(string);
            }
            if (this.appName == null && REDEPLOY.equalsIgnoreCase(this.command)) {
                string = this.cat.noName();
                this.error(string);
            }
        }
        for (int i = 0; i < this.opts.args().length; ++i) {
            if (!this.opts.args()[i].startsWith("-")) continue;
            string = this.cat.unrecognizedArg(this.opts.args()[i]);
            this.error(string);
        }
        if (string != null) {
            this.usage();
            throw new IllegalArgumentException(string);
        }
    }

    void dumpArgs() {
        this.inform(this.cat.nameValue(HOST, this.host));
        this.inform(this.cat.nameValue(PORT, this.port));
        this.inform(this.cat.nameValue(USER, this.user));
        this.inform(this.cat.nameValue(VERBOSE, Boolean.toString(this.verbose)));
        this.inform(this.cat.nameValue(DEBUG, Boolean.toString(this.debug)));
        this.inform(this.cat.nameValue(QUIET, Boolean.toString(this.quiet)));
        this.inform(this.cat.nameValue(REMOTE, Boolean.toString(this.remote)));
        this.inform(this.cat.nameValue(USEPLAN, this.usePlan));
        this.inform(this.cat.nameValue(SAVEPLAN, this.savePlan));
        this.inform(this.cat.nameValue(TARGETS, this.targs));
        this.inform(this.cat.nameValue(PLUGIN, this.plugin));
        this.inform(this.cat.nameValue(CONFIG, this.config));
        String string = "";
        if (this.moduleType != null) {
            string = this.moduleType.toString();
        }
        this.inform(this.cat.nameValue(TYPE, string));
    }

    void print(String string) {
        if (!this.quiet) {
            System.out.println(string);
        }
    }

    void inform(String string) {
        if (this.verbose) {
            System.out.println(string);
        }
    }

    String error(String string) {
        System.err.println(string);
        return string;
    }
}

