/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.api.tools.samples;

import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.deploy.shared.CommandType;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.shared.StateType;
import javax.enterprise.deploy.shared.factories.DeploymentFactoryManager;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.TargetException;
import javax.enterprise.deploy.spi.factories.DeploymentFactory;
import javax.enterprise.deploy.spi.status.DeploymentStatus;
import javax.enterprise.deploy.spi.status.ProgressEvent;
import javax.enterprise.deploy.spi.status.ProgressListener;
import javax.enterprise.deploy.spi.status.ProgressObject;
import weblogic.deploy.api.shared.WebLogicCommandType;
import weblogic.deploy.api.shared.WebLogicModuleType;
import weblogic.deploy.api.spi.DeploymentOptions;
import weblogic.deploy.api.spi.WebLogicDeploymentManager;
import weblogic.deploy.api.spi.WebLogicTargetModuleID;
import weblogic.deploy.api.spi.factories.WebLogicDeploymentFactory;
import weblogic.deploy.api.tools.samples.Config;
import weblogic.deploy.api.tools.samples.J2EEDeployerToolTextFormatter;

public class J2EEDeployer {
    private Config cfg;
    private J2EEDeployerToolTextFormatter cat;
    private boolean failed = false;
    private DeploymentOptions options;
    private int indent = 0;

    public static void main(String[] stringArray) {
        try {
            J2EEDeployer j2EEDeployer = new J2EEDeployer(new Config(stringArray, J2EEDeployer.class.getName()));
            j2EEDeployer.run();
        }
        catch (Exception exception) {
            System.err.println(exception.toString());
            if (exception instanceof RuntimeException && !(exception instanceof IllegalArgumentException)) {
                exception.printStackTrace();
            }
            System.exit(1);
        }
    }

    private J2EEDeployer(Config config) {
        this.cfg = config;
        this.cat = J2EEDeployerToolTextFormatter.getInstance();
    }

    private void fail() {
        System.exit(1);
    }

    private void dumpStack(Throwable throwable) {
        throwable.printStackTrace();
        for (Throwable throwable2 = throwable.getCause(); throwable2 != null; throwable2 = throwable2.getCause()) {
            this.cfg.error("Nested cause:");
            throwable2.printStackTrace();
        }
    }

    private DeploymentOptions createOptions() {
        DeploymentOptions deploymentOptions = new DeploymentOptions();
        deploymentOptions.setStageMode(this.cfg.stage);
        return deploymentOptions;
    }

    private void run() throws IllegalArgumentException {
        this.options = this.createOptions();
        if (this.cfg.command.equalsIgnoreCase("listtypes")) {
            this.dumpModuleTypes();
            return;
        }
        if (this.cfg.command.equalsIgnoreCase("listcommands")) {
            this.dumpCommandTypes();
            return;
        }
        this.cfg.inform(this.cat.registerFactory());
        WebLogicDeploymentFactory webLogicDeploymentFactory = (WebLogicDeploymentFactory)this.registerFactory();
        try {
            this.cfg.inform(this.cat.getDM());
            WebLogicDeploymentManager webLogicDeploymentManager = (WebLogicDeploymentManager)webLogicDeploymentFactory.getDeploymentManager(this.getConnectedURI(webLogicDeploymentFactory), this.cfg.user, this.cfg.password);
            if (this.cfg.command.equalsIgnoreCase("listtargets")) {
                this.doListTargets(webLogicDeploymentManager);
            } else {
                this.cfg.inform(this.cat.collectTargets());
                Target[] targetArray = this.getTargets(webLogicDeploymentManager, this.cfg.targets);
                if (this.cfg.command.equalsIgnoreCase("distribute")) {
                    this.doDistribute(webLogicDeploymentManager, targetArray);
                } else if (this.cfg.command.equalsIgnoreCase("start")) {
                    this.doStart(webLogicDeploymentManager, targetArray);
                } else if (this.cfg.command.equalsIgnoreCase("deploy")) {
                    this.doDeploy(webLogicDeploymentManager, targetArray);
                } else if (this.cfg.command.equalsIgnoreCase("stop")) {
                    this.doStop(webLogicDeploymentManager, targetArray);
                } else if (this.cfg.command.equalsIgnoreCase("undeploy")) {
                    this.doUndeploy(webLogicDeploymentManager, targetArray);
                } else if (this.cfg.command.equalsIgnoreCase("listall")) {
                    this.doListAll(webLogicDeploymentManager, targetArray);
                } else if (this.cfg.command.equalsIgnoreCase("liststarted")) {
                    this.doListStarted(webLogicDeploymentManager, targetArray);
                } else if (this.cfg.command.equalsIgnoreCase("liststopped")) {
                    this.doListStopped(webLogicDeploymentManager, targetArray);
                } else if (this.cfg.command.equalsIgnoreCase("redeploy")) {
                    this.doRedeploy(webLogicDeploymentManager, targetArray);
                } else if (this.cfg.command.equalsIgnoreCase("update")) {
                    this.doUpdate(webLogicDeploymentManager, targetArray);
                }
            }
        }
        catch (Exception exception) {
            this.cfg.error(exception.toString());
            if (exception instanceof RuntimeException || this.cfg.debug) {
                this.dumpStack(exception);
            }
            this.fail();
        }
        if (this.failed) {
            this.cfg.inform("Exiting with failed status");
            this.fail();
        }
    }

    private String getConnectedURI(WebLogicDeploymentFactory webLogicDeploymentFactory) {
        int n = this.cfg.remote ? 1 : 0;
        return webLogicDeploymentFactory.createUri(webLogicDeploymentFactory.getUris()[n], this.cfg.host, this.cfg.port);
    }

    private DeploymentFactory registerFactory() throws IllegalArgumentException {
        try {
            Class<?> clazz = Class.forName(this.cfg.factoryClassName);
            if (DeploymentFactory.class.isAssignableFrom(clazz)) {
                DeploymentFactory deploymentFactory = (DeploymentFactory)clazz.newInstance();
                DeploymentFactoryManager.getInstance().registerDeploymentFactory(deploymentFactory);
                this.cfg.inform(this.cat.registeredFactory(this.cfg.factoryClassName));
                return deploymentFactory;
            }
            throw new IllegalArgumentException(this.cfg.error(this.cat.invalidFactory(this.cfg.factoryClassName)));
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (this.cfg.debug) {
                this.dumpStack(classNotFoundException);
            }
            throw new IllegalArgumentException(this.cfg.error(this.cat.invalidFactoryException(this.cfg.factoryClassName, classNotFoundException.toString())));
        }
        catch (InstantiationException instantiationException) {
            if (this.cfg.debug) {
                this.dumpStack(instantiationException);
            }
            throw new IllegalArgumentException(this.cfg.error(this.cat.invalidFactoryException(this.cfg.factoryClassName, instantiationException.toString())));
        }
        catch (IllegalAccessException illegalAccessException) {
            if (this.cfg.debug) {
                this.dumpStack(illegalAccessException);
            }
            throw new IllegalArgumentException(this.cfg.error(this.cat.invalidFactoryException(this.cfg.factoryClassName, illegalAccessException.toString())));
        }
    }

    private Target[] getTargets(DeploymentManager deploymentManager, Set set) throws IllegalStateException {
        int n;
        Target[] targetArray = deploymentManager.getTargets();
        if (this.cfg.debug) {
            this.cfg.print("Configured targets:");
            for (n = 0; n < targetArray.length; ++n) {
                this.cfg.print("  " + targetArray[n].getName() + "(" + targetArray[n].getDescription() + ")");
            }
        }
        if (set.isEmpty()) {
            return targetArray;
        }
        ArrayList<Target> arrayList = new ArrayList<Target>();
        for (n = 0; n < targetArray.length; ++n) {
            if (!set.contains(targetArray[n].getName())) continue;
            arrayList.add(targetArray[n]);
            if (!this.cfg.debug) continue;
            this.cfg.print("Targeting " + targetArray[n].getName() + "(" + targetArray[n].getDescription() + ")");
        }
        if (arrayList.isEmpty()) {
            String string = this.cfg.error(this.cat.noValidTargets());
            this.cfg.dumpArgs();
            throw new IllegalArgumentException(string);
        }
        if (arrayList.size() < set.size()) {
            // empty if block
        }
        return arrayList.toArray(new Target[0]);
    }

    private void doListTargets(DeploymentManager deploymentManager) {
        Target[] targetArray = deploymentManager.getTargets();
        targetArray = deploymentManager.getTargets();
        this.cfg.inform("Configured targets:");
        for (int i = 0; i < targetArray.length; ++i) {
            this.cfg.print(targetArray[i].toString());
        }
    }

    private void doDistribute(WebLogicDeploymentManager webLogicDeploymentManager, Target[] targetArray) throws IllegalStateException {
        ProgressObject progressObject;
        this.cfg.inform(this.cat.distribute(this.cfg.fileOrApp));
        boolean bl = true;
        if (bl) {
            try {
                progressObject = webLogicDeploymentManager.distribute(targetArray, new FileInputStream(new File(this.cfg.fileOrApp)), this.cfg.usePlan == null ? null : new FileInputStream(new File(this.cfg.usePlan)));
            }
            catch (Exception exception) {
                this.cfg.error(exception.toString());
                return;
            }
        } else {
            progressObject = webLogicDeploymentManager.distribute(targetArray, new File(this.cfg.fileOrApp), this.cfg.usePlan == null ? null : new File(this.cfg.usePlan));
        }
        this.wait(progressObject);
        this.results(progressObject);
        TargetModuleID[] targetModuleIDArray = new TargetModuleID[]{};
        try {
            targetModuleIDArray = webLogicDeploymentManager.getAvailableModules(this.cfg.moduleType, targetArray);
        }
        catch (TargetException targetException) {
            targetException.printStackTrace();
        }
        this.cfg.inform("+++++++++++++++++available modules:");
        for (int i = 0; i < targetModuleIDArray.length; ++i) {
            TargetModuleID targetModuleID = targetModuleIDArray[i];
            this.cfg.inform(targetModuleID.toString());
        }
    }

    private void doDeploy(WebLogicDeploymentManager webLogicDeploymentManager, Target[] targetArray) throws IllegalStateException {
        this.cfg.inform(this.cat.deploy(this.cfg.fileOrApp));
        try {
            Set set = this.getTmids(targetArray, this.cfg.appName, webLogicDeploymentManager);
            if (set == null) {
                this.cfg.error(this.cat.noTmidsToDeploy(this.cfg.fileOrApp, this.cfg.moduleType.toString()));
                return;
            }
            ProgressObject progressObject = webLogicDeploymentManager.deploy(set.toArray(new TargetModuleID[0]), new File(this.cfg.fileOrApp), this.cfg.usePlan == null ? null : new File(this.cfg.usePlan), this.options);
            this.wait(progressObject);
            this.results(progressObject);
        }
        catch (TargetException targetException) {
            this.cfg.error(targetException.toString());
        }
    }

    private void doStart(WebLogicDeploymentManager webLogicDeploymentManager, Target[] targetArray) throws IllegalStateException {
        this.cfg.inform(this.cat.start(this.cfg.fileOrApp));
        Set set = this.getTmids(targetArray, this.cfg.appName, webLogicDeploymentManager);
        if (set == null) {
            this.cfg.error(this.cat.noTmidsToDeploy(this.cfg.fileOrApp, this.cfg.moduleType.toString()));
            return;
        }
        ProgressObject progressObject = webLogicDeploymentManager.start(set.toArray(new TargetModuleID[0]), this.options);
        this.wait(progressObject);
        this.results(progressObject);
    }

    private void doRedeploy(WebLogicDeploymentManager webLogicDeploymentManager, Target[] targetArray) throws IllegalStateException {
        this.cfg.inform(this.cat.redeploy(this.cfg.fileOrApp));
        Set set = this.getTmids(targetArray, this.cfg.appName, webLogicDeploymentManager);
        if (set.isEmpty()) {
            this.cfg.error(this.cat.noTmidsToDeploy(this.cfg.fileOrApp, this.cfg.moduleType.toString()));
            return;
        }
        ProgressObject progressObject = !this.cfg.delta.isEmpty() ? webLogicDeploymentManager.redeploy(set.toArray(new TargetModuleID[0]), new File(this.cfg.fileOrApp), this.cfg.delta.toArray(new String[0]), this.options) : webLogicDeploymentManager.redeploy(set.toArray(new TargetModuleID[0]), new File(this.cfg.fileOrApp), this.cfg.usePlan == null ? null : new File(this.cfg.usePlan), this.options);
        this.wait(progressObject);
        this.results(progressObject);
    }

    private void doUpdate(WebLogicDeploymentManager webLogicDeploymentManager, Target[] targetArray) throws IllegalStateException {
        this.cfg.inform(this.cat.update(this.cfg.fileOrApp, this.cfg.usePlan));
        Set set = this.getTmids(targetArray, this.cfg.appName, webLogicDeploymentManager);
        if (set.isEmpty()) {
            this.cfg.error(this.cat.noTmidsToDeploy(this.cfg.fileOrApp, this.cfg.moduleType.toString()));
            return;
        }
        ProgressObject progressObject = webLogicDeploymentManager.update(set.toArray(new TargetModuleID[0]), new File(this.cfg.usePlan), this.options);
        this.wait(progressObject);
        this.results(progressObject);
    }

    private Set getTmids(Target[] targetArray, String string, WebLogicDeploymentManager webLogicDeploymentManager) {
        String string2 = string;
        if (string2 == null) {
            string2 = this.cfg.fileOrApp;
        }
        File file = new File(string2);
        string2 = file.getName();
        if (this.cfg.debug) {
            this.cfg.inform("getting tmids for " + string2);
        }
        HashSet<WebLogicTargetModuleID> hashSet = new HashSet<WebLogicTargetModuleID>();
        for (int i = 0; i < targetArray.length; ++i) {
            Target target = targetArray[i];
            WebLogicTargetModuleID webLogicTargetModuleID = webLogicDeploymentManager.createTargetModuleID(string2, this.cfg.moduleType, target);
            if (!this.cfg.modules.isEmpty()) {
                for (String string3 : this.cfg.modules) {
                    webLogicTargetModuleID = webLogicDeploymentManager.createTargetModuleID(webLogicTargetModuleID, string3, WebLogicModuleType.UNKNOWN);
                    hashSet.add(webLogicTargetModuleID);
                }
                continue;
            }
            hashSet.add(webLogicTargetModuleID);
        }
        return hashSet;
    }

    private void doStop(WebLogicDeploymentManager webLogicDeploymentManager, Target[] targetArray) throws IllegalStateException {
        this.cfg.inform(this.cat.stop(this.cfg.fileOrApp));
        Set set = this.getTmids(targetArray, this.cfg.appName, webLogicDeploymentManager);
        if (set == null) {
            this.cfg.error(this.cat.noTmidsToDeploy(this.cfg.fileOrApp, this.cfg.moduleType.toString()));
            return;
        }
        ProgressObject progressObject = webLogicDeploymentManager.stop(set.toArray(new TargetModuleID[0]));
        this.wait(progressObject);
        this.results(progressObject);
    }

    private void doUndeploy(WebLogicDeploymentManager webLogicDeploymentManager, Target[] targetArray) throws IllegalStateException {
        this.cfg.inform(this.cat.undeploy(this.cfg.fileOrApp));
        Set set = this.getTmids(targetArray, this.cfg.appName, webLogicDeploymentManager);
        if (set == null) {
            this.cfg.error(this.cat.noTmidsToDeploy(this.cfg.fileOrApp, this.cfg.moduleType.toString()));
            return;
        }
        ProgressObject progressObject = !this.cfg.delta.isEmpty() ? webLogicDeploymentManager.undeploy(set.toArray(new TargetModuleID[0]), new File(this.cfg.fileOrApp), this.cfg.delta.toArray(new String[0]), this.options) : webLogicDeploymentManager.undeploy(set.toArray(new TargetModuleID[0]));
        this.wait(progressObject);
        this.results(progressObject);
    }

    private void doListAll(DeploymentManager deploymentManager, Target[] targetArray) throws TargetException, IllegalStateException {
        this.cfg.inform(this.cat.listAll());
        TargetModuleID[] targetModuleIDArray = deploymentManager.getAvailableModules(this.cfg.moduleType, targetArray);
        this.showTMIDs(targetModuleIDArray);
    }

    private void doListStopped(DeploymentManager deploymentManager, Target[] targetArray) throws TargetException, IllegalStateException {
        this.cfg.inform(this.cat.listStopped());
        TargetModuleID[] targetModuleIDArray = deploymentManager.getNonRunningModules(this.cfg.moduleType, targetArray);
        this.showTMIDs(targetModuleIDArray);
    }

    private void doListStarted(DeploymentManager deploymentManager, Target[] targetArray) throws TargetException, IllegalStateException {
        this.cfg.inform(this.cat.listStarted());
        TargetModuleID[] targetModuleIDArray = deploymentManager.getRunningModules(this.cfg.moduleType, targetArray);
        this.showTMIDs(targetModuleIDArray);
    }

    private void results(ProgressObject progressObject) {
        this.cfg.print("Modules processed:");
        this.showTMIDs(progressObject.getResultTargetModuleIDs());
    }

    private void showTMIDs(TargetModuleID[] targetModuleIDArray) {
        int n;
        String string = "";
        for (n = 0; n < this.indent; ++n) {
            string = string + "   ";
        }
        if (this.indent == 0) {
            this.cfg.inform(this.cat.listHeader());
        }
        ++this.indent;
        if (targetModuleIDArray != null) {
            for (n = 0; n < targetModuleIDArray.length; ++n) {
                this.cfg.print(string + targetModuleIDArray[n].toString());
                TargetModuleID[] targetModuleIDArray2 = targetModuleIDArray[n].getChildTargetModuleID();
                if (targetModuleIDArray2 == null) continue;
                this.showTMIDs(targetModuleIDArray2);
            }
        }
        --this.indent;
    }

    void wait(ProgressObject progressObject) {
        StateType stateType;
        ProgressHandler progressHandler = new ProgressHandler();
        if (!progressObject.getDeploymentStatus().isRunning()) {
            this.showStatus(progressObject.getDeploymentStatus(), true);
            this.failed = progressObject.getDeploymentStatus().isFailed();
            return;
        }
        progressObject.addProgressListener((ProgressListener)progressHandler);
        progressHandler.start();
        while (progressHandler.getCompletionState() == null) {
            try {
                progressHandler.join();
            }
            catch (InterruptedException interruptedException) {
                if (progressHandler.isAlive()) continue;
                break;
            }
        }
        this.failed = (stateType = progressHandler.getCompletionState()) == null || stateType.getValue() == StateType.FAILED.getValue();
        progressObject.removeProgressListener((ProgressListener)progressHandler);
    }

    void showStatus(DeploymentStatus deploymentStatus, boolean bl) {
        if (bl || !this.cfg.quiet) {
            String string = deploymentStatus.getCommand().toString();
            String string2 = deploymentStatus.getState().toString();
            String string3 = deploymentStatus.getMessage();
            this.cfg.print(this.cat.showStatus(string, string2, string3));
        }
    }

    private void dumpModuleTypes() {
        String[] stringArray = WebLogicModuleType.JMS.getStringTable();
        ModuleType[] moduleTypeArray = WebLogicModuleType.JMS.getEnumValueTable();
        this.cfg.print("Available types:");
        for (int i = 0; i < stringArray.length; ++i) {
            this.cfg.print(moduleTypeArray[i].getValue() + ":" + stringArray[i]);
        }
    }

    private void dumpCommandTypes() {
        String[] stringArray = WebLogicCommandType.DEPLOY.getStringTable();
        CommandType[] commandTypeArray = WebLogicCommandType.DEPLOY.getEnumValueTable();
        this.cfg.print("Available commands:");
        for (int i = 0; i < stringArray.length; ++i) {
            this.cfg.print(commandTypeArray[i].getValue() + ":" + stringArray[i]);
        }
    }

    class ProgressHandler
    extends Thread
    implements ProgressListener {
        boolean progressDone = false;
        StateType finalState = null;

        ProgressHandler() {
        }

        public void run() {
            while (!this.progressDone) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        public void handleProgressEvent(ProgressEvent progressEvent) {
            DeploymentStatus deploymentStatus = progressEvent.getDeploymentStatus();
            TargetModuleID targetModuleID = progressEvent.getTargetModuleID();
            if (targetModuleID != null) {
                J2EEDeployer.this.cfg.inform(J2EEDeployer.this.cat.progressTmid(targetModuleID.toString()));
            }
            J2EEDeployer.this.showStatus(deploymentStatus, ((J2EEDeployer)J2EEDeployer.this).cfg.verbose);
            if (deploymentStatus.getState().getValue() != StateType.RUNNING.getValue()) {
                this.progressDone = true;
                this.finalState = deploymentStatus.getState();
            }
        }

        public StateType getCompletionState() {
            return this.finalState;
        }
    }
}

