/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.beans.factory.internal;

import java.io.File;
import java.io.FileNotFoundException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.management.InvalidAttributeValueException;
import weblogic.application.utils.ApplicationVersionUtils;
import weblogic.deploy.api.shared.WebLogicModuleType;
import weblogic.deploy.beans.factory.DeploymentBeanFactory;
import weblogic.deploy.beans.factory.InvalidTargetException;
import weblogic.deploy.common.Debug;
import weblogic.deploy.internal.TargetHelper;
import weblogic.descriptor.BeanUpdateEvent;
import weblogic.descriptor.DescriptorBean;
import weblogic.management.DistributedManagementException;
import weblogic.management.ManagementException;
import weblogic.management.WebLogicMBean;
import weblogic.management.configuration.AppDeploymentMBean;
import weblogic.management.configuration.BasicDeploymentMBean;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.LibraryMBean;
import weblogic.management.configuration.SubDeploymentMBean;
import weblogic.management.configuration.TargetInfoMBean;
import weblogic.management.configuration.TargetMBean;
import weblogic.management.deploy.DeploymentData;
import weblogic.management.deploy.internal.MBeanConverter;
import weblogic.management.provider.ManagementService;
import weblogic.management.utils.AppDeploymentHelper;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;

public final class DeploymentBeanFactoryImpl
implements DeploymentBeanFactory {
    private DomainMBean editableDomain = null;
    private boolean callerOwnsEditLock = false;
    private DomainMBean runtimeDomain = null;
    private HashMap deployerInitiatedBeanUpdates = new HashMap();
    private static final String LIBRARIES_PROP_NAME = "Libraries";
    private static final String APP_DEPLOYMENTS_PROP_NAME = "AppDeployments";
    private static final String SUB_DEPLOYMENTS_PROP_NAME = "SubDeployments";
    private static final String TARGETS_PROP_NAME = "Targets";
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    public final AppDeploymentMBean createAppDeploymentMBean(String string, File file, DeploymentData deploymentData) throws InvalidTargetException, FileNotFoundException, ManagementException {
        AppDeploymentMBean appDeploymentMBean;
        if (deploymentData.isLibrary()) {
            appDeploymentMBean = this.getEditableDomain().createLibrary(string, file.getPath());
            this.addBeanUpdate(this.getEditableDomain(), LIBRARIES_PROP_NAME, 2, appDeploymentMBean);
        } else {
            try {
                appDeploymentMBean = this.getEditableDomain().createAppDeployment(string, file.getPath());
                this.addBeanUpdate(this.getEditableDomain(), APP_DEPLOYMENTS_PROP_NAME, 2, appDeploymentMBean);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Throwable throwable = illegalArgumentException.getCause();
                if (throwable != null) {
                    if (throwable instanceof ManagementException) {
                        throw (ManagementException)throwable;
                    }
                    throw new ManagementException(throwable);
                }
                throw new ManagementException((Throwable)illegalArgumentException);
            }
        }
        try {
            this.addTargetsInDeploymentData(deploymentData, appDeploymentMBean);
        }
        catch (InvalidTargetException invalidTargetException) {
            AppDeploymentHelper.destroyAppOrLib(appDeploymentMBean, this.getEditableDomain());
            throw invalidTargetException;
        }
        appDeploymentMBean.setModuleType(WebLogicModuleType.getFileModuleTypeAsString(file));
        DeploymentBeanFactoryImpl.initialize(appDeploymentMBean, deploymentData);
        return appDeploymentMBean;
    }

    public final BasicDeploymentMBean addTargetsInDeploymentData(DeploymentData deploymentData, BasicDeploymentMBean basicDeploymentMBean) throws InvalidTargetException, ManagementException {
        this.addGlobalTargetsToDeployable(deploymentData, basicDeploymentMBean);
        this.addModuleTargetsToDeployable(deploymentData, basicDeploymentMBean);
        this.addSubModuleTargetsToDeployable(deploymentData, basicDeploymentMBean);
        return basicDeploymentMBean;
    }

    public final BasicDeploymentMBean removeTargetsInDeploymentData(DeploymentData deploymentData, BasicDeploymentMBean basicDeploymentMBean) throws InvalidTargetException {
        if (deploymentData == null) {
            return basicDeploymentMBean;
        }
        InvalidTargetException invalidTargetException = null;
        try {
            this.rmGlobalTargets(deploymentData, basicDeploymentMBean);
        }
        catch (InvalidTargetException invalidTargetException2) {
            invalidTargetException = invalidTargetException2;
        }
        this.rmModuleTargets(deploymentData, basicDeploymentMBean);
        this.rmSubModuleTargets(deploymentData, basicDeploymentMBean);
        boolean bl = this.rmGlobalTargetsPropagateToModules(deploymentData, basicDeploymentMBean);
        boolean bl2 = this.rmGlobalTargetsPropagateToSubModules(deploymentData, basicDeploymentMBean);
        if (!bl && !bl2 && null != invalidTargetException) {
            throw invalidTargetException;
        }
        return basicDeploymentMBean;
    }

    public final void removeMBean(AppDeploymentMBean appDeploymentMBean) throws ManagementException {
        DomainMBean domainMBean = this.getEditableDomain();
        if (MBeanConverter.isDebugEnabled()) {
            MBeanConverter.debug("DeploymentBeanFactory: Destroy " + appDeploymentMBean.getObjectName() + " from " + domainMBean.getObjectName());
        }
        AppDeploymentHelper.destroyAppOrLib(appDeploymentMBean, domainMBean);
        String string = appDeploymentMBean instanceof LibraryMBean ? LIBRARIES_PROP_NAME : APP_DEPLOYMENTS_PROP_NAME;
        this.addBeanUpdate(domainMBean, string, 3, appDeploymentMBean);
    }

    public final void setEditableDomain(DomainMBean domainMBean, boolean bl) {
        this.editableDomain = domainMBean;
        this.callerOwnsEditLock = bl;
    }

    public final void resetEditableDomain() {
        this.editableDomain = null;
        this.callerOwnsEditLock = false;
    }

    public final DomainMBean getEditableDomain() {
        if (this.editableDomain != null) {
            return this.editableDomain;
        }
        if (this.runtimeDomain == null) {
            this.runtimeDomain = ManagementService.getRuntimeAccess(kernelId).getDomain();
        }
        return this.runtimeDomain;
    }

    public boolean isDeployerInitiatedBeanUpdate(DescriptorBean descriptorBean, BeanUpdateEvent.PropertyUpdate propertyUpdate) {
        ArrayList arrayList = (ArrayList)this.deployerInitiatedBeanUpdates.get(this.getBeanId(descriptorBean));
        if (arrayList == null || arrayList.size() == 0) {
            return false;
        }
        return this.contains(arrayList, propertyUpdate);
    }

    public void resetDeployerInitiatedBeanUpdates() {
        if (Debug.isDeploymentDebugEnabled()) {
            Debug.deploymentDebug("DeploymentBeanFactoryImpl.resetDeployerInitiatedBeanUpdates");
        }
        this.deployerInitiatedBeanUpdates.clear();
    }

    private void rmSubModuleTargets(DeploymentData deploymentData, BasicDeploymentMBean basicDeploymentMBean) throws InvalidTargetException {
        Map map = deploymentData.getAllSubModuleTargets();
        if (deploymentData.isStandaloneModule()) {
            this.rmSubTargets(basicDeploymentMBean.getSubDeployments(), (Map)map.get("_the_standalone_module"));
        } else {
            for (String string : map.keySet()) {
                SubDeploymentMBean subDeploymentMBean = basicDeploymentMBean.lookupSubDeployment(string);
                if (subDeploymentMBean == null) {
                    throw new InvalidTargetException(string);
                }
                this.rmSubTargets(subDeploymentMBean.getSubDeployments(), (Map)map.get(string));
            }
        }
    }

    private void rmSubTargets(SubDeploymentMBean[] subDeploymentMBeanArray, Map map) throws InvalidTargetException {
        block0: for (String string : map.keySet()) {
            for (int i = 0; subDeploymentMBeanArray != null && i < subDeploymentMBeanArray.length; ++i) {
                if (!subDeploymentMBeanArray[i].getName().equals(string)) continue;
                this.removeTarget(subDeploymentMBeanArray[i], (String[])map.get(string));
                TargetMBean[] targetMBeanArray = subDeploymentMBeanArray[i].getTargets();
                if (targetMBeanArray != null && targetMBeanArray.length != 0) continue block0;
                this.removeSubDeployment(subDeploymentMBeanArray[i]);
                continue block0;
            }
        }
    }

    private void rmModuleTargets(DeploymentData deploymentData, BasicDeploymentMBean basicDeploymentMBean) throws InvalidTargetException {
        if (deploymentData.isStandaloneModule()) {
            return;
        }
        Map map = deploymentData.getAllModuleTargets();
        for (String string : map.keySet()) {
            SubDeploymentMBean subDeploymentMBean = basicDeploymentMBean.lookupSubDeployment(string);
            String[] stringArray = (String[])map.get(string);
            if (subDeploymentMBean != null) {
                this.removeTarget(subDeploymentMBean, stringArray);
                continue;
            }
            SubDeploymentMBean subDeploymentMBean2 = this.findOrCreateSubDeployment(string, basicDeploymentMBean);
            TargetMBean[] targetMBeanArray = basicDeploymentMBean.getTargets();
            String[] stringArray2 = new String[targetMBeanArray.length];
            for (int i = 0; targetMBeanArray != null && i < targetMBeanArray.length; ++i) {
                stringArray2[i] = targetMBeanArray[i].getName();
            }
            this.addTargets(subDeploymentMBean2, TargetHelper.lookupTargetMBeans(this.getEditableDomain(), stringArray2));
            this.removeTarget(subDeploymentMBean2, stringArray);
        }
    }

    private boolean rmGlobalTargetsPropagateToModules(DeploymentData deploymentData, BasicDeploymentMBean basicDeploymentMBean) {
        boolean bl = false;
        String[] stringArray = deploymentData.getGlobalTargets();
        SubDeploymentMBean[] subDeploymentMBeanArray = basicDeploymentMBean.getSubDeployments();
        for (int i = 0; i < subDeploymentMBeanArray.length; ++i) {
            try {
                this.removeTarget(subDeploymentMBeanArray[i], stringArray, true);
                bl = true;
                continue;
            }
            catch (InvalidTargetException invalidTargetException) {
                // empty catch block
            }
        }
        return bl;
    }

    private boolean rmGlobalTargetsPropagateToSubModules(DeploymentData deploymentData, BasicDeploymentMBean basicDeploymentMBean) {
        if (deploymentData.isStandaloneModule()) {
            return false;
        }
        boolean bl = false;
        String[] stringArray = deploymentData.getGlobalTargets();
        SubDeploymentMBean[] subDeploymentMBeanArray = basicDeploymentMBean.getSubDeployments();
        for (int i = 0; i < subDeploymentMBeanArray.length; ++i) {
            SubDeploymentMBean[] subDeploymentMBeanArray2 = subDeploymentMBeanArray[i].getSubDeployments();
            for (int j = 0; j < subDeploymentMBeanArray2.length; ++j) {
                try {
                    this.removeTarget(subDeploymentMBeanArray2[j], stringArray);
                    bl = true;
                    continue;
                }
                catch (InvalidTargetException invalidTargetException) {
                    // empty catch block
                }
            }
        }
        return bl;
    }

    private void rmGlobalTargets(DeploymentData deploymentData, BasicDeploymentMBean basicDeploymentMBean) throws InvalidTargetException {
        String[] stringArray = deploymentData.getGlobalTargets();
        this.removeTarget(basicDeploymentMBean, stringArray);
    }

    private void removeTarget(TargetInfoMBean targetInfoMBean, String[] stringArray) throws InvalidTargetException {
        this.removeTarget(targetInfoMBean, stringArray, false);
    }

    private void removeTarget(TargetInfoMBean targetInfoMBean, String[] stringArray, boolean bl) throws InvalidTargetException {
        for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
            boolean bl2 = bl;
            String string = stringArray[i];
            TargetMBean[] targetMBeanArray = targetInfoMBean.getTargets();
            for (int j = 0; targetMBeanArray != null && j < targetMBeanArray.length; ++j) {
                if (!targetMBeanArray[j].getName().equals(string)) continue;
                try {
                    bl2 = true;
                    targetInfoMBean.removeTarget(targetMBeanArray[j]);
                    this.addBeanUpdate(targetInfoMBean, TARGETS_PROP_NAME, 3, targetMBeanArray[j]);
                    continue;
                }
                catch (InvalidAttributeValueException invalidAttributeValueException) {
                    throw new InvalidTargetException(invalidAttributeValueException.toString());
                }
                catch (DistributedManagementException distributedManagementException) {
                    throw new InvalidTargetException(distributedManagementException.toString());
                }
            }
            if (bl2) continue;
            throw new InvalidTargetException(string);
        }
    }

    private void addGlobalTargetsToDeployable(DeploymentData deploymentData, BasicDeploymentMBean basicDeploymentMBean) throws InvalidTargetException {
        this.addTargets(basicDeploymentMBean, TargetHelper.lookupTargetMBeans(this.getEditableDomain(), deploymentData.getGlobalTargets()));
    }

    private void addModuleTargetsToDeployable(DeploymentData deploymentData, BasicDeploymentMBean basicDeploymentMBean) throws InvalidTargetException {
        Map map = deploymentData.getAllModuleTargets();
        for (String string : map.keySet()) {
            String[] stringArray = (String[])map.get(string);
            if (stringArray == null) continue;
            SubDeploymentMBean subDeploymentMBean = this.findOrCreateSubDeployment(string, basicDeploymentMBean);
            this.addTargets(subDeploymentMBean, TargetHelper.lookupTargetMBeans(this.getEditableDomain(), stringArray));
        }
    }

    private SubDeploymentMBean findOrCreateSubDeployment(String string, BasicDeploymentMBean basicDeploymentMBean) {
        SubDeploymentMBean subDeploymentMBean = basicDeploymentMBean.lookupSubDeployment(string);
        if (subDeploymentMBean == null) {
            subDeploymentMBean = basicDeploymentMBean.createSubDeployment(string);
            this.addBeanUpdate(basicDeploymentMBean, SUB_DEPLOYMENTS_PROP_NAME, 2, subDeploymentMBean);
        }
        return subDeploymentMBean;
    }

    private void addTargets(TargetInfoMBean targetInfoMBean, TargetMBean[] targetMBeanArray) throws InvalidTargetException {
        TargetMBean[] targetMBeanArray2 = targetInfoMBean.getTargets();
        for (int i = 0; i < targetMBeanArray.length; ++i) {
            TargetMBean targetMBean = targetMBeanArray[i];
            if (!DeploymentBeanFactoryImpl.isNewTarget(targetMBeanArray2, targetMBean)) continue;
            try {
                targetInfoMBean.addTarget(targetMBean);
                this.addBeanUpdate(targetInfoMBean, TARGETS_PROP_NAME, 2, targetMBean);
                continue;
            }
            catch (InvalidAttributeValueException invalidAttributeValueException) {
                throw new InvalidTargetException(invalidAttributeValueException.toString());
            }
            catch (DistributedManagementException distributedManagementException) {
                throw new InvalidTargetException(distributedManagementException.toString());
            }
        }
    }

    private static boolean isNewTarget(TargetMBean[] targetMBeanArray, TargetMBean targetMBean) {
        if (targetMBeanArray == null) {
            return false;
        }
        for (int i = 0; i < targetMBeanArray.length; ++i) {
            TargetMBean targetMBean2 = targetMBeanArray[i];
            if (!targetMBean2.getName().equals(targetMBean.getName())) continue;
            return false;
        }
        return true;
    }

    private void addSubModuleTargetsToDeployable(DeploymentData deploymentData, BasicDeploymentMBean basicDeploymentMBean) throws InvalidTargetException {
        Map map = deploymentData.getAllSubModuleTargets();
        if (map.isEmpty()) {
            return;
        }
        for (String string : map.keySet()) {
            Map map2 = (Map)map.get(string);
            for (String string2 : map2.keySet()) {
                String[] stringArray = (String[])map2.get(string2);
                SubDeploymentMBean subDeploymentMBean = string.equals("_the_standalone_module") ? this.findOrCreateSubDeployment(string2, basicDeploymentMBean) : this.findOrCreateSubSubDeployment(basicDeploymentMBean, string, string2);
                if (stringArray == null) continue;
                this.addTargets(subDeploymentMBean, TargetHelper.lookupTargetMBeans(this.getEditableDomain(), stringArray));
            }
        }
    }

    private SubDeploymentMBean findOrCreateSubSubDeployment(BasicDeploymentMBean basicDeploymentMBean, String string, String string2) {
        SubDeploymentMBean subDeploymentMBean;
        SubDeploymentMBean subDeploymentMBean2 = basicDeploymentMBean.lookupSubDeployment(string);
        if (subDeploymentMBean2 == null) {
            subDeploymentMBean2 = basicDeploymentMBean.createSubDeployment(string);
            subDeploymentMBean = subDeploymentMBean2.createSubDeployment(string2);
            this.addBeanUpdate(subDeploymentMBean2, SUB_DEPLOYMENTS_PROP_NAME, 2, subDeploymentMBean);
        } else {
            subDeploymentMBean = subDeploymentMBean2.lookupSubDeployment(string2);
            if (subDeploymentMBean == null) {
                subDeploymentMBean = subDeploymentMBean2.createSubDeployment(string2);
                this.addBeanUpdate(subDeploymentMBean2, SUB_DEPLOYMENTS_PROP_NAME, 2, subDeploymentMBean);
            }
        }
        return subDeploymentMBean;
    }

    private static void initialize(AppDeploymentMBean appDeploymentMBean, DeploymentData deploymentData) {
        Object object;
        if (deploymentData.getDeploymentPlan() != null) {
            String[] stringArray;
            if (deploymentData.getConfigDirectory() != null && (stringArray = ((File)(object = new File(deploymentData.getConfigDirectory()))).list()) != null && stringArray.length > 0) {
                appDeploymentMBean.setPlanDir(deploymentData.getConfigDirectory());
            }
            appDeploymentMBean.setPlanPath(deploymentData.getDeploymentPlan());
        }
        if (deploymentData.getAltDescriptorPath() != null) {
            appDeploymentMBean.setAltDescriptorPath(deploymentData.getAltDescriptorPath());
        }
        if (deploymentData.getAltWLSDescriptorPath() != null) {
            appDeploymentMBean.setAltWLSDescriptorPath(deploymentData.getAltWLSDescriptorPath());
        }
        if (deploymentData.isSecurityValidationEnabled()) {
            appDeploymentMBean.setValidateDDSecurityData(true);
        }
        if (deploymentData.getSecurityModel() != null) {
            appDeploymentMBean.setSecurityDDModel(deploymentData.getSecurityModel());
        }
        if (appDeploymentMBean.getVersionIdentifier() != null && (object = ApplicationVersionUtils.getActiveAppDeployment(appDeploymentMBean.getApplicationName())) != null) {
            appDeploymentMBean.setSecurityDDModel(object.getSecurityDDModel());
            if (object.isValidateDDSecurityData() != appDeploymentMBean.isValidateDDSecurityData()) {
                appDeploymentMBean.setValidateDDSecurityData(object.isValidateDDSecurityData());
            }
        }
        if (deploymentData.getDeploymentPrincipalName() != null) {
            appDeploymentMBean.setDeploymentPrincipalName(deploymentData.getDeploymentPrincipalName());
        }
    }

    private void addBeanUpdate(DescriptorBean descriptorBean, String string, int n, Object object) {
        if (!this.callerOwnsEditLock) {
            return;
        }
        String string2 = this.getBeanId(descriptorBean);
        ArrayList<BeanUpdateEvent.PropertyUpdate> arrayList = (ArrayList<BeanUpdateEvent.PropertyUpdate>)this.deployerInitiatedBeanUpdates.get(string2);
        if (arrayList == null) {
            arrayList = new ArrayList<BeanUpdateEvent.PropertyUpdate>();
            this.deployerInitiatedBeanUpdates.put(string2, arrayList);
        }
        BeanUpdateEvent.PropertyUpdate propertyUpdate = arrayList.iterator();
        while (propertyUpdate.hasNext()) {
            BeanUpdateEvent.PropertyUpdate propertyUpdate2 = (BeanUpdateEvent.PropertyUpdate)propertyUpdate.next();
            if (!string.equals(propertyUpdate2.getPropertyName()) || (n != 2 || propertyUpdate2.getUpdateType() != 3 || !object.equals(propertyUpdate2.getAddedObject())) && (n != 3 || propertyUpdate2.getUpdateType() != 2 || !object.equals(propertyUpdate2.getRemovedObject()))) continue;
            if (Debug.isDeploymentDebugEnabled()) {
                Debug.deploymentDebug("DeploymentBeanFactoryImpl.removePropertyUpdate " + propertyUpdate2);
            }
            propertyUpdate.remove();
            return;
        }
        propertyUpdate = new BeanUpdateEvent.PropertyUpdate(string, n, object, true, false, false);
        if (Debug.isDeploymentDebugEnabled()) {
            Debug.deploymentDebug("DeploymentBeanFactoryImpl.addPropertyUpdate  source=" + descriptorBean + ", update=" + propertyUpdate);
        }
        arrayList.add(propertyUpdate);
    }

    private boolean contains(ArrayList arrayList, BeanUpdateEvent.PropertyUpdate propertyUpdate) {
        String string = propertyUpdate.getPropertyName();
        int n = propertyUpdate.getUpdateType();
        if (Debug.isDeploymentDebugEnabled()) {
            Debug.deploymentDebug("DeploymentBeanFactoryImpl.contains deployerUpdates=" + arrayList + ", update=" + propertyUpdate);
        }
        for (BeanUpdateEvent.PropertyUpdate propertyUpdate2 : arrayList) {
            if (!string.equals(propertyUpdate2.getPropertyName()) || n != propertyUpdate2.getUpdateType() || (n != 2 || !this.isEqualBean(propertyUpdate.getAddedObject(), propertyUpdate2.getAddedObject())) && (n != 3 || !this.isEqualBean(propertyUpdate.getRemovedObject(), propertyUpdate2.getRemovedObject()))) continue;
            return true;
        }
        return false;
    }

    private String getBeanId(DescriptorBean descriptorBean) {
        if (descriptorBean instanceof WebLogicMBean) {
            return descriptorBean.getClass().getName() + ":" + ((WebLogicMBean)descriptorBean).getName();
        }
        return descriptorBean.toString();
    }

    private boolean isEqualBean(Object object, Object object2) {
        if (object instanceof WebLogicMBean && object2 instanceof WebLogicMBean) {
            return object.getClass().equals(object2.getClass()) && ((WebLogicMBean)object).getName().equals(((WebLogicMBean)object2).getName());
        }
        return object.equals(object2);
    }

    private void removeSubDeployment(SubDeploymentMBean subDeploymentMBean) {
        WebLogicMBean webLogicMBean = subDeploymentMBean.getParent();
        if (webLogicMBean instanceof AppDeploymentMBean) {
            AppDeploymentMBean appDeploymentMBean = (AppDeploymentMBean)webLogicMBean;
            appDeploymentMBean.destroySubDeployment(subDeploymentMBean);
            this.addBeanUpdate(appDeploymentMBean, SUB_DEPLOYMENTS_PROP_NAME, 3, subDeploymentMBean);
            if (Debug.isDeploymentDebugEnabled()) {
                Debug.deploymentDebug("DeploymentBeanFactoryImpl.removeSubDeployment('" + subDeploymentMBean + "') from '" + appDeploymentMBean + "'");
            }
        } else if (webLogicMBean instanceof SubDeploymentMBean) {
            SubDeploymentMBean[] subDeploymentMBeanArray;
            SubDeploymentMBean subDeploymentMBean2 = (SubDeploymentMBean)webLogicMBean;
            subDeploymentMBean2.destroySubDeployment(subDeploymentMBean);
            this.addBeanUpdate(subDeploymentMBean2, SUB_DEPLOYMENTS_PROP_NAME, 3, subDeploymentMBean);
            if (Debug.isDeploymentDebugEnabled()) {
                Debug.deploymentDebug("DeploymentBeanFactoryImpl.removeSubDeployment('" + subDeploymentMBean + "') from '" + subDeploymentMBean2 + "'");
            }
            if ((subDeploymentMBeanArray = subDeploymentMBean2.getSubDeployments()) == null || subDeploymentMBeanArray.length == 0) {
                this.removeSubDeployment(subDeploymentMBean2);
            }
        }
    }
}

