/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.compatibility;

import java.io.Serializable;
import java.security.AccessController;
import weblogic.application.ModuleListener;
import weblogic.deploy.internal.targetserver.state.AppTransition;
import weblogic.deploy.internal.targetserver.state.DeploymentState;
import weblogic.deploy.internal.targetserver.state.ModuleTransition;
import weblogic.deploy.internal.targetserver.state.TargetModuleState;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.management.configuration.ApplicationMBean;
import weblogic.management.provider.ManagementService;
import weblogic.management.provider.RuntimeAccess;
import weblogic.management.runtime.DeploymentTaskRuntimeMBean;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;

public class NotificationBroadcaster {
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    public static void sendNotificationsFromManagedServer(DeploymentState deploymentState, DeploymentTaskRuntimeMBean deploymentTaskRuntimeMBean, DebugLogger debugLogger) {
        if (null == deploymentState) {
            return;
        }
        ApplicationMBean applicationMBean = deploymentTaskRuntimeMBean.getDeploymentObject();
        if (applicationMBean == null) {
            if (debugLogger.isDebugEnabled()) {
                debugLogger.debug("AppMBean from Task is NULL. No notifs sent.");
            }
            return;
        }
        Object[] objectArray = deploymentState.getTransitions();
        for (int i = 0; objectArray != null && i < objectArray.length; ++i) {
            NotificationBroadcaster.sendJMXNotification(deploymentTaskRuntimeMBean, applicationMBean, objectArray[i]);
        }
    }

    private static void sendJMXNotification(DeploymentTaskRuntimeMBean deploymentTaskRuntimeMBean, ApplicationMBean applicationMBean, Object object) {
        Serializable serializable;
        if (object instanceof ModuleTransition && deploymentTaskRuntimeMBean.getNotificationLevel() >= 2) {
            serializable = (ModuleTransition)object;
            TargetModuleState targetModuleState = ((ModuleTransition)serializable).getModule();
            applicationMBean.sendModuleNotification(targetModuleState.getServerName(), targetModuleState.getModuleId(), ((ModuleTransition)serializable).getName(), ((ModuleTransition)serializable).getCurrentState(), ((ModuleTransition)serializable).getNewState(), deploymentTaskRuntimeMBean.getId(), ((ModuleTransition)serializable).getGenerationTime());
        }
        if (object instanceof AppTransition && deploymentTaskRuntimeMBean.getNotificationLevel() >= 1) {
            serializable = (AppTransition)object;
            applicationMBean.sendAppLevelNotification(((AppTransition)serializable).getServerName(), ((AppTransition)serializable).getXition(), null);
        }
    }

    public static void sendAppNotification(String string, String string2, String string3) {
        RuntimeAccess runtimeAccess = ManagementService.getRuntimeAccess(kernelId);
        ApplicationMBean applicationMBean = runtimeAccess.getDomain().lookupApplication(string2);
        if (applicationMBean != null) {
            applicationMBean.sendAppLevelNotification(ManagementService.getRuntimeAccess(kernelId).getServerName(), string, string3);
        }
    }

    public static boolean isRelevantToWLS81(String string, String string2) {
        boolean bl = string.equals(((Object)ModuleListener.STATE_NEW).toString()) && string2.equals(((Object)ModuleListener.STATE_PREPARED).toString());
        boolean bl2 = string.equals(((Object)ModuleListener.STATE_PREPARED).toString()) && string2.equals(((Object)ModuleListener.STATE_NEW).toString());
        return !bl && !bl2;
    }
}

