/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.event;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Iterator;
import java.util.ListIterator;
import weblogic.application.ApplicationException;
import weblogic.application.ApplicationVersionLifecycleEvent;
import weblogic.application.ApplicationVersionLifecycleListener;
import weblogic.application.utils.ApplicationVersionUtils;
import weblogic.deploy.common.Debug;
import weblogic.deploy.event.BaseDeploymentEvent;
import weblogic.deploy.event.DeploymentEvent;
import weblogic.deploy.event.DeploymentEventListener;
import weblogic.deploy.event.DeploymentEventManager;
import weblogic.deploy.event.DeploymentVetoException;
import weblogic.deploy.event.VetoableDeploymentEvent;
import weblogic.deploy.event.VetoableDeploymentListener;
import weblogic.deploy.service.internal.DeploymentServiceLogger;
import weblogic.management.DeploymentException;
import weblogic.management.configuration.AppDeploymentMBean;
import weblogic.security.SubjectUtils;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;

public class ApplicationVersionLifecycleListenerAdapter
implements VetoableDeploymentListener,
DeploymentEventListener {
    private static final AuthenticatedSubject KERNEL_ID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static final AuthenticatedSubject ANONYMOUS_ID = SubjectUtils.getAnonymousSubject();
    private String appId;
    private ApplicationVersionLifecycleListener[] appListeners;

    public ApplicationVersionLifecycleListenerAdapter(String string, ApplicationVersionLifecycleListener[] applicationVersionLifecycleListenerArray) throws DeploymentException {
        if (Debug.isDeploymentDebugEnabled()) {
            Debug.deploymentDebug("AppVersionLifecycleAdapter create for " + string + ", listeners=" + Arrays.asList(applicationVersionLifecycleListenerArray));
        }
        this.appId = string;
        this.appListeners = applicationVersionLifecycleListenerArray;
        if (applicationVersionLifecycleListenerArray.length > 0) {
            this.registerDeploymentEventListeners(ApplicationVersionUtils.getApplicationName(string));
        } else if (Debug.isDeploymentDebugEnabled()) {
            Debug.deploymentDebug("AppVersionLifecycleAdapter no listeners for " + string);
        }
    }

    private void registerDeploymentEventListeners(String string) throws DeploymentException {
        if (string != null) {
            DeploymentEventManager.addVetoableDeploymentListener(string, this);
            DeploymentEventManager.addDeploymentEventListener(string, this);
        } else if (Debug.isDeploymentDebugEnabled()) {
            Debug.deploymentDebug("AppVersionLifecycleAdapter null appName for " + this.appId);
        }
    }

    public String toString() {
        return "ApplicationVersionLifecycleListenerAdapter[" + this.appId + "]";
    }

    public void cleanup() {
        if (Debug.isDeploymentDebugEnabled()) {
            Debug.deploymentDebug("AppVersionLifecycleAdapter cleanup for " + this.appId);
        }
        this.unregisterDeploymentEventListeners();
    }

    private void unregisterDeploymentEventListeners() {
        DeploymentEventManager.removeVetoableDeploymentListener(this);
        DeploymentEventManager.removeDeploymentEventListener(this);
    }

    public void vetoableApplicationActivate(VetoableDeploymentEvent vetoableDeploymentEvent) throws DeploymentVetoException {
    }

    public void vetoableApplicationDeploy(VetoableDeploymentEvent vetoableDeploymentEvent) throws DeploymentVetoException {
        this.invokeAppLifecycleListeners(ApplicationLifecycleAction.PRE_DEPLOY, vetoableDeploymentEvent, true, false);
    }

    public void vetoableApplicationUndeploy(VetoableDeploymentEvent vetoableDeploymentEvent) throws DeploymentVetoException {
        this.invokeAppLifecycleListeners(ApplicationLifecycleAction.PRE_UNDEPLOY, vetoableDeploymentEvent, true, true);
    }

    public void applicationActivated(DeploymentEvent deploymentEvent) {
    }

    public void applicationDeployed(DeploymentEvent deploymentEvent) {
        try {
            this.invokeAppLifecycleListeners(ApplicationLifecycleAction.POST_DEPLOY, deploymentEvent, false, false);
        }
        catch (DeploymentVetoException deploymentVetoException) {
            // empty catch block
        }
    }

    public void applicationRedeployed(DeploymentEvent deploymentEvent) {
        try {
            this.invokeAppLifecycleListeners(ApplicationLifecycleAction.POST_DEPLOY, deploymentEvent, false, false);
        }
        catch (DeploymentVetoException deploymentVetoException) {
            // empty catch block
        }
    }

    public void applicationDeleted(DeploymentEvent deploymentEvent) {
        try {
            this.invokeAppLifecycleListeners(ApplicationLifecycleAction.POST_DELETE, deploymentEvent, false, true);
        }
        catch (DeploymentVetoException deploymentVetoException) {
            // empty catch block
        }
    }

    private void invokeAppLifecycleListeners(final ApplicationLifecycleAction applicationLifecycleAction, final BaseDeploymentEvent baseDeploymentEvent, final boolean bl, final boolean bl2) throws DeploymentVetoException {
        Object object = SecurityServiceManager.runAs((AuthenticatedSubject)KERNEL_ID, (AuthenticatedSubject)ANONYMOUS_ID, (PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                Object object = null;
                Iterator iterator = ApplicationVersionLifecycleListenerAdapter.this.getIterator(bl2);
                while (iterator.hasNext()) {
                    Object object2;
                    try {
                        ApplicationVersionLifecycleListener applicationVersionLifecycleListener = (ApplicationVersionLifecycleListener)iterator.next();
                        object2 = ApplicationVersionLifecycleListenerAdapter.this.getAppLifecycleEvent(baseDeploymentEvent);
                        if (Debug.isDeploymentDebugEnabled()) {
                            Debug.deploymentDebug("AppVersionLifecycleAdapter invoke " + applicationLifecycleAction + " for " + applicationVersionLifecycleListener + ", " + baseDeploymentEvent);
                        }
                        if (applicationVersionLifecycleListener == null || baseDeploymentEvent == null) continue;
                        applicationLifecycleAction.invoke(applicationVersionLifecycleListener, (ApplicationVersionLifecycleEvent)object2);
                    }
                    catch (Throwable throwable) {
                        if (bl) {
                            return throwable;
                        }
                        object2 = null;
                        if (object == null || throwable.getCause() == null) {
                            object2 = new Throwable(throwable);
                        } else {
                            object2 = new Throwable(throwable.getMessage());
                            ((Throwable)object2).initCause((Throwable)object);
                        }
                        object = object2;
                    }
                }
                return object;
            }
        });
        if (object instanceof Throwable) {
            if (bl) {
                throw new DeploymentVetoException((Throwable)object);
            }
            throw new ApplicationLifecycleException((Throwable)object);
        }
    }

    private Iterator getIterator(boolean bl) {
        if (bl) {
            return new Iterator(){
                private ListIterator listIter;
                {
                    this.listIter = Arrays.asList(ApplicationVersionLifecycleListenerAdapter.this.appListeners).listIterator(ApplicationVersionLifecycleListenerAdapter.this.appListeners.length);
                }

                public boolean hasNext() {
                    return this.listIter.hasPrevious();
                }

                public Object next() {
                    return this.listIter.previous();
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
        return Arrays.asList(this.appListeners).iterator();
    }

    private ApplicationVersionLifecycleEvent getAppLifecycleEvent(BaseDeploymentEvent baseDeploymentEvent) {
        AppDeploymentMBean appDeploymentMBean = baseDeploymentEvent.getAppDeployment();
        return new ApplicationVersionLifecycleEvent(this.appId, appDeploymentMBean.getName());
    }

    public class ApplicationLifecycleException
    extends RuntimeException {
        public ApplicationLifecycleException(Throwable throwable) {
            super(DeploymentServiceLogger.logAppListenerExceptionLoggable().getMessage(), throwable);
        }
    }

    private static abstract class ApplicationLifecycleAction {
        static final ApplicationLifecycleAction PRE_DEPLOY = new ApplicationLifecycleAction("preDeploy"){

            void invoke(ApplicationVersionLifecycleListener applicationVersionLifecycleListener, ApplicationVersionLifecycleEvent applicationVersionLifecycleEvent) throws ApplicationException {
                applicationVersionLifecycleListener.preDeploy(applicationVersionLifecycleEvent);
            }
        };
        static final ApplicationLifecycleAction POST_DEPLOY = new ApplicationLifecycleAction("postDeploy"){

            void invoke(ApplicationVersionLifecycleListener applicationVersionLifecycleListener, ApplicationVersionLifecycleEvent applicationVersionLifecycleEvent) throws ApplicationException {
                applicationVersionLifecycleListener.postDeploy(applicationVersionLifecycleEvent);
            }
        };
        static final ApplicationLifecycleAction PRE_UNDEPLOY = new ApplicationLifecycleAction("preUndeploy"){

            void invoke(ApplicationVersionLifecycleListener applicationVersionLifecycleListener, ApplicationVersionLifecycleEvent applicationVersionLifecycleEvent) throws ApplicationException {
                applicationVersionLifecycleListener.preUndeploy(applicationVersionLifecycleEvent);
            }
        };
        static final ApplicationLifecycleAction POST_DELETE = new ApplicationLifecycleAction("postDelete"){

            void invoke(ApplicationVersionLifecycleListener applicationVersionLifecycleListener, ApplicationVersionLifecycleEvent applicationVersionLifecycleEvent) throws ApplicationException {
                applicationVersionLifecycleListener.postDelete(applicationVersionLifecycleEvent);
            }
        };
        private String name;

        ApplicationLifecycleAction(String string) {
            this.name = string;
        }

        public String toString() {
            return this.name;
        }

        String getName() {
            return this.name;
        }

        abstract void invoke(ApplicationVersionLifecycleListener var1, ApplicationVersionLifecycleEvent var2) throws ApplicationException;
    }
}

