/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.event;

import java.security.AccessController;
import java.util.EventListener;
import java.util.EventObject;
import weblogic.deploy.event.DeploymentVetoException;
import weblogic.management.configuration.AppDeploymentMBean;
import weblogic.management.configuration.BasicDeploymentMBean;
import weblogic.management.configuration.SystemResourceMBean;
import weblogic.management.provider.ManagementService;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;

public class BaseDeploymentEvent
extends EventObject {
    private static final long serialVersionUID = -7782817013969844896L;
    private EventType type;
    private BasicDeploymentMBean deployMBean;
    private boolean isStaticAppDeployment;
    private String[] modules;
    private String[] targets;
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    protected BaseDeploymentEvent(Object object, EventType eventType, BasicDeploymentMBean basicDeploymentMBean, boolean bl, String[] stringArray, String[] stringArray2) {
        super(object);
        this.type = eventType;
        this.deployMBean = basicDeploymentMBean;
        this.isStaticAppDeployment = bl;
        if (stringArray != null && stringArray.length > 0) {
            this.modules = stringArray;
        }
        if (stringArray2 != null && stringArray2.length > 0) {
            this.targets = stringArray2;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getName()).append("{").append(this.toStringContent()).append("}");
        return stringBuffer.toString();
    }

    protected String toStringContent() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("EventType=").append(this.type).append(",").append("BasicDeployment=").append(this.deployMBean).append(",").append("isStaticAppDeploy=").append(this.isStaticAppDeployment).append(",").append("Modules=").append(this.modules).append(",").append("Targets=").append(this.targets);
        return stringBuffer.toString();
    }

    public AppDeploymentMBean getAppDeployment() {
        if (!(this.deployMBean instanceof AppDeploymentMBean)) {
            return null;
        }
        return (AppDeploymentMBean)this.deployMBean;
    }

    public SystemResourceMBean getSystemResource() {
        if (!(this.deployMBean instanceof SystemResourceMBean)) {
            return null;
        }
        return (SystemResourceMBean)this.deployMBean;
    }

    public String[] getModules() {
        return this.modules;
    }

    public String[] getTargets() {
        return this.targets;
    }

    public boolean isAdminServer() {
        return ManagementService.getRuntimeAccess(kernelId).isAdminServer();
    }

    public boolean isStaticAppDeployment() {
        return this.isStaticAppDeployment;
    }

    public EventType getType() {
        return this.type;
    }

    ListenerAdapter getListenerAdapter() {
        return this.type.getListenerAdapter();
    }

    static interface ListenerAdapter {
        public void notifyListener(EventListener var1, BaseDeploymentEvent var2) throws DeploymentVetoException;
    }

    public static class EventType {
        private String name;
        private ListenerAdapter adapter;

        protected EventType(String string, ListenerAdapter listenerAdapter) {
            this.name = string;
            this.adapter = listenerAdapter;
        }

        public String toString() {
            return this.name;
        }

        public String getName() {
            return this.name;
        }

        private ListenerAdapter getListenerAdapter() {
            return this.adapter;
        }
    }
}

