/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.event;

import java.util.EventListener;
import weblogic.deploy.common.Debug;
import weblogic.deploy.event.ApplicationVersionLifecycleListenerAdapter;
import weblogic.deploy.event.BaseDeploymentEvent;
import weblogic.deploy.event.DeploymentEventListener;
import weblogic.deploy.event.DeploymentVetoException;
import weblogic.management.configuration.AppDeploymentMBean;

public class DeploymentEvent
extends BaseDeploymentEvent {
    private static final long serialVersionUID = 5996987879320598338L;
    public static final BaseDeploymentEvent.EventType APP_ACTIVATED = new BaseDeploymentEvent.EventType("AppActivated", new BaseDeploymentEvent.ListenerAdapter(){

        public void notifyListener(EventListener eventListener, BaseDeploymentEvent baseDeploymentEvent) throws DeploymentVetoException {
            if (DeploymentEvent.isDebugEnabled()) {
                DeploymentEvent.debug("EventType('AppActivated'): applicationActivated() fired on : '" + eventListener + "' for the event : '" + baseDeploymentEvent + "'");
            }
            DeploymentEventListener deploymentEventListener = (DeploymentEventListener)eventListener;
            deploymentEventListener.applicationDeployed((DeploymentEvent)baseDeploymentEvent);
        }
    });
    public static final BaseDeploymentEvent.EventType APP_DEPLOYED = new BaseDeploymentEvent.EventType("AppDeployed", new BaseDeploymentEvent.ListenerAdapter(){

        public void notifyListener(EventListener eventListener, BaseDeploymentEvent baseDeploymentEvent) throws DeploymentVetoException {
            if (DeploymentEvent.isDebugEnabled()) {
                DeploymentEvent.debug("EventType('AppDeployed'): applicationDeployed() fired on : '" + eventListener + "' for the event : '" + baseDeploymentEvent + "'");
            }
            ((DeploymentEventListener)eventListener).applicationDeployed((DeploymentEvent)baseDeploymentEvent);
        }
    });
    public static final BaseDeploymentEvent.EventType APP_REDEPLOYED = new BaseDeploymentEvent.EventType("AppRedeployed", new BaseDeploymentEvent.ListenerAdapter(){

        public void notifyListener(EventListener eventListener, BaseDeploymentEvent baseDeploymentEvent) throws DeploymentVetoException {
            if (DeploymentEvent.isDebugEnabled()) {
                DeploymentEvent.debug("EventType('AppRedeployed'): applicationRedeployed() fired on : '" + eventListener + "' for the event : '" + baseDeploymentEvent + "'");
            }
            ((DeploymentEventListener)eventListener).applicationRedeployed((DeploymentEvent)baseDeploymentEvent);
        }
    });
    public static final BaseDeploymentEvent.EventType APP_STARTED = new BaseDeploymentEvent.EventType("AppStarted", new BaseDeploymentEvent.ListenerAdapter(){

        public void notifyListener(EventListener eventListener, BaseDeploymentEvent baseDeploymentEvent) throws DeploymentVetoException {
            DeploymentEventListener deploymentEventListener;
            if (DeploymentEvent.isDebugEnabled()) {
                DeploymentEvent.debug("EventType('AppStarted'): applicationStarted() fired on : '" + eventListener + "' for the event : '" + baseDeploymentEvent + "'");
            }
            if (!((deploymentEventListener = (DeploymentEventListener)eventListener) instanceof ApplicationVersionLifecycleListenerAdapter)) {
                deploymentEventListener.applicationDeployed((DeploymentEvent)baseDeploymentEvent);
            }
        }
    });
    public static final BaseDeploymentEvent.EventType APP_DELETED = new BaseDeploymentEvent.EventType("AppDeleted", new BaseDeploymentEvent.ListenerAdapter(){

        public void notifyListener(EventListener eventListener, BaseDeploymentEvent baseDeploymentEvent) throws DeploymentVetoException {
            if (DeploymentEvent.isDebugEnabled()) {
                DeploymentEvent.debug("EventType('AppDeleted'): applicationDeleted() fired on : '" + eventListener + "' for the event : '" + baseDeploymentEvent + "'");
            }
            ((DeploymentEventListener)eventListener).applicationDeleted((DeploymentEvent)baseDeploymentEvent);
        }
    });

    private DeploymentEvent(Object object, BaseDeploymentEvent.EventType eventType, AppDeploymentMBean appDeploymentMBean, boolean bl, String[] stringArray, String[] stringArray2) {
        super(object, eventType, appDeploymentMBean, bl, stringArray, stringArray2);
    }

    public static DeploymentEvent create(Object object, BaseDeploymentEvent.EventType eventType, AppDeploymentMBean appDeploymentMBean, String[] stringArray, String[] stringArray2) {
        return new DeploymentEvent(object, eventType, appDeploymentMBean, false, stringArray, stringArray2);
    }

    public static DeploymentEvent create(Object object, BaseDeploymentEvent.EventType eventType, AppDeploymentMBean appDeploymentMBean, boolean bl, String[] stringArray, String[] stringArray2) {
        return new DeploymentEvent(object, eventType, appDeploymentMBean, bl, stringArray, stringArray2);
    }

    private static boolean isDebugEnabled() {
        return Debug.isDeploymentDebugEnabled();
    }

    private static void debug(String string) {
        Debug.deploymentDebug("<DeploymentEvent>: " + string);
    }
}

