/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.event;

import java.security.AccessController;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.EventListenerProxy;
import java.util.Iterator;
import weblogic.application.utils.ApplicationVersionUtils;
import weblogic.deploy.common.Debug;
import weblogic.deploy.event.BaseDeploymentEvent;
import weblogic.deploy.event.DeploymentEvent;
import weblogic.deploy.event.DeploymentEventListener;
import weblogic.deploy.event.DeploymentEventListenerProxy;
import weblogic.deploy.event.DeploymentVetoException;
import weblogic.deploy.event.VetoableDeploymentEvent;
import weblogic.deploy.event.VetoableDeploymentListener;
import weblogic.management.DeploymentException;
import weblogic.management.configuration.AppDeploymentMBean;
import weblogic.management.configuration.BasicDeploymentMBean;
import weblogic.management.deploy.internal.DeployerRuntimeLogger;
import weblogic.management.provider.ManagementService;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;

public final class DeploymentEventManager {
    private static Object deployEventListenersLock = "DeployEventListeners";
    private static ArrayList deployEventListeners = new ArrayList();
    private static Object vetoableDeployListenersLock = "VetoDeployListeners";
    private static ArrayList vetoableDeployListeners = new ArrayList();
    private static Object vetoableSystemResourceListenersLock = "VetoSystemResourceListeners";
    private static ArrayList vetoableSystemResourceListeners = new ArrayList();
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    public static void addDeploymentEventListener(DeploymentEventListener deploymentEventListener) {
        DeploymentEventManager.internalAddDeploymentEventListener(deploymentEventListener, false);
    }

    public static void addDeploymentEventListener(DeploymentEventListener deploymentEventListener, boolean bl) {
        DeploymentEventManager.internalAddDeploymentEventListener(deploymentEventListener, bl);
    }

    public static void addDeploymentEventListener(String string, DeploymentEventListener deploymentEventListener) throws DeploymentException {
        DeploymentEventManager.internalAddDeploymentEventListener(new DeploymentEventListenerProxy(string, deploymentEventListener), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void internalAddDeploymentEventListener(EventListener eventListener, boolean bl) {
        if (Debug.isDeploymentDebugEnabled()) {
            Debug.deploymentDebug("Add DeploymentEventListener " + eventListener);
        }
        if (eventListener == null) {
            return;
        }
        if (bl && !ManagementService.getRuntimeAccess(kernelId).isAdminServer()) {
            return;
        }
        Object object = deployEventListenersLock;
        synchronized (object) {
            ArrayList<EventListener> arrayList = new ArrayList<EventListener>(deployEventListeners);
            arrayList.add(eventListener);
            deployEventListeners = arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean removeDeploymentEventListener(DeploymentEventListener deploymentEventListener) {
        if (Debug.isDeploymentDebugEnabled()) {
            Debug.deploymentDebug("Remove DeploymentEventListener " + deploymentEventListener);
        }
        if (deploymentEventListener == null) {
            return false;
        }
        Object object = deployEventListenersLock;
        synchronized (object) {
            if (deployEventListeners.size() == 0) {
                return false;
            }
            ArrayList arrayList = new ArrayList(deployEventListeners);
            boolean bl = DeploymentEventManager.removeListener(deploymentEventListener, arrayList);
            deployEventListeners = arrayList;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendDeploymentEvent(DeploymentEvent deploymentEvent) {
        ArrayList arrayList;
        if (Debug.isDeploymentDebugEnabled()) {
            Debug.deploymentDebug("Send deployment event: " + deploymentEvent);
        }
        if (deploymentEvent == null) {
            return;
        }
        Object object = deployEventListenersLock;
        synchronized (object) {
            arrayList = deployEventListeners;
        }
        object = deploymentEvent.getListenerAdapter();
        Throwable throwable = null;
        for (EventListener eventListener : arrayList) {
            if (!DeploymentEventManager.isEventEnabled(eventListener, deploymentEvent)) continue;
            try {
                object.notifyListener(DeploymentEventManager.getListener(eventListener), deploymentEvent);
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = new Throwable(throwable2.toString());
                throwable3.setStackTrace(throwable2.getStackTrace());
                throwable3.initCause(throwable);
                throwable = throwable3;
            }
        }
        if (throwable != null) {
            DeployerRuntimeLogger.logSendDeploymentEventError((String)ApplicationVersionUtils.getDisplayName(deploymentEvent.getAppDeployment()), (String)deploymentEvent.getType().getName(), throwable);
        }
    }

    public static void addVetoableDeploymentListener(VetoableDeploymentListener vetoableDeploymentListener) throws DeploymentException {
        DeploymentEventManager.internalAddVetoableDeploymentListener(vetoableDeploymentListener);
    }

    public static void addVetoableDeploymentListener(String string, VetoableDeploymentListener vetoableDeploymentListener) throws DeploymentException {
        DeploymentEventManager.internalAddVetoableDeploymentListener(new DeploymentEventListenerProxy(string, vetoableDeploymentListener));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void internalAddVetoableDeploymentListener(EventListener eventListener) {
        if (Debug.isDeploymentDebugEnabled()) {
            Debug.deploymentDebug("Add VetoableDeploymentListener: " + eventListener);
        }
        if (eventListener == null) {
            return;
        }
        Object object = vetoableDeployListenersLock;
        synchronized (object) {
            ArrayList<EventListener> arrayList = new ArrayList<EventListener>(vetoableDeployListeners);
            arrayList.add(eventListener);
            vetoableDeployListeners = arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean removeVetoableDeploymentListener(VetoableDeploymentListener vetoableDeploymentListener) {
        if (Debug.isDeploymentDebugEnabled()) {
            Debug.deploymentDebug("Remove VetoableDeploymentListener: " + vetoableDeploymentListener);
        }
        if (vetoableDeploymentListener == null) {
            return false;
        }
        Object object = vetoableDeployListenersLock;
        synchronized (object) {
            if (vetoableDeployListeners.size() == 0) {
                return false;
            }
            ArrayList arrayList = new ArrayList(vetoableDeployListeners);
            boolean bl = DeploymentEventManager.removeListener(vetoableDeploymentListener, arrayList);
            vetoableDeployListeners = arrayList;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addVetoableSystemResourceDeploymentListener(VetoableDeploymentListener vetoableDeploymentListener) throws DeploymentException {
        if (Debug.isDeploymentDebugEnabled()) {
            Debug.deploymentDebug("Add VetoableSystemResourceDeploymentListener: " + vetoableDeploymentListener);
        }
        if (vetoableDeploymentListener == null) {
            return;
        }
        Object object = vetoableSystemResourceListenersLock;
        synchronized (object) {
            ArrayList<VetoableDeploymentListener> arrayList = new ArrayList<VetoableDeploymentListener>(vetoableSystemResourceListeners);
            arrayList.add(vetoableDeploymentListener);
            vetoableSystemResourceListeners = arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean removeVetoableSystemResourceDeploymentListener(VetoableDeploymentListener vetoableDeploymentListener) {
        if (Debug.isDeploymentDebugEnabled()) {
            Debug.deploymentDebug("Remove VetoableSystemResourceDeploymentListener: " + vetoableDeploymentListener);
        }
        if (vetoableDeploymentListener == null) {
            return false;
        }
        Object object = vetoableSystemResourceListenersLock;
        synchronized (object) {
            if (vetoableSystemResourceListeners.size() == 0) {
                return false;
            }
            ArrayList arrayList = new ArrayList(vetoableSystemResourceListeners);
            boolean bl = DeploymentEventManager.removeListener(vetoableDeploymentListener, arrayList);
            vetoableSystemResourceListeners = arrayList;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendVetoableDeploymentEvent(VetoableDeploymentEvent vetoableDeploymentEvent) throws DeploymentException {
        Object object;
        if (Debug.isDeploymentDebugEnabled()) {
            Debug.deploymentDebug("Send vetoable deploy event: " + vetoableDeploymentEvent);
        }
        if (vetoableDeploymentEvent == null) {
            return;
        }
        ArrayList arrayList = null;
        BasicDeploymentMBean basicDeploymentMBean = vetoableDeploymentEvent.getAppDeployment();
        if (basicDeploymentMBean != null) {
            object = vetoableDeployListenersLock;
            synchronized (object) {
                arrayList = vetoableDeployListeners;
            }
        }
        basicDeploymentMBean = vetoableDeploymentEvent.getSystemResource();
        if (basicDeploymentMBean != null) {
            object = vetoableSystemResourceListenersLock;
            synchronized (object) {
                arrayList = vetoableSystemResourceListeners;
            }
        }
        if (arrayList == null) {
            return;
        }
        object = vetoableDeploymentEvent.getListenerAdapter();
        Throwable throwable = null;
        for (EventListener eventListener : arrayList) {
            if (!DeploymentEventManager.isEventEnabled(eventListener, vetoableDeploymentEvent)) continue;
            try {
                object.notifyListener(DeploymentEventManager.getListener(eventListener), vetoableDeploymentEvent);
            }
            catch (DeploymentVetoException deploymentVetoException) {
                throw new DeploymentException(deploymentVetoException.getMessage(), deploymentVetoException);
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = new Throwable(throwable2.toString());
                throwable3.setStackTrace(throwable2.getStackTrace());
                throwable3.initCause(throwable);
                throwable = throwable3;
            }
        }
        if (throwable != null) {
            DeployerRuntimeLogger.logSendVetoableDeployEventError((String)ApplicationVersionUtils.getDisplayName(basicDeploymentMBean), throwable);
        }
    }

    private static boolean removeListener(EventListener eventListener, ArrayList arrayList) {
        boolean bl = false;
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            EventListener eventListener2 = (EventListener)iterator.next();
            if (eventListener2 instanceof EventListenerProxy) {
                eventListener2 = ((EventListenerProxy)eventListener2).getListener();
            }
            if (eventListener2 != eventListener) continue;
            iterator.remove();
            bl = true;
            break;
        }
        return bl;
    }

    private static boolean isEventEnabled(EventListener eventListener, BaseDeploymentEvent baseDeploymentEvent) {
        if (!(eventListener instanceof DeploymentEventListenerProxy)) {
            return true;
        }
        String string = ((DeploymentEventListenerProxy)eventListener).getAppName();
        AppDeploymentMBean appDeploymentMBean = baseDeploymentEvent.getAppDeployment();
        return appDeploymentMBean != null && (appDeploymentMBean.getApplicationName().equals(string) || appDeploymentMBean.getName().equals(string));
    }

    private static EventListener getListener(EventListener eventListener) {
        if (eventListener instanceof EventListenerProxy) {
            return ((EventListenerProxy)eventListener).getListener();
        }
        return eventListener;
    }
}

