/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.event;

import weblogic.application.utils.ApplicationVersionUtils;
import weblogic.deploy.event.BaseDeploymentEvent;
import weblogic.management.configuration.AppDeploymentMBean;

public final class SecurityInfo {
    private final BaseDeploymentEvent evt;
    private AppDeploymentMBean srcMBean;

    SecurityInfo(BaseDeploymentEvent baseDeploymentEvent) {
        this.evt = baseDeploymentEvent;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getName()).append("{").append("SourceMBean=").append(this.getSource()).append("}");
        return stringBuffer.toString();
    }

    public AppDeploymentMBean getSource() {
        if (this.srcMBean == null) {
            AppDeploymentMBean appDeploymentMBean = this.evt.getAppDeployment();
            if (appDeploymentMBean == null) {
                return null;
            }
            this.srcMBean = ApplicationVersionUtils.getActiveAppDeployment(appDeploymentMBean.getApplicationName());
        }
        return this.srcMBean;
    }

    public String getRealm() {
        return "weblogicDEFAULT";
    }
}

