/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.event;

import java.util.EventListener;
import weblogic.deploy.common.Debug;
import weblogic.deploy.event.ApplicationVersionLifecycleListenerAdapter;
import weblogic.deploy.event.BaseDeploymentEvent;
import weblogic.deploy.event.DeploymentVetoException;
import weblogic.deploy.event.SecurityInfo;
import weblogic.deploy.event.VetoableDeploymentListener;
import weblogic.management.configuration.BasicDeploymentMBean;

public class VetoableDeploymentEvent
extends BaseDeploymentEvent {
    private static final long serialVersionUID = 2451377168814537861L;
    public static final BaseDeploymentEvent.EventType APP_ACTIVATE = new BaseDeploymentEvent.EventType("AppActivated", new BaseDeploymentEvent.ListenerAdapter(){

        public void notifyListener(EventListener eventListener, BaseDeploymentEvent baseDeploymentEvent) throws DeploymentVetoException {
            if (VetoableDeploymentEvent.isDebugEnabled()) {
                VetoableDeploymentEvent.debug("EventType('AppActivated'): vetoableApplicationActivate() fired on : '" + eventListener + "' for the event : '" + baseDeploymentEvent + "'");
            }
            VetoableDeploymentListener vetoableDeploymentListener = (VetoableDeploymentListener)eventListener;
            vetoableDeploymentListener.vetoableApplicationDeploy((VetoableDeploymentEvent)baseDeploymentEvent);
        }
    });
    public static final BaseDeploymentEvent.EventType APP_DEPLOY = new BaseDeploymentEvent.EventType("AppDeployed", new BaseDeploymentEvent.ListenerAdapter(){

        public void notifyListener(EventListener eventListener, BaseDeploymentEvent baseDeploymentEvent) throws DeploymentVetoException {
            if (VetoableDeploymentEvent.isDebugEnabled()) {
                VetoableDeploymentEvent.debug("EventType('AppDeployed'): vetoableApplicationDeploy() fired on : '" + eventListener + "' for the event : '" + baseDeploymentEvent + "'");
            }
            ((VetoableDeploymentListener)eventListener).vetoableApplicationDeploy((VetoableDeploymentEvent)baseDeploymentEvent);
        }
    });
    public static final BaseDeploymentEvent.EventType APP_START = new BaseDeploymentEvent.EventType("AppStarted", new BaseDeploymentEvent.ListenerAdapter(){

        public void notifyListener(EventListener eventListener, BaseDeploymentEvent baseDeploymentEvent) throws DeploymentVetoException {
            VetoableDeploymentListener vetoableDeploymentListener;
            if (VetoableDeploymentEvent.isDebugEnabled()) {
                VetoableDeploymentEvent.debug("EventType('AppStarted'): vetoableApplicationStart() fired on : '" + eventListener + "' for the event : '" + baseDeploymentEvent + "'");
            }
            if (!((vetoableDeploymentListener = (VetoableDeploymentListener)eventListener) instanceof ApplicationVersionLifecycleListenerAdapter)) {
                vetoableDeploymentListener.vetoableApplicationDeploy((VetoableDeploymentEvent)baseDeploymentEvent);
            }
        }
    });
    public static final BaseDeploymentEvent.EventType APP_UNDEPLOY = new BaseDeploymentEvent.EventType("AppDeleted", new BaseDeploymentEvent.ListenerAdapter(){

        public void notifyListener(EventListener eventListener, BaseDeploymentEvent baseDeploymentEvent) throws DeploymentVetoException {
            if (VetoableDeploymentEvent.isDebugEnabled()) {
                VetoableDeploymentEvent.debug("EventType('AppDeleted'): vetoableApplicationUndeploy() fired on : '" + eventListener + "' for the event : '" + baseDeploymentEvent + "'");
            }
            ((VetoableDeploymentListener)eventListener).vetoableApplicationUndeploy((VetoableDeploymentEvent)baseDeploymentEvent);
        }
    });
    private final boolean isNewAppDeployment;
    private final SecurityInfo securityInfo = new SecurityInfo(this);

    private VetoableDeploymentEvent(Object object, BaseDeploymentEvent.EventType eventType, BasicDeploymentMBean basicDeploymentMBean, boolean bl, boolean bl2, String[] stringArray, String[] stringArray2) {
        super(object, eventType, basicDeploymentMBean, bl, stringArray, stringArray2);
        this.isNewAppDeployment = bl2;
    }

    protected String toStringContent() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toStringContent()).append(",").append("isNewApp=").append(this.isNewAppDeployment).append(",").append("SecurityInfo=").append(this.securityInfo);
        return stringBuffer.toString();
    }

    public static VetoableDeploymentEvent create(Object object, BaseDeploymentEvent.EventType eventType, BasicDeploymentMBean basicDeploymentMBean, boolean bl, String[] stringArray, String[] stringArray2) {
        return new VetoableDeploymentEvent(object, eventType, basicDeploymentMBean, false, bl, stringArray, stringArray2);
    }

    public static VetoableDeploymentEvent create(Object object, BaseDeploymentEvent.EventType eventType, BasicDeploymentMBean basicDeploymentMBean, boolean bl, boolean bl2, String[] stringArray, String[] stringArray2) {
        return new VetoableDeploymentEvent(object, eventType, basicDeploymentMBean, bl, bl2, stringArray, stringArray2);
    }

    public boolean isNewAppDeployment() {
        return this.isNewAppDeployment;
    }

    public SecurityInfo getSecurityInfo() {
        return this.securityInfo;
    }

    private static boolean isDebugEnabled() {
        return Debug.isDeploymentDebugEnabled();
    }

    private static void debug(String string) {
        Debug.deploymentDebug("<VetoableDeploymentEvent>: " + string);
    }
}

