/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.internal;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.Map;
import weblogic.deploy.common.Debug;
import weblogic.deploy.internal.DeploymentVersion;
import weblogic.deploy.service.Version;

public final class AggregateDeploymentVersion
implements Version {
    private static final long serialVersionUID = 7559709643035775633L;
    private static final String IDENTITY = "Deployments";
    private Map versionComponentsMap = new HashMap();

    public static AggregateDeploymentVersion createAggregateDeploymentVersion() {
        return new AggregateDeploymentVersion();
    }

    public static AggregateDeploymentVersion createAggregateDeploymentVersion(Map map) {
        AggregateDeploymentVersion aggregateDeploymentVersion = new AggregateDeploymentVersion();
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                aggregateDeploymentVersion.addOrUpdateDeploymentVersion((String)entry.getKey(), (DeploymentVersion)entry.getValue());
            }
        }
        return aggregateDeploymentVersion;
    }

    public String getIdentity() {
        return IDENTITY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getVersionComponents() {
        Map map = this.versionComponentsMap;
        synchronized (map) {
            return new HashMap(this.versionComponentsMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOrUpdateDeploymentVersion(String string, DeploymentVersion deploymentVersion) {
        Version version2 = null;
        Object object = this.versionComponentsMap;
        synchronized (object) {
            version2 = this.versionComponentsMap.put(string, deploymentVersion);
        }
        if (Debug.isDeploymentDebugEnabled()) {
            object = null;
            object = version2 != null ? "AggregateDeploymentVersion: Updated version for id '" + string + "' from: '" + version2 + "' to: '" + deploymentVersion + "', '" + this.toString() + "'" : "AggregateDeploymentVersion: Updated version for id '" + string + "' from: '" + version2 + "' to: '" + deploymentVersion + "', '" + this.toString() + "'";
            Debug.deploymentDebug((String)object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDeploymentVersionFor(String string) {
        Map map = this.versionComponentsMap;
        synchronized (map) {
            this.versionComponentsMap.remove(string);
        }
        if (Debug.isDeploymentDebugEnabled()) {
            Debug.deploymentDebug("AggregateDeploymentVersion: removed id '" + string + ", " + this.toString() + "'");
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (object instanceof AggregateDeploymentVersion) {
            Map map = this.getVersionComponents();
            Map map2 = ((AggregateDeploymentVersion)object).getVersionComponents();
            return ((Object)map).equals(map2);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hashCode() {
        Map map = this.versionComponentsMap;
        synchronized (map) {
            return ((Object)this.versionComponentsMap).hashCode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString()).append("Aggregated Deployment Version: (");
        stringBuffer.append("id: ").append(this.getIdentity());
        stringBuffer.append(" - versionComponentsMap{");
        Map map = this.versionComponentsMap;
        synchronized (map) {
            for (Map.Entry entry : this.versionComponentsMap.entrySet()) {
                String string = (String)entry.getKey();
                stringBuffer.append(" [id: ");
                stringBuffer.append(string);
                stringBuffer.append(", version: ");
                stringBuffer.append(entry.getValue().toString());
                stringBuffer.append("]");
            }
        }
        stringBuffer.append("}").append(")");
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        Map map = this.versionComponentsMap;
        synchronized (map) {
            objectOutput.writeObject(this.versionComponentsMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        Map map = this.versionComponentsMap;
        synchronized (map) {
            this.versionComponentsMap.putAll((Map)objectInput.readObject());
        }
    }
}

