/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.internal;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.Map;
import weblogic.deploy.common.Debug;
import weblogic.deploy.internal.DeploymentVersion;
import weblogic.deploy.internal.InternalDeploymentData;
import weblogic.deploy.service.internal.BaseDeploymentImpl;
import weblogic.management.deploy.DeploymentData;
import weblogic.management.deploy.DeploymentTaskRuntime;
import weblogic.security.acl.internal.AuthenticatedSubject;

public final class Deployment
extends BaseDeploymentImpl {
    private static final long serialVersionUID = 6457624201160781380L;
    private InternalDeploymentData internalDeploymentData;
    private String taskRuntimeId;
    private boolean isBeforeDeploymentHandler;
    private boolean isDeploy;
    private boolean requiresRestart;
    private boolean isSyncWithAdmin;
    private Map syncWithAdminState = new HashMap();
    private DeploymentVersion proposedDeploymentVersion;
    private long deploymentRequestId;
    private transient DeploymentTaskRuntime taskRuntime;
    private transient AuthenticatedSubject initiator;
    private transient boolean isCallerLockOwner;
    private transient boolean isStaged;
    private transient boolean isAControlOperation;
    private transient boolean isAnAppDeployment;
    private transient int operation;

    public Deployment() {
    }

    public Deployment(String string, DeploymentTaskRuntime deploymentTaskRuntime, DeploymentData deploymentData, AuthenticatedSubject authenticatedSubject, boolean bl, boolean bl2, boolean bl3) {
        super(deploymentTaskRuntime != null ? deploymentTaskRuntime.getDeploymentMBean().getName() : null, string, null, null, null, null, null);
        this.taskRuntime = deploymentTaskRuntime;
        this.internalDeploymentData = new InternalDeploymentData();
        this.internalDeploymentData.setExternalDeploymentData(deploymentData);
        if (deploymentTaskRuntime != null) {
            this.internalDeploymentData.setNotificationLevel(deploymentTaskRuntime.getNotificationLevel());
            this.internalDeploymentData.setDeploymentOperation(deploymentTaskRuntime.getTask());
            this.internalDeploymentData.setDeploymentName(deploymentTaskRuntime.getApplicationId());
            this.taskRuntimeId = deploymentTaskRuntime.getId();
            this.operation = deploymentTaskRuntime.getTask();
            if (deploymentTaskRuntime.getAppDeploymentMBean() != null) {
                this.isAnAppDeployment = true;
            }
        }
        this.initiator = authenticatedSubject;
        this.isCallerLockOwner = bl;
        this.isAControlOperation = bl2;
        this.requiresRestart = bl3;
    }

    public void setNotificationLevel(int n) {
        this.internalDeploymentData.setNotificationLevel(n);
    }

    public final int getOperation() {
        return this.operation;
    }

    public final DeploymentVersion getProposedDeploymentVersion() {
        return this.proposedDeploymentVersion;
    }

    public final void setProposedDeploymentVersion(DeploymentVersion deploymentVersion) {
        this.proposedDeploymentVersion = deploymentVersion;
    }

    public final boolean isCallerLockOwner() {
        return this.isCallerLockOwner;
    }

    public final AuthenticatedSubject getInitiator() {
        return this.initiator;
    }

    public final boolean isAControlOperation() {
        return this.isAControlOperation;
    }

    public final boolean requiresRestart() {
        return this.requiresRestart;
    }

    public final DeploymentTaskRuntime getDeploymentTaskRuntime() {
        return this.taskRuntime;
    }

    public final String getDeploymentTaskRuntimeId() {
        return this.taskRuntimeId;
    }

    public final boolean isBeforeDeploymentHandler() {
        return this.isBeforeDeploymentHandler;
    }

    public final void setBeforeDeploymentHandler() {
        this.isBeforeDeploymentHandler = true;
    }

    public final boolean isDeploy() {
        return this.isDeploy;
    }

    public final void setIsDeploy() {
        this.isDeploy = true;
    }

    public final InternalDeploymentData getInternalDeploymentData() {
        return this.internalDeploymentData;
    }

    public final void setInternalDeploymentData(InternalDeploymentData internalDeploymentData) {
        this.internalDeploymentData = internalDeploymentData;
    }

    public final void setDeploymentRequestIdentifier(long l) {
        this.deploymentRequestId = l;
    }

    public final long getDeploymentRequestId() {
        return this.deploymentRequestId;
    }

    public final boolean isAnAppDeployment() {
        return this.isAnAppDeployment;
    }

    public final void setStaged(String string) {
        if (Debug.isDeploymentDebugEnabled()) {
            Debug.deploymentDebug("Setting staged mode of '" + this.getIdentity() + "' to '" + string + "'");
        }
        if (string == null || "stage".equals(string)) {
            this.isStaged = true;
        }
    }

    public final boolean isStaged() {
        return this.isStaged;
    }

    public final boolean isSyncWithAdmin() {
        return this.isSyncWithAdmin;
    }

    public final void enableSyncWithAdmin(Map map) {
        this.isSyncWithAdmin = true;
        this.syncWithAdminState = map;
    }

    public final Map getSyncWithAdminState() {
        return this.syncWithAdminState;
    }

    protected String toPrettyString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toPrettyString());
        stringBuffer.append(", isBeforeDeploymentHandler: ");
        stringBuffer.append(this.isBeforeDeploymentHandler);
        return stringBuffer.toString();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        objectOutput.writeObject(this.internalDeploymentData);
        objectOutput.writeObject(this.taskRuntimeId);
        objectOutput.writeBoolean(this.isBeforeDeploymentHandler);
        objectOutput.writeBoolean(this.isDeploy);
        objectOutput.writeBoolean(this.requiresRestart);
        objectOutput.writeBoolean(this.isSyncWithAdmin);
        objectOutput.writeObject(this.syncWithAdminState);
        objectOutput.writeObject(this.proposedDeploymentVersion);
        objectOutput.writeLong(this.deploymentRequestId);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        this.internalDeploymentData = (InternalDeploymentData)objectInput.readObject();
        this.taskRuntimeId = (String)objectInput.readObject();
        this.isBeforeDeploymentHandler = objectInput.readBoolean();
        this.isDeploy = objectInput.readBoolean();
        this.requiresRestart = objectInput.readBoolean();
        this.isSyncWithAdmin = objectInput.readBoolean();
        this.syncWithAdminState = (Map)objectInput.readObject();
        this.proposedDeploymentVersion = (DeploymentVersion)objectInput.readObject();
        this.deploymentRequestId = objectInput.readLong();
    }
}

