/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.internal;

import java.util.Comparator;
import java.util.HashMap;
import weblogic.deploy.internal.DeploymentType;
import weblogic.deploy.service.internal.DeploymentServiceLogger;
import weblogic.management.configuration.BasicDeploymentMBean;

public class DeploymentOrder {
    public static final DeploymentType[] DEPLOYMENT_ORDER = new DeploymentType[]{DeploymentType.CACHE, DeploymentType.INTERNAL_APP, DeploymentType.JDBC_SYS_RES, DeploymentType.DEPLOYMENT_HANDLER, DeploymentType.JMS_SYS_RES, DeploymentType.RESOURCE_DEPENDENT_DEPLOYMENT_HANDLER, DeploymentType.STARTUP_CLASS, DeploymentType.WLDF_SYS_RES, DeploymentType.LIBRARY, DeploymentType.DEFAULT_APP, DeploymentType.COHERENCE_CLUSTER_SYS_RES, DeploymentType.CUSTOM_SYS_RES};
    public static final Comparator COMPARATOR = new Comparator(){

        public int compare(Object object, Object object2) {
            if (object == object2) {
                return 0;
            }
            for (int i = 0; i < DEPLOYMENT_ORDER.length; ++i) {
                DeploymentType deploymentType = DEPLOYMENT_ORDER[i];
                if (deploymentType.isInstance(object) && !deploymentType.isInstance(object2)) {
                    return -1;
                }
                if (!deploymentType.isInstance(object) && deploymentType.isInstance(object2)) {
                    return 1;
                }
                if (!deploymentType.isInstance(object) || !deploymentType.isInstance(object2)) continue;
                return deploymentType.compare(object, object2);
            }
            String string = DeploymentServiceLogger.unrecognizedTypes((String)object.getClass().getName(), (String)object2.getClass().getName());
            throw new ClassCastException(string);
        }
    };
    private static final HashMap orderMap = new HashMap();

    public static final boolean isBeforeDeploymentHandler(BasicDeploymentMBean basicDeploymentMBean) {
        for (int i = 0; i < DEPLOYMENT_ORDER.length; ++i) {
            DeploymentType deploymentType = DEPLOYMENT_ORDER[i];
            if (deploymentType == DeploymentType.DEPLOYMENT_HANDLER) {
                return false;
            }
            if (!deploymentType.isInstance(basicDeploymentMBean)) continue;
            return true;
        }
        return true;
    }

    public static int getCachedDeploymentOrder(BasicDeploymentMBean basicDeploymentMBean) {
        Integer n = (Integer)orderMap.get(basicDeploymentMBean);
        if (n != null) {
            return n;
        }
        return basicDeploymentMBean.getDeploymentOrder();
    }

    public static Object addToDeploymentOrderCache(BasicDeploymentMBean basicDeploymentMBean, int n) {
        return orderMap.put(basicDeploymentMBean, new Integer(n));
    }

    public static Object removeFromDeploymentOrderCache(BasicDeploymentMBean basicDeploymentMBean) {
        return orderMap.remove(basicDeploymentMBean);
    }
}

