/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.internal;

import java.util.Comparator;
import weblogic.deploy.internal.DeploymentOrder;
import weblogic.jdbc.common.internal.JDBCMBeanConverter;
import weblogic.management.WebLogicMBean;
import weblogic.management.configuration.AppDeploymentMBean;
import weblogic.management.configuration.BasicDeploymentMBean;
import weblogic.management.configuration.CacheMBean;
import weblogic.management.configuration.CoherenceClusterSystemResourceMBean;
import weblogic.management.configuration.CustomResourceMBean;
import weblogic.management.configuration.DeploymentMBean;
import weblogic.management.configuration.JDBCSystemResourceMBean;
import weblogic.management.configuration.JMSSystemResourceMBean;
import weblogic.management.configuration.LibraryMBean;
import weblogic.management.configuration.StartupClassMBean;
import weblogic.management.configuration.WLDFSystemResourceMBean;
import weblogic.management.deploy.internal.DeploymentManagerLogger;

public class DeploymentType
implements Comparator {
    private final String name;
    private final Class cls;
    public static final DeploymentType CUSTOM_SYS_RES = new DeploymentType("Custom", CustomResourceMBean.class);
    public static final DeploymentType JDBC_SYS_RES = new DeploymentType("JDBC", JDBCSystemResourceMBean.class){

        public int compare(Object object, Object object2) {
            this.ensureType(object, object2);
            JDBCSystemResourceMBean jDBCSystemResourceMBean = (JDBCSystemResourceMBean)object;
            JDBCSystemResourceMBean jDBCSystemResourceMBean2 = (JDBCSystemResourceMBean)object2;
            boolean bl = this.isMultiDS(jDBCSystemResourceMBean);
            boolean bl2 = this.isMultiDS(jDBCSystemResourceMBean2);
            if (!bl && bl2) {
                return -1;
            }
            if (bl && !bl2) {
                return 1;
            }
            return this.compare(jDBCSystemResourceMBean, jDBCSystemResourceMBean2);
        }

        private boolean isMultiDS(JDBCSystemResourceMBean jDBCSystemResourceMBean) {
            try {
                return JDBCMBeanConverter.getLegacyType(jDBCSystemResourceMBean.getJDBCResource()) == 0 && jDBCSystemResourceMBean.getJDBCResource().getJDBCDataSourceParams().getDataSourceList() != null;
            }
            catch (NullPointerException nullPointerException) {
                return false;
            }
        }
    };
    public static final DeploymentType JMS_SYS_RES = new DeploymentType("JMS", JMSSystemResourceMBean.class);
    public static final DeploymentType WLDF_SYS_RES = new DeploymentType("WLDF", WLDFSystemResourceMBean.class);
    public static final DeploymentType COHERENCE_CLUSTER_SYS_RES = new DeploymentType("CoherenceCluster", CoherenceClusterSystemResourceMBean.class);
    public static final DeploymentType LIBRARY = new DeploymentType("Library", LibraryMBean.class);
    public static final DeploymentType INTERNAL_APP = new DeploymentType("Internal", AppDeploymentMBean.class){

        public boolean isInstance(Object object) {
            return super.isInstance(object) && ((AppDeploymentMBean)object).isInternalApp();
        }
    };
    public static final DeploymentType DEFAULT_APP = new DeploymentType("Default", AppDeploymentMBean.class){

        public boolean isInstance(Object object) {
            return super.isInstance(object) && !((AppDeploymentMBean)object).isInternalApp() && !(object instanceof LibraryMBean);
        }
    };
    public static final Object PSEUDO_DEPLOYMENT_HANDLER_MBEAN = new String("PseudoDeploymentHandlerMBean");
    public static final DeploymentType DEPLOYMENT_HANDLER = new DeploymentType("DeploymentHandler", DeploymentMBean.class){

        public boolean isInstance(Object object) {
            if (object == PSEUDO_DEPLOYMENT_HANDLER_MBEAN) {
                return true;
            }
            return super.isInstance(object);
        }

        public int compare(Object object, Object object2) {
            this.ensureType(object, object2);
            DeploymentMBean deploymentMBean = (DeploymentMBean)object;
            DeploymentMBean deploymentMBean2 = (DeploymentMBean)object2;
            int n = deploymentMBean.getDeploymentOrder();
            int n2 = deploymentMBean2.getDeploymentOrder();
            if (n < n2) {
                return -1;
            }
            if (n2 < n) {
                return 1;
            }
            return this.defaultCompare(deploymentMBean, deploymentMBean2);
        }
    };
    public static final Object PSEUDO_RESOURCE_DEPENDENT_DEP_HANDLER_MBEAN = new String("PseudoResourceDependentDeploymentHandlerMBean");
    public static final DeploymentType RESOURCE_DEPENDENT_DEPLOYMENT_HANDLER = new DeploymentType("ResourceDependentDeploymentHandler", DeploymentMBean.class){

        public boolean isInstance(Object object) {
            return object == PSEUDO_RESOURCE_DEPENDENT_DEP_HANDLER_MBEAN;
        }
    };
    public static final Object PSEUDO_STARTUP_CLASS_MBEAN = new String("PseudoStartupClassMBean");
    public static final DeploymentType STARTUP_CLASS = new DeploymentType("StartupClass", StartupClassMBean.class){

        public boolean isInstance(Object object) {
            if (object == PSEUDO_STARTUP_CLASS_MBEAN) {
                return true;
            }
            return super.isInstance(object);
        }

        public int compare(Object object, Object object2) {
            return DEPLOYMENT_HANDLER.compare(object, object2);
        }
    };
    public static final DeploymentType CACHE = new DeploymentType("Cache", CacheMBean.class);

    private DeploymentType(String string, Class clazz) {
        this.name = string;
        this.cls = clazz;
    }

    public String toString() {
        return this.name;
    }

    public boolean isInstance(Object object) {
        return this.cls.isInstance(object);
    }

    public Comparator getComparator() {
        return this;
    }

    public int compare(Object object, Object object2) {
        this.ensureType(object, object2);
        if (object instanceof BasicDeploymentMBean) {
            return this.compare((BasicDeploymentMBean)object, (BasicDeploymentMBean)object2);
        }
        return this.defaultCompare(object, object2);
    }

    protected void ensureType(Object object, Object object2) {
        if (!this.isInstance(object)) {
            String string = DeploymentManagerLogger.unrecognizedType(object.getClass().getName());
            throw new ClassCastException(string);
        }
        if (!this.isInstance(object2)) {
            String string = DeploymentManagerLogger.unrecognizedType(object2.getClass().getName());
            throw new ClassCastException(string);
        }
    }

    protected int defaultCompare(Object object, Object object2) {
        if (object instanceof WebLogicMBean && object2 instanceof WebLogicMBean) {
            return ((WebLogicMBean)object).getName().compareTo(((WebLogicMBean)object2).getName());
        }
        return 0;
    }

    protected int compare(BasicDeploymentMBean basicDeploymentMBean, BasicDeploymentMBean basicDeploymentMBean2) {
        int n;
        int n2 = DeploymentOrder.getCachedDeploymentOrder(basicDeploymentMBean);
        if (n2 < (n = DeploymentOrder.getCachedDeploymentOrder(basicDeploymentMBean2))) {
            return -1;
        }
        if (n < n2) {
            return 1;
        }
        return this.defaultCompare(basicDeploymentMBean, basicDeploymentMBean2);
    }
}

