/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.internal;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.Map;
import weblogic.deploy.service.Version;

public class DeploymentVersion
implements Version {
    private static final long serialVersionUID = 7424059632370370194L;
    public static final String ARCHIVE_TIMESTAMP = "ARCHIVE_TIMESTAMP";
    public static final String PLAN_TIMESTAMP = "PLAN_TIMESTAMP";
    private String identity = null;
    private Map versionMap = new HashMap();

    public DeploymentVersion() {
    }

    public DeploymentVersion(String string, long l, long l2) {
        this();
        this.identity = string;
        this.versionMap.put(ARCHIVE_TIMESTAMP, new Long(l));
        this.versionMap.put(PLAN_TIMESTAMP, new Long(l2));
    }

    public String getIdentity() {
        return this.identity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getVersionComponents() {
        Map map = this.versionMap;
        synchronized (map) {
            return this.versionMap;
        }
    }

    public long getArchiveTimeStamp() {
        return this.getValue(ARCHIVE_TIMESTAMP);
    }

    public long getPlanTimeStamp() {
        return this.getValue(PLAN_TIMESTAMP);
    }

    public void update(boolean bl, boolean bl2) {
        long l = System.currentTimeMillis();
        if (bl) {
            this.resetArchiveTimeStamp(l);
            this.resetPlanTimeStamp(l);
        } else if (!bl2) {
            this.resetPlanTimeStamp(l);
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (object instanceof DeploymentVersion) {
            Map map = this.getVersionComponents();
            Map map2 = ((Version)object).getVersionComponents();
            return ((Object)map).equals(map2);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hashCode() {
        Map map = this.versionMap;
        synchronized (map) {
            return ((Object)this.versionMap).hashCode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString()).append("(").append("id: ");
        stringBuffer.append(this.identity);
        stringBuffer.append(" - versionMap{");
        Map map = this.versionMap;
        synchronized (map) {
            for (Map.Entry entry : this.versionMap.entrySet()) {
                String string = (String)entry.getKey();
                stringBuffer.append(" [Component: ");
                stringBuffer.append(string);
                stringBuffer.append(" - version: ");
                stringBuffer.append(entry.getValue().toString());
                stringBuffer.append("]");
            }
        }
        stringBuffer.append("}").append(")");
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.identity);
        Map map = this.versionMap;
        synchronized (map) {
            objectOutput.writeObject(this.versionMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.identity = (String)objectInput.readObject();
        Map map = this.versionMap;
        synchronized (map) {
            this.versionMap.putAll((Map)objectInput.readObject());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetArchiveTimeStamp(long l) {
        Map map = this.versionMap;
        synchronized (map) {
            this.versionMap.put(ARCHIVE_TIMESTAMP, new Long(l));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetPlanTimeStamp(long l) {
        Map map = this.versionMap;
        synchronized (map) {
            this.versionMap.put(PLAN_TIMESTAMP, new Long(l));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getValue(String string) {
        Map map = this.versionMap;
        synchronized (map) {
            return (Long)this.versionMap.get(string);
        }
    }
}

