/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.internal;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import javax.management.InvalidAttributeValueException;
import weblogic.Home;
import weblogic.application.MBeanFactory;
import weblogic.deploy.common.Debug;
import weblogic.deploy.internal.WSATAppDeployHelper;
import weblogic.descriptor.EditableDescriptorManager;
import weblogic.j2ee.descriptor.wl.DeploymentPlanBean;
import weblogic.j2ee.descriptor.wl.ModuleDescriptorBean;
import weblogic.j2ee.descriptor.wl.VariableAssignmentBean;
import weblogic.j2ee.descriptor.wl.VariableBean;
import weblogic.j2ee.descriptor.wl.VariableDefinitionBean;
import weblogic.management.ApplicationException;
import weblogic.management.DeploymentException;
import weblogic.management.DomainDir;
import weblogic.management.ManagementException;
import weblogic.management.configuration.AdminConsoleMBean;
import weblogic.management.configuration.AppDeploymentMBean;
import weblogic.management.configuration.ApplicationMBean;
import weblogic.management.configuration.ClusterMBean;
import weblogic.management.configuration.ComponentMBean;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.configuration.TargetMBean;
import weblogic.management.deploy.internal.DeployerRuntimeLogger;
import weblogic.management.deploy.internal.DeploymentManagerLogger;
import weblogic.management.deploy.internal.SlaveDeployerLogger;
import weblogic.management.provider.ConfigurationProcessor;
import weblogic.management.provider.ManagementService;
import weblogic.management.provider.UpdateException;
import weblogic.management.runtime.ServerRuntimeMBean;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.internal.SAMLServerConfig;
import weblogic.security.internal.saml2.SAML2ServerConfig;
import weblogic.security.service.PrivilegedActions;
import weblogic.utils.FileUtils;

public class InternalAppProcessor
implements ConfigurationProcessor {
    private static final String WAR = ".war";
    private static final String JAR = ".jar";
    private static final String EAR = ".ear";
    private static final boolean ADMIN_ONLY = true;
    private static final boolean ALL_SERVERS = false;
    private static final boolean CRITICAL = true;
    private static final boolean NON_CRITICAL = false;
    private static final boolean BACKGROUND = true;
    private static final boolean IN_STARTUP = false;
    private static final boolean DISPLAY_REFRESH = true;
    private static final boolean NO_REFRESH = false;
    private static final boolean APP = false;
    private static final boolean LIBRARY = true;
    public static final String LIB = Home.getPath() + File.separator + "lib";
    private static final String WEBLOGIC_JAR_PATH = LIB + File.separator + "weblogic.jar";
    private static boolean done = false;
    private String serverName;
    private static final String COOKIE_NAME = "CookieName";
    private static final String SESSION_TIMEOUT = "SessionTimeout";
    private static final String WSAT_APP = "wls-wsat";
    private static final boolean m_isWSATDeployed = new Boolean(System.getProperty("weblogic.wsee.wstx.wsat.deployed", "true"));
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private boolean isAdminServer = ManagementService.getRuntimeAccess(kernelId).isAdminServer();
    private ArrayList internalApps = new ArrayList();
    private File stageDir;

    public InternalAppProcessor() {
        InternalApp internalApp;
        Object object;
        DomainMBean domainMBean = ManagementService.getRuntimeAccess(kernelId).getDomain();
        ServerRuntimeMBean serverRuntimeMBean = ManagementService.getRuntimeAccess(kernelId).getServerRuntime();
        this.internalApps.addAll(Arrays.asList(new InternalApp("bea_wls_management_internal2", WAR, true, true, false, false, new String[]{"bea_wls_management_internal2"}, false), new InternalApp("bea_wls_diagnostics", WAR, false, false, false, true, new String[]{"bea_wls_diagnostics"}, false)));
        if (domainMBean.getDeploymentConfiguration().isRemoteDeployerEJBEnabled() && serverRuntimeMBean.isServiceAvailable("EJB")) {
            this.internalApps.add(new InternalApp("bea_wls_remote_deployer", JAR, true, false));
        }
        this.internalApps.add(new InternalApp("uddi", WAR, false, false, false, true, new String[]{"uddi"}, false));
        this.internalApps.add(new InternalApp("uddiexplorer", WAR, false, false, false, true, new String[]{"uddiexplorer"}, true));
        if (domainMBean.isConsoleEnabled()) {
            object = domainMBean.getConsoleContextPath();
            internalApp = new InternalApp("consoleapp", "", true, false, false, false, new String[]{object, "console-help"}, true);
            this.initConsoleDeploymentPlan(internalApp, domainMBean);
            this.internalApps.add(internalApp);
            if (!domainMBean.isProductionModeEnabled()) {
                this.internalApps.add(new InternalApp("wlstestclient", EAR, true, false, false, true, new String[]{"wls_utc"}, true));
            }
        }
        if (domainMBean.getRestfulManagementServices().isEnabled()) {
            this.internalApps.add(new InternalApp("wls-management-services", WAR, true, false, true));
        }
        if (domainMBean.getJMX().isManagementEJBEnabled() && serverRuntimeMBean.isServiceAvailable("EJB")) {
            this.internalApps.add(new InternalApp("mejb", JAR, true, false, true));
        }
        this.internalApps.add(new InternalApp("bea_wls_deployment_internal", WAR, false, true, false, false, new String[]{"bea_wls_deployment_internal"}, false));
        object = ManagementService.getRuntimeAccess(kernelId).getServer();
        if (object.getCluster() != null) {
            this.internalApps.add(new InternalApp("bea_wls_cluster_internal", WAR, false, true));
        }
        if (!object.isDefaultInternalServletsDisabled()) {
            this.internalApps.add(new InternalApp("bea_wls_internal", WAR, false, true));
        }
        if (System.getProperty("weblogic.wsee.skip.async.response") == null) {
            this.internalApps.add(new InternalApp("bea_wls9_async_response", WAR, false, false, false, object.getCluster() == null && !domainMBean.isProductionModeEnabled()));
        }
        if (serverRuntimeMBean.isServiceAvailable("EJB")) {
            this.internalApps.add(new InternalApp("bea_wls_async_response", JAR, false, false, true, true));
        }
        if (domainMBean.isGuardianEnabled()) {
            this.internalApps.add(new InternalApp("bea-guardian-agent", WAR, false, false, true));
        }
        if (m_isWSATDeployed) {
            internalApp = new InternalApp(WSAT_APP, WAR, false, false, false, true, new String[]{WSAT_APP}, false);
            DeploymentPlanBean deploymentPlanBean = WSATAppDeployHelper.buildWSATAppDeploymentPlan(WSAT_APP, domainMBean.getJTA());
            if (deploymentPlanBean != null) {
                internalApp.setDeploymentPlanBean(deploymentPlanBean);
            }
            this.internalApps.add(internalApp);
        }
        if (!domainMBean.isProductionModeEnabled()) {
            this.internalApps.add(new InternalApp("wls-cat", WAR, false, false, false, true, new String[]{"wls-cat"}, true));
        }
    }

    public void updateConfiguration(DomainMBean domainMBean) throws UpdateException {
        if (done) {
            return;
        }
        this.initStagingDir();
        this.createStagingDirForInternalApps();
        if (SAMLServerConfig.isApplicationConfigured((String)"samlits_ba")) {
            this.internalApps.add(new InternalApp("samlits_ba", WAR, false, false));
        }
        if (SAMLServerConfig.isApplicationConfigured((String)"samlits_cc")) {
            this.internalApps.add(new InternalApp("samlits_cc", WAR, false, false));
        }
        if (SAMLServerConfig.isApplicationConfigured((String)"samlacs")) {
            this.internalApps.add(new InternalApp("samlacs", WAR, false, false));
        }
        if (SAMLServerConfig.isApplicationConfigured((String)"samlars")) {
            this.internalApps.add(new InternalApp("samlars", WAR, false, false));
        }
        if (SAML2ServerConfig.isApplicationConfigured("saml2")) {
            InternalApp internalApp = new InternalApp("saml2", WAR, false, false);
            internalApp.setClustered(true);
            this.internalApps.add(internalApp);
        }
        for (InternalApp internalApp : this.internalApps) {
            try {
                if (internalApp.adminOnly && !this.isAdminServer) continue;
                this.stageFilesAndCreateBeansForInternalApp(internalApp, 1, domainMBean);
            }
            catch (Exception exception) {
                this.handleErr(exception, internalApp.name, internalApp.critical);
            }
        }
        done = true;
    }

    private void handleErr(Exception exception, String string, boolean bl) throws UpdateException {
        if (bl) {
            String string2 = DeploymentManagerLogger.logCriticalInternalAppNotDeployed(string, exception.getMessage());
            throw new UpdateException(string2, exception);
        }
        DeploymentManagerLogger.logNonCriticalInternalAppNotDeployed(string, exception.getMessage());
    }

    private void createStagingDirForInternalApps() {
        if (this.stageDir.exists()) {
            if (!this.stageDir.isDirectory()) {
                this.stageDir.delete();
                this.stageDir.mkdirs();
            }
        } else {
            this.stageDir.mkdirs();
        }
    }

    private void stageFilesAndCreateBeansForInternalApp(InternalApp internalApp, int n, DomainMBean domainMBean) throws ManagementException {
        String string = internalApp.name;
        boolean bl = false;
        DeploymentException deploymentException = null;
        for (int i = 0; i <= n && !bl; ++i) {
            if (Debug.isDeploymentDebugEnabled()) {
                Debug.deploymentDebug("Deploying internal app: " + internalApp.location + File.separator + string);
            }
            try {
                if (!internalApp.adminOnly) {
                    this.stageFilesForInternalApp(internalApp);
                }
                this.createBeansForInternalApp(internalApp, domainMBean);
                bl = true;
            }
            catch (SecurityException securityException) {
                deploymentException = new DeploymentException(securityException.getMessage(), securityException);
            }
            catch (ManagementException managementException) {
                deploymentException = new DeploymentException(managementException.getMessage(), managementException);
            }
            catch (ApplicationException applicationException) {
                deploymentException = new DeploymentException(applicationException.getMessage(), (Throwable)((Object)applicationException));
            }
            catch (InvalidAttributeValueException invalidAttributeValueException) {
                deploymentException = new DeploymentException(invalidAttributeValueException.getMessage(), invalidAttributeValueException);
            }
            if (i <= 0 || bl) continue;
            SlaveDeployerLogger.logRetryingInternalAppDeploymentLoggable((String)string);
            if (!Debug.isDeploymentDebugEnabled()) continue;
            Debug.deploymentDebug("Retrying deployment of internal app " + string + ", the initial attempt failed with this exception " + deploymentException.toString());
        }
        if (!bl) {
            if (internalApp.critical) {
                DeploymentManagerLogger.logDeployFailedForInternalApp(string, deploymentException);
                throw deploymentException;
            }
            DeploymentManagerLogger.logNonCriticalInternalAppNotDeployed(string, deploymentException.getMessage());
            if (Debug.isDeploymentDebugEnabled()) {
                deploymentException.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void stageFilesForInternalApp(InternalApp internalApp) throws DeploymentException {
        DeploymentException deploymentException;
        boolean bl;
        block21: {
            Object object;
            File file;
            String string;
            block22: {
                string = internalApp.name + internalApp.suffix;
                String string2 = internalApp.location;
                bl = false;
                deploymentException = new DeploymentException(string);
                file = new File(this.stageDir, string);
                File file2 = new File(string2);
                if (file2.exists() && file2.isDirectory()) {
                    File file3 = new File(file2, string);
                    if (file3.exists()) {
                        if (file.lastModified() > file3.lastModified()) {
                            bl = true;
                        } else {
                            if (Debug.isDeploymentDebugEnabled()) {
                                Debug.deploymentDebug("Staging File: " + string2 + string + ". copying: '" + string + "' to: '" + file + "'");
                            }
                            try {
                                FileUtils.copy((File)file3, (File)file);
                                bl = true;
                            }
                            catch (IOException iOException) {
                                if (Debug.isDeploymentDebugEnabled()) {
                                    Debug.deploymentDebug("Exception while staging file: " + string2 + string + ". copying: '" + string + "' to: '" + file + "' " + iOException.getMessage());
                                }
                                deploymentException = new DeploymentException(iOException);
                            }
                        }
                    } else {
                        object = DeployerRuntimeLogger.noAppFilesExist((String)file3.toString());
                        deploymentException = new DeploymentException((String)object);
                    }
                }
                if (bl) break block21;
                file2 = new File(WEBLOGIC_JAR_PATH);
                if (!file2.exists() || file.lastModified() <= file2.lastModified()) break block22;
                bl = true;
                break block21;
            }
            object = InternalAppProcessor.class.getResourceAsStream("/" + string);
            if (object != null) {
                if (Debug.isDeploymentDebugEnabled()) {
                    Debug.deploymentDebug("Staging globalWarFile. copying: '" + string + "' to: '" + file + "'");
                }
                FileUtils.writeToFile((InputStream)object, (File)file);
                bl = true;
                Object var12_11 = null;
                try {
                    ((InputStream)object).close();
                }
                catch (IOException iOException) {}
                break block21;
                {
                    catch (IOException iOException) {
                        if (Debug.isDeploymentDebugEnabled()) {
                            Debug.deploymentDebug("Exception while staging file: /" + string + " Unable to get resource from classloader" + iOException.getMessage());
                        }
                        deploymentException = new DeploymentException(iOException);
                        Object var12_12 = null;
                        try {
                            ((InputStream)object).close();
                        }
                        catch (IOException iOException2) {}
                    }
                }
                catch (Throwable throwable) {
                    Object var12_13 = null;
                    try {
                        ((InputStream)object).close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }
        if (!bl) {
            throw deploymentException;
        }
    }

    public void createBeansForInternalApp(InternalApp internalApp, DomainMBean domainMBean) throws ApplicationException, InvalidAttributeValueException, ManagementException {
        String string = internalApp.name;
        File file = internalApp.adminOnly ? new File(new File(internalApp.location), string + internalApp.suffix) : new File(this.stageDir, string + internalApp.suffix);
        if (Debug.isDeploymentDebugEnabled()) {
            Debug.deploymentDebug("Creating ApplicationMBean for internal app: " + file);
        }
        if (!file.exists()) {
            throw new ApplicationException(DeployerRuntimeLogger.noAppFilesExist((String)string));
        }
        ApplicationMBean applicationMBean = MBeanFactory.getMBeanFactory().initializeMBeans(domainMBean, file, string, null, null, null);
        applicationMBean.setPersistenceEnabled(false);
        applicationMBean.setLoadOrder(0);
        applicationMBean.setStagingMode("nostage");
        applicationMBean.setInternalApp(true);
        ComponentMBean[] componentMBeanArray = applicationMBean.getComponents();
        for (int i = 0; i < componentMBeanArray.length; ++i) {
            componentMBeanArray[i].setPersistenceEnabled(false);
            if (internalApp.isClustered()) {
                componentMBeanArray[i].setTargets(this.getTargetsForClusteredInternalApp(domainMBean));
                continue;
            }
            componentMBeanArray[i].setTargets(this.getTargetsForInternalApp(domainMBean));
        }
        this.createAppDeploymentMBeanForInternalApp(applicationMBean, file.getPath(), domainMBean, internalApp);
    }

    public void createAppDeploymentMBeanForInternalApp(ApplicationMBean applicationMBean, String string, DomainMBean domainMBean, InternalApp internalApp) throws InvalidAttributeValueException, ManagementException {
        AppDeploymentMBean appDeploymentMBean;
        if (internalApp.isLib) {
            if (Debug.isDeploymentDebugEnabled()) {
                Debug.deploymentDebug("Creating LibraryMBean for internal app: " + string);
            }
            appDeploymentMBean = domainMBean.createInternalLibrary(applicationMBean.getName(), string);
        } else {
            if (Debug.isDeploymentDebugEnabled()) {
                Debug.deploymentDebug("Creating AppDeploymentMBean for internal app: " + string);
            }
            appDeploymentMBean = domainMBean.createInternalAppDeployment(applicationMBean.getName(), string);
        }
        if (internalApp.isBackground) {
            appDeploymentMBean.setBackgroundDeployment(true);
        }
        appDeploymentMBean.setPersistenceEnabled(false);
        appDeploymentMBean.setDeploymentOrder(0);
        if (internalApp.isClustered()) {
            appDeploymentMBean.setTargets(this.getTargetsForClusteredInternalApp(domainMBean));
        } else {
            appDeploymentMBean.setTargets(this.getTargetsForInternalApp(domainMBean));
        }
        appDeploymentMBean.setStagingMode("nostage");
        appDeploymentMBean.setSecurityDDModel("DDOnly");
        appDeploymentMBean.setInternalApp(true);
        if (internalApp.onDemandContextPaths != null && internalApp.onDemandContextPaths.length > 0 && domainMBean.isInternalAppsDeployOnDemandEnabled()) {
            if (Debug.isDeploymentDebugEnabled()) {
                Debug.deploymentDebug("Marking internal application for on-demand deployment: " + internalApp.name + " with refresh page boolean: " + internalApp.onDemandDisplayRefresh);
            }
            appDeploymentMBean.setOnDemandContextPaths(internalApp.onDemandContextPaths);
            appDeploymentMBean.setOnDemandDisplayRefresh(internalApp.onDemandDisplayRefresh);
            appDeploymentMBean.setBackgroundDeployment(true);
        }
        appDeploymentMBean.setDeploymentPlanDescriptor(internalApp.getDeploymentPlanBean());
    }

    private TargetMBean[] getTargetsForInternalApp(DomainMBean domainMBean) {
        ServerMBean serverMBean = domainMBean.lookupServer(this.serverName);
        return new TargetMBean[]{serverMBean};
    }

    private TargetMBean[] getTargetsForClusteredInternalApp(DomainMBean domainMBean) {
        ServerMBean serverMBean = domainMBean.lookupServer(this.serverName);
        ClusterMBean clusterMBean = serverMBean.getCluster();
        if (clusterMBean != null) {
            return new TargetMBean[]{clusterMBean};
        }
        return new TargetMBean[]{serverMBean};
    }

    private void initStagingDir() {
        this.serverName = ManagementService.getRuntimeAccess(kernelId).getServerName();
        String string = DomainDir.getTempDirForServer((String)this.serverName) + File.separatorChar + ".internal";
        try {
            this.stageDir = new File(string).getCanonicalFile();
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
    }

    private void initConsoleDeploymentPlan(InternalApp internalApp, DomainMBean domainMBean) {
        VariableAssignmentBean variableAssignmentBean;
        VariableBean variableBean;
        AdminConsoleMBean adminConsoleMBean = domainMBean.getAdminConsole();
        if (adminConsoleMBean == null) {
            return;
        }
        boolean bl = adminConsoleMBean.isSet(COOKIE_NAME);
        boolean bl2 = adminConsoleMBean.isSet(SESSION_TIMEOUT);
        if (!bl && !bl2) {
            return;
        }
        EditableDescriptorManager editableDescriptorManager = new EditableDescriptorManager();
        DeploymentPlanBean deploymentPlanBean = (DeploymentPlanBean)editableDescriptorManager.createDescriptorRoot(DeploymentPlanBean.class, "UTF-8").getRootBean();
        deploymentPlanBean.setApplicationName("consoleapp");
        VariableDefinitionBean variableDefinitionBean = deploymentPlanBean.getVariableDefinition();
        if (bl) {
            variableBean = variableDefinitionBean.createVariable();
            variableBean.setName(COOKIE_NAME);
            variableBean.setValue(adminConsoleMBean.getCookieName());
        }
        if (bl2) {
            variableBean = variableDefinitionBean.createVariable();
            variableBean.setName(SESSION_TIMEOUT);
            variableBean.setValue("" + adminConsoleMBean.getSessionTimeout());
        }
        variableBean = deploymentPlanBean.createModuleOverride();
        variableBean.setModuleName("webapp");
        variableBean.setModuleType("war");
        ModuleDescriptorBean moduleDescriptorBean = variableBean.createModuleDescriptor();
        moduleDescriptorBean.setRootElement("weblogic-web-app");
        moduleDescriptorBean.setUri("WEB-INF/weblogic.xml");
        if (bl) {
            variableAssignmentBean = moduleDescriptorBean.createVariableAssignment();
            variableAssignmentBean.setName(COOKIE_NAME);
            variableAssignmentBean.setXpath("/weblogic-web-app/session-descriptor/cookie-name");
        }
        if (bl2) {
            variableAssignmentBean = moduleDescriptorBean.createVariableAssignment();
            variableAssignmentBean.setName(SESSION_TIMEOUT);
            variableAssignmentBean.setXpath("/weblogic-web-app/session-descriptor/timeout-secs");
        }
        internalApp.setDeploymentPlanBean(deploymentPlanBean);
    }

    private final class InternalApp {
        private final String name;
        private final String suffix;
        private final boolean adminOnly;
        private final boolean critical;
        private final String location;
        private final boolean isLib;
        private boolean isBackground;
        private String[] onDemandContextPaths;
        private boolean onDemandDisplayRefresh;
        private DeploymentPlanBean deploymentPlanBean;
        private boolean clustered;

        private InternalApp(String string, String string2, boolean bl, boolean bl2) {
            this(string, string2, bl, bl2, false, false);
        }

        private InternalApp(String string, String string2, boolean bl, boolean bl2, boolean bl3) {
            this(string, string2, bl, bl2, false, bl3);
        }

        private InternalApp(String string, String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
            this(string, string2, bl, bl2, bl3, bl4, null, false);
        }

        private InternalApp(String string, String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4, String[] stringArray, boolean bl5) {
            this.name = string;
            this.suffix = string2;
            this.adminOnly = bl;
            this.critical = bl2;
            this.location = LIB;
            this.isLib = bl3;
            this.isBackground = bl4;
            this.onDemandContextPaths = stringArray;
            this.onDemandDisplayRefresh = bl5;
        }

        private DeploymentPlanBean getDeploymentPlanBean() {
            return this.deploymentPlanBean;
        }

        private void setDeploymentPlanBean(DeploymentPlanBean deploymentPlanBean) {
            this.deploymentPlanBean = deploymentPlanBean;
        }

        private boolean isClustered() {
            return this.clustered;
        }

        private void setClustered(boolean bl) {
            this.clustered = bl;
        }
    }
}

