/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.internal;

import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import weblogic.application.ModuleListener;
import weblogic.application.utils.TargetUtils;
import weblogic.deploy.beans.factory.InvalidTargetException;
import weblogic.deploy.common.Debug;
import weblogic.deploy.internal.targetserver.BasicDeployment;
import weblogic.deploy.internal.targetserver.state.DeploymentState;
import weblogic.deploy.internal.targetserver.state.TargetModuleState;
import weblogic.management.configuration.BasicDeploymentMBean;
import weblogic.management.configuration.ClusterMBean;
import weblogic.management.configuration.DeploymentMBean;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.configuration.SubDeploymentMBean;
import weblogic.management.configuration.TargetInfoMBean;
import weblogic.management.configuration.TargetMBean;
import weblogic.management.deploy.DeploymentData;
import weblogic.management.provider.ManagementService;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.utils.collections.ArraySet;

public class TargetHelper {
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    public static ServerMBean localServer = ManagementService.getRuntimeAccess(kernelId).getServer();

    public static String[] getModulesForTarget(DeploymentData deploymentData, DomainMBean domainMBean) {
        if (deploymentData.isTargetsFromConfig()) {
            return null;
        }
        if (deploymentData.hasGlobalTarget(localServer.getName())) {
            return null;
        }
        Map map = deploymentData.getAllModuleTargets();
        Iterator iterator = map.keySet().iterator();
        ArrayList<String> arrayList = new ArrayList<String>();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String[] stringArray = (String[])map.get(string);
            if (!TargetHelper.targetsContainLocalServer(stringArray, domainMBean)) continue;
            arrayList.add(string);
        }
        if (arrayList.size() > 0) {
            return arrayList.toArray(new String[0]);
        }
        return null;
    }

    private static boolean targetsContainLocalServer(String[] stringArray, DomainMBean domainMBean) {
        TargetMBean[] targetMBeanArray;
        try {
            DomainMBean domainMBean2 = domainMBean;
            if (domainMBean == null) {
                domainMBean2 = ManagementService.getRuntimeAccess(kernelId).getDomain();
            }
            targetMBeanArray = TargetHelper.lookupTargetMBeans(domainMBean2, stringArray);
        }
        catch (InvalidTargetException invalidTargetException) {
            throw new AssertionError((Object)invalidTargetException);
        }
        catch (Exception exception) {
            throw new AssertionError((Object)exception);
        }
        return TargetUtils.isDeployedLocally(targetMBeanArray);
    }

    public static boolean isAppTargetedToCurrentServer(BasicDeploymentMBean basicDeploymentMBean) {
        TargetMBean[] targetMBeanArray = basicDeploymentMBean.getTargets();
        String string = localServer.getName();
        ArraySet arraySet = new ArraySet();
        for (int i = 0; i < targetMBeanArray.length; ++i) {
            arraySet.addAll(targetMBeanArray[i].getServerNames());
        }
        if (arraySet.contains(string)) {
            return true;
        }
        return TargetHelper.areSubDeploymentsTargetedToCurrentServer(basicDeploymentMBean);
    }

    private static boolean areSubDeploymentsTargetedToCurrentServer(BasicDeploymentMBean basicDeploymentMBean) {
        List list = TargetHelper.getAllSubDeployments(basicDeploymentMBean);
        String string = localServer.getName();
        for (SubDeploymentMBean subDeploymentMBean : list) {
            if (subDeploymentMBean == null) continue;
            TargetMBean[] targetMBeanArray = subDeploymentMBean.getTargets();
            for (int i = 0; i < targetMBeanArray.length; ++i) {
                Set set = targetMBeanArray[i].getServerNames();
                if (!set.contains(string)) continue;
                return true;
            }
        }
        return false;
    }

    private static List getAllSubDeployments(BasicDeploymentMBean basicDeploymentMBean) {
        ArrayList<SubDeploymentMBean> arrayList = new ArrayList<SubDeploymentMBean>();
        SubDeploymentMBean[] subDeploymentMBeanArray = basicDeploymentMBean.getSubDeployments();
        if (subDeploymentMBeanArray == null || subDeploymentMBeanArray.length == 0) {
            return Collections.EMPTY_LIST;
        }
        for (int i = 0; i < subDeploymentMBeanArray.length; ++i) {
            arrayList.add(subDeploymentMBeanArray[i]);
            List list = TargetHelper.getAllSubDeployments(subDeploymentMBeanArray[i]);
            arrayList.addAll(list);
        }
        return arrayList;
    }

    private static List getAllSubDeployments(SubDeploymentMBean subDeploymentMBean) {
        ArrayList<SubDeploymentMBean> arrayList = new ArrayList<SubDeploymentMBean>();
        SubDeploymentMBean[] subDeploymentMBeanArray = subDeploymentMBean.getSubDeployments();
        if (subDeploymentMBeanArray == null || subDeploymentMBeanArray.length == 0) {
            return Collections.EMPTY_LIST;
        }
        for (int i = 0; i < subDeploymentMBeanArray.length; ++i) {
            arrayList.add(subDeploymentMBeanArray[i]);
            List list = TargetHelper.getAllSubDeployments(subDeploymentMBeanArray[i]);
            arrayList.addAll(list);
        }
        return arrayList;
    }

    public static TargetMBean[] lookupTargetMBeans(DomainMBean domainMBean, String[] stringArray) throws InvalidTargetException {
        TargetMBean[] targetMBeanArray = new TargetMBean[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                targetMBeanArray[i] = domainMBean.lookupTarget(stringArray[i]);
                if (targetMBeanArray[i] != null) continue;
                throw new InvalidTargetException(stringArray[i]);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new InvalidTargetException(stringArray[i]);
            }
        }
        return targetMBeanArray;
    }

    public static String[] getNonGlobalModules(DeploymentData deploymentData, BasicDeployment basicDeployment, DomainMBean domainMBean) {
        if (deploymentData.isTargetsFromConfig()) {
            return null;
        }
        TargetMBean[] targetMBeanArray = basicDeployment.getDeploymentMBean().getTargets();
        if (TargetUtils.isDeployedLocally(targetMBeanArray)) {
            for (int i = 0; i < targetMBeanArray.length; ++i) {
                TargetMBean targetMBean = targetMBeanArray[i];
                if (!deploymentData.hasGlobalTarget(targetMBean.getName())) continue;
                return null;
            }
            return TargetHelper.getModulesForTarget(deploymentData, domainMBean);
        }
        DeploymentState deploymentState = basicDeployment.getState();
        if (null == deploymentState) {
            return TargetHelper.getModulesForTarget(deploymentData, domainMBean);
        }
        TargetModuleState[] targetModuleStateArray = deploymentState.getTargetModules();
        boolean bl = true;
        String[] stringArray = TargetHelper.getModulesForTarget(deploymentData, domainMBean);
        if (stringArray != null && targetModuleStateArray != null) {
            List<String> list = Arrays.asList(stringArray);
            for (int i = 0; i < targetModuleStateArray.length; ++i) {
                if (targetModuleStateArray[i].getCurrentState().equals(((Object)ModuleListener.STATE_NEW).toString()) || list.contains(targetModuleStateArray[i].getModuleId())) continue;
                bl = false;
            }
        }
        if (!bl) {
            return stringArray;
        }
        return null;
    }

    public static String[] getNonGlobalSubModules(DeploymentData deploymentData, BasicDeployment basicDeployment) {
        String[] stringArray;
        Object[] objectArray2;
        if (deploymentData.isTargetsFromConfig()) {
            return null;
        }
        DeploymentState deploymentState = basicDeployment.getState();
        if (deploymentState == null) {
            return null;
        }
        TargetModuleState[] targetModuleStateArray = deploymentState.getTargetModules();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < targetModuleStateArray.length; ++i) {
            if (!targetModuleStateArray[i].isSubmodule() || ((Object)ModuleListener.STATE_NEW).toString().equals(targetModuleStateArray[i].getCurrentState())) continue;
            arrayList.add(targetModuleStateArray[i].getSubmoduleId());
        }
        Map map = deploymentData.getAllSubModuleTargets();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (Object[] objectArray2 : map.keySet()) {
            stringArray = (String[])map.get(objectArray2);
            Iterator iterator = stringArray.keySet().iterator();
            while (iterator.hasNext()) {
                arrayList2.add((String)iterator.next());
            }
        }
        if (arrayList2.containsAll(arrayList)) {
            return null;
        }
        objectArray2 = arrayList2.toArray();
        if (0 == objectArray2.length) {
            return null;
        }
        stringArray = new String[objectArray2.length];
        for (int i = 0; i < objectArray2.length; ++i) {
            stringArray[i] = (String)objectArray2[i];
        }
        return stringArray;
    }

    public static ClusterMBean getTargetCluster(String string) {
        ClusterMBean clusterMBean = null;
        DomainMBean domainMBean = ManagementService.getRuntimeAccess(kernelId).getDomain();
        ServerMBean serverMBean = domainMBean.lookupServer(string);
        if (serverMBean != null) {
            clusterMBean = serverMBean.getCluster();
        }
        if (clusterMBean == null) {
            clusterMBean = domainMBean.lookupCluster(string);
        }
        return clusterMBean;
    }

    public static Set getAllTargetedServers(BasicDeploymentMBean basicDeploymentMBean) {
        HashSet hashSet = new HashSet();
        hashSet.addAll(TargetHelper.resolveTargetMBeans(basicDeploymentMBean.getTargets()));
        SubDeploymentMBean[] subDeploymentMBeanArray = basicDeploymentMBean.getSubDeployments();
        for (int i = 0; i < subDeploymentMBeanArray.length; ++i) {
            hashSet.addAll(TargetHelper.resolveTargetMBeans(subDeploymentMBeanArray[i].getTargets()));
            hashSet.addAll(TargetHelper.resolveTargetInfos(subDeploymentMBeanArray[i].getSubDeployments()));
        }
        return hashSet;
    }

    private static Set resolveTargetMBeans(TargetMBean[] targetMBeanArray) {
        HashSet hashSet = new HashSet();
        if (targetMBeanArray != null) {
            for (int i = 0; i < targetMBeanArray.length; ++i) {
                hashSet.addAll(targetMBeanArray[i].getServerNames());
            }
        }
        return hashSet;
    }

    private static Set resolveTargetInfos(TargetInfoMBean[] targetInfoMBeanArray) {
        HashSet hashSet = new HashSet();
        for (int i = 0; i < targetInfoMBeanArray.length; ++i) {
            hashSet.addAll(TargetHelper.resolveTargetMBeans(targetInfoMBeanArray[i].getTargets()));
        }
        return hashSet;
    }

    public static int getTypeForTarget(String string) {
        DomainMBean domainMBean = ManagementService.getRuntimeAccess(kernelId).getDomain();
        if (domainMBean.lookupCluster(string) != null) {
            return 1;
        }
        if (domainMBean.lookupServer(string) != null) {
            return 2;
        }
        if (domainMBean.lookupVirtualHost(string) != null) {
            return 3;
        }
        if (domainMBean.lookupJMSServer(string) != null) {
            return 4;
        }
        if (domainMBean.lookupSAFAgent(string) != null) {
            return 5;
        }
        return 0;
    }

    public static boolean isTargetedLocaly(BasicDeploymentMBean basicDeploymentMBean) {
        Set set = TargetHelper.getAllTargetedServers(basicDeploymentMBean);
        TargetHelper.printTargetList(basicDeploymentMBean, set);
        return set.contains(ManagementService.getRuntimeAccess(kernelId).getServer().getName());
    }

    public static boolean isTargetedLocally(DeploymentMBean deploymentMBean) {
        Set set = TargetHelper.resolveTargetMBeans(deploymentMBean.getTargets());
        return set.contains(ManagementService.getRuntimeAccess(kernelId).getServer().getName());
    }

    public static boolean isPinnedToServerInCluster(BasicDeploymentMBean basicDeploymentMBean) {
        ServerMBean serverMBean = ManagementService.getRuntimeAccess(kernelId).getServer();
        String string = serverMBean.getName();
        ClusterMBean clusterMBean = serverMBean.getCluster();
        if (clusterMBean == null) {
            return false;
        }
        Set set = clusterMBean.getServerNames();
        set.remove(string);
        Set set2 = TargetHelper.getAllTargetedServers(basicDeploymentMBean);
        TargetHelper.printTargetList(basicDeploymentMBean, set2);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            if (!set2.contains(iterator.next())) continue;
            return true;
        }
        return false;
    }

    private static void printTargetList(BasicDeploymentMBean basicDeploymentMBean, Set set) {
        if (Debug.isDeploymentDebugEnabled()) {
            Debug.deploymentDebug("Targets for app, " + basicDeploymentMBean.getName());
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Debug.deploymentDebug("   " + iterator.next());
            }
        }
    }

    public static boolean isDebugEnabled() {
        return Debug.isDeploymentDebugEnabled();
    }

    public static String[] getTargetNames(TargetMBean[] targetMBeanArray) {
        if (targetMBeanArray == null) {
            return null;
        }
        String[] stringArray = new String[targetMBeanArray.length];
        for (int i = 0; i < targetMBeanArray.length; ++i) {
            stringArray[i] = targetMBeanArray[i].getName();
        }
        return stringArray;
    }
}

