/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.internal;

import weblogic.descriptor.EditableDescriptorManager;
import weblogic.j2ee.descriptor.wl.DeploymentPlanBean;
import weblogic.j2ee.descriptor.wl.ModuleDescriptorBean;
import weblogic.j2ee.descriptor.wl.ModuleOverrideBean;
import weblogic.j2ee.descriptor.wl.VariableAssignmentBean;
import weblogic.j2ee.descriptor.wl.VariableBean;
import weblogic.j2ee.descriptor.wl.VariableDefinitionBean;
import weblogic.management.configuration.JTAMBean;

public class WSATAppDeployHelper {
    private static final String WAR = ".war";
    private static final String BUILTIN_POLICY_HOME = "weblogic/wsee/policy/runtime/";
    private static final String POLICY_HOME = "policies/";
    private static final String WSAT_POLICY = "policy:wls_internal/wsat/wsat-registration-policy.xml";
    private static final String WSAT11_POLICY = "policy:wls_internal/wsat/wsat11-registration-policy.xml";
    private static final String WSAT_INBOUND_POLICY = "policy:wls_internal/wsat/wsat-registration-inbound-policy.xml";
    private static final String WSAT11_INBOUND_POLICY = "policy:wls_internal/wsat/wsat11-registration-inbound-policy.xml";
    private static final String WSAT_OUTBOUND_POLICY = "policy:wls_internal/wsat/wsat-registration-outbound-policy.xml";
    private static final String WSAT11_OUTBOUND_POLICY = "policy:wls_internal/wsat/wsat11-registration-outbound-policy.xml";
    private static final String WSAT_HTTPS_POLICY = "policy:wls_internal/wsat/wsat-https-policy.xml";
    private static final String WSAT_HTTPSCLIENTCERT_POLICY = "policy:wls_internal/wsat/wsat-httpsclientcert-policy.xml";
    private static final String WSAT_REGISTRATION_PORT = "RegistrationPortTypeRPCPort";
    private static final String WSAT11_REGISTRATION_PORT = "RegistrationPort";
    private static final String WSAT_REGISTRATIONREQUESTER_PORT = "RegistrationRequesterPortTypePort";
    private static final String WSAT11_REGISTRATIONREQUESTER_PORT = "RegistrationRequesterPort";
    private static final String[] PORTS = new String[]{"RegistrationPortTypeRPCPort", "RegistrationPort", "RegistrationRequesterPortTypePort", "RegistrationRequesterPort", "ParticipantPortTypePort", "CoordinatorPortTypePort", "ParticipantPort", "CoordinatorPort"};

    public static DeploymentPlanBean buildWSATAppDeploymentPlan(String string, JTAMBean jTAMBean) {
        if (jTAMBean == null) {
            return null;
        }
        boolean bl = jTAMBean.isWSATIssuedTokenEnabled();
        String string2 = jTAMBean.getWSATTransportSecurityMode();
        if (!bl && "SSLNotRequired".equals(string2)) {
            return null;
        }
        return WSATAppDeployHelper.buildWSATAppDeploymentPlan(string, bl, string2);
    }

    public static DeploymentPlanBean buildWSATAppDeploymentPlan(String string, boolean bl, String string2) {
        EditableDescriptorManager editableDescriptorManager = new EditableDescriptorManager();
        DeploymentPlanBean deploymentPlanBean = (DeploymentPlanBean)editableDescriptorManager.createDescriptorRoot(DeploymentPlanBean.class, "UTF-8").getRootBean();
        deploymentPlanBean.setApplicationName(string);
        ModuleDescriptorBean moduleDescriptorBean = WSATAppDeployHelper.createModuleOverrideBean(string, deploymentPlanBean);
        VariableDefinitionBean variableDefinitionBean = deploymentPlanBean.getVariableDefinition();
        if (bl) {
            WSATAppDeployHelper.createVDBean(variableDefinitionBean, WSAT_POLICY, "both");
            WSATAppDeployHelper.createVDBean(variableDefinitionBean, WSAT11_POLICY, "both");
            WSATAppDeployHelper.createVDBean(variableDefinitionBean, WSAT_INBOUND_POLICY, "inbound");
            WSATAppDeployHelper.createVDBean(variableDefinitionBean, WSAT_OUTBOUND_POLICY, "outbound");
            WSATAppDeployHelper.createVDBean(variableDefinitionBean, WSAT_REGISTRATIONREQUESTER_PORT, "inbound");
            WSATAppDeployHelper.createVDBean(variableDefinitionBean, WSAT11_INBOUND_POLICY, "inbound");
            WSATAppDeployHelper.createVDBean(variableDefinitionBean, WSAT11_OUTBOUND_POLICY, "outbound");
            WSATAppDeployHelper.createVDBean(variableDefinitionBean, WSAT11_REGISTRATIONREQUESTER_PORT, "inbound");
            WSATAppDeployHelper.attachPolicyToPort(moduleDescriptorBean, WSAT_REGISTRATION_PORT, WSAT_POLICY);
            WSATAppDeployHelper.attachPolicyToPort(moduleDescriptorBean, WSAT_REGISTRATION_PORT, WSAT_INBOUND_POLICY, true);
            WSATAppDeployHelper.attachPolicyToPort(moduleDescriptorBean, WSAT_REGISTRATION_PORT, WSAT_OUTBOUND_POLICY, true);
            WSATAppDeployHelper.attachPolicyToPort(moduleDescriptorBean, WSAT_REGISTRATIONREQUESTER_PORT, WSAT_POLICY);
            WSATAppDeployHelper.attachPolicyToPort(moduleDescriptorBean, WSAT_REGISTRATIONREQUESTER_PORT, WSAT_REGISTRATIONREQUESTER_PORT, WSAT_OUTBOUND_POLICY, true);
            WSATAppDeployHelper.attachPolicyToPort(moduleDescriptorBean, WSAT11_REGISTRATION_PORT, WSAT11_POLICY);
            WSATAppDeployHelper.attachPolicyToPort(moduleDescriptorBean, WSAT11_REGISTRATION_PORT, WSAT11_INBOUND_POLICY, true);
            WSATAppDeployHelper.attachPolicyToPort(moduleDescriptorBean, WSAT11_REGISTRATION_PORT, WSAT11_OUTBOUND_POLICY, true);
            WSATAppDeployHelper.attachPolicyToPort(moduleDescriptorBean, WSAT11_REGISTRATIONREQUESTER_PORT, WSAT11_POLICY);
            WSATAppDeployHelper.attachPolicyToPort(moduleDescriptorBean, WSAT11_REGISTRATIONREQUESTER_PORT, WSAT11_REGISTRATIONREQUESTER_PORT, WSAT11_OUTBOUND_POLICY, true);
        }
        if ("SSLRequired".equals(string2)) {
            WSATAppDeployHelper.createVDBean(variableDefinitionBean, WSAT_HTTPS_POLICY, "both");
            for (String string3 : PORTS) {
                WSATAppDeployHelper.attachPolicyToPort(moduleDescriptorBean, string3, WSAT_HTTPS_POLICY);
            }
        }
        if ("ClientCertRequired".equals(string2)) {
            WSATAppDeployHelper.createVDBean(variableDefinitionBean, WSAT_HTTPSCLIENTCERT_POLICY, "both");
            for (String string3 : PORTS) {
                WSATAppDeployHelper.attachPolicyToPort(moduleDescriptorBean, string3, WSAT_HTTPSCLIENTCERT_POLICY);
            }
        }
        return deploymentPlanBean;
    }

    private static void createVDBean(VariableDefinitionBean variableDefinitionBean, String string, String string2) {
        VariableBean variableBean = variableDefinitionBean.createVariable();
        variableBean.setName(string);
        variableBean.setValue(string2);
    }

    private static ModuleDescriptorBean createModuleOverrideBean(String string, DeploymentPlanBean deploymentPlanBean) {
        ModuleOverrideBean moduleOverrideBean = deploymentPlanBean.createModuleOverride();
        moduleOverrideBean.setModuleName(string + WAR);
        moduleOverrideBean.setModuleType("war");
        ModuleDescriptorBean moduleDescriptorBean = moduleOverrideBean.createModuleDescriptor();
        moduleDescriptorBean.setRootElement("webservice-policy-ref");
        moduleDescriptorBean.setUri("WEB-INF/weblogic-webservices-policy.xml");
        return moduleDescriptorBean;
    }

    private static void attachPolicyToPort(ModuleDescriptorBean moduleDescriptorBean, String string, String string2) {
        WSATAppDeployHelper.attachPolicyToPort(moduleDescriptorBean, string, string2, false);
    }

    private static void attachPolicyToPort(ModuleDescriptorBean moduleDescriptorBean, String string, String string2, boolean bl) {
        WSATAppDeployHelper.attachPolicyToPort(moduleDescriptorBean, string, string2, string2, bl);
    }

    private static void attachPolicyToPort(ModuleDescriptorBean moduleDescriptorBean, String string, String string2, String string3, boolean bl) {
        if (bl && !WSATAppDeployHelper.isExisted(string3)) {
            return;
        }
        VariableAssignmentBean variableAssignmentBean = moduleDescriptorBean.createVariableAssignment();
        variableAssignmentBean.setName(string2);
        variableAssignmentBean.setXpath("/webservice-policy-ref/port-policy/[port-name=\"" + string + "\"]/ws-policy/[uri=\"" + string3 + "\"]/direction");
    }

    private static boolean isExisted(String string) {
        String string2 = string.substring(7);
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        return classLoader.getResourceAsStream(POLICY_HOME + string2) != null || classLoader.getResourceAsStream(BUILTIN_POLICY_HOME + string2) != null;
    }
}

