/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.internal.adminserver;

import java.beans.BeanInfo;
import java.io.File;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import javax.enterprise.deploy.shared.ModuleType;
import weblogic.application.ApplicationFileManager;
import weblogic.deploy.api.shared.WebLogicModuleType;
import weblogic.deploy.beans.factory.DeploymentBeanFactory;
import weblogic.deploy.beans.factory.InvalidTargetException;
import weblogic.deploy.common.Debug;
import weblogic.deploy.internal.Deployment;
import weblogic.deploy.internal.DeploymentOrder;
import weblogic.deploy.internal.TargetHelper;
import weblogic.deploy.internal.adminserver.DeploymentManager;
import weblogic.deploy.service.ConfigurationContext;
import weblogic.deploy.service.DeploymentRequest;
import weblogic.descriptor.BeanUpdateEvent;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.DescriptorDiff;
import weblogic.management.ManagementException;
import weblogic.management.WebLogicMBean;
import weblogic.management.configuration.AppDeploymentMBean;
import weblogic.management.configuration.BasicDeploymentMBean;
import weblogic.management.configuration.ClusterMBean;
import weblogic.management.configuration.DeploymentMBean;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.DomainTargetedMBean;
import weblogic.management.configuration.JMSServerMBean;
import weblogic.management.configuration.JMSSystemResourceMBean;
import weblogic.management.configuration.MigratableTargetMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.configuration.SubDeploymentMBean;
import weblogic.management.configuration.SystemResourceMBean;
import weblogic.management.configuration.TargetInfoMBean;
import weblogic.management.configuration.TargetMBean;
import weblogic.management.deploy.DeploymentData;
import weblogic.management.deploy.DeploymentTaskRuntime;
import weblogic.management.deploy.internal.DeployerRuntimeLogger;
import weblogic.management.deploy.internal.DeploymentServerService;
import weblogic.management.internal.PendingDirectoryManager;
import weblogic.management.provider.ManagementService;
import weblogic.management.provider.ManagementServiceRestricted;
import weblogic.management.provider.beaninfo.BeanInfoAccess;
import weblogic.management.provider.internal.DescriptorInfoUtils;
import weblogic.management.runtime.AppRuntimeStateRuntimeMBean;
import weblogic.management.utils.AppDeploymentHelper;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;
import weblogic.utils.StackTraceUtils;

final class ConfigChangesHandler {
    private static final String TARGETS_PROP_NAME = "Targets";
    private static final String CANDIDATE_SERVERS_PROP_NAME = "ConstrainedCandidateServers";
    private static final String TASK_ID_PREFIX = "weblogic.deploy.configChangeTask.";
    private static int curTaskId = 0;
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static AppRuntimeStateRuntimeMBean appRTMBean;
    private static DeploymentBeanFactory beanFactory;

    ConfigChangesHandler() {
    }

    public static List[] configChanged(DeploymentRequest deploymentRequest, ConfigurationContext configurationContext) {
        Map map;
        boolean bl = false;
        boolean bl2 = false;
        Iterator iterator = ConfigChangesHandler.getDescriptorDiff(configurationContext);
        if (iterator == null) {
            return null;
        }
        if (Debug.isDeploymentDebugEnabled()) {
            Debug.deploymentDebug("ConfigChangesHandler.configChanged: deployRequest=" + deploymentRequest.getId() + ", diffs=" + ConfigChangesHandler.dumpDiff(configurationContext));
        }
        OrderedDeployments orderedDeployments = new OrderedDeployments();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<SubDeploymentMBean[]> arrayList2 = new ArrayList<SubDeploymentMBean[]>();
        ArrayList<Object> arrayList3 = new ArrayList<Object>();
        ArrayList<SubDeploymentMBean[]> arrayList4 = new ArrayList<SubDeploymentMBean[]>();
        ArrayList<Object> arrayList5 = new ArrayList<Object>();
        ArrayList<SubDeploymentMBean[]> arrayList6 = new ArrayList<SubDeploymentMBean[]>();
        while (iterator.hasNext()) {
            map = (BeanUpdateEvent)iterator.next();
            BeanUpdateEvent.PropertyUpdate[] propertyUpdateArray = map.getUpdateList();
            DescriptorBean descriptorBean = map.getSourceBean();
            boolean bl3 = false;
            block6: for (int i = 0; i < propertyUpdateArray.length; ++i) {
                SubDeploymentMBean[] subDeploymentMBeanArray;
                Object object;
                BeanUpdateEvent.PropertyUpdate propertyUpdate = propertyUpdateArray[i];
                if (beanFactory.isDeployerInitiatedBeanUpdate(descriptorBean, propertyUpdate)) {
                    if (Debug.isDeploymentDebugEnabled()) {
                        Debug.deploymentDebug("ConfigChangesHandler.isDeployerInitiatedBeanUpdate " + propertyUpdate);
                    }
                    if (propertyUpdate.getUpdateType() != 2 || !((object = propertyUpdate.getAddedObject()) instanceof AppDeploymentMBean)) continue;
                    subDeploymentMBeanArray = (AppDeploymentMBean)object;
                    arrayList6.add(subDeploymentMBeanArray);
                    continue;
                }
                switch (propertyUpdate.getUpdateType()) {
                    case 2: {
                        object = propertyUpdate.getAddedObject();
                        if (object instanceof BasicDeploymentMBean) {
                            ConfigChangesHandler.deploymentAdded(orderedDeployments, (BasicDeploymentMBean)object);
                            if (object instanceof SystemResourceMBean) {
                                if (object instanceof JMSSystemResourceMBean && (subDeploymentMBeanArray = ((JMSSystemResourceMBean)object).getSubDeployments()) != null && subDeploymentMBeanArray.length > 0) {
                                    bl2 = true;
                                }
                                arrayList5.add(object);
                            }
                        } else if (object instanceof SubDeploymentMBean) {
                            arrayList.add(object);
                            if (map.getProposedBean() instanceof JMSSystemResourceMBean) {
                                bl2 = true;
                            }
                        } else if (ConfigChangesHandler.isTargetsChanged(descriptorBean, propertyUpdate)) {
                            arrayList3.add(object);
                        } else if (ConfigChangesHandler.isCandidateServersChanged(descriptorBean, propertyUpdate)) {
                            bl3 = true;
                        }
                        if (!(object instanceof JMSServerMBean)) continue block6;
                        bl = true;
                        continue block6;
                    }
                    case 3: {
                        subDeploymentMBeanArray = propertyUpdate.getRemovedObject();
                        if (subDeploymentMBeanArray instanceof BasicDeploymentMBean) {
                            ConfigChangesHandler.deploymentRemoved(orderedDeployments, (BasicDeploymentMBean)subDeploymentMBeanArray);
                            if (!(subDeploymentMBeanArray instanceof SystemResourceMBean)) continue block6;
                            arrayList5.add(subDeploymentMBeanArray);
                            continue block6;
                        }
                        if (subDeploymentMBeanArray instanceof SubDeploymentMBean) {
                            arrayList2.add(subDeploymentMBeanArray);
                            continue block6;
                        }
                        if (ConfigChangesHandler.isTargetsChanged(descriptorBean, propertyUpdate)) {
                            arrayList4.add(subDeploymentMBeanArray);
                            continue block6;
                        }
                        if (!ConfigChangesHandler.isCandidateServersChanged(descriptorBean, propertyUpdate)) continue block6;
                        bl3 = true;
                        continue block6;
                    }
                    case 1: {
                        if (!ConfigChangesHandler.isTargetsChanged(descriptorBean, propertyUpdate) && !ConfigChangesHandler.isCandidateServersChanged(descriptorBean, propertyUpdate)) continue block6;
                        bl3 = true;
                        continue block6;
                    }
                }
            }
            if (bl3) {
                ConfigChangesHandler.targetsChanged(orderedDeployments, ConfigChangesHandler.getTargets((WebLogicMBean)descriptorBean), (WebLogicMBean)map.getProposedBean());
            }
            if (arrayList4.size() > 0) {
                ConfigChangesHandler.targetsRemoved(orderedDeployments, (WebLogicMBean)map.getProposedBean(), arrayList4);
                arrayList4.clear();
            }
            if (arrayList3.size() > 0) {
                ConfigChangesHandler.targetsAdded(orderedDeployments, (WebLogicMBean)map.getProposedBean(), Arrays.asList(ConfigChangesHandler.getTargets((WebLogicMBean)descriptorBean)), arrayList3);
                arrayList3.clear();
            }
            if (arrayList2.size() > 0) {
                ConfigChangesHandler.subDepsRemoved(orderedDeployments, (TargetInfoMBean)map.getProposedBean(), arrayList2);
                arrayList2.clear();
            }
            if (arrayList.size() <= 0) continue;
            ConfigChangesHandler.subDepsAdded(orderedDeployments, (TargetInfoMBean)map.getProposedBean(), arrayList);
            arrayList.clear();
        }
        map = ConfigChangesHandler.getExternalDescritorDiffs(configurationContext);
        ConfigChangesHandler.handleExternalTreeChanges(orderedDeployments, map, deploymentRequest.getId(), arrayList5);
        arrayList5.clear();
        boolean bl4 = !bl2 || !bl;
        return orderedDeployments.getAllDeployments(deploymentRequest, bl4, arrayList6);
    }

    public static void restartSystemResource(SystemResourceMBean systemResourceMBean) throws ManagementException {
        TargetMBean[] targetMBeanArray = ConfigChangesHandler.getTargets(systemResourceMBean);
        if (targetMBeanArray == null || targetMBeanArray.length == 0) {
            if (Debug.isDeploymentDebugEnabled()) {
                Debug.deploymentDebug("ConfigChangesHandler.restartSystemResource returning immediately since SystemResource '" + systemResourceMBean.getName() + "' does not have any targets");
            }
            return;
        }
        DeploymentData deploymentData = new DeploymentData();
        for (int i = 0; i < targetMBeanArray.length; ++i) {
            deploymentData.addTarget(targetMBeanArray[i].getName(), null);
        }
        weblogic.deploy.service.Deployment deployment = ConfigChangesHandler.findOrCreateDeployment(9, systemResourceMBean, deploymentData, false, false, true);
        DeploymentTaskRuntime deploymentTaskRuntime = ((Deployment)deployment).getDeploymentTaskRuntime();
        deploymentTaskRuntime.start();
    }

    private static void deploymentAdded(OrderedDeployments orderedDeployments, BasicDeploymentMBean basicDeploymentMBean) {
        TargetMBean[] targetMBeanArray = ConfigChangesHandler.getTargets(basicDeploymentMBean);
        if (targetMBeanArray == null || targetMBeanArray.length == 0) {
            return;
        }
        DeployInfo deployInfo = ConfigChangesHandler.createDeploymentInfo(basicDeploymentMBean, Arrays.asList(targetMBeanArray), 1, true);
        deployInfo.deployData.setNewApp(true);
        if (Debug.isDeploymentDebugEnabled()) {
            Debug.deploymentDebug("ConfigChangesHandler.deploymentAdded for " + basicDeploymentMBean.getName() + ", deployData=" + deployInfo.deployData);
        }
        deployInfo.requireRestart = false;
        orderedDeployments.addDeploymentInfo(deployInfo);
    }

    private static void deploymentRemoved(OrderedDeployments orderedDeployments, BasicDeploymentMBean basicDeploymentMBean) {
        String[] stringArray;
        Object object;
        TargetMBean[] targetMBeanArray;
        if (Debug.isDeploymentDebugEnabled()) {
            Debug.deploymentDebug("ConfigChangesHandler.deploymentRemoved for " + basicDeploymentMBean.getName() + ", bean: " + basicDeploymentMBean);
            targetMBeanArray = ConfigChangesHandler.getTargets(basicDeploymentMBean);
            for (int i = 0; i < targetMBeanArray.length; ++i) {
                object = targetMBeanArray[i].getServerNames();
                stringArray = new String[]{};
                String[] stringArray2 = object.toArray(stringArray);
                Debug.deploymentDebug("target[" + i + "] = " + targetMBeanArray[i]);
                for (int j = 0; j < stringArray2.length; ++j) {
                    Debug.deploymentDebug("\t sub-target[" + j + "] = " + stringArray2[j]);
                }
            }
        }
        targetMBeanArray = new DeploymentData();
        String[] stringArray3 = new String[]{};
        object = TargetHelper.getAllTargetedServers(basicDeploymentMBean).toArray(stringArray3);
        if (object != null && ((String[])object).length > 0) {
            targetMBeanArray.setGlobalTargets((String[])object);
            stringArray = new UndeployDeployInfo(basicDeploymentMBean, (DeploymentData)targetMBeanArray, false);
            stringArray.requireRestart = false;
            orderedDeployments.addDeploymentInfo((DeployInfo)stringArray);
        }
    }

    private static void subDepsAdded(OrderedDeployments orderedDeployments, TargetInfoMBean targetInfoMBean, List list) {
        if (list.size() == 0) {
            return;
        }
        if (Debug.isDeploymentDebugEnabled()) {
            Debug.deploymentDebug("ConfigChangesHandler.subDepsAdded for " + targetInfoMBean + ", subDeps=" + list + ", isJMSModule=" + ConfigChangesHandler.isJMSModule(targetInfoMBean));
        }
        if (ConfigChangesHandler.isJMSModule(targetInfoMBean)) {
            ConfigChangesHandler.jmsSubDepsChanged(orderedDeployments, list, true);
        } else {
            ConfigChangesHandler.appSubDepsChanged(orderedDeployments, targetInfoMBean, list, true);
        }
    }

    private static void subDepsRemoved(OrderedDeployments orderedDeployments, TargetInfoMBean targetInfoMBean, List list) {
        if (list.size() == 0) {
            return;
        }
        if (Debug.isDeploymentDebugEnabled()) {
            Debug.deploymentDebug("ConfigChangesHandler.subDepsRemoved for " + targetInfoMBean + ", subDeps=" + list + ", isJMSModule=" + ConfigChangesHandler.isJMSModule(targetInfoMBean));
        }
        if (ConfigChangesHandler.isJMSModule(targetInfoMBean)) {
            ConfigChangesHandler.jmsSubDepsChanged(orderedDeployments, list, false);
        } else {
            ConfigChangesHandler.appSubDepsChanged(orderedDeployments, targetInfoMBean, list, false);
        }
    }

    private static void jmsSubDepsChanged(OrderedDeployments orderedDeployments, List list, boolean bl) {
        RedeployDeployInfo redeployDeployInfo = new RedeployDeployInfo(null, new DeploymentData(), bl);
        for (SubDeploymentMBean subDeploymentMBean : list) {
            TargetMBean[] targetMBeanArray = subDeploymentMBean.getTargets();
            if (targetMBeanArray == null || targetMBeanArray.length == 0) continue;
            ConfigChangesHandler.populateDeploymentInfo(redeployDeployInfo, subDeploymentMBean, Arrays.asList(targetMBeanArray));
        }
        redeployDeployInfo.requireRestart = false;
        orderedDeployments.addDeploymentInfo(redeployDeployInfo);
    }

    private static void appSubDepsChanged(OrderedDeployments orderedDeployments, TargetInfoMBean targetInfoMBean, List list, boolean bl) {
        for (SubDeploymentMBean subDeploymentMBean : list) {
            TargetMBean[] targetMBeanArray;
            TargetMBean[] targetMBeanArray2;
            if (bl) {
                targetMBeanArray2 = ConfigChangesHandler.getTargets(targetInfoMBean);
                targetMBeanArray = ConfigChangesHandler.getTargets(subDeploymentMBean);
            } else {
                targetMBeanArray2 = ConfigChangesHandler.getTargets(subDeploymentMBean);
                targetMBeanArray = ConfigChangesHandler.getTargets(targetInfoMBean);
            }
            List list2 = ConfigChangesHandler.getTargetsNotIn(targetMBeanArray2, targetMBeanArray);
            List list3 = ConfigChangesHandler.getTargetsNotIn(targetMBeanArray, targetMBeanArray2);
            if (Debug.isDeploymentDebugEnabled()) {
                Debug.deploymentDebug("ConfigChangesHandler.appSubDepsChanged('" + subDeploymentMBean + ")" + " undeployTargets=" + list2 + ", deployTargets=" + list3);
            }
            if (list2.size() > 0) {
                ConfigChangesHandler.targetsRemoved(orderedDeployments, subDeploymentMBean, list2);
            }
            if (list3.size() <= 0) continue;
            ConfigChangesHandler.targetsAdded(orderedDeployments, subDeploymentMBean, Arrays.asList(targetMBeanArray2), list3);
        }
    }

    private static void targetsAdded(OrderedDeployments orderedDeployments, WebLogicMBean webLogicMBean, List list, List list2) {
        if (Debug.isDeploymentDebugEnabled()) {
            Debug.deploymentDebug("ConfigChangesHandler.targetsAdded for " + webLogicMBean + ", addedTargets=" + ConfigChangesHandler.getTargetsString(list2));
        }
        if (webLogicMBean instanceof TargetInfoMBean) {
            ConfigChangesHandler.deploymentTargetsAdded(orderedDeployments, (TargetInfoMBean)webLogicMBean, list, list2);
        } else {
            WebLogicMBean webLogicMBean2 = webLogicMBean;
            boolean bl = webLogicMBean instanceof MigratableTargetMBean;
            if (bl) {
                webLogicMBean2 = ConfigChangesHandler.getJMSServer((MigratableTargetMBean)webLogicMBean);
            }
            if (webLogicMBean2 instanceof DeploymentMBean && webLogicMBean2 instanceof TargetMBean) {
                ConfigChangesHandler.deploymentMBeanTargetChanged(orderedDeployments, (DeploymentMBean)webLogicMBean2, Collections.EMPTY_LIST, list2, bl, 9);
            }
        }
    }

    private static void targetsRemoved(OrderedDeployments orderedDeployments, WebLogicMBean webLogicMBean, List list) {
        if (Debug.isDeploymentDebugEnabled()) {
            Debug.deploymentDebug("ConfigChangesHandler.targetsRemoved for " + webLogicMBean + ", removedTargets=" + ConfigChangesHandler.getTargetsString(list));
        }
        if (webLogicMBean instanceof TargetInfoMBean) {
            ConfigChangesHandler.deploymentTargetsRemoved(orderedDeployments, (TargetInfoMBean)webLogicMBean, list);
        } else {
            WebLogicMBean webLogicMBean2 = webLogicMBean;
            boolean bl = webLogicMBean instanceof MigratableTargetMBean;
            if (bl) {
                webLogicMBean2 = ConfigChangesHandler.getJMSServer((MigratableTargetMBean)webLogicMBean);
            }
            if (webLogicMBean2 instanceof DeploymentMBean && webLogicMBean2 instanceof TargetMBean) {
                ConfigChangesHandler.deploymentMBeanTargetChanged(orderedDeployments, (DeploymentMBean)webLogicMBean2, list, Collections.EMPTY_LIST, bl, 12);
            }
        }
    }

    private static void targetsChanged(OrderedDeployments orderedDeployments, TargetMBean[] targetMBeanArray, WebLogicMBean webLogicMBean) {
        ConfigChangesHandler.targetsChanged(orderedDeployments, targetMBeanArray, ConfigChangesHandler.getTargets(webLogicMBean), webLogicMBean);
    }

    private static void targetsChanged(OrderedDeployments orderedDeployments, TargetMBean[] targetMBeanArray, TargetMBean[] targetMBeanArray2, WebLogicMBean webLogicMBean) {
        if (Debug.isDeploymentDebugEnabled()) {
            Debug.deploymentDebug("ConfigChangesHandler.targetsChanged for " + webLogicMBean + ", oldTargets=" + ConfigChangesHandler.getTargetsString(targetMBeanArray) + ", newTargets=" + ConfigChangesHandler.getTargetsString(targetMBeanArray2));
        }
        List list = ConfigChangesHandler.getTargetsNotIn(targetMBeanArray, targetMBeanArray2);
        List list2 = ConfigChangesHandler.getTargetsNotIn(targetMBeanArray2, targetMBeanArray);
        if (Debug.isDeploymentDebugEnabled()) {
            Debug.deploymentDebug("ConfigChangesHandler undeployTargets=" + list + ", deployTargets=" + list2);
        }
        if (list.size() > 0) {
            ConfigChangesHandler.targetsRemoved(orderedDeployments, webLogicMBean, list);
        }
        if (list2.size() > 0) {
            ConfigChangesHandler.targetsAdded(orderedDeployments, webLogicMBean, Arrays.asList(targetMBeanArray), list2);
        }
        if (list.size() == 0 && list2.size() == 0) {
            ConfigChangesHandler.targetsAdded(orderedDeployments, webLogicMBean, Arrays.asList(targetMBeanArray), Arrays.asList(targetMBeanArray2));
        }
    }

    private static void deploymentTargetsAdded(OrderedDeployments orderedDeployments, TargetInfoMBean targetInfoMBean, List list, List list2) {
        Object object;
        if (list2.size() == 0) {
            return;
        }
        ArrayList arrayList = new ArrayList(list2);
        if (Debug.isDeploymentDebugEnabled()) {
            Debug.deploymentDebug("ConfigChangesHandler.depTargetsAdded for " + targetInfoMBean + ", targets=" + arrayList + ", isJMSModule=" + ConfigChangesHandler.isJMSModule(targetInfoMBean));
        }
        if (!(targetInfoMBean instanceof SystemResourceMBean)) {
            object = arrayList.iterator();
            while (object.hasNext()) {
                TargetMBean targetMBean = (TargetMBean)object.next();
                String string = targetMBean.getName();
                ClusterMBean clusterMBean = TargetHelper.getTargetCluster(string);
                if (clusterMBean == null) continue;
                ClusterDeployInfo clusterDeployInfo = new ClusterDeployInfo(null, new DeploymentData(), 1, true, clusterMBean.getName());
                DeployInfo deployInfo = clusterDeployInfo.delegate;
                ArrayList<TargetMBean> arrayList2 = new ArrayList<TargetMBean>();
                arrayList2.add(targetMBean);
                ConfigChangesHandler.populateDeploymentInfo(deployInfo, targetInfoMBean, arrayList2);
                object.remove();
                if ((deployInfo.hasModuleTargets() || deployInfo.hasSubModuleTargets()) && (ConfigChangesHandler.isJMSModule(targetInfoMBean) || ConfigChangesHandler.isJMSModule((TargetInfoMBean)targetInfoMBean.getParent()))) {
                    clusterDeployInfo.setOp(9);
                }
                if (ConfigChangesHandler.isTargetedToCluster(list, clusterMBean)) {
                    clusterDeployInfo.setOp(9);
                }
                clusterDeployInfo.setRequireRestart(false);
                orderedDeployments.addDeploymentInfo(clusterDeployInfo);
            }
            if (arrayList.size() == 0) {
                return;
            }
        }
        if ((((DeployInfo)(object = ConfigChangesHandler.createDeploymentInfo(targetInfoMBean, arrayList, 1, true))).hasModuleTargets() || ((DeployInfo)object).hasSubModuleTargets()) && (ConfigChangesHandler.isJMSModule(targetInfoMBean) || ConfigChangesHandler.isJMSModule((TargetInfoMBean)targetInfoMBean.getParent()))) {
            ((DeployInfo)object).op = 9;
        }
        ((DeployInfo)object).requireRestart = false;
        orderedDeployments.addDeploymentInfo((DeployInfo)object);
    }

    private static void deploymentTargetsRemoved(OrderedDeployments orderedDeployments, TargetInfoMBean targetInfoMBean, List list) {
        Object object;
        if (list.size() == 0) {
            return;
        }
        ArrayList arrayList = new ArrayList(list);
        if (Debug.isDeploymentDebugEnabled()) {
            Debug.deploymentDebug("ConfigChangesHandler.depTargetsRemoved for " + targetInfoMBean + ", targets=" + arrayList + ", isJMSModule=" + ConfigChangesHandler.isJMSModule(targetInfoMBean));
        }
        if (!(targetInfoMBean instanceof SystemResourceMBean)) {
            object = arrayList.iterator();
            while (object.hasNext()) {
                TargetMBean targetMBean = (TargetMBean)object.next();
                String string = targetMBean.getName();
                ClusterMBean clusterMBean = TargetHelper.getTargetCluster(string);
                if (clusterMBean == null) continue;
                ClusterDeployInfo clusterDeployInfo = new ClusterDeployInfo(null, new DeploymentData(), 4, false, clusterMBean.getName());
                DeployInfo deployInfo = clusterDeployInfo.delegate;
                ArrayList<TargetMBean> arrayList2 = new ArrayList<TargetMBean>();
                arrayList2.add(targetMBean);
                ConfigChangesHandler.populateDeploymentInfo(deployInfo, targetInfoMBean, arrayList2);
                object.remove();
                if ((deployInfo.hasModuleTargets() || deployInfo.hasSubModuleTargets()) && (ConfigChangesHandler.isJMSModule(targetInfoMBean) || ConfigChangesHandler.isJMSModule((TargetInfoMBean)targetInfoMBean.getParent()))) {
                    clusterDeployInfo.setOp(9);
                }
                if (ConfigChangesHandler.isTargetedToCluster(Arrays.asList(ConfigChangesHandler.getTargets(targetInfoMBean)), clusterMBean)) {
                    clusterDeployInfo.setOp(9);
                }
                clusterDeployInfo.setRequireRestart(false);
                orderedDeployments.addDeploymentInfo(clusterDeployInfo);
            }
            if (arrayList.size() == 0) {
                return;
            }
        }
        object = ConfigChangesHandler.createDeploymentInfo(targetInfoMBean, arrayList, 4, false);
        if (Debug.isDeploymentDebugEnabled()) {
            Debug.deploymentDebug("ConfigChangesHandler.depTargetsRemoved : created DeploymentInfo : " + object);
        }
        if ((((DeployInfo)object).hasModuleTargets() || ((DeployInfo)object).hasSubModuleTargets()) && (ConfigChangesHandler.isJMSModule(targetInfoMBean) || ConfigChangesHandler.isJMSModule((TargetInfoMBean)targetInfoMBean.getParent()))) {
            ((DeployInfo)object).op = 9;
        }
        ((DeployInfo)object).requireRestart = false;
        orderedDeployments.addDeploymentInfo((DeployInfo)object);
    }

    private static void createAndAddClusterDeploymentInfos(BasicDeploymentMBean basicDeploymentMBean, List list, List list2) {
    }

    private static void deploymentMBeanTargetChanged(OrderedDeployments orderedDeployments, DeploymentMBean deploymentMBean, List list, List list2, boolean bl, int n) {
        DomainMBean domainMBean = ConfigChangesHandler.getDomainBean(false);
        String string = deploymentMBean.getName();
        DeploymentData deploymentData = null;
        DeploymentData deploymentData2 = null;
        JMSSystemResourceMBean[] jMSSystemResourceMBeanArray = domainMBean.getJMSSystemResources();
        for (int i = 0; i < jMSSystemResourceMBeanArray.length; ++i) {
            JMSSystemResourceMBean jMSSystemResourceMBean = jMSSystemResourceMBeanArray[i];
            if (deploymentData == null) {
                deploymentData = new DeploymentData();
            }
            if (deploymentData2 == null) {
                deploymentData2 = new DeploymentData();
            }
            if (!ConfigChangesHandler.isModuleTargeted(jMSSystemResourceMBean, string, list, list2, deploymentData2, deploymentData, bl)) continue;
            ConfigChangesHandler.createAndAddDeploymentInfos(orderedDeployments, jMSSystemResourceMBean, list, list2, deploymentData2, deploymentData, n);
            deploymentData = null;
            deploymentData2 = null;
        }
        AppDeploymentMBean[] appDeploymentMBeanArray = AppDeploymentHelper.getAppsAndLibs(domainMBean);
        for (int i = 0; i < appDeploymentMBeanArray.length; ++i) {
            AppDeploymentMBean appDeploymentMBean = appDeploymentMBeanArray[i];
            if (!ConfigChangesHandler.isEar(appDeploymentMBean)) {
                if (deploymentData == null) {
                    deploymentData = new DeploymentData();
                }
                if (deploymentData2 == null) {
                    deploymentData2 = new DeploymentData();
                }
                if (!ConfigChangesHandler.isModuleTargeted(appDeploymentMBean, string, list, list2, deploymentData2, deploymentData, bl)) continue;
                ConfigChangesHandler.createAndAddDeploymentInfos(orderedDeployments, appDeploymentMBean, list, list2, deploymentData2, deploymentData, n);
                deploymentData = null;
                deploymentData2 = null;
                continue;
            }
            SubDeploymentMBean[] subDeploymentMBeanArray = appDeploymentMBean.getSubDeployments();
            for (int j = 0; j < subDeploymentMBeanArray.length; ++j) {
                SubDeploymentMBean subDeploymentMBean = subDeploymentMBeanArray[j];
                if (deploymentData == null) {
                    deploymentData = new DeploymentData();
                }
                if (deploymentData2 == null) {
                    deploymentData2 = new DeploymentData();
                }
                if (!ConfigChangesHandler.isModuleTargeted(subDeploymentMBean, string, list, list2, deploymentData2, deploymentData, bl)) continue;
                ConfigChangesHandler.createAndAddDeploymentInfos(orderedDeployments, appDeploymentMBean, list, list2, deploymentData2, deploymentData, n);
                deploymentData = null;
                deploymentData2 = null;
            }
        }
    }

    private static boolean isModuleTargeted(BasicDeploymentMBean basicDeploymentMBean, String string, List list, List list2, DeploymentData deploymentData, DeploymentData deploymentData2, boolean bl) {
        if (ConfigChangesHandler.isTargetIn(string, basicDeploymentMBean.getTargets())) {
            if (Debug.isDeploymentDebugEnabled()) {
                Debug.deploymentDebug("isModuleTargeted addTarget " + string + " for " + basicDeploymentMBean.getName());
            }
            ConfigChangesHandler.addTargetsToData(string, list, list2, deploymentData, deploymentData2, bl);
            return true;
        }
        return ConfigChangesHandler.isJMSModule(basicDeploymentMBean) && ConfigChangesHandler.isSubModulesTargeted(null, basicDeploymentMBean.getSubDeployments(), string, list, list2, deploymentData, deploymentData2, bl);
    }

    private static boolean isModuleTargeted(SubDeploymentMBean subDeploymentMBean, String string, List list, List list2, DeploymentData deploymentData, DeploymentData deploymentData2, boolean bl) {
        if (ConfigChangesHandler.isTargetIn(string, subDeploymentMBean.getTargets())) {
            if (Debug.isDeploymentDebugEnabled()) {
                Debug.deploymentDebug("isModuleTargeted addModuleTarget(" + subDeploymentMBean.getName() + "," + string + ")");
            }
            ConfigChangesHandler.addModuleTargetsToData(subDeploymentMBean.getName(), string, list, list2, deploymentData, deploymentData2, bl);
            return true;
        }
        return ConfigChangesHandler.isJMSModule(subDeploymentMBean) && ConfigChangesHandler.isSubModulesTargeted(subDeploymentMBean.getName(), subDeploymentMBean.getSubDeployments(), string, list, list2, deploymentData, deploymentData2, bl);
    }

    private static boolean isSubModulesTargeted(String string, SubDeploymentMBean[] subDeploymentMBeanArray, String string2, List list, List list2, DeploymentData deploymentData, DeploymentData deploymentData2, boolean bl) {
        if (subDeploymentMBeanArray == null || subDeploymentMBeanArray.length == 0) {
            return false;
        }
        boolean bl2 = false;
        for (int i = 0; i < subDeploymentMBeanArray.length; ++i) {
            SubDeploymentMBean subDeploymentMBean = subDeploymentMBeanArray[i];
            if (!ConfigChangesHandler.isTargetIn(string2, subDeploymentMBean.getTargets())) continue;
            if (Debug.isDeploymentDebugEnabled()) {
                Debug.deploymentDebug("isSubModulesTargeted addSubModuleTarget(" + string + "," + subDeploymentMBean.getName() + "," + string2 + ")");
            }
            ConfigChangesHandler.addSubModuleTargetsToData(string, subDeploymentMBean.getName(), string2, list, list2, deploymentData, deploymentData2, bl);
            bl2 = true;
        }
        return bl2;
    }

    private static void handleExternalTreeChanges(OrderedDeployments orderedDeployments, Map map, long l, List list) {
        if (map == null || map.size() <= 0) {
            return;
        }
        for (DescriptorBean descriptorBean : map.keySet()) {
            SystemResourceMBean systemResourceMBean = (SystemResourceMBean)DescriptorInfoUtils.getDescriptorConfigExtension(descriptorBean.getDescriptor());
            if (list == null || list.contains(systemResourceMBean)) continue;
            ConfigChangesHandler.handleGlobalDescriptorChanges(orderedDeployments, systemResourceMBean, map, l);
        }
    }

    private static void handleGlobalDescriptorChanges(OrderedDeployments orderedDeployments, SystemResourceMBean systemResourceMBean, Map map, long l) {
        String string;
        PendingDirectoryManager pendingDirectoryManager = PendingDirectoryManager.getInstance();
        if (pendingDirectoryManager.globalDescriptorExists(string = systemResourceMBean.getDescriptorFileName())) {
            if (Debug.isDeploymentDebugEnabled()) {
                Debug.deploymentDebug("handleGlobalDescriptorChanges: bean=" + systemResourceMBean + ", file=" + string);
            }
            Object v = map.get(systemResourceMBean.getResource());
            boolean bl = false;
            if (v != null && (bl = ConfigChangesHandler.hasNonDynamicChanges(systemResourceMBean, (ArrayList)v, l)) && Debug.isDeploymentDebugEnabled()) {
                Debug.deploymentDebug("bean=" + systemResourceMBean + " has non dynamic changes");
            }
            DeploymentData deploymentData = new DeploymentData();
            TargetMBean[] targetMBeanArray = ConfigChangesHandler.getTargets(systemResourceMBean);
            if (targetMBeanArray == null || targetMBeanArray.length == 0) {
                return;
            }
            List<TargetMBean> list = Arrays.asList(targetMBeanArray);
            deploymentData.addSubModuleTarget(null, string, ConfigChangesHandler.getTargetNames(list));
            DeployInfo deployInfo = ConfigChangesHandler.createNewDeploymentInfo(systemResourceMBean, deploymentData, 9, true);
            deployInfo.requireRestart = bl;
            orderedDeployments.addDeploymentInfo(deployInfo);
        }
    }

    private static BeanInfo getBeanInfo(DescriptorBean descriptorBean) {
        BeanInfoAccess beanInfoAccess = ManagementService.getBeanInfoAccess();
        BeanInfo beanInfo = beanInfoAccess.getBeanInfoForInstance((Object)descriptorBean, true, null);
        return beanInfo;
    }

    private static boolean hasNonDynamicChanges(SystemResourceMBean systemResourceMBean, ArrayList arrayList, long l) {
        if (!arrayList.isEmpty()) {
            for (BeanUpdateEvent beanUpdateEvent : arrayList) {
                DescriptorBean descriptorBean = beanUpdateEvent.getProposedBean();
                if (descriptorBean == null) {
                    return false;
                }
                BeanInfo beanInfo = ConfigChangesHandler.getBeanInfo(descriptorBean);
                if (beanInfo == null) {
                    return false;
                }
                BeanUpdateEvent.PropertyUpdate[] propertyUpdateArray = beanUpdateEvent.getUpdateList();
                for (int i = 0; i < propertyUpdateArray.length; ++i) {
                    if (propertyUpdateArray[i].isDynamic()) continue;
                    DeployerRuntimeLogger.logNonDynamicPropertyChange((long)l, (String)systemResourceMBean.getName(), (String)propertyUpdateArray[i].getPropertyName(), (String)beanUpdateEvent.getSourceBean().toString());
                    return true;
                }
            }
        }
        return false;
    }

    private static Iterator getDescriptorDiff(ConfigurationContext configurationContext) {
        if (configurationContext == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        DescriptorDiff descriptorDiff = (DescriptorDiff)configurationContext.getContextComponent("beanUpdateDescriptorDiffId");
        return descriptorDiff.iterator();
    }

    private static Map getExternalDescritorDiffs(ConfigurationContext configurationContext) {
        if (configurationContext == null) {
            return null;
        }
        return (Map)configurationContext.getContextComponent("externalDescritorDiffId");
    }

    private static boolean isTargetsChanged(DescriptorBean descriptorBean, BeanUpdateEvent.PropertyUpdate propertyUpdate) {
        return (descriptorBean instanceof TargetInfoMBean || descriptorBean instanceof DeploymentMBean && descriptorBean instanceof TargetMBean) && propertyUpdate.getPropertyName().equals(TARGETS_PROP_NAME);
    }

    private static boolean isCandidateServersChanged(DescriptorBean descriptorBean, BeanUpdateEvent.PropertyUpdate propertyUpdate) {
        return descriptorBean instanceof MigratableTargetMBean && propertyUpdate.getPropertyName().equals(CANDIDATE_SERVERS_PROP_NAME);
    }

    private static DeployInfo createDeploymentInfo(TargetInfoMBean targetInfoMBean, List list, int n, boolean bl) {
        DeployInfo deployInfo = ConfigChangesHandler.createNewDeploymentInfo(n, bl);
        ConfigChangesHandler.populateDeploymentInfo(deployInfo, targetInfoMBean, list);
        return deployInfo;
    }

    private static DeployInfo createNewDeploymentInfo(int n, boolean bl) {
        return ConfigChangesHandler.createNewDeploymentInfo(null, new DeploymentData(), n, bl);
    }

    private static DeployInfo createNewDeploymentInfo(BasicDeploymentMBean basicDeploymentMBean, DeploymentData deploymentData, int n, boolean bl) {
        if (n == 1) {
            return new DeployDeployInfo(basicDeploymentMBean, deploymentData, bl);
        }
        if (n == 9) {
            return new RedeployDeployInfo(basicDeploymentMBean, deploymentData, bl);
        }
        return new UndeployDeployInfo(basicDeploymentMBean, deploymentData, bl);
    }

    private static void populateDeploymentInfo(DeployInfo deployInfo, TargetInfoMBean targetInfoMBean, List list) {
        BasicDeploymentMBean basicDeploymentMBean;
        DeploymentData deploymentData = deployInfo.deployData;
        if (targetInfoMBean instanceof BasicDeploymentMBean) {
            basicDeploymentMBean = (BasicDeploymentMBean)targetInfoMBean;
            if (list != null && !list.isEmpty()) {
                for (TargetMBean targetMBean : list) {
                    deploymentData.addTarget(targetMBean.getName(), null);
                }
            }
        } else {
            WebLogicMBean webLogicMBean = targetInfoMBean.getParent();
            if (webLogicMBean instanceof BasicDeploymentMBean) {
                basicDeploymentMBean = (BasicDeploymentMBean)webLogicMBean;
                if (ConfigChangesHandler.isEar(basicDeploymentMBean)) {
                    String string = targetInfoMBean.getName();
                    if (list != null && !list.isEmpty()) {
                        for (TargetMBean targetMBean : list) {
                            deploymentData.addModuleTarget(string, targetMBean.getName());
                        }
                    }
                } else {
                    String string = targetInfoMBean.getName();
                    deploymentData.addSubModuleTarget(null, string, ConfigChangesHandler.getTargetNames(list));
                }
            } else {
                basicDeploymentMBean = (BasicDeploymentMBean)webLogicMBean.getParent();
                String string = targetInfoMBean.getName();
                String string2 = webLogicMBean.getName();
                deploymentData.addSubModuleTarget(string2, string, ConfigChangesHandler.getTargetNames(list));
            }
        }
        deployInfo.topLevelDepBean = basicDeploymentMBean;
    }

    private static String[] getTargetNames(List list) {
        if (list == null || list.size() == 0) {
            return null;
        }
        String[] stringArray = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            stringArray[i] = ((TargetMBean)list.get(i)).getName();
        }
        return stringArray;
    }

    private static weblogic.deploy.service.Deployment findOrCreateDeployment(int n, BasicDeploymentMBean basicDeploymentMBean, DeploymentData deploymentData, boolean bl, boolean bl2, boolean bl3) {
        try {
            String string = basicDeploymentMBean.getSourcePath();
            String string2 = TASK_ID_PREFIX + ConfigChangesHandler.getTaskId();
            DeploymentTaskRuntime deploymentTaskRuntime = ConfigChangesHandler.createDeploymentTask(string, basicDeploymentMBean, deploymentData, string2, n, bl, bl3);
            AuthenticatedSubject authenticatedSubject = SecurityServiceManager.getCurrentSubject((AuthenticatedSubject)kernelId);
            return DeploymentManager.getInstance(kernelId).createDeployment(string2, deploymentData, n, deploymentTaskRuntime, ConfigChangesHandler.getDomainBean(bl), true, authenticatedSubject, true, bl3, bl2);
        }
        catch (Throwable throwable) {
            if (Debug.isDeploymentDebugEnabled()) {
                Debug.deploymentDebug(StackTraceUtils.throwable2StackTrace((Throwable)throwable));
            }
            return null;
        }
    }

    private static synchronized int getTaskId() {
        return curTaskId++;
    }

    private static DeploymentTaskRuntime createDeploymentTask(String string, BasicDeploymentMBean basicDeploymentMBean, DeploymentData deploymentData, String string2, int n, boolean bl, boolean bl2) throws ManagementException {
        DomainMBean domainMBean = ConfigChangesHandler.getDomainBean(bl);
        DeploymentTaskRuntime deploymentTaskRuntime = new DeploymentTaskRuntime(string, basicDeploymentMBean, deploymentData, string2, n, domainMBean, bl2, true);
        return deploymentTaskRuntime;
    }

    private static TargetMBean[] getTargets(WebLogicMBean webLogicMBean) {
        if (webLogicMBean instanceof TargetInfoMBean) {
            if (webLogicMBean instanceof DomainTargetedMBean) {
                return ConfigChangesHandler.getDomainBean(true).getServers();
            }
            return ((TargetInfoMBean)webLogicMBean).getTargets();
        }
        if (webLogicMBean instanceof DeploymentMBean && webLogicMBean instanceof TargetMBean) {
            return ((DeploymentMBean)webLogicMBean).getTargets();
        }
        if (webLogicMBean instanceof MigratableTargetMBean) {
            return ((MigratableTargetMBean)webLogicMBean).getAllCandidateServers();
        }
        return null;
    }

    private static DomainMBean getDomainBean(boolean bl) {
        block3: {
            if (bl) {
                try {
                    return ManagementServiceRestricted.getEditAccess(kernelId).getDomainBean();
                }
                catch (Throwable throwable) {
                    if (!Debug.isDeploymentDebugEnabled()) break block3;
                    Debug.deploymentDebug("Failed to get proposed DomainBean" + StackTraceUtils.throwable2StackTrace((Throwable)throwable));
                }
            }
        }
        return ManagementService.getRuntimeAccess(kernelId).getDomain();
    }

    private static List getTargetsNotIn(TargetMBean[] targetMBeanArray, TargetMBean[] targetMBeanArray2) {
        if (targetMBeanArray == null || targetMBeanArray.length == 0) {
            return Collections.EMPTY_LIST;
        }
        if (targetMBeanArray2 == null || targetMBeanArray2.length == 0) {
            return Arrays.asList(targetMBeanArray);
        }
        HashSet<String> hashSet = new HashSet<String>();
        HashSet hashSet2 = new HashSet();
        for (int i = 0; i < targetMBeanArray2.length; ++i) {
            hashSet.add(targetMBeanArray2[i].getName());
            hashSet2.addAll(targetMBeanArray2[i].getServerNames());
        }
        ArrayList<TargetMBean> arrayList = new ArrayList<TargetMBean>();
        for (int i = 0; i < targetMBeanArray.length; ++i) {
            TargetMBean targetMBean = targetMBeanArray[i];
            if (ConfigChangesHandler.isPhysicalTarget(targetMBean)) {
                if (hashSet2.contains(targetMBean.getName())) continue;
                arrayList.add(targetMBean);
                continue;
            }
            Set set = targetMBean.getServerNames();
            for (String string : set) {
                TargetMBean targetMBean2;
                if (hashSet2.contains(string) || (targetMBean2 = ConfigChangesHandler.getDomainBean(false).lookupTarget(string)) == null) continue;
                arrayList.add(targetMBean2);
            }
        }
        return arrayList;
    }

    private static boolean isPhysicalTarget(TargetMBean targetMBean) {
        return targetMBean instanceof ServerMBean;
    }

    private static boolean isEar(TargetInfoMBean targetInfoMBean) {
        if (!(targetInfoMBean instanceof AppDeploymentMBean)) {
            return false;
        }
        if (ModuleType.EAR.toString().equals(targetInfoMBean.getModuleType())) {
            return true;
        }
        String string = ((AppDeploymentMBean)targetInfoMBean).getAbsoluteSourcePath();
        if (string != null) {
            if (string.endsWith(".ear")) {
                return true;
            }
            if (new File(string, "META-INF/application.xml").exists()) {
                return true;
            }
        }
        return false;
    }

    private static boolean isJMSModule(TargetInfoMBean targetInfoMBean) {
        if (targetInfoMBean instanceof JMSSystemResourceMBean) {
            return true;
        }
        if (targetInfoMBean instanceof AppDeploymentMBean) {
            String string = ((AppDeploymentMBean)targetInfoMBean).getAbsoluteSourcePath();
            return string != null && string.endsWith("-jms.xml");
        }
        if (targetInfoMBean instanceof SubDeploymentMBean) {
            TargetInfoMBean targetInfoMBean2 = (TargetInfoMBean)targetInfoMBean.getParent();
            if (targetInfoMBean2 instanceof JMSSystemResourceMBean) {
                return true;
            }
            if (targetInfoMBean2 instanceof AppDeploymentMBean) {
                if (ConfigChangesHandler.isJMSModule(targetInfoMBean2)) {
                    return true;
                }
                return ConfigChangesHandler.isJMSModule(targetInfoMBean2, targetInfoMBean);
            }
            if (targetInfoMBean2 instanceof SubDeploymentMBean) {
                TargetInfoMBean targetInfoMBean3 = (TargetInfoMBean)targetInfoMBean2.getParent();
                return ConfigChangesHandler.isJMSModule(targetInfoMBean3, targetInfoMBean2);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isJMSModule(TargetInfoMBean var0, TargetInfoMBean var1_1) {
        block15: {
            block14: {
                var2_2 = ConfigChangesHandler.getAppRuntimeState().getModuleType(var0.getName(), var1_1.getName());
                if (Debug.isDeploymentDebugEnabled()) {
                    Debug.deploymentDebug("Module type for " + var1_1 + ": " + var2_2);
                }
                if (var2_2.equals(WebLogicModuleType.MODULETYPE_UNKNOWN) == false) return false;
                if (var0 instanceof AppDeploymentMBean == false) return false;
                var3_3 = null;
                try {
                    try {
                        var4_4 = ApplicationFileManager.newInstance(((AppDeploymentMBean)var0).getAbsoluteSourcePath());
                        var3_3 = var4_4.getVirtualJarFile();
                        var5_6 = var3_3.entries();
                        while (var5_6.hasNext()) {
                            var6_7 = (JarEntry)var5_6.next();
                            if (Debug.isDeploymentDebugEnabled()) {
                                Debug.deploymentDebug("Entry: " + var6_7.getName());
                            }
                            if (!var6_7.getName().endsWith("-jms.xml")) continue;
                            var7_8 = true;
                            var9_9 = null;
                            if (var3_3 == null) return var7_8;
                            break block14;
                        }
                        break block15;
                    }
                    catch (Throwable var4_5) {
                        if (Debug.isDeploymentDebugEnabled()) {
                            Debug.deploymentDebug("Failed to get module type", var4_5);
                        }
                        var9_11 = null;
                        if (var3_3 == null) return false;
                        try {
                            var3_3.close();
                            return false;
                        }
                        catch (Throwable var10_15) {
                            return false;
                        }
                    }
                }
                catch (Throwable var8_17) {
                    var9_12 = null;
                    if (var3_3 == null) throw var8_17;
                    ** try [egrp 2[TRYBLOCK] [6 : 230->239)] { 
lbl39:
                    // 1 sources

                    var3_3.close();
                    throw var8_17;
lbl41:
                    // 1 sources

                    catch (Throwable var10_16) {
                        // empty catch block
                    }
                    throw var8_17;
                }
            }
            ** try [egrp 2[TRYBLOCK] [6 : 230->239)] { 
lbl46:
            // 1 sources

            var3_3.close();
            return var7_8;
lbl48:
            // 1 sources

            catch (Throwable var10_13) {
                // empty catch block
            }
            return var7_8;
        }
        var9_10 = null;
        if (var3_3 == null) return false;
        try {}
        catch (Throwable var10_14) {}
        var3_3.close();
        return false;
        return false;
    }

    private static AppRuntimeStateRuntimeMBean getAppRuntimeState() {
        if (appRTMBean == null) {
            appRTMBean = ManagementService.getDomainAccess(kernelId).getAppRuntimeStateRuntime();
        }
        return appRTMBean;
    }

    private static JMSServerMBean getJMSServer(MigratableTargetMBean migratableTargetMBean) {
        DomainMBean domainMBean = ConfigChangesHandler.getDomainBean(true);
        JMSServerMBean[] jMSServerMBeanArray = domainMBean.getJMSServers();
        if (jMSServerMBeanArray == null) {
            return null;
        }
        for (int i = 0; i < jMSServerMBeanArray.length; ++i) {
            TargetMBean[] targetMBeanArray = jMSServerMBeanArray[i].getTargets();
            if (targetMBeanArray.length != 1 || !targetMBeanArray[0].equals(migratableTargetMBean)) continue;
            return jMSServerMBeanArray[i];
        }
        return null;
    }

    private static void createAndAddDeploymentInfos(OrderedDeployments orderedDeployments, BasicDeploymentMBean basicDeploymentMBean, List list, List list2, DeploymentData deploymentData, DeploymentData deploymentData2, int n) {
        DeployInfo deployInfo;
        if (list.size() > 0) {
            deployInfo = ConfigChangesHandler.createNewDeploymentInfo(basicDeploymentMBean, deploymentData, n, false);
            deployInfo.requireRestart = false;
            orderedDeployments.addDeploymentInfo(deployInfo);
        }
        if (list2.size() > 0) {
            deployInfo = ConfigChangesHandler.createNewDeploymentInfo(basicDeploymentMBean, deploymentData2, n, true);
            deployInfo.requireRestart = false;
            orderedDeployments.addDeploymentInfo(deployInfo);
        }
    }

    private static void addTargetsToData(String string, List list, List list2, DeploymentData deploymentData, DeploymentData deploymentData2, boolean bl) {
        if (bl) {
            for (TargetMBean targetMBean : list) {
                deploymentData.addTarget(targetMBean.getName(), null);
            }
            for (TargetMBean targetMBean : list2) {
                deploymentData2.addTarget(targetMBean.getName(), null);
            }
        } else {
            if (list.size() > 0) {
                deploymentData.addTarget(string, null);
            }
            if (list2.size() > 0) {
                deploymentData2.addTarget(string, null);
            }
        }
    }

    private static void addModuleTargetsToData(String string, String string2, List list, List list2, DeploymentData deploymentData, DeploymentData deploymentData2, boolean bl) {
        if (bl) {
            for (TargetMBean targetMBean : list) {
                deploymentData.addModuleTarget(string, targetMBean.getName());
            }
            for (TargetMBean targetMBean : list2) {
                deploymentData2.addModuleTarget(string, targetMBean.getName());
            }
        } else {
            if (list.size() > 0) {
                deploymentData.addModuleTarget(string, string2);
            }
            if (list2.size() > 0) {
                deploymentData2.addModuleTarget(string, string2);
            }
        }
    }

    private static void addSubModuleTargetsToData(String string, String string2, String string3, List list, List list2, DeploymentData deploymentData, DeploymentData deploymentData2, boolean bl) {
        String[] stringArray;
        String[] stringArray2;
        if (bl) {
            stringArray2 = ConfigChangesHandler.getTargetNames(list);
        } else {
            String[] stringArray3 = new String[1];
            stringArray2 = stringArray3;
            stringArray3[0] = string3;
        }
        String[] stringArray4 = stringArray2;
        if (bl) {
            stringArray = ConfigChangesHandler.getTargetNames(list2);
        } else {
            String[] stringArray5 = new String[1];
            stringArray = stringArray5;
            stringArray5[0] = string3;
        }
        String[] stringArray6 = stringArray;
        if (list.size() > 0) {
            deploymentData.addSubModuleTarget(string, string2, stringArray4);
        }
        if (list2.size() > 0) {
            deploymentData2.addSubModuleTarget(string, string2, stringArray6);
        }
    }

    private static boolean isTargetIn(String string, TargetMBean[] targetMBeanArray) {
        if (targetMBeanArray == null || targetMBeanArray.length == 0) {
            return false;
        }
        for (int i = 0; i < targetMBeanArray.length; ++i) {
            if (!targetMBeanArray[i].getName().equals(string)) continue;
            return true;
        }
        return false;
    }

    private static String dumpDiff(ConfigurationContext configurationContext) {
        Iterator iterator = ConfigChangesHandler.getDescriptorDiff(configurationContext);
        StringBuffer stringBuffer = new StringBuffer("{");
        while (iterator.hasNext()) {
            BeanUpdateEvent beanUpdateEvent = (BeanUpdateEvent)iterator.next();
            BeanUpdateEvent.PropertyUpdate[] propertyUpdateArray = beanUpdateEvent.getUpdateList();
            DescriptorBean descriptorBean = beanUpdateEvent.getSourceBean();
            stringBuffer.append("\n=> Event for ").append(descriptorBean).append("[updateID=").append(beanUpdateEvent.getUpdateID()).append("]={");
            for (int i = 0; i < propertyUpdateArray.length; ++i) {
                BeanUpdateEvent.PropertyUpdate propertyUpdate = propertyUpdateArray[i];
                stringBuffer.append("\n[").append(propertyUpdate).append("]");
                if (i >= propertyUpdateArray.length - 1) continue;
                stringBuffer.append(",");
            }
            stringBuffer.append("} ");
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    private static String dumpTargets(DeploymentData deploymentData) {
        Object object;
        Map map;
        if (deploymentData == null) {
            return "{}";
        }
        StringBuffer stringBuffer = new StringBuffer("{");
        String[] stringArray = deploymentData.getGlobalTargets();
        if (stringArray != null && stringArray.length > 0) {
            stringBuffer.append("GlobalTargets=");
            for (int i = 0; i < stringArray.length; ++i) {
                stringBuffer.append(stringArray[i]);
                if (i >= stringArray.length - 1) continue;
                stringBuffer.append(",");
            }
        }
        if ((map = deploymentData.getAllModuleTargets()) != null && map.size() > 0) {
            object = map.entrySet().iterator();
            while (object.hasNext()) {
                Map.Entry entry = (Map.Entry)object.next();
                stringBuffer.append("\nModuleTargets(").append(entry.getKey()).append(")=");
                stringArray = (String[])entry.getValue();
                for (int i = 0; i < stringArray.length; ++i) {
                    stringBuffer.append(stringArray[i]);
                    if (i >= stringArray.length - 1) continue;
                    stringBuffer.append(",");
                }
            }
        }
        if ((object = deploymentData.getAllSubModuleTargets()) != null && object.size() > 0) {
            for (Map.Entry entry : object.entrySet()) {
                String string = (String)entry.getKey();
                Map map2 = (Map)entry.getValue();
                for (Map.Entry entry2 : map2.entrySet()) {
                    stringBuffer.append("\nSubModuleTargets(").append(string).append(",").append(entry2.getKey()).append(")=");
                    stringArray = (String[])entry2.getValue();
                    for (int i = 0; i < stringArray.length; ++i) {
                        stringBuffer.append(stringArray[i]);
                        if (i >= stringArray.length - 1) continue;
                        stringBuffer.append(",");
                    }
                }
            }
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    private static String getTargetsString(TargetMBean[] targetMBeanArray) {
        StringBuffer stringBuffer = new StringBuffer("(");
        if (targetMBeanArray != null) {
            for (int i = 0; i < targetMBeanArray.length; ++i) {
                stringBuffer.append(targetMBeanArray[i].getName());
                if (i >= targetMBeanArray.length - 1) continue;
                stringBuffer.append(",");
            }
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    private static String getTargetsString(List list) {
        StringBuffer stringBuffer = new StringBuffer("(");
        if (list != null && !list.isEmpty()) {
            for (int i = 0; i < list.size(); ++i) {
                TargetMBean targetMBean = (TargetMBean)list.get(i);
                if (targetMBean != null) {
                    stringBuffer.append(targetMBean.getName());
                }
                if (i >= list.size() - 1) continue;
                stringBuffer.append(",");
            }
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    private static String getTaskString(int n) {
        switch (n) {
            case 1: {
                return "Activate";
            }
            case 4: {
                return "Remove";
            }
            case 9: {
                return "Redeploy";
            }
        }
        return "Unknown";
    }

    private static boolean isDebugEnabled() {
        return Debug.isDeploymentDebugEnabled();
    }

    private static void debugSay(String string) {
        Debug.deploymentDebug(string);
    }

    private static boolean areTargetsSame(DeploymentData deploymentData, DeploymentData deploymentData2) {
        List<String> list = Arrays.asList(deploymentData.getGlobalTargets());
        List<String> list2 = Arrays.asList(deploymentData2.getGlobalTargets());
        boolean bl = ((Object)list).equals(list2);
        if (ConfigChangesHandler.isDebugEnabled()) {
            ConfigChangesHandler.debugSay(" Global Targets are same : " + bl);
        }
        if (!bl) {
            return false;
        }
        bl = ((Object)deploymentData.getAllModuleTargets()).equals(deploymentData2.getAllModuleTargets());
        if (ConfigChangesHandler.isDebugEnabled()) {
            ConfigChangesHandler.debugSay(" Module Targets are same : " + bl);
        }
        if (!bl) {
            return false;
        }
        bl = ((Object)deploymentData.getAllSubModuleTargets()).equals(deploymentData2.getAllSubModuleTargets());
        if (ConfigChangesHandler.isDebugEnabled()) {
            ConfigChangesHandler.debugSay(" Submodule Targets are same : " + bl);
            ConfigChangesHandler.debugSay(" Targets are same : " + bl);
        }
        return bl;
    }

    private static boolean haveCommonTargets(DeploymentData deploymentData, DeploymentData deploymentData2) {
        if (ConfigChangesHandler.haveCommonGlobalTargets(deploymentData, deploymentData2)) {
            return true;
        }
        if (ConfigChangesHandler.haveCommonModuleTargets(deploymentData, deploymentData2)) {
            return true;
        }
        return ConfigChangesHandler.haveCommonSubModuleTargets(deploymentData, deploymentData2);
    }

    private static boolean haveCommonGlobalTargets(DeploymentData deploymentData, DeploymentData deploymentData2) {
        Set set;
        Set set2;
        String[] stringArray = deploymentData.getGlobalTargets();
        if (stringArray == null || stringArray.length == 0) {
            return false;
        }
        ExtendedArrayList extendedArrayList = new ExtendedArrayList(stringArray);
        String[] stringArray2 = deploymentData2.getGlobalTargets();
        if (stringArray2 == null || stringArray2.length == 0) {
            return false;
        }
        if (extendedArrayList.containsOne(stringArray2)) {
            return true;
        }
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(Arrays.asList(stringArray));
        HashSet<String> hashSet2 = new HashSet<String>();
        hashSet2.addAll(Arrays.asList(stringArray2));
        try {
            set2 = deploymentData.getAllTargetedServers(hashSet);
            set = deploymentData2.getAllTargetedServers(hashSet2);
        }
        catch (InvalidTargetException invalidTargetException) {
            return false;
        }
        if (set2.isEmpty() || set.isEmpty()) {
            return false;
        }
        for (Object e : set2) {
            if (!set.contains(e)) continue;
            deploymentData.setGlobalTargets(set2.toArray(new String[0]));
            deploymentData2.setGlobalTargets(set.toArray(new String[0]));
            return true;
        }
        return false;
    }

    private static boolean haveCommonModuleTargets(DeploymentData deploymentData, DeploymentData deploymentData2) {
        Map map = deploymentData.getAllModuleTargets();
        Map map2 = deploymentData2.getAllModuleTargets();
        if (map2.isEmpty() || map.isEmpty()) {
            return false;
        }
        Set set = map2.keySet();
        for (String string : set) {
            if (!map.containsKey(string)) continue;
            String[] stringArray = (String[])map2.get(string);
            ExtendedArrayList extendedArrayList = new ExtendedArrayList((String[])map.get(string));
            if (!extendedArrayList.containsOne(stringArray)) continue;
            return true;
        }
        return false;
    }

    private static boolean haveCommonSubModuleTargets(DeploymentData deploymentData, DeploymentData deploymentData2) {
        Map map = deploymentData.getAllSubModuleTargets();
        Map map2 = deploymentData2.getAllSubModuleTargets();
        if (map2.isEmpty() || map.isEmpty()) {
            return false;
        }
        Set set = map2.keySet();
        for (String string : set) {
            Map map3;
            Map map4;
            if (!map.containsKey(string) || (map4 = (Map)map2.get(string)) == null || map4.isEmpty() || (map3 = (Map)map.get(string)) == null || map3.isEmpty()) continue;
            for (String string2 : map4.keySet()) {
                if (!map3.containsKey(string2)) continue;
                String[] stringArray = (String[])map4.get(string2);
                ExtendedArrayList extendedArrayList = new ExtendedArrayList((String[])map3.get(string2));
                if (!extendedArrayList.containsOne(stringArray)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isTargetedToCluster(List list, ClusterMBean clusterMBean) {
        if (list.isEmpty()) {
            return false;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (TargetMBean targetMBean : list) {
            arrayList.add(targetMBean.getName());
        }
        if (arrayList.contains(clusterMBean.getName())) {
            return true;
        }
        ServerMBean[] serverMBeanArray = clusterMBean.getServers();
        for (int i = 0; i < serverMBeanArray.length; ++i) {
            if (!arrayList.contains(serverMBeanArray[i].getName())) continue;
            return true;
        }
        return false;
    }

    static {
        beanFactory = DeploymentServerService.getDeploymentBeanFactory();
    }

    private static class ExtendedArrayList
    extends ArrayList {
        ExtendedArrayList(Collection collection) {
            super(collection);
        }

        ExtendedArrayList(String[] stringArray) {
            this(stringArray != null ? Arrays.asList(stringArray) : Collections.EMPTY_LIST);
        }

        boolean containsOne(String[] stringArray) {
            if (this.isEmpty()) {
                return false;
            }
            if (stringArray == null || stringArray.length == 0) {
                return false;
            }
            for (int i = 0; i < stringArray.length; ++i) {
                if (!this.contains(stringArray[i])) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class OrderedDeployments {
        private static final Comparator LOCAL_COMPARATOR = new Comparator(){

            public int compare(Object object, Object object2) {
                if (object == object2) {
                    return 0;
                }
                int n = OrderedDeployments.compareDeployment((DeployInfo)object, (DeployInfo)object2);
                return n != 0 ? n : -1;
            }
        };
        private final TreeSet preDeploymentHandlerDeployments = new TreeSet(LOCAL_COMPARATOR);
        private final TreeSet postDeploymentHandlerDeployments = new TreeSet(LOCAL_COMPARATOR);
        private final List tempInfoList = new ArrayList(){

            public boolean add(Object object) {
                if (this.contains(object)) {
                    return false;
                }
                DeployInfo deployInfo = (DeployInfo)object;
                List list = this.getDeployInfosOnSameApp(deployInfo);
                if (ConfigChangesHandler.isDebugEnabled()) {
                    ConfigChangesHandler.debugSay(" MergedList.addDeployInfo() : sameInfos of kind '" + deployInfo + "' =========== " + list);
                }
                if (list.size() < 1) {
                    return super.add(deployInfo);
                }
                for (DeployInfo deployInfo2 : list) {
                    boolean bl = deployInfo.mergeWithOtherOperation(deployInfo2, this);
                    if (!bl) continue;
                    return true;
                }
                return super.add(deployInfo);
            }

            private List getDeployInfosOnSameApp(DeployInfo deployInfo) {
                ArrayList<DeployInfo> arrayList = new ArrayList<DeployInfo>();
                BasicDeploymentMBean basicDeploymentMBean = deployInfo.getTopLevelDepBean();
                if (basicDeploymentMBean == null) {
                    return arrayList;
                }
                if (this.isEmpty()) {
                    return arrayList;
                }
                for (DeployInfo deployInfo2 : this) {
                    BasicDeploymentMBean basicDeploymentMBean2 = deployInfo2.getTopLevelDepBean();
                    if (basicDeploymentMBean2 == null || basicDeploymentMBean2 != basicDeploymentMBean || deployInfo == deployInfo2) continue;
                    arrayList.add(deployInfo2);
                }
                return arrayList;
            }
        };

        private OrderedDeployments() {
        }

        private boolean addDeploymentInfo(DeployInfo deployInfo) {
            return this.tempInfoList.add(deployInfo);
        }

        private void add(DeployInfo deployInfo) {
            boolean bl = DeploymentOrder.isBeforeDeploymentHandler(deployInfo.getTopLevelDepBean());
            boolean bl2 = deployInfo.isDeploy();
            if (bl && bl2 || !bl && !bl2) {
                this.preDeploymentHandlerDeployments.add(deployInfo);
                if (ConfigChangesHandler.isDebugEnabled()) {
                    ConfigChangesHandler.debugSay(" ++ preDeploymentHandlerDeployments after add : " + this.preDeploymentHandlerDeployments);
                }
                Deployment deployment = (Deployment)deployInfo.getDeployment();
                deployment.setBeforeDeploymentHandler();
                if (bl2) {
                    deployment.setIsDeploy();
                }
            } else {
                this.postDeploymentHandlerDeployments.add(deployInfo);
                if (ConfigChangesHandler.isDebugEnabled()) {
                    ConfigChangesHandler.debugSay(" ++ postDeploymentHandlerDeployments after add : " + this.postDeploymentHandlerDeployments);
                }
            }
        }

        private static int compareDeployment(DeployInfo deployInfo, DeployInfo deployInfo2) {
            boolean bl = deployInfo.isDeploy();
            boolean bl2 = deployInfo2.isDeploy();
            if (bl && bl2) {
                return OrderedDeployments.compare(deployInfo, deployInfo2);
            }
            if (!bl && !bl2) {
                return OrderedDeployments.compare(deployInfo, deployInfo2) * -1;
            }
            return !bl && bl2 ? -1 : 1;
        }

        private static int compare(DeployInfo deployInfo, DeployInfo deployInfo2) {
            return DeploymentOrder.COMPARATOR.compare(deployInfo.getTopLevelDepBean(), deployInfo2.getTopLevelDepBean());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processDeploymentInfos() {
            try {
                for (DeployInfo deployInfo : this.tempInfoList) {
                    weblogic.deploy.service.Deployment deployment = deployInfo.createDeployment();
                    if (deployment == null) continue;
                    if (Debug.isDeploymentDebugEnabled()) {
                        Debug.deploymentDebug("ConfigChangesHandler.addDeployment for " + deployInfo.getTopLevelDepBean().getName() + ", deployOp=" + ConfigChangesHandler.getTaskString(deployInfo.getOp()) + ", isDeploy=" + deployInfo.isDeploy() + ", deployData=" + deployInfo.getDeployData() + ", targets=" + ConfigChangesHandler.dumpTargets(deployInfo.getDeployData()) + ", deployment=" + deployInfo.getDeployment());
                    }
                    this.add(deployInfo);
                }
                Object var5_4 = null;
                this.tempInfoList.clear();
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                this.tempInfoList.clear();
                throw throwable;
            }
        }

        private void addDeployments(Collection collection, List list) {
            if (collection == null || collection.size() == 0) {
                return;
            }
            for (DeployInfo deployInfo : collection) {
                if (Debug.isDeploymentDebugEnabled()) {
                    Debug.deploymentDebug("  MBean=" + deployInfo.getTopLevelDepBean() + ", op=" + ConfigChangesHandler.getTaskString(deployInfo.getOp()));
                }
                if (deployInfo.getDeployment() == null) continue;
                list.add(deployInfo.getDeployment());
            }
        }

        private List[] getAllDeployments(DeploymentRequest deploymentRequest, boolean bl, List<AppDeploymentMBean> list) {
            boolean bl2 = Debug.isDeploymentDebugEnabled();
            this.processDeploymentInfos();
            ArrayList arrayList = new ArrayList();
            ArrayList<Deployment> arrayList2 = new ArrayList<Deployment>();
            if (bl2) {
                Debug.deploymentDebug("ConfigChangesHandler PreDepHandlerDeployments:" + this.preDeploymentHandlerDeployments);
            }
            this.addDeployments(this.preDeploymentHandlerDeployments, arrayList);
            if (bl && arrayList.size() > 0) {
                deploymentRequest.setCallConfigurationProviderLast();
            }
            if (bl2) {
                Debug.deploymentDebug("ConfigChangesHandler PostDepHandlerDeployments:" + this.postDeploymentHandlerDeployments);
            }
            this.addDeployments(this.postDeploymentHandlerDeployments, arrayList2);
            Collection collection = DeploymentManager.getInstance(kernelId).getPendingDeploymentsForEditLockOwner();
            if (collection != null && collection.size() > 0) {
                if (bl2) {
                    Debug.deploymentDebug("ConfigChangesHandler PostDepHandlerDeployments with no configuration side-effects:");
                }
                for (Deployment deployment : collection) {
                    if (bl2) {
                        Debug.deploymentDebug(deployment.getDeploymentTaskRuntimeId());
                    }
                    for (AppDeploymentMBean appDeploymentMBean : list) {
                        if (!appDeploymentMBean.getName().equals(deployment.getIdentity())) continue;
                        TargetMBean[] targetMBeanArray = appDeploymentMBean.getTargets();
                        ArrayList<String> arrayList3 = new ArrayList<String>();
                        for (int i = 0; i < targetMBeanArray.length; ++i) {
                            Set set = targetMBeanArray[i].getServerNames();
                            for (String string : set) {
                                arrayList3.add(string);
                            }
                        }
                        deployment.setTargets(arrayList3);
                    }
                    arrayList2.add(deployment);
                }
            }
            return new List[]{arrayList, arrayList2};
        }
    }

    private static abstract class DeployInfo {
        protected BasicDeploymentMBean topLevelDepBean;
        protected final DeploymentData deployData;
        protected int op;
        protected boolean isDeploy = true;
        private weblogic.deploy.service.Deployment deployment;
        protected boolean requireRestart;

        private DeployInfo() {
            this.topLevelDepBean = null;
            this.deployData = null;
            this.deployment = null;
        }

        private DeployInfo(BasicDeploymentMBean basicDeploymentMBean, DeploymentData deploymentData, int n, boolean bl) {
            this.topLevelDepBean = basicDeploymentMBean;
            this.deployData = deploymentData != null ? deploymentData : new DeploymentData();
            this.op = n;
            this.isDeploy = bl;
        }

        public boolean isDeploy() {
            return this.isDeploy;
        }

        public DeploymentData getDeployData() {
            return this.deployData;
        }

        public void setRequireRestart(boolean bl) {
            this.requireRestart = bl;
        }

        public int getOp() {
            return this.op;
        }

        public void setOp(int n) {
            this.op = n;
        }

        public weblogic.deploy.service.Deployment getDeployment() {
            return this.deployment;
        }

        public BasicDeploymentMBean getTopLevelDepBean() {
            return this.topLevelDepBean;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(super.toString()).append("[");
            stringBuffer.append("topLevelBean=").append(this.topLevelDepBean).append(",deployData=").append(this.deployData).append(",op=").append(this.op).append(",isDeploy=").append(this.isDeploy).append(",hasTargetedServers=").append(this.hasTargetedServers(ConfigChangesHandler.getDomainBean(true))).append("]");
            return stringBuffer.toString();
        }

        private boolean hasModuleTargets() {
            return this.deployData != null && this.deployData.hasModuleTargets();
        }

        private boolean hasSubModuleTargets() {
            return this.deployData != null && this.deployData.hasSubModuleTargets();
        }

        private boolean hasTargetedServers(DomainMBean domainMBean) {
            boolean bl;
            block4: {
                if (this.deployData == null) {
                    return false;
                }
                bl = false;
                try {
                    Set set = this.deployData.getAllTargetedServers(this.deployData.getAllLogicalTargets(), domainMBean);
                    bl = set != null && set.size() > 0;
                }
                catch (Throwable throwable) {
                    if (!Debug.isDeploymentDebugEnabled()) break block4;
                    Debug.deploymentDebug("getAllTargetedServers failed", throwable);
                }
            }
            if (Debug.isDeploymentDebugEnabled()) {
                Debug.deploymentDebug("ConfigChangesHandler.hasTargets=" + bl);
            }
            return bl;
        }

        protected boolean mergeWithRedeploy(DeployInfo deployInfo, Collection collection) {
            if (!(deployInfo instanceof RedeployDeployInfo)) {
                throw new AssertionError((Object)"Other DeployInfo is not Redeploy info");
            }
            return false;
        }

        protected boolean mergeWithUndeploy(DeployInfo deployInfo, Collection collection) {
            if (!(deployInfo instanceof UndeployDeployInfo)) {
                throw new AssertionError((Object)"Other DeployInfo is not Undeploy info");
            }
            return false;
        }

        protected boolean mergeWithDeploy(DeployInfo deployInfo, Collection collection) {
            if (!(deployInfo instanceof DeployDeployInfo)) {
                throw new AssertionError((Object)"Other DeployInfo is not Deploy info");
            }
            return false;
        }

        protected boolean mergeWithSameInfo(DeployInfo deployInfo, Collection collection) {
            if (!this.isSameInfoType(deployInfo)) {
                throw new AssertionError((Object)" DeployInfo instances are different types");
            }
            if (ConfigChangesHandler.isDebugEnabled()) {
                ConfigChangesHandler.debugSay(" +++ DeployInfos are of same type. Merging their data and making one info...");
            }
            DeploymentData deploymentData = this.deployData;
            DeploymentData deploymentData2 = deployInfo.deployData;
            DeploymentData deploymentData3 = deploymentData.copy();
            deploymentData3.setDeploymentPlan(deploymentData2.getDeploymentPlan());
            deploymentData3.addGlobalTargets(deploymentData2.getGlobalTargets());
            if (deploymentData2.hasModuleTargets()) {
                deploymentData3.addOrUpdateModuleTargets(deploymentData2.getAllModuleTargets());
            }
            if (deploymentData2.hasSubModuleTargets()) {
                deploymentData3.addOrUpdateSubModuleTargets(deploymentData2.getAllSubModuleTargets());
            }
            collection.remove(deployInfo);
            collection.remove(this);
            DeployInfo deployInfo2 = ConfigChangesHandler.createNewDeploymentInfo(this.topLevelDepBean, deploymentData3, this.op, this.isDeploy);
            deployInfo2.requireRestart = this.requireRestart;
            if (ConfigChangesHandler.isDebugEnabled()) {
                ConfigChangesHandler.debugSay(" +++ Merged into Info : " + deployInfo2);
            }
            collection.add(deployInfo2);
            return true;
        }

        protected boolean mergeWithOtherOperation(DeployInfo deployInfo, Collection collection) {
            if (ConfigChangesHandler.isDebugEnabled()) {
                ConfigChangesHandler.debugSay("DeployInfo.mergeWithOtherOperation() invoked on '" + this + "' ------ with parameter '" + deployInfo);
            }
            if (deployInfo instanceof ClusterDeployInfo) {
                return false;
            }
            if (deployInfo instanceof DeployDeployInfo) {
                return this.mergeWithDeploy(deployInfo, collection);
            }
            if (deployInfo instanceof RedeployDeployInfo) {
                return this.mergeWithRedeploy(deployInfo, collection);
            }
            return this.mergeWithUndeploy(deployInfo, collection);
        }

        protected weblogic.deploy.service.Deployment createDeployment() {
            if (this.deployData == null || this.topLevelDepBean == null || !this.hasTargetedServers(ConfigChangesHandler.getDomainBean(this.isDeploy))) {
                if (Debug.isDeploymentDebugEnabled()) {
                    Debug.deploymentDebug("ConfigChangesHandler.addDeployment skipped, deployInfo=" + this);
                }
                this.deployment = null;
            } else {
                this.deployment = ConfigChangesHandler.findOrCreateDeployment(this.op, this.topLevelDepBean, this.deployData, this.isDeploy, this.requireRestart, false);
            }
            return this.deployment;
        }

        private boolean isSameInfoType(DeployInfo deployInfo) {
            return this.getClass().equals(deployInfo.getClass());
        }
    }

    private static final class UndeployDeployInfo
    extends DeployInfo {
        private UndeployDeployInfo(BasicDeploymentMBean basicDeploymentMBean, DeploymentData deploymentData, boolean bl) {
            super(basicDeploymentMBean, deploymentData, 4, bl);
        }

        protected boolean mergeWithRedeploy(DeployInfo deployInfo, Collection collection) {
            super.mergeWithRedeploy(deployInfo, collection);
            return deployInfo.mergeWithUndeploy(this, collection);
        }

        protected boolean mergeWithUndeploy(DeployInfo deployInfo, Collection collection) {
            super.mergeWithUndeploy(deployInfo, collection);
            return this.mergeWithSameInfo(deployInfo, collection);
        }

        protected boolean mergeWithDeploy(DeployInfo deployInfo, Collection collection) {
            super.mergeWithDeploy(deployInfo, collection);
            return deployInfo.mergeWithUndeploy(this, collection);
        }
    }

    private static final class RedeployDeployInfo
    extends DeployInfo {
        private RedeployDeployInfo(BasicDeploymentMBean basicDeploymentMBean, DeploymentData deploymentData, boolean bl) {
            super(basicDeploymentMBean, deploymentData, 9, bl);
        }

        protected boolean mergeWithRedeploy(DeployInfo deployInfo, Collection collection) {
            super.mergeWithRedeploy(deployInfo, collection);
            return this.mergeWithSameInfo(deployInfo, collection);
        }

        protected boolean mergeWithUndeploy(DeployInfo deployInfo, Collection collection) {
            super.mergeWithUndeploy(deployInfo, collection);
            if (ConfigChangesHandler.areTargetsSame(this.deployData, deployInfo.deployData)) {
                if (ConfigChangesHandler.isDebugEnabled()) {
                    ConfigChangesHandler.debugSay(" +++ Targets are same...");
                    ConfigChangesHandler.debugSay(" +++ Removing from the list : " + deployInfo);
                }
                collection.remove(deployInfo);
                collection.remove(this);
                if (ConfigChangesHandler.isDebugEnabled()) {
                    ConfigChangesHandler.debugSay(" +++ Adding to the list : " + this);
                }
                collection.add(this);
                return true;
            }
            if (ConfigChangesHandler.isDebugEnabled()) {
                ConfigChangesHandler.debugSay(" +++ Targets are *NOT* same...");
            }
            if (ConfigChangesHandler.haveCommonTargets(this.deployData, deployInfo.deployData)) {
                DeployInfo deployInfo2;
                DeploymentData deploymentData = this.deployData;
                DeploymentData deploymentData2 = deployInfo.deployData;
                deploymentData.removeCommonTargets(deploymentData2, false);
                if (ConfigChangesHandler.isDebugEnabled()) {
                    ConfigChangesHandler.debugSay(" +++ Have common targets...");
                    ConfigChangesHandler.debugSay(" +++ Removing info : " + deployInfo);
                    ConfigChangesHandler.debugSay(" +++ Removing info : " + this);
                }
                collection.remove(deployInfo);
                collection.remove(this);
                if (!deploymentData2.hasNoTargets()) {
                    if (ConfigChangesHandler.isDebugEnabled()) {
                        ConfigChangesHandler.debugSay(" +++ Other data HAS targets after removing common targets...");
                    }
                    deployInfo2 = ConfigChangesHandler.createNewDeploymentInfo(deployInfo.topLevelDepBean, deploymentData2, 4, deployInfo.isDeploy);
                    deployInfo2.requireRestart = deployInfo.requireRestart;
                    if (ConfigChangesHandler.isDebugEnabled()) {
                        ConfigChangesHandler.debugSay(" +++ Adding new UndeployInfo : " + deployInfo2);
                    }
                    collection.add(deployInfo2);
                }
                deployInfo2 = ConfigChangesHandler.createNewDeploymentInfo(this.topLevelDepBean, deploymentData, 9, this.isDeploy);
                deployInfo2.requireRestart = this.requireRestart;
                if (ConfigChangesHandler.isDebugEnabled()) {
                    ConfigChangesHandler.debugSay(" +++ Adding new RedeployInfo : " + deployInfo2);
                }
                collection.add(deployInfo2);
                return true;
            }
            if (ConfigChangesHandler.isDebugEnabled()) {
                ConfigChangesHandler.debugSay(" +++ Have *NO* common targets... So returning false");
            }
            return false;
        }

        protected boolean mergeWithDeploy(DeployInfo deployInfo, Collection collection) {
            super.mergeWithDeploy(deployInfo, collection);
            if (ConfigChangesHandler.areTargetsSame(this.deployData, deployInfo.deployData)) {
                if (ConfigChangesHandler.isDebugEnabled()) {
                    ConfigChangesHandler.debugSay(" +++ Targets are same... Need not have to add this");
                }
                return true;
            }
            DeploymentData deploymentData = this.deployData;
            DeploymentData deploymentData2 = deployInfo.deployData;
            deploymentData.setDeploymentPlan(deploymentData2.getDeploymentPlan());
            deploymentData.addGlobalTargets(deploymentData2.getGlobalTargets());
            if (deploymentData2.hasModuleTargets()) {
                deploymentData.addOrUpdateModuleTargets(deploymentData2.getAllModuleTargets());
            }
            if (deploymentData2.hasSubModuleTargets()) {
                deploymentData.addOrUpdateSubModuleTargets(deploymentData2.getAllSubModuleTargets());
            }
            collection.remove(deployInfo);
            collection.remove(this);
            DeployInfo deployInfo2 = ConfigChangesHandler.createNewDeploymentInfo(this.topLevelDepBean, deploymentData, this.op, this.isDeploy);
            deployInfo2.requireRestart = this.requireRestart;
            collection.add(deployInfo2);
            return true;
        }
    }

    private static final class DeployDeployInfo
    extends DeployInfo {
        private DeployDeployInfo(BasicDeploymentMBean basicDeploymentMBean, DeploymentData deploymentData, boolean bl) {
            super(basicDeploymentMBean, deploymentData, 1, bl);
        }

        protected boolean mergeWithRedeploy(DeployInfo deployInfo, Collection collection) {
            super.mergeWithRedeploy(deployInfo, collection);
            return deployInfo.mergeWithDeploy(this, collection);
        }

        protected boolean mergeWithUndeploy(DeployInfo deployInfo, Collection collection) {
            super.mergeWithUndeploy(deployInfo, collection);
            if (ConfigChangesHandler.areTargetsSame(this.deployData, deployInfo.deployData)) {
                if (ConfigChangesHandler.isDebugEnabled()) {
                    ConfigChangesHandler.debugSay(" +++ Targets are same...");
                    ConfigChangesHandler.debugSay(" +++ Removing from the list : " + deployInfo);
                }
                collection.remove(deployInfo);
                collection.remove(this);
                DeployInfo deployInfo2 = ConfigChangesHandler.createNewDeploymentInfo(this.topLevelDepBean, this.deployData, 9, this.isDeploy);
                deployInfo2.requireRestart = this.requireRestart;
                if (ConfigChangesHandler.isDebugEnabled()) {
                    ConfigChangesHandler.debugSay(" +++ Adding to the list : " + deployInfo2);
                }
                collection.add(deployInfo2);
                return true;
            }
            if (ConfigChangesHandler.isDebugEnabled()) {
                ConfigChangesHandler.debugSay(" +++ Targets are *NOT* same...");
            }
            if (ConfigChangesHandler.haveCommonTargets(this.deployData, deployInfo.deployData)) {
                DeployInfo deployInfo3;
                DeploymentData deploymentData = this.deployData;
                DeploymentData deploymentData2 = deployInfo.deployData;
                deploymentData.removeCommonTargets(deploymentData2, false);
                if (ConfigChangesHandler.isDebugEnabled()) {
                    ConfigChangesHandler.debugSay(" +++ Have common targets...");
                    ConfigChangesHandler.debugSay(" +++ Removing info : " + deployInfo);
                    ConfigChangesHandler.debugSay(" +++ Removing info : " + this);
                }
                collection.remove(deployInfo);
                collection.remove(this);
                if (!deploymentData2.hasNoTargets()) {
                    if (ConfigChangesHandler.isDebugEnabled()) {
                        ConfigChangesHandler.debugSay(" +++ Other data HAS targets after removing common targets...");
                    }
                    deployInfo3 = ConfigChangesHandler.createNewDeploymentInfo(deployInfo.topLevelDepBean, deploymentData2, 4, deployInfo.isDeploy);
                    deployInfo3.requireRestart = deployInfo.requireRestart;
                    if (ConfigChangesHandler.isDebugEnabled()) {
                        ConfigChangesHandler.debugSay(" +++ Adding new UndeployInfo : " + deployInfo3);
                    }
                    collection.add(deployInfo3);
                }
                deployInfo3 = ConfigChangesHandler.createNewDeploymentInfo(this.topLevelDepBean, deploymentData, 9, this.isDeploy);
                deployInfo3.requireRestart = this.requireRestart;
                if (ConfigChangesHandler.isDebugEnabled()) {
                    ConfigChangesHandler.debugSay(" +++ Adding new RedeployInfo : " + deployInfo3);
                }
                collection.add(deployInfo3);
                return true;
            }
            if (ConfigChangesHandler.isDebugEnabled()) {
                ConfigChangesHandler.debugSay(" +++ Have *NO* common targets... So returning false");
            }
            return false;
        }

        protected boolean mergeWithDeploy(DeployInfo deployInfo, Collection collection) {
            super.mergeWithDeploy(deployInfo, collection);
            return this.mergeWithSameInfo(deployInfo, collection);
        }
    }

    private static final class ClusterDeployInfo
    extends DeployInfo {
        private DeployInfo delegate;
        String associatedClusterName;

        private ClusterDeployInfo(BasicDeploymentMBean basicDeploymentMBean, DeploymentData deploymentData, int n, boolean bl, String string) {
            this.delegate = n == 1 ? new DeployDeployInfo(basicDeploymentMBean, deploymentData, bl) : (n == 9 ? new RedeployDeployInfo(basicDeploymentMBean, deploymentData, bl) : new UndeployDeployInfo(basicDeploymentMBean, deploymentData, bl));
            this.associatedClusterName = string;
        }

        public boolean isDeploy() {
            return this.delegate.isDeploy();
        }

        public DeploymentData getDeployData() {
            return this.delegate.getDeployData();
        }

        public int getOp() {
            return this.delegate.getOp();
        }

        public void setRequireRestart(boolean bl) {
            this.delegate.setRequireRestart(bl);
        }

        public void setOp(int n) {
            this.delegate.setOp(n);
        }

        public final String toString() {
            return "ClusterDeplyInfo for cluster [" + this.associatedClusterName + "] with delegate " + this.delegate;
        }

        protected final boolean mergeWithOtherOperation(DeployInfo deployInfo, Collection collection) {
            if (ConfigChangesHandler.isDebugEnabled()) {
                ConfigChangesHandler.debugSay("ClusterDeployInfo.mergeWithOtherOperation() invoked on '" + this + "' ------ with otherInfo '" + deployInfo);
            }
            if (!(deployInfo instanceof ClusterDeployInfo)) {
                return false;
            }
            ClusterDeployInfo clusterDeployInfo = (ClusterDeployInfo)deployInfo;
            if (!this.associatedClusterName.equals(clusterDeployInfo.associatedClusterName)) {
                return false;
            }
            DeployInfo deployInfo2 = clusterDeployInfo.delegate;
            if (this.delegate instanceof DeployDeployInfo) {
                if (deployInfo2 instanceof DeployDeployInfo) {
                    clusterDeployInfo.mergeTargets(this.delegate);
                    collection.remove(this);
                    return true;
                }
                if (deployInfo2 instanceof UndeployDeployInfo) {
                    collection.remove(clusterDeployInfo);
                    return false;
                }
                clusterDeployInfo.mergeTargets(this.delegate);
                collection.remove(this);
                return true;
            }
            if (this.delegate instanceof RedeployDeployInfo) {
                if (deployInfo2 instanceof DeployDeployInfo) {
                    this.mergeTargets(deployInfo2);
                    collection.remove(clusterDeployInfo);
                    return false;
                }
                if (deployInfo2 instanceof UndeployDeployInfo) {
                    collection.remove(clusterDeployInfo);
                    return false;
                }
                clusterDeployInfo.mergeTargets(this.delegate);
                collection.remove(this);
                return true;
            }
            if (deployInfo2 instanceof DeployDeployInfo) {
                collection.remove(this);
                return true;
            }
            if (deployInfo2 instanceof UndeployDeployInfo) {
                clusterDeployInfo.mergeTargets(this.delegate);
                collection.remove(this);
                return true;
            }
            collection.remove(this);
            return true;
        }

        void mergeTargets(DeployInfo deployInfo) {
            DeploymentData deploymentData = this.delegate.deployData;
            DeploymentData deploymentData2 = deployInfo.deployData;
            deploymentData.setDeploymentPlan(deploymentData2.getDeploymentPlan());
            deploymentData.addGlobalTargets(deploymentData2.getGlobalTargets());
            if (deploymentData2.hasModuleTargets()) {
                deploymentData.addOrUpdateModuleTargets(deploymentData2.getAllModuleTargets());
            }
            if (deploymentData2.hasSubModuleTargets()) {
                deploymentData.addOrUpdateSubModuleTargets(deploymentData2.getAllSubModuleTargets());
            }
            boolean bl = this.delegate.requireRestart = this.delegate.requireRestart || deployInfo.requireRestart;
            if (ConfigChangesHandler.isDebugEnabled()) {
                ConfigChangesHandler.debugSay(" +++ Merged into Info : " + this);
            }
        }

        protected weblogic.deploy.service.Deployment createDeployment() {
            if (Debug.isDeploymentDebugEnabled()) {
                Debug.deploymentDebug("ConfigChangesHandler.ClusterDeployInfo.createDeployment --> " + this);
            }
            return this.delegate.createDeployment();
        }

        public weblogic.deploy.service.Deployment getDeployment() {
            return this.delegate.getDeployment();
        }

        public BasicDeploymentMBean getTopLevelDepBean() {
            return this.delegate.getTopLevelDepBean();
        }
    }
}

