/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.internal.adminserver;

import java.io.Serializable;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import weblogic.deploy.beans.factory.DeploymentBeanFactory;
import weblogic.deploy.common.Debug;
import weblogic.deploy.compatibility.NotificationBroadcaster;
import weblogic.deploy.internal.AggregateDeploymentVersion;
import weblogic.deploy.internal.Deployment;
import weblogic.deploy.internal.DeploymentVersion;
import weblogic.deploy.internal.adminserver.ConfigChangesHandler;
import weblogic.deploy.internal.adminserver.DeploymentServiceDriver;
import weblogic.deploy.internal.adminserver.EditAccessHelper;
import weblogic.deploy.internal.adminserver.operations.AbstractOperation;
import weblogic.deploy.internal.adminserver.operations.OperationHelper;
import weblogic.deploy.internal.targetserver.state.DeploymentState;
import weblogic.deploy.service.ChangeDescriptor;
import weblogic.deploy.service.ConfigurationContext;
import weblogic.deploy.service.DeploymentException;
import weblogic.deploy.service.DeploymentFailureHandler;
import weblogic.deploy.service.DeploymentProvider;
import weblogic.deploy.service.DeploymentRequest;
import weblogic.deploy.service.FailureDescription;
import weblogic.deploy.service.RequiresRestartFailureDescription;
import weblogic.deploy.service.Version;
import weblogic.deploy.service.internal.adminserver.AdminDeploymentException;
import weblogic.logging.Loggable;
import weblogic.management.DeferredDeploymentException;
import weblogic.management.ManagementException;
import weblogic.management.configuration.AppDeploymentMBean;
import weblogic.management.configuration.BasicDeploymentMBean;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.SubDeploymentMBean;
import weblogic.management.configuration.SystemResourceMBean;
import weblogic.management.configuration.TargetMBean;
import weblogic.management.deploy.DeploymentData;
import weblogic.management.deploy.DeploymentTaskRuntime;
import weblogic.management.deploy.TargetStatus;
import weblogic.management.deploy.internal.AppRuntimeStateManager;
import weblogic.management.deploy.internal.AppRuntimeStateRuntimeMBeanImpl;
import weblogic.management.deploy.internal.ApplicationRuntimeState;
import weblogic.management.deploy.internal.DeployerRuntimeImpl;
import weblogic.management.deploy.internal.DeployerRuntimeLogger;
import weblogic.management.deploy.internal.DeploymentManagerLogger;
import weblogic.management.deploy.internal.DeploymentServerService;
import weblogic.management.provider.DomainAccess;
import weblogic.management.provider.ManagementService;
import weblogic.management.runtime.DeploymentRequestTaskRuntimeMBean;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;
import weblogic.utils.StackTraceUtils;

public final class DeploymentManager
implements DeploymentProvider {
    private static final String DEPLOYMENT_SERVICE_CALLBACK_HANDLER_ID = "Application";
    private static final DeploymentManager theInstance = new DeploymentManager();
    private DeploymentServiceDriver driver;
    private AggregateDeploymentVersion adminServerAggregateDeploymentVersion;
    private static DeploymentBeanFactory beanFactory = DeploymentServerService.getDeploymentBeanFactory();
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private List pendingDeploymentsForLockOwner;
    private List pendingDeploymentsForLockAcquirer;
    private Map pendingControlDeployments;
    private Map requestInfoTable;
    private EditAccessHelper editAccessHelper;
    private DeployerRuntimeImpl deployerRuntime;
    private Map taskRuntimeToDeploymentTable;
    private Map taskRuntimeToDeploymentInfoTable;
    private static boolean initialized = false;

    private DeploymentManager() {
    }

    public static DeploymentManager getInstance(AuthenticatedSubject authenticatedSubject) {
        SecurityServiceManager.checkKernelIdentity((AuthenticatedSubject)authenticatedSubject);
        return theInstance;
    }

    private void loadAppRuntimeStates() throws ManagementException {
        AppRuntimeStateManager.getManager().loadStartupState(null);
        Map map = AppRuntimeStateManager.getManager().getDeploymentVersions();
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                String string = (String)entry.getKey();
                DeploymentVersion deploymentVersion = (DeploymentVersion)entry.getValue();
                this.addOrUpdateAdminServerAggregateDeploymentVersion(string, deploymentVersion);
            }
        }
    }

    public void initialize() throws ManagementException {
        if (initialized) {
            return;
        }
        this.loadAppRuntimeStates();
        this.driver = DeploymentServiceDriver.getInstance();
        DomainAccess domainAccess = ManagementService.getDomainAccess(kernelId);
        this.deployerRuntime = (DeployerRuntimeImpl)domainAccess.getDeployerRuntime();
        this.driver.initialize(DEPLOYMENT_SERVICE_CALLBACK_HANDLER_ID, this.getAdminServerAggregateDeploymentsVersion(), this);
        this.requestInfoTable = new HashMap();
        this.pendingDeploymentsForLockOwner = new ArrayList();
        this.pendingDeploymentsForLockAcquirer = new ArrayList();
        this.pendingControlDeployments = new HashMap();
        this.taskRuntimeToDeploymentTable = new HashMap();
        this.taskRuntimeToDeploymentInfoTable = new HashMap();
        this.editAccessHelper = EditAccessHelper.getInstance(kernelId);
        AppRuntimeStateRuntimeMBeanImpl.initialize();
    }

    public static void shutdown() {
        DeploymentServiceDriver.getInstance().shutdown();
    }

    public DeployerRuntimeImpl getDeployerRuntime() {
        return this.deployerRuntime;
    }

    public EditAccessHelper getEditAccessHelper(AuthenticatedSubject authenticatedSubject) {
        SecurityServiceManager.checkKernelIdentity((AuthenticatedSubject)authenticatedSubject);
        return this.editAccessHelper;
    }

    public void restartSystemResource(SystemResourceMBean systemResourceMBean) throws ManagementException {
        ConfigChangesHandler.restartSystemResource(systemResourceMBean);
    }

    public String getIdentity() {
        return DEPLOYMENT_SERVICE_CALLBACK_HANDLER_ID;
    }

    public synchronized void addDeploymentsTo(DeploymentRequest deploymentRequest, ConfigurationContext configurationContext) {
        List[] listArray = this.pendingDeploymentsForLockAcquirer.isEmpty() ? ConfigChangesHandler.configChanged(deploymentRequest, configurationContext) : new List[]{this.pendingDeploymentsForLockAcquirer};
        this.updateRequestAndDeployments(deploymentRequest, listArray);
        this.clearPendingDeployments();
    }

    private void clearPendingDeployments() {
        this.pendingDeploymentsForLockAcquirer.clear();
        this.pendingDeploymentsForLockOwner.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateRequestAndDeployments(DeploymentRequest deploymentRequest, List[] listArray) {
        if (listArray == null || listArray.length == 0) {
            return;
        }
        DeploymentRequestInfo deploymentRequestInfo = null;
        boolean bl = true;
        boolean bl2 = true;
        AuthenticatedSubject authenticatedSubject = null;
        for (int i = 0; i < listArray.length; ++i) {
            List list = listArray[i];
            if (list == null || list.isEmpty()) continue;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                if (deploymentRequestInfo == null) {
                    deploymentRequestInfo = new DeploymentRequestInfo(deploymentRequest);
                }
                Deployment deployment = (Deployment)iterator.next();
                bl = deployment.isCallerLockOwner();
                bl2 = deployment.isAControlOperation();
                authenticatedSubject = deployment.getInitiator();
                deploymentRequest.addDeployment(deployment);
                deployment.setDeploymentRequestIdentifier(deploymentRequest.getId());
                DeploymentTaskRuntime deploymentTaskRuntime = deployment.getDeploymentTaskRuntime();
                String string = deploymentTaskRuntime.getId();
                deploymentRequest.getTaskRuntime().addDeploymentRequestSubTask(deploymentTaskRuntime, string);
                DeploymentData deploymentData = deploymentTaskRuntime.getDeploymentData();
                if (deploymentData != null) {
                    deploymentRequest.setTimeoutInterval(deploymentData.getTimeOut());
                }
                deploymentRequestInfo.addDeploymentStatusContainerFor(string);
                if (deployment.isAnAppDeployment()) {
                    deployment.setStaged(deploymentTaskRuntime.getAppDeploymentMBean().getStagingMode());
                }
                this.taskRuntimeToDeploymentInfoTable.put(string, deploymentRequestInfo);
                this.taskRuntimeToDeploymentTable.put(string, deployment);
            }
        }
        if (deploymentRequestInfo == null) {
            return;
        }
        deploymentRequest.setInitiator(authenticatedSubject);
        if (!bl) {
            deploymentRequest.setStartControl(true);
        }
        deploymentRequest.setControlRequest(bl2);
        if (!bl2) {
            deploymentRequestInfo.setIsEditLockOwner(bl);
            if (Debug.isDeploymentDebugEnabled()) {
                Debug.deploymentDebug("Request '" + deploymentRequest.getId() + "' initiated by '" + authenticatedSubject + "'");
            }
            DomainMBean domainMBean = this.editAccessHelper.getEditDomainBean(authenticatedSubject);
            deploymentRequestInfo.setEditableDomain(domainMBean);
        }
        Map map = this.requestInfoTable;
        synchronized (map) {
            this.requestInfoTable.put(new Long(deploymentRequest.getId()), deploymentRequestInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getPendingDeploymentsForEditLockOwner() {
        List list = this.pendingDeploymentsForLockOwner;
        synchronized (list) {
            if (!this.pendingDeploymentsForLockOwner.isEmpty() && this.pendingDeploymentsForLockOwner.size() > 0) {
                if (Debug.isDeploymentDebugEnabled()) {
                    Debug.deploymentDebug("DeploymentManager: getPendingDeployments returning " + this.pendingDeploymentsForLockOwner.size() + " deployments");
                }
                ArrayList arrayList = new ArrayList();
                arrayList.addAll(this.pendingDeploymentsForLockOwner);
                return arrayList;
            }
            if (Debug.isDeploymentDebugEnabled()) {
                Debug.deploymentDebug("DeploymentManager: getPendingDeployments no deployments to return");
            }
        }
        return null;
    }

    public DomainMBean getEditableDomainMBean(long l) {
        DeploymentRequestInfo deploymentRequestInfo = this.getDeploymentRequestInfo(l);
        if (deploymentRequestInfo == null) {
            if (Debug.isDeploymentDebugEnabled()) {
                Debug.deploymentDebug("DeploymentManager: getEditableDomainMBean() ' requestInfo for request '" + l + "' is null");
            }
            return null;
        }
        DomainMBean domainMBean = deploymentRequestInfo.editableDomain;
        if (Debug.isDeploymentDebugEnabled()) {
            Debug.deploymentDebug("DeploymentManager: getEditableDomainMBean() ' editableDomain for request '" + l + "' is " + domainMBean);
        }
        return domainMBean;
    }

    private static String getCompositeKey(String string, int n) {
        return string + "###" + Integer.toString(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean lockOwnerMatchesPendingDeploymentsLockOwner(boolean bl) {
        List list = this.pendingDeploymentsForLockAcquirer;
        synchronized (list) {
            if (bl && !this.pendingDeploymentsForLockAcquirer.isEmpty()) {
                return false;
            }
        }
        list = this.pendingDeploymentsForLockOwner;
        synchronized (list) {
            if (!bl && !this.pendingDeploymentsForLockOwner.isEmpty()) {
                return false;
            }
        }
        return true;
    }

    private static int getCanonicalOperation(int n) {
        int n2 = n;
        switch (n) {
            case 1: 
            case 6: 
            case 11: {
                n2 = 1;
                break;
            }
            case 9: {
                n2 = 9;
                break;
            }
            case 4: 
            case 12: {
                n2 = 4;
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Deployment createDeployment(String string, DeploymentData deploymentData, int n, DeploymentTaskRuntime deploymentTaskRuntime, DomainMBean domainMBean, boolean bl, AuthenticatedSubject authenticatedSubject, boolean bl2, boolean bl3, boolean bl4) throws ManagementException {
        if (!bl3 && !this.lockOwnerMatchesPendingDeploymentsLockOwner(bl2)) {
            String string2 = DeployerRuntimeLogger.configLocked();
            throw new ManagementException(string2);
        }
        Deployment deployment = this.createAndInitializeDeployment(deploymentTaskRuntime, domainMBean, deploymentData, n, authenticatedSubject, bl2, bl3, bl4);
        if (Debug.isDeploymentDebugEnabled()) {
            Debug.deploymentDebug("DeploymentManager: deployment '" + deployment + "' initiated by '" + authenticatedSubject + "'");
        }
        if (bl3) {
            if (Debug.isDeploymentDebugEnabled()) {
                Debug.deploymentDebug("DeploymentManager: added deployment: " + deployment + " to list of control opeartions");
            }
            this.pendingControlDeployments.put(deploymentTaskRuntime.getId(), deployment);
        } else if (bl2) {
            if (bl) {
                if (Debug.isDeploymentDebugEnabled()) {
                    Debug.deploymentDebug("DeploymentManager: not adding config change: " + deployment + " to list of pending  deployments for edit " + "lock owner");
                }
            } else {
                List list = this.pendingDeploymentsForLockOwner;
                synchronized (list) {
                    boolean bl5;
                    if (Debug.isDeploymentDebugEnabled()) {
                        Debug.deploymentDebug("DeploymentManager: added deployment: " + deployment + " to list of pending deployments for edit " + "lock owner");
                    }
                    if (!(bl5 = this.removeDeployIfNoop(deployment))) {
                        this.pendingDeploymentsForLockOwner.add(deployment);
                    }
                }
            }
        } else {
            List list = this.pendingDeploymentsForLockAcquirer;
            synchronized (list) {
                if (Debug.isDeploymentDebugEnabled()) {
                    Debug.deploymentDebug("DeploymentManager: added deployment: " + deployment + " to list of pending deployments for edit " + "lock acquirer");
                }
                this.pendingDeploymentsForLockAcquirer.add(deployment);
            }
        }
        return deployment;
    }

    private Deployment createAndInitializeDeployment(DeploymentTaskRuntime deploymentTaskRuntime, DomainMBean domainMBean, DeploymentData deploymentData, int n, AuthenticatedSubject authenticatedSubject, boolean bl, boolean bl2, boolean bl3) {
        Deployment deployment = this.createDeployment(deploymentTaskRuntime, deploymentTaskRuntime.getDeploymentData(), domainMBean, authenticatedSubject, bl, bl2, bl3);
        Map map = this.getAdminServerAggregateDeploymentsVersion().getVersionComponents();
        AggregateDeploymentVersion aggregateDeploymentVersion = AggregateDeploymentVersion.createAggregateDeploymentVersion(map);
        DeploymentVersion deploymentVersion = null;
        if (deploymentTaskRuntime.getAppDeploymentMBean() != null) {
            boolean bl4 = DeploymentManager.isAConfigurationChange(deploymentTaskRuntime.getAppDeploymentMBean(), deploymentData, n);
            deploymentVersion = this.createDeploymentVersion(deployment.getIdentity(), bl4, bl2);
            if (n == 4 || n == 12) {
                aggregateDeploymentVersion.removeDeploymentVersionFor(deployment.getIdentity());
            } else {
                aggregateDeploymentVersion.addOrUpdateDeploymentVersion(deployment.getIdentity(), deploymentVersion);
            }
        }
        deployment.setProposedVersion(aggregateDeploymentVersion);
        deployment.setProposedDeploymentVersion(deploymentVersion);
        ChangeDescriptor changeDescriptor = this.createChangeDescriptor((Serializable)((Object)deployment.getIdentity()), deploymentVersion);
        deployment.addChangeDescriptor(changeDescriptor);
        if (Debug.isDeploymentDebugEnabled()) {
            Debug.deploymentDebug("DeploymentManager: Created Deployment : '" + deployment.toString() + "'");
        }
        return deployment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DeploymentRequestInfo getDeploymentRequestInfo(long l) {
        Map map = this.requestInfoTable;
        synchronized (map) {
            return (DeploymentRequestInfo)this.requestInfoTable.get(new Long(l));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deploymentRequestSucceeded(long l, FailureDescription[] failureDescriptionArray) {
        block12: {
            DeploymentRequestInfo deploymentRequestInfo;
            block11: {
                if (Debug.isDeploymentDebugEnabled()) {
                    Debug.deploymentDebug("Received deployment request success:  for deployment request id: " + l);
                }
                if ((deploymentRequestInfo = this.getDeploymentRequestInfo(l)) != null) break block11;
                if (Debug.isDeploymentDebugEnabled()) {
                    Debug.deploymentDebug("deploymentRequestSucceeded(): Request id: " + l + " has completed or timed out since there is no " + "active current deployment");
                }
                break block12;
            }
            DeploymentRequestInfo deploymentRequestInfo2 = deploymentRequestInfo;
            synchronized (deploymentRequestInfo2) {
                ArrayList<FailureDescription> arrayList;
                int n;
                try {
                    this.releaseEditLock(deploymentRequestInfo);
                    Object var7_5 = null;
                    this.updateTasksWithAccumulatedStatus(l);
                    n = 3;
                    arrayList = new ArrayList<FailureDescription>();
                }
                catch (Throwable throwable) {
                    Object var7_6 = null;
                    this.updateTasksWithAccumulatedStatus(l);
                    int n2 = 3;
                    ArrayList<FailureDescription> arrayList2 = new ArrayList<FailureDescription>();
                    if (failureDescriptionArray != null && failureDescriptionArray.length > 0) {
                        for (int i = 0; i < failureDescriptionArray.length; ++i) {
                            FailureDescription failureDescription = failureDescriptionArray[i];
                            if (failureDescription instanceof RequiresRestartFailureDescription) continue;
                            n2 = 4;
                            String string = failureDescriptionArray[i].getAttemptedOperation();
                            String string2 = failureDescriptionArray[i].getServer();
                            DeferredDeploymentException deferredDeploymentException = new DeferredDeploymentException(failureDescriptionArray[i].getReason());
                            arrayList2.add(new FailureDescription(string2, (Exception)((Object)deferredDeploymentException), string));
                        }
                    }
                    FailureDescription[] failureDescriptionArray2 = new FailureDescription[arrayList2.size()];
                    failureDescriptionArray2 = arrayList2.toArray(failureDescriptionArray2);
                    this.updateTasksWithDeploymentStatus(l, failureDescriptionArray2, n2, false);
                    this.updateAdminServerRuntimeStateAndAggregateDeploymentVersion(deploymentRequestInfo);
                    throw throwable;
                }
                if (failureDescriptionArray != null && failureDescriptionArray.length > 0) {
                    for (int i = 0; i < failureDescriptionArray.length; ++i) {
                        FailureDescription failureDescription = failureDescriptionArray[i];
                        if (failureDescription instanceof RequiresRestartFailureDescription) continue;
                        n = 4;
                        String string = failureDescriptionArray[i].getAttemptedOperation();
                        String string3 = failureDescriptionArray[i].getServer();
                        DeferredDeploymentException deferredDeploymentException = new DeferredDeploymentException(failureDescriptionArray[i].getReason());
                        arrayList.add(new FailureDescription(string3, (Exception)((Object)deferredDeploymentException), string));
                    }
                }
                FailureDescription[] failureDescriptionArray3 = new FailureDescription[arrayList.size()];
                failureDescriptionArray3 = arrayList.toArray(failureDescriptionArray3);
                this.updateTasksWithDeploymentStatus(l, failureDescriptionArray3, n, false);
                this.updateAdminServerRuntimeStateAndAggregateDeploymentVersion(deploymentRequestInfo);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTasksWithDeploymentStatus(long l, FailureDescription[] failureDescriptionArray, int n, boolean bl) {
        DeploymentRequestInfo deploymentRequestInfo = this.getDeploymentRequestInfo(l);
        if (deploymentRequestInfo == null) {
            if (Debug.isDeploymentDebugEnabled()) {
                Debug.deploymentDebug("DeploymentManager: updateTasksWithDeploymentStatus() couldn't find requestInfo for request : " + l);
            }
            return;
        }
        if (Debug.isDeploymentDebugEnabled()) {
            Debug.deploymentDebug("DeploymentManager: updateTasksWithDeploymentStatus for request : " + l + " with status: " + n);
        }
        DeploymentRequestInfo deploymentRequestInfo2 = deploymentRequestInfo;
        synchronized (deploymentRequestInfo2) {
            DeploymentRequest deploymentRequest = deploymentRequestInfo.request;
            Iterator iterator = deploymentRequest.getDeployments(DEPLOYMENT_SERVICE_CALLBACK_HANDLER_ID);
            while (iterator.hasNext()) {
                Deployment deployment = (Deployment)iterator.next();
                DeploymentTaskRuntime deploymentTaskRuntime = deployment.getDeploymentTaskRuntime();
                if (Debug.isDeploymentDebugEnabled()) {
                    StringBuffer stringBuffer = new StringBuffer();
                    if (failureDescriptionArray != null) {
                        stringBuffer.append(Arrays.asList(failureDescriptionArray));
                    } else {
                        stringBuffer.append("null");
                    }
                    Debug.deploymentDebug("DeploymentManager: Updating task '" + deploymentTaskRuntime.getId() + "' with failures : " + stringBuffer.toString());
                }
                DeploymentManager.updateTaskWithFailures(deploymentTaskRuntime, failureDescriptionArray, n);
                if (!(bl || n != 3 && n != 4)) {
                    this.updateTaskStatusOfRestartTargets(l, deploymentTaskRuntime, deploymentRequest.getTaskRuntime().getServersToBeRestarted());
                }
                if (!bl && n == 2) {
                    if (Debug.isDeploymentDebugEnabled()) {
                        Debug.deploymentDebug("DeploymentManager: Calling handleFailure on task '" + deploymentTaskRuntime.getId() + "'");
                    }
                    deploymentTaskRuntime.handleFailure();
                }
                if (bl) {
                    deploymentTaskRuntime.updatePendingServersWithSuccess();
                }
                if (!bl && n != 2) continue;
                this.reset(deploymentTaskRuntime.getId());
            }
        }
    }

    private void releaseEditLock(DeploymentRequestInfo deploymentRequestInfo) {
        block5: {
            if (deploymentRequestInfo.isControlOperation()) {
                return;
            }
            long l = deploymentRequestInfo.request.getId();
            boolean bl = deploymentRequestInfo.ownsEditLock;
            AuthenticatedSubject authenticatedSubject = deploymentRequestInfo.request.getInitiator();
            beanFactory.resetDeployerInitiatedBeanUpdates();
            if (authenticatedSubject != null && !bl) {
                try {
                    if (Debug.isDeploymentDebugEnabled()) {
                        Debug.deploymentLogger.debug("DeploymentManager: stopping edit session for request id: " + l);
                    }
                    this.editAccessHelper.stopEditSession(authenticatedSubject);
                }
                catch (ManagementException managementException) {
                    if (!Debug.isDeploymentDebugEnabled()) break block5;
                    Debug.deploymentLogger.debug("Failed to stop edit session on a successful deployment of request id: " + l);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deploymentRequestFailedBeforeStart(DeploymentRequestInfo deploymentRequestInfo, DeploymentException deploymentException) {
        if (deploymentRequestInfo == null) {
            return;
        }
        long l = deploymentRequestInfo.getRequestId();
        if (Debug.isDeploymentDebugEnabled()) {
            Debug.deploymentDebug("Received deployment request failure : " + deploymentException.toString() + " before start for request id: " + l);
        }
        this.clearPendingDeployments();
        DeploymentRequestInfo deploymentRequestInfo2 = deploymentRequestInfo;
        synchronized (deploymentRequestInfo2) {
            DeploymentRequest deploymentRequest = deploymentRequestInfo.request;
            Set set = deploymentRequest.getRegisteredFailureListeners();
            if (set != null) {
                for (DeploymentFailureHandler deploymentFailureHandler : set) {
                    deploymentFailureHandler.deployFailed(l, deploymentException);
                }
            }
            this.deploymentRequestFailed(l, null, deploymentException.getFailures());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deploymentRequestFailed(long l, DeploymentException deploymentException, FailureDescription[] failureDescriptionArray) {
        if (Debug.isDeploymentDebugEnabled()) {
            Debug.deploymentDebug("Received deployment request failure: " + deploymentException + " for " + "deployment request id: " + l);
        }
        DeploymentRequestInfo deploymentRequestInfo = this.getDeploymentRequestInfo(l);
        if (Debug.isDeploymentDebugEnabled()) {
            Debug.deploymentDebug("DeploymentManager.deploymentRequestFailed(): requestInfo : " + deploymentRequestInfo);
        }
        if (deploymentRequestInfo == null) {
            if (Debug.isDeploymentDebugEnabled()) {
                Debug.deploymentDebug("deploymentRequestFailed(): Request id: " + l + " has completed, timed out or was never started " + "since there is no active deployment information for this request");
            }
        } else {
            DeploymentRequestInfo deploymentRequestInfo2 = deploymentRequestInfo;
            synchronized (deploymentRequestInfo2) {
                this.undoUnactivatedChanges(deploymentRequestInfo);
                if (Debug.isDeploymentDebugEnabled()) {
                    Debug.deploymentDebug("DeploymentManager.deploymentRequestFailed(): Calling updateTasksWithDeploymentStatus() for request '" + l + "' with status failed");
                }
                this.updateTasksWithDeploymentStatus(l, failureDescriptionArray, 2, false);
            }
        }
        if (Debug.isDeploymentDebugEnabled()) {
            Debug.deploymentDebug("DeploymentManager.deploymentRequestFailed(): Returning from deploymentRequestFailed()...");
        }
    }

    public void undoChangesTriggeredByUser(Deployment deployment) {
        this.pendingDeploymentsForLockOwner.remove(deployment);
        if (Debug.isDeploymentDebugEnabled()) {
            Debug.deploymentDebug("DeploymentManager: Removed entry: '" + deployment + "' from pendingDeploymentsForLockOwner if has one");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void undoUnactivatedChanges(DeploymentRequestInfo deploymentRequestInfo) {
        block14: {
            AuthenticatedSubject authenticatedSubject;
            long l;
            block15: {
                if (deploymentRequestInfo.isControlOperation()) {
                    return;
                }
                l = deploymentRequestInfo.request.getId();
                boolean bl = deploymentRequestInfo.ownsEditLock;
                authenticatedSubject = deploymentRequestInfo.request.getInitiator();
                if (authenticatedSubject == null || bl) break block15;
                if (Debug.isDeploymentDebugEnabled()) {
                    Debug.deploymentDebug("DeploymentManager: undoUnactivatedChanges for request: " + l);
                }
                this.editAccessHelper.undoUnactivatedChanges(authenticatedSubject);
                Object var8_5 = null;
                try {
                    this.editAccessHelper.stopEditSession(authenticatedSubject);
                }
                catch (Exception exception) {
                    Debug.deploymentLogger.debug("Failed to stop edit session on a failed deployment of request id: " + l + " due to " + StackTraceUtils.throwable2StackTrace((Throwable)exception));
                }
                break block14;
                {
                    catch (ManagementException managementException) {
                        Debug.deploymentLogger.debug("Failed to undo unactivated changes on a failed deployment of request id: " + l + " due to " + StackTraceUtils.throwable2StackTrace((Throwable)managementException));
                        Object var8_6 = null;
                        try {
                            this.editAccessHelper.stopEditSession(authenticatedSubject);
                        }
                        catch (Exception exception) {
                            Debug.deploymentLogger.debug("Failed to stop edit session on a failed deployment of request id: " + l + " due to " + StackTraceUtils.throwable2StackTrace((Throwable)exception));
                        }
                        break block14;
                    }
                    catch (Throwable throwable) {
                        Debug.deploymentLogger.debug("Failed to undo unactivated changes on a failed deployment of request id: " + l + " due to " + StackTraceUtils.throwable2StackTrace((Throwable)throwable));
                        Object var8_7 = null;
                        try {
                            this.editAccessHelper.stopEditSession(authenticatedSubject);
                        }
                        catch (Exception exception) {
                            Debug.deploymentLogger.debug("Failed to stop edit session on a failed deployment of request id: " + l + " due to " + StackTraceUtils.throwable2StackTrace((Throwable)exception));
                        }
                        break block14;
                    }
                }
                catch (Throwable throwable) {
                    Object var8_8 = null;
                    try {
                        this.editAccessHelper.stopEditSession(authenticatedSubject);
                    }
                    catch (Exception exception) {
                        Debug.deploymentLogger.debug("Failed to stop edit session on a failed deployment of request id: " + l + " due to " + StackTraceUtils.throwable2StackTrace((Throwable)exception));
                    }
                    throw throwable;
                }
            }
            if (authenticatedSubject != null) {
                if (Debug.isDeploymentDebugEnabled()) {
                    Debug.deploymentDebug("DeploymentManager: rollbackFailedTasks for request: " + l);
                }
                this.rollBackFailedTasks(l, authenticatedSubject);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rollBackFailedTasks(long l, AuthenticatedSubject authenticatedSubject) {
        DeploymentRequestInfo deploymentRequestInfo = this.getDeploymentRequestInfo(l);
        if (deploymentRequestInfo == null) {
            return;
        }
        DeploymentRequestInfo deploymentRequestInfo2 = deploymentRequestInfo;
        synchronized (deploymentRequestInfo2) {
            DeploymentRequest deploymentRequest = deploymentRequestInfo.request;
            Iterator iterator = deploymentRequest.getDeployments(DEPLOYMENT_SERVICE_CALLBACK_HANDLER_ID);
            while (iterator.hasNext()) {
                Deployment deployment = (Deployment)iterator.next();
                DeploymentTaskRuntime deploymentTaskRuntime = deployment.getDeploymentTaskRuntime();
                AbstractOperation abstractOperation = deploymentTaskRuntime.getAdminOperation();
                if (abstractOperation == null) continue;
                if (Debug.isDeploymentDebugEnabled()) {
                    Debug.deploymentDebug("DeploymentManager: rollback for task " + deploymentTaskRuntime.getId());
                }
                abstractOperation.rollback(authenticatedSubject);
            }
        }
    }

    public Deployment[] getDeployments(Version version2, Version version3, String string) {
        Deployment deployment = new Deployment();
        deployment.setProposedVersion(this.getAdminServerAggregateDeploymentsVersion());
        deployment.setCallbackHandlerId(this.driver.getHandlerIdentity());
        deployment.enableSyncWithAdmin(AppRuntimeStateManager.getManager().getStartupStateForServer(string));
        Deployment[] deploymentArray = new Deployment[]{deployment};
        if (Debug.isDeploymentDebugEnabled()) {
            Debug.deploymentDebug("DeploymentManager: getDeployments from '" + string + "' returning '" + deploymentArray + "'");
        }
        return deploymentArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deploymentRequestCommitFailed(long l, FailureDescription[] failureDescriptionArray) {
        DeploymentRequestInfo deploymentRequestInfo;
        if (Debug.isDeploymentDebugEnabled()) {
            Debug.deploymentDebug("Received 'commit failure' for request id '" + l + "''");
        }
        if ((deploymentRequestInfo = this.getDeploymentRequestInfo(l)) == null) {
            return;
        }
        DeploymentRequestInfo deploymentRequestInfo2 = deploymentRequestInfo;
        synchronized (deploymentRequestInfo2) {
            this.updateTasksWithDeploymentStatus(l, failureDescriptionArray, 2, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deploymentRequestCommitSucceeded(long l) {
        DeploymentRequestInfo deploymentRequestInfo;
        if (Debug.isDeploymentDebugEnabled()) {
            Debug.deploymentDebug("Received 'commit success' for request id '" + l + "''");
        }
        if ((deploymentRequestInfo = this.getDeploymentRequestInfo(l)) == null) {
            return;
        }
        DeploymentRequestInfo deploymentRequestInfo2 = deploymentRequestInfo;
        synchronized (deploymentRequestInfo2) {
            this.updateTasksWithDeploymentStatus(l, null, 3, true);
        }
    }

    public void deploymentRequestCancelSucceeded(long l, FailureDescription[] failureDescriptionArray) {
        if (Debug.isDeploymentDebugEnabled()) {
            Debug.deploymentDebug("Request id '" + l + "' cancel succeeded");
        }
        this.updateTaskWithCancelState(l, 8);
    }

    public void deploymentRequestCancelFailed(long l, DeploymentException deploymentException, FailureDescription[] failureDescriptionArray) {
        if (Debug.isDeploymentDebugEnabled()) {
            Debug.deploymentDebug("Request id '" + l + "' cancel failed " + "due to '" + deploymentException.toString());
        }
        this.updateTaskWithCancelState(l, 4);
    }

    public void handleReceivedStatus(long l, DeploymentState deploymentState, String string) {
        DeploymentTaskRuntime deploymentTaskRuntime;
        if (Debug.isDeploymentDebugEnabled()) {
            Debug.deploymentDebug("DeploymentManager: handleReceivedStatus for: " + deploymentState + " from " + string + " for request: " + l);
        }
        if ((deploymentTaskRuntime = this.getDeploymentTaskRuntime(deploymentState)) == null) {
            if (deploymentState != null) {
                if ("__Lifecycle_taskid__".equals(deploymentState.getTaskID())) {
                    Debug.deploymentLogger.debug("DeploymentManager: handleReceivedStatus received status " + deploymentState + " for " + "lifecycle task from " + string);
                    this.updateRuntimeState(deploymentState);
                } else {
                    Deployment deployment = (Deployment)this.taskRuntimeToDeploymentTable.get(deploymentState.getTaskID());
                    if (deployment != null) {
                        deploymentTaskRuntime = deployment.getDeploymentTaskRuntime();
                    }
                    if (deploymentTaskRuntime != null) {
                        this.updateRuntimeState(deploymentState);
                    } else {
                        Debug.deploymentLogger.debug("DeploymentManager: handleReceivedStatus ignoring received status " + deploymentState + " for non" + "existing task from " + string);
                        this.updateRuntimeState(deploymentState);
                    }
                }
            }
            return;
        }
        this.updateStatus(l, deploymentTaskRuntime, string, deploymentState);
    }

    private DeploymentTaskRuntime getDeploymentTaskRuntime(DeploymentState deploymentState) {
        DeploymentTaskRuntime deploymentTaskRuntime = null;
        if (deploymentState != null) {
            deploymentTaskRuntime = this.getDeploymentTaskRuntime(deploymentState.getTaskID());
        }
        return deploymentTaskRuntime;
    }

    private DeploymentTaskRuntime getDeploymentTaskRuntime(String string) {
        return (DeploymentTaskRuntime)this.deployerRuntime.query(string);
    }

    public void startDeploymentTask(DeploymentTaskRuntime deploymentTaskRuntime, String string) throws ManagementException {
        if (deploymentTaskRuntime == null) {
            return;
        }
        Deployment deployment = (Deployment)this.taskRuntimeToDeploymentTable.get(deploymentTaskRuntime.getId());
        if (deployment == null && (deployment = (Deployment)this.pendingControlDeployments.remove(deploymentTaskRuntime.getId())) == null) {
            if (Debug.isDeploymentDebugEnabled()) {
                Debug.deploymentDebug("No deployment object available for task with id: " + deploymentTaskRuntime.getId());
            }
            return;
        }
        deployment.setNotificationLevel(deploymentTaskRuntime.getNotificationLevel());
        long l = deployment.getDeploymentRequestId();
        DeploymentRequestInfo deploymentRequestInfo = this.getDeploymentRequestInfo(l);
        if (!deploymentTaskRuntime.isAControlOperation() && deployment.isCallerLockOwner()) {
            if (Debug.isDeploymentDebugEnabled()) {
                Debug.deploymentDebug("Caller owns the edit lock for the task with id : " + deploymentTaskRuntime.getId());
            }
            return;
        }
        try {
            DeploymentRequestTaskRuntimeMBean deploymentRequestTaskRuntimeMBean = (DeploymentRequestTaskRuntimeMBean)deploymentTaskRuntime.getMyParent();
            if (deploymentRequestTaskRuntimeMBean == null) {
                if (deploymentTaskRuntime.isAControlOperation()) {
                    this.startDeploymentForControlOperation(deploymentTaskRuntime, deployment);
                    return;
                }
                throw new AssertionError((Object)("DeploymentTaskRuntime: " + this + " does not have an associated parent DeploymentRequestTaskRuntime"));
            }
            deploymentRequestTaskRuntimeMBean.start();
        }
        catch (Exception exception) {
            ManagementException managementException = exception instanceof ManagementException ? (ManagementException)((Object)exception) : new ManagementException(exception.getMessage(), (Throwable)exception);
            AuthenticatedSubject authenticatedSubject = null;
            if (deploymentRequestInfo != null && deploymentRequestInfo.request != null) {
                authenticatedSubject = deploymentRequestInfo.request.getInitiator();
            }
            this.deploymentFailedBeforeStart(deployment, managementException, deployment.isCallerLockOwner(), authenticatedSubject, deploymentTaskRuntime.isAControlOperation());
            String string2 = "An exception occurred while executing task " + deploymentTaskRuntime.getDescription() + " for application " + string + ":" + StackTraceUtils.throwable2StackTrace((Throwable)managementException);
            if (Debug.isDeploymentDebugEnabled()) {
                Debug.deploymentDebug(string2);
            }
            throw managementException;
        }
    }

    public final void deploymentFailedBeforeStart(Deployment deployment, Throwable throwable, boolean bl, AuthenticatedSubject authenticatedSubject, boolean bl2) {
        beanFactory.resetDeployerInitiatedBeanUpdates();
        this.deploymentFailedBeforeStart(deployment, throwable);
        this.abortSessionBeforeStart(authenticatedSubject, bl, bl2);
        if (deployment == null) {
            return;
        }
        String string = deployment.getInternalDeploymentData().getDeploymentName();
        int n = deployment.getInternalDeploymentData().getDeploymentOperation();
        OperationHelper.logTaskFailed(string, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void deploymentRequestCancelledBeforeStart(DeploymentRequest deploymentRequest) {
        DeploymentRequestInfo deploymentRequestInfo;
        if (deploymentRequest == null) {
            return;
        }
        long l = deploymentRequest.getId();
        if (Debug.isDeploymentDebugEnabled()) {
            Debug.deploymentDebug("Request id '" + l + "' cancelled " + "before start");
        }
        if ((deploymentRequestInfo = this.getDeploymentRequestInfo(l)) == null) {
            return;
        }
        DeploymentRequestInfo deploymentRequestInfo2 = deploymentRequestInfo;
        synchronized (deploymentRequestInfo2) {
            boolean bl = deploymentRequestInfo.ownsEditLock;
            AuthenticatedSubject authenticatedSubject = deploymentRequestInfo.request.getInitiator();
            boolean bl2 = deploymentRequestInfo.isControlOperation();
            if (Debug.isDeploymentDebugEnabled()) {
                Debug.deploymentDebug("calling abortEditSessionBeforeStart() for requestId : " + l);
            }
            this.abortSessionBeforeStart(authenticatedSubject, bl, bl2);
            Iterator iterator = deploymentRequestInfo.request.getDeployments(DEPLOYMENT_SERVICE_CALLBACK_HANDLER_ID);
            while (iterator.hasNext()) {
                Deployment deployment = (Deployment)iterator.next();
                DeploymentTaskRuntime deploymentTaskRuntime = deployment.getDeploymentTaskRuntime();
                if (deploymentTaskRuntime == null || deploymentTaskRuntime.isComplete()) continue;
                deploymentTaskRuntime.setCancelState(8);
            }
        }
    }

    public final void deploymentFailedBeforeStart(Deployment deployment, Throwable throwable) {
        if (deployment == null) {
            return;
        }
        AdminDeploymentException adminDeploymentException = new AdminDeploymentException();
        FailureDescription failureDescription = new FailureDescription("adminServer", new Exception(throwable.toString()), OperationHelper.getTaskString(deployment.getInternalDeploymentData().getDeploymentOperation()));
        adminDeploymentException.addFailureDescription(failureDescription);
        DeploymentRequestInfo deploymentRequestInfo = this.getDeploymentRequestInfo(deployment.getDeploymentRequestId());
        if (deploymentRequestInfo != null) {
            this.deploymentRequestFailedBeforeStart(deploymentRequestInfo, adminDeploymentException);
        } else {
            DeploymentTaskRuntime deploymentTaskRuntime = deployment.getDeploymentTaskRuntime();
            if (deploymentTaskRuntime == null) {
                return;
            }
            this.pendingControlDeployments.remove(deploymentTaskRuntime.getId());
            if (Debug.isDeploymentDebugEnabled()) {
                Debug.deploymentDebug("DeploymentManager: Removed task '" + deploymentTaskRuntime.getId() + "' from pendingControlDeployments if has one");
            }
            this.pendingDeploymentsForLockOwner.remove(deployment);
            if (Debug.isDeploymentDebugEnabled()) {
                Debug.deploymentDebug("DeploymentManager: Removed entry: '" + deployment + "' from pendingDeploymentsForLockOwner if has one");
            }
            this.pendingDeploymentsForLockAcquirer.remove(deployment);
            if (Debug.isDeploymentDebugEnabled()) {
                Debug.deploymentDebug("DeploymentManager: Removed deployment '" + deployment + "' from pendingDeploymentsForLockAcquirer if has one");
            }
            FailureDescription[] failureDescriptionArray = adminDeploymentException.getFailures();
            if (Debug.isDeploymentDebugEnabled()) {
                Debug.deploymentDebug("DeploymentManager: Updating task '" + deploymentTaskRuntime.getId() + "' with failures : " + failureDescriptionArray);
            }
            DeploymentManager.updateTaskWithFailures(deploymentTaskRuntime, failureDescriptionArray, 2);
            deploymentTaskRuntime.handleFailure();
            this.reset(deploymentTaskRuntime.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List getExistingOperationsOnSameApp(AbstractOperation abstractOperation) {
        ArrayList<AbstractOperation> arrayList = new ArrayList<AbstractOperation>();
        DeploymentTaskRuntime deploymentTaskRuntime = abstractOperation.getTaskRuntime();
        BasicDeploymentMBean basicDeploymentMBean = deploymentTaskRuntime.getDeploymentMBean();
        List list = this.pendingDeploymentsForLockOwner;
        synchronized (list) {
            for (Deployment deployment : this.pendingDeploymentsForLockOwner) {
                AbstractOperation abstractOperation2;
                BasicDeploymentMBean basicDeploymentMBean2;
                DeploymentTaskRuntime deploymentTaskRuntime2 = deployment.getDeploymentTaskRuntime();
                if (deploymentTaskRuntime2 == null || (basicDeploymentMBean2 = deploymentTaskRuntime2.getDeploymentMBean()) == null || basicDeploymentMBean == null || !basicDeploymentMBean2.getName().equals(basicDeploymentMBean.getName()) || (abstractOperation2 = deploymentTaskRuntime2.getAdminOperation()) == null) continue;
                arrayList.add(abstractOperation2);
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List getExistingOperationsOnApp(String string) {
        ArrayList<AbstractOperation> arrayList = new ArrayList<AbstractOperation>();
        List list = this.pendingDeploymentsForLockOwner;
        synchronized (list) {
            for (Deployment deployment : this.pendingDeploymentsForLockOwner) {
                AbstractOperation abstractOperation;
                BasicDeploymentMBean basicDeploymentMBean;
                DeploymentTaskRuntime deploymentTaskRuntime = deployment.getDeploymentTaskRuntime();
                if (deploymentTaskRuntime == null || (basicDeploymentMBean = deploymentTaskRuntime.getDeploymentMBean()) == null || !basicDeploymentMBean.getName().equals(string) || (abstractOperation = deploymentTaskRuntime.getAdminOperation()) == null) continue;
                arrayList.add(abstractOperation);
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeDeploymentsForTasks(List list) {
        if (list == null || list.isEmpty()) {
            return;
        }
        for (String string : list) {
            List list2 = this.pendingDeploymentsForLockOwner;
            synchronized (list2) {
                Deployment deployment = this.findDeploymentForTask(string);
                if (Debug.isDeploymentDebugEnabled()) {
                    Debug.deploymentDebug("Found deployment for '" + string + "' : " + deployment);
                }
                if (deployment != null) {
                    if (Debug.isDeploymentDebugEnabled()) {
                        Debug.deploymentDebug("Removing deployment for '" + string + "' : " + deployment);
                    }
                    this.pendingDeploymentsForLockOwner.remove(deployment);
                }
            }
            if (Debug.isDeploymentDebugEnabled()) {
                Debug.deploymentDebug("Removing task '" + string + "' and it's corresponding deployments...");
            }
            this.taskRuntimeToDeploymentTable.remove(string);
            this.taskRuntimeToDeploymentInfoTable.remove(string);
        }
    }

    private synchronized Deployment findDeploymentForTask(String string) {
        for (Deployment deployment : this.pendingDeploymentsForLockOwner) {
            DeploymentTaskRuntime deploymentTaskRuntime = deployment.getDeploymentTaskRuntime();
            if (deploymentTaskRuntime == null || !deploymentTaskRuntime.getId().equals(string)) continue;
            return deployment;
        }
        return null;
    }

    private final void startDeploymentForControlOperation(DeploymentTaskRuntime deploymentTaskRuntime, Deployment deployment) throws ManagementException {
        if (deploymentTaskRuntime == null || deployment == null) {
            return;
        }
        String[] stringArray = deployment.getTargets();
        if (stringArray == null || stringArray.length == 0) {
            deploymentTaskRuntime.updateTargetStatus(null, 3, null);
            return;
        }
        DeploymentRequest deploymentRequest = this.driver.createDeploymentRequest();
        ArrayList<Deployment> arrayList = new ArrayList<Deployment>();
        arrayList.add(deployment);
        List[] listArray = new List[]{arrayList};
        this.updateRequestAndDeployments(deploymentRequest, listArray);
        DeploymentRequestInfo deploymentRequestInfo = this.getDeploymentRequestInfo(deploymentRequest.getId());
        deploymentRequestInfo.setControlOperation();
        deploymentRequest.getTaskRuntime().start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetDeploymentState(long l) {
        if (Debug.isDeploymentDebugEnabled()) {
            Debug.deploymentDebug("Resetting deployment(s) with request id: " + l);
        }
        Map map = this.requestInfoTable;
        synchronized (map) {
            this.requestInfoTable.remove(new Long(l));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reset(String string) {
        if (Debug.isDeploymentDebugEnabled()) {
            Debug.deploymentDebug("Resetting deployment task ref " + string);
        }
        this.taskRuntimeToDeploymentTable.remove(string);
        DeploymentRequestInfo deploymentRequestInfo = (DeploymentRequestInfo)this.taskRuntimeToDeploymentInfoTable.remove(string);
        if (deploymentRequestInfo == null) {
            return;
        }
        DeploymentRequestInfo deploymentRequestInfo2 = deploymentRequestInfo;
        synchronized (deploymentRequestInfo2) {
            deploymentRequestInfo.removeDeploymentStatusContainerFor(string);
            if (deploymentRequestInfo.removedAllStatusContainers()) {
                this.resetDeploymentState(deploymentRequestInfo.request.getId());
            }
        }
    }

    private void addOrUpdateAdminServerAggregateDeploymentVersion(String string, DeploymentVersion deploymentVersion) {
        this.getAdminServerAggregateDeploymentsVersion().addOrUpdateDeploymentVersion(string, deploymentVersion);
    }

    private void updateAdminServerRuntimeStateAndAggregateDeploymentVersion(DeploymentRequestInfo deploymentRequestInfo) {
        Iterator iterator = deploymentRequestInfo.request.getDeployments(DEPLOYMENT_SERVICE_CALLBACK_HANDLER_ID);
        while (iterator.hasNext()) {
            boolean bl;
            Deployment deployment = (Deployment)iterator.next();
            if (!deployment.isAnAppDeployment() || deployment.isAControlOperation()) continue;
            int n = deployment.getOperation();
            boolean bl2 = bl = n != 4 && n != 12;
            if (bl) {
                boolean bl3;
                if (Debug.isDeploymentDebugEnabled()) {
                    Debug.deploymentDebug("Updating runtime state and aggregate deployment version component for " + deployment.getIdentity());
                }
                boolean bl4 = bl3 = !deploymentRequestInfo.request.isControlRequest();
                if (Debug.isDeploymentDebugEnabled()) {
                    Debug.deploymentDebug("Needs DeploymentVersion Update : " + bl3);
                }
                if (!bl3) continue;
                DeploymentManager.updateRuntimeState(deployment.getIdentity(), deployment.getProposedDeploymentVersion());
                this.addOrUpdateAdminServerAggregateDeploymentVersion(deployment.getIdentity(), deployment.getProposedDeploymentVersion());
                continue;
            }
            if (Debug.isDeploymentDebugEnabled()) {
                Debug.deploymentDebug("Removing runtime state and aggregate deployment version component for " + deployment.getIdentity());
            }
            this.getAdminServerAggregateDeploymentsVersion().removeDeploymentVersionFor(deployment.getIdentity());
        }
    }

    private Deployment createDeployment(DeploymentTaskRuntime deploymentTaskRuntime, DeploymentData deploymentData, DomainMBean domainMBean, AuthenticatedSubject authenticatedSubject, boolean bl, boolean bl2, boolean bl3) {
        Deployment deployment = new Deployment(this.driver.getHandlerIdentity(), deploymentTaskRuntime, deploymentData, authenticatedSubject, bl, bl2, bl3);
        TargetStatus[] targetStatusArray = deploymentTaskRuntime.getTargets();
        if (targetStatusArray != null) {
            for (int i = 0; i < targetStatusArray.length; ++i) {
                String string = targetStatusArray[i].getTarget();
                String[] stringArray = DeploymentManager.getServerNames(string, domainMBean);
                for (int j = 0; j < stringArray.length; ++j) {
                    deployment.addTarget(stringArray[j]);
                }
            }
        }
        return deployment;
    }

    private DeploymentVersion createDeploymentVersion(String string, boolean bl, boolean bl2) {
        long l;
        DeploymentVersion deploymentVersion = null;
        Map map = this.getAdminServerAggregateDeploymentsVersion().getVersionComponents();
        if (map.size() > 0) {
            deploymentVersion = (DeploymentVersion)map.get(string);
        }
        long l2 = l = System.currentTimeMillis();
        if (deploymentVersion != null) {
            l = deploymentVersion.getArchiveTimeStamp();
            l2 = deploymentVersion.getPlanTimeStamp();
            if (Debug.isDeploymentDebugEnabled()) {
                Debug.deploymentDebug("DeploymentManager: create deployment version for id: " + string + " version: " + deploymentVersion + " archive ts: " + l + " plan ts: " + l2);
            }
        } else if (Debug.isDeploymentDebugEnabled()) {
            Debug.deploymentDebug("DeploymentManager: create deployment version for id: " + string + " archive ts: " + l + " plan ts: " + l2);
        }
        DeploymentVersion deploymentVersion2 = new DeploymentVersion(string, l, l2);
        deploymentVersion2.update(bl, bl2);
        if (Debug.isDeploymentDebugEnabled()) {
            Debug.deploymentDebug("DeploymentManager: update version: " + deploymentVersion);
        }
        return deploymentVersion2;
    }

    private ChangeDescriptor createChangeDescriptor(Serializable serializable, DeploymentVersion deploymentVersion) {
        return this.driver.createChangeDescriptor(serializable, deploymentVersion);
    }

    private AggregateDeploymentVersion getAdminServerAggregateDeploymentsVersion() {
        if (this.adminServerAggregateDeploymentVersion == null) {
            this.adminServerAggregateDeploymentVersion = AggregateDeploymentVersion.createAggregateDeploymentVersion();
        }
        return this.adminServerAggregateDeploymentVersion;
    }

    private static String[] getServerNames(String string, DomainMBean domainMBean) {
        if (domainMBean != null) {
            TargetMBean targetMBean = domainMBean.lookupTarget(string);
            Set set = new HashSet();
            if (targetMBean != null) {
                set = targetMBean.getServerNames();
            }
            return set.toArray(new String[0]);
        }
        return new String[0];
    }

    private static boolean isAlreadyTargeted(String string) {
        DomainMBean domainMBean = ManagementService.getRuntimeAccess(kernelId).getDomain();
        AppDeploymentMBean appDeploymentMBean = domainMBean.lookupAppDeployment(string);
        if (appDeploymentMBean != null) {
            if (appDeploymentMBean.getTargets() != null && appDeploymentMBean.getTargets().length > 0) {
                return true;
            }
            SubDeploymentMBean[] subDeploymentMBeanArray = appDeploymentMBean.getSubDeployments();
            if (subDeploymentMBeanArray != null && subDeploymentMBeanArray.length > 0) {
                for (int i = 0; i < subDeploymentMBeanArray.length; ++i) {
                    if (subDeploymentMBeanArray[i].getTargets() != null && subDeploymentMBeanArray[i].getTargets().length > 0) {
                        return true;
                    }
                    SubDeploymentMBean[] subDeploymentMBeanArray2 = subDeploymentMBeanArray[i].getSubDeployments();
                    if (subDeploymentMBeanArray2 == null || subDeploymentMBeanArray2.length <= 0) continue;
                    for (int j = 0; j < subDeploymentMBeanArray2.length; ++j) {
                        if (subDeploymentMBeanArray2[j].getTargets() == null || subDeploymentMBeanArray2[j].getTargets().length <= 0) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private static boolean isRedeployAConfigChange(AppDeploymentMBean appDeploymentMBean, DeploymentData deploymentData) {
        boolean bl;
        boolean bl2 = bl = deploymentData != null && (deploymentData.hasFiles() || deploymentData.hasSubModuleTargets());
        return !bl || !DeploymentManager.isAlreadyTargeted(appDeploymentMBean.getName());
    }

    private static boolean isAConfigurationChange(AppDeploymentMBean appDeploymentMBean, DeploymentData deploymentData, int n) {
        boolean bl = false;
        switch (n) {
            case 1: 
            case 4: 
            case 6: 
            case 11: 
            case 12: {
                bl = true;
                break;
            }
            case 9: {
                bl = DeploymentManager.isRedeployAConfigChange(appDeploymentMBean, deploymentData);
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    private static void updateTaskWithFailures(DeploymentTaskRuntime deploymentTaskRuntime, FailureDescription[] failureDescriptionArray, int n) {
        if (failureDescriptionArray != null && failureDescriptionArray.length > 0) {
            for (int i = 0; i < failureDescriptionArray.length; ++i) {
                if (Debug.isDeploymentDebugEnabled()) {
                    Debug.deploymentDebug("DeploymentManager: updateTaskWithFailures:  for server: " + failureDescriptionArray[i].getServer() + " task: " + deploymentTaskRuntime.getId() + " with status: " + n);
                }
                deploymentTaskRuntime.updateTargetStatus(failureDescriptionArray[i].getServer(), n, failureDescriptionArray[i].getReason());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTaskWithCancelState(long l, int n) {
        DeploymentRequestInfo deploymentRequestInfo = this.getDeploymentRequestInfo(l);
        if (deploymentRequestInfo == null) {
            return;
        }
        DeploymentRequestInfo deploymentRequestInfo2 = deploymentRequestInfo;
        synchronized (deploymentRequestInfo2) {
            if (n == 8) {
                this.undoUnactivatedChanges(deploymentRequestInfo);
            }
            Iterator iterator = deploymentRequestInfo.request.getDeployments(DEPLOYMENT_SERVICE_CALLBACK_HANDLER_ID);
            while (iterator.hasNext()) {
                Deployment deployment = (Deployment)iterator.next();
                DeploymentTaskRuntime deploymentTaskRuntime = deployment.getDeploymentTaskRuntime();
                if (deploymentTaskRuntime == null) continue;
                deploymentTaskRuntime.setCancelState(n);
                if (n != 8 && n != 4) continue;
                this.reset(deploymentTaskRuntime.getId());
            }
        }
    }

    private void updateStatus(long l, DeploymentTaskRuntime deploymentTaskRuntime, String string, DeploymentState deploymentState) {
        DeploymentManager.sendNotifications(deploymentState, deploymentTaskRuntime);
        if (this.updateTaskStatus(l, deploymentTaskRuntime, string, deploymentState)) {
            this.updateRuntimeState(deploymentState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateTaskStatus(long l, DeploymentTaskRuntime deploymentTaskRuntime, String string, DeploymentState deploymentState) {
        DeploymentRequestInfo deploymentRequestInfo = this.getDeploymentRequestInfo(l);
        if (deploymentRequestInfo == null) {
            deploymentTaskRuntime.updateTargetStatus(string, deploymentState.getTaskState(), deploymentState.getException());
            return true;
        }
        DeploymentRequestInfo deploymentRequestInfo2 = deploymentRequestInfo;
        synchronized (deploymentRequestInfo2) {
            return deploymentRequestInfo.updateDeploymentStatus(deploymentTaskRuntime.getId(), string, new DeploymentTargetStatus(l, deploymentState));
        }
    }

    private static void sendNotifications(DeploymentState deploymentState, DeploymentTaskRuntime deploymentTaskRuntime) {
        try {
            NotificationBroadcaster.sendNotificationsFromManagedServer(deploymentState, deploymentTaskRuntime, Debug.deploymentLogger);
        }
        catch (Throwable throwable) {
            Debug.deploymentLogger.debug("Error during send Notification for " + deploymentTaskRuntime.getApplicationName());
            throwable.printStackTrace();
        }
    }

    private void updateTaskStatusOfRestartTargets(long l, DeploymentTaskRuntime deploymentTaskRuntime, String[] stringArray) {
        if (Debug.isDeploymentDebugEnabled()) {
            Debug.deploymentDebug("DeploymentManager: updateTasksWithRestartTargetStatus for request: " + l);
        }
        if (stringArray != null && stringArray.length > 0) {
            String string = DeployerRuntimeLogger.requiresRestart();
            for (int i = 0; i < stringArray.length; ++i) {
                deploymentTaskRuntime.updateTargetStatus(stringArray[i], 3, new Exception(string));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTasksWithAccumulatedStatus(long l) {
        DeploymentRequestInfo deploymentRequestInfo;
        if (Debug.isDeploymentDebugEnabled()) {
            Debug.deploymentDebug("DeploymentManager: updateTasksWithAccumulatedStatus for request: " + l);
        }
        if ((deploymentRequestInfo = this.getDeploymentRequestInfo(l)) == null) {
            return;
        }
        DeploymentRequestInfo deploymentRequestInfo2 = deploymentRequestInfo;
        synchronized (deploymentRequestInfo2) {
            for (String string : deploymentRequestInfo.deploymentsStatus.keySet()) {
                Map map = deploymentRequestInfo.getDeploymentStatus(string);
                for (String string2 : map.keySet()) {
                    DeploymentTargetStatus deploymentTargetStatus = (DeploymentTargetStatus)map.get(string2);
                    DeploymentTaskRuntime deploymentTaskRuntime = this.getDeploymentTaskRuntime(string);
                    if (deploymentTaskRuntime == null) continue;
                    deploymentTaskRuntime.updateTargetStatus(string2, deploymentTargetStatus.deploymentStatus.getTaskState(), deploymentTargetStatus.deploymentStatus.getException());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateRuntimeState(String string, DeploymentVersion deploymentVersion) {
        if (string == null || deploymentVersion == null || "?".equals(string)) {
            return;
        }
        try {
            AppRuntimeStateManager appRuntimeStateManager = AppRuntimeStateManager.getManager();
            synchronized (appRuntimeStateManager) {
                AppRuntimeStateManager.getManager().updateState(string, deploymentVersion);
            }
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateRuntimeState(DeploymentState deploymentState) {
        if (deploymentState == null) {
            return;
        }
        try {
            String string = deploymentState.getId();
            if (string == null || "?".equals(string)) {
                return;
            }
            AppRuntimeStateManager appRuntimeStateManager = AppRuntimeStateManager.getManager();
            synchronized (appRuntimeStateManager) {
                DeploymentTaskRuntime deploymentTaskRuntime = this.getDeploymentTaskRuntime(deploymentState);
                if ("STATE_UPDATE_PENDING".equals(deploymentState.getCurrentState()) && (deploymentTaskRuntime == null || deploymentTaskRuntime.getState() > 1)) {
                    if (Debug.isDeploymentDebugEnabled()) {
                        Debug.deploymentDebug("DeploymentManager: Ignore update app runtime state to STATE_UPDATE_PENDING after task is completed");
                    }
                    return;
                }
                AppRuntimeStateManager appRuntimeStateManager2 = AppRuntimeStateManager.getManager();
                ApplicationRuntimeState applicationRuntimeState = appRuntimeStateManager2.get(string);
                appRuntimeStateManager2.updateState(string, deploymentState);
                if (applicationRuntimeState == null && deploymentState.getCurrentState() == null) {
                    try {
                        appRuntimeStateManager2.setRetireTimeMillis(string, 0L);
                    }
                    catch (ManagementException managementException) {
                        DeploymentManagerLogger.logStatePersistenceFailed(string, managementException);
                    }
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void abortSessionBeforeStart(AuthenticatedSubject authenticatedSubject, boolean bl, boolean bl2) {
        if (!bl2 && authenticatedSubject != null && !bl) {
            try {
                try {
                    this.editAccessHelper.cancelActivateSession(authenticatedSubject);
                    this.editAccessHelper.undoUnactivatedChanges(authenticatedSubject);
                }
                catch (ManagementException managementException) {
                    Loggable loggable = DeployerRuntimeLogger.logErrorOnAbortEditSessionLoggable((String)authenticatedSubject.toString(), (Throwable)managementException);
                    if (Debug.isDeploymentDebugEnabled()) {
                        Debug.deploymentDebug("abortEditSessionBeforeStart: Error occured while aborting the session : " + loggable.getMessage());
                    }
                    loggable.log();
                    Object var7_5 = null;
                    this.editAccessHelper.cancelEditSession(authenticatedSubject);
                }
                Object var7_4 = null;
                this.editAccessHelper.cancelEditSession(authenticatedSubject);
            }
            catch (Throwable throwable) {
                Object var7_6 = null;
                this.editAccessHelper.cancelEditSession(authenticatedSubject);
                throw throwable;
            }
        }
    }

    private boolean removeDeployIfNoop(Deployment deployment) {
        boolean bl = false;
        if (deployment == null || !deployment.isAnAppDeployment() || deployment.getOperation() != 4 || this.pendingDeploymentsForLockOwner.isEmpty()) {
            return false;
        }
        DomainMBean domainMBean = ManagementService.getRuntimeAccess(kernelId).getDomain();
        AppDeploymentMBean appDeploymentMBean = deployment.getDeploymentTaskRuntime().getAppDeploymentMBean();
        if (domainMBean == null || appDeploymentMBean == null || domainMBean.lookupAppDeployment(appDeploymentMBean.getName()) != null) {
            return false;
        }
        Iterator iterator = this.pendingDeploymentsForLockOwner.iterator();
        while (iterator.hasNext()) {
            AppDeploymentMBean appDeploymentMBean2;
            Deployment deployment2 = (Deployment)iterator.next();
            DeploymentTaskRuntime deploymentTaskRuntime = deployment2.getDeploymentTaskRuntime();
            if (deploymentTaskRuntime == null || (appDeploymentMBean2 = deploymentTaskRuntime.getAppDeploymentMBean()) == null || !appDeploymentMBean2.getName().equals(appDeploymentMBean.getName())) continue;
            bl = true;
            iterator.remove();
            deployment2.getDeploymentTaskRuntime().setState(2);
        }
        if (bl) {
            deployment.getDeploymentTaskRuntime().setState(2);
        }
        return bl;
    }

    private static final class DeploymentRequestInfo {
        final DeploymentRequest request;
        Map deploymentsStatus;
        boolean ownsEditLock;
        DomainMBean editableDomain;
        boolean controlOperation = false;

        private DeploymentRequestInfo(DeploymentRequest deploymentRequest) {
            this.request = deploymentRequest;
            this.deploymentsStatus = new HashMap();
        }

        private void setIsEditLockOwner(boolean bl) {
            this.ownsEditLock = bl;
        }

        private void setEditableDomain(DomainMBean domainMBean) {
            this.editableDomain = domainMBean;
        }

        private void addDeploymentStatusContainerFor(String string) {
            if (Debug.isDeploymentDebugEnabled()) {
                Debug.deploymentDebug("DeploymentRequestInfo: Created status containers for taskId: " + string + " associated with request: " + this.request.getId());
            }
            this.deploymentsStatus.put(string, new HashMap());
        }

        private synchronized void removeDeploymentStatusContainerFor(String string) {
            if (Debug.isDeploymentDebugEnabled()) {
                Debug.deploymentDebug("DeploymentRequestInfo: Removing status containers for taskId: " + string + " associated with request: " + this.request.getId());
            }
            if (this.deploymentsStatus != null && this.deploymentsStatus.containsKey(string)) {
                this.deploymentsStatus.remove(string);
                if (this.deploymentsStatus.isEmpty()) {
                    this.deploymentsStatus.clear();
                    this.deploymentsStatus = null;
                }
            }
        }

        private synchronized boolean removedAllStatusContainers() {
            return this.deploymentsStatus == null;
        }

        private synchronized boolean updateDeploymentStatus(String string, String string2, DeploymentTargetStatus deploymentTargetStatus) {
            DeploymentTargetStatus deploymentTargetStatus2;
            if (this.deploymentsStatus == null) {
                return true;
            }
            HashMap hashMap = (HashMap)this.deploymentsStatus.get(string);
            if (hashMap == null) {
                return true;
            }
            if (hashMap.get(string2) != null && !(deploymentTargetStatus2 = (DeploymentTargetStatus)hashMap.get(string2)).isUpdatableTo(deploymentTargetStatus) && Debug.isDeploymentDebugEnabled()) {
                Debug.deploymentDebug("DeploymentRequestInfo: ignore update STATE_UPDATE_PENDING since state is already set to a complete state by same target in same deploy request.");
                return false;
            }
            if (Debug.isDeploymentDebugEnabled()) {
                Debug.deploymentDebug("DeploymentRequestInfo: adding status update from: " + string2 + " for task: " + string + " associated with request: " + this.request.getId());
            }
            hashMap.put(string2, deploymentTargetStatus);
            return true;
        }

        private synchronized Map getDeploymentStatus(String string) {
            if (this.deploymentsStatus == null) {
                return null;
            }
            HashMap hashMap = (HashMap)this.deploymentsStatus.get(string);
            if (hashMap == null) {
                return null;
            }
            return (Map)hashMap.clone();
        }

        private final void setControlOperation() {
            this.controlOperation = true;
        }

        private final boolean isControlOperation() {
            return this.controlOperation;
        }

        private final long getRequestId() {
            return this.request.getId();
        }
    }

    private static final class DeploymentTargetStatus {
        final long requestId;
        final DeploymentState deploymentStatus;

        private DeploymentTargetStatus(long l, DeploymentState deploymentState) {
            this.requestId = l;
            this.deploymentStatus = deploymentState;
        }

        private boolean isUpdatableTo(DeploymentTargetStatus deploymentTargetStatus) {
            String string = this.deploymentStatus.getCurrentState();
            String string2 = deploymentTargetStatus.deploymentStatus.getCurrentState();
            return this.requestId != deploymentTargetStatus.requestId || !"STATE_UPDATE_PENDING".equals(string2) || !"STATE_ACTIVE".equals(string) && !"STATE_FAILED".equals(string);
        }
    }
}

