/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.internal.adminserver;

import java.io.Serializable;
import java.util.Set;
import weblogic.deploy.common.Debug;
import weblogic.deploy.internal.adminserver.DeploymentManager;
import weblogic.deploy.internal.targetserver.state.DeploymentState;
import weblogic.deploy.service.ChangeDescriptor;
import weblogic.deploy.service.Deployment;
import weblogic.deploy.service.DeploymentException;
import weblogic.deploy.service.DeploymentProvider;
import weblogic.deploy.service.DeploymentRequest;
import weblogic.deploy.service.DeploymentServiceCallbackHandler;
import weblogic.deploy.service.FailureDescription;
import weblogic.deploy.service.InvalidCreateChangeDescriptorException;
import weblogic.deploy.service.RegistrationExistsException;
import weblogic.deploy.service.RequiresRestartFailureDescription;
import weblogic.deploy.service.RequiresTaskMediatedStartException;
import weblogic.deploy.service.Version;
import weblogic.deploy.service.internal.DeploymentService;
import weblogic.deploy.service.internal.DeploymentServiceLogger;
import weblogic.management.ManagementException;
import weblogic.management.runtime.DeploymentRequestTaskRuntimeMBean;

public final class DeploymentServiceDriver
implements DeploymentServiceCallbackHandler {
    private String identity;
    private final DeploymentService service = DeploymentService.getDeploymentService();
    private DeploymentManager deploymentManager;

    private DeploymentServiceDriver() {
    }

    public static DeploymentServiceDriver getInstance() {
        return Maker.DRIVER;
    }

    public void initialize(String string, Version version2, DeploymentManager deploymentManager) throws ManagementException {
        try {
            this.identity = string;
            this.deploymentManager = deploymentManager;
            this.service.register(version2, this);
            this.service.registerDeploymentProvider(deploymentManager);
        }
        catch (RegistrationExistsException registrationExistsException) {
            String string2 = DeploymentServiceLogger.duplicateRegistration((String)string);
            throw new ManagementException(string2);
        }
    }

    public void shutdown() {
        this.service.unregister(this.getHandlerIdentity());
    }

    public DeploymentRequestTaskRuntimeMBean deploy(DeploymentRequest deploymentRequest) throws RequiresTaskMediatedStartException {
        return this.service.deploy(deploymentRequest);
    }

    public DeploymentRequestTaskRuntimeMBean startDeploy(DeploymentRequest deploymentRequest) {
        return this.service.startDeploy(deploymentRequest);
    }

    public String getHandlerIdentity() {
        return this.identity;
    }

    public Deployment[] getDeployments(Version version2, Version version3, String string) {
        return this.deploymentManager.getDeployments(version2, version3, string);
    }

    public void deploySucceeded(long l, FailureDescription[] failureDescriptionArray) {
        String string = DeploymentServiceDriver.getFailureDescriptions(failureDescriptionArray);
        if (string != null) {
            Debug.deploymentLogger.debug("Deployment id '" + l + "' succeeded - however the listed servers did not receive the " + "deployment for the provided reasons:" + string + " - these " + "servers will receive the deployment when they are reachable from " + "the admin server");
        }
        this.deploymentManager.deploymentRequestSucceeded(l, failureDescriptionArray);
    }

    public void deployFailed(long l, DeploymentException deploymentException) {
        Debug.deploymentLogger.debug("Deployment id '" + l + "' failed due to the following reason: " + deploymentException.toString());
        FailureDescription[] failureDescriptionArray = deploymentException.getFailures();
        this.deploymentManager.deploymentRequestFailed(l, deploymentException, failureDescriptionArray);
    }

    public void commitFailed(long l, FailureDescription[] failureDescriptionArray) {
        String string = DeploymentServiceDriver.getFailureDescriptions(failureDescriptionArray);
        if (string != null) {
            Debug.deploymentLogger.debug("Deployment id '" + l + "' succeeded - however the listed servers did not receive the " + "'commit' for the provided reasons:" + string);
        }
        this.deploymentManager.deploymentRequestCommitFailed(l, failureDescriptionArray);
    }

    public void commitSucceeded(long l) {
        this.deploymentManager.deploymentRequestCommitSucceeded(l);
    }

    public void cancelSucceeded(long l, FailureDescription[] failureDescriptionArray) {
        String string = DeploymentServiceDriver.getFailureDescriptions(failureDescriptionArray);
        Debug.deploymentLogger.debug("Deployment id '" + l + "' was successfully canceled - however the listed servers did not " + "receive the cancel due to the provided reasons:" + string);
        this.deploymentManager.deploymentRequestCancelSucceeded(l, failureDescriptionArray);
    }

    public void cancelFailed(long l, DeploymentException deploymentException) {
        Debug.deploymentLogger.debug("Attempt to cancel deployment id '" + l + "' failed due to the following reason: " + deploymentException.toString());
        FailureDescription[] failureDescriptionArray = deploymentException.getFailures();
        this.deploymentManager.deploymentRequestCancelFailed(l, deploymentException, failureDescriptionArray);
    }

    private static String getFailureDescriptions(FailureDescription[] failureDescriptionArray) {
        String string = null;
        if (failureDescriptionArray != null && failureDescriptionArray.length > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < failureDescriptionArray.length; ++i) {
                stringBuffer.append("Deployment to '");
                stringBuffer.append(failureDescriptionArray[i].getServer());
                if (failureDescriptionArray[i] instanceof RequiresRestartFailureDescription) {
                    stringBuffer.append("' requires restart due to non-dynamic changes");
                    continue;
                }
                stringBuffer.append("' failed with the reason: '");
                stringBuffer.append(failureDescriptionArray[i].getReason().toString());
                stringBuffer.append("'");
            }
            string = stringBuffer.toString();
        }
        return string;
    }

    public void receivedStatusFrom(long l, Serializable serializable, String string) {
        this.deploymentManager.handleReceivedStatus(l, (DeploymentState)serializable, string);
    }

    public final void registerDeploymentProvider(DeploymentProvider deploymentProvider) {
        this.service.registerDeploymentProvider(deploymentProvider);
    }

    public Set getRegisteredDeploymentProviders() {
        return this.service.getRegisteredDeploymentProviders();
    }

    public final ChangeDescriptor createChangeDescriptor(String string, String string2, String string3, Serializable serializable) throws InvalidCreateChangeDescriptorException {
        return this.service.createChangeDescriptor(string, string2, string3, serializable);
    }

    public final ChangeDescriptor createChangeDescriptor(String string, String string2, String string3, Serializable serializable, String string4) throws InvalidCreateChangeDescriptorException {
        return this.service.createChangeDescriptor(string, string2, string3, serializable, string4);
    }

    public final ChangeDescriptor createChangeDescriptor(Serializable serializable, Serializable serializable2) {
        return this.service.createChangeDescriptor(serializable, serializable2);
    }

    public DeploymentRequest createDeploymentRequest() throws ManagementException {
        return this.service.createDeploymentRequest();
    }

    static final class Maker {
        static final DeploymentServiceDriver DRIVER = new DeploymentServiceDriver();

        Maker() {
        }
    }
}

